/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.db.engine.WF_StepInputs_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class DetermineInputs
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DetermineInputs.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        List<WF_StepInputs_t> list;
        if (activityContext.getActivityInputs() != null && activityContext.getActivityInputs().getChildren().size() > 0) {
            logger.info(activityContext.getJobId(), "skipping input determination for activity since it has been assigned with [%s]", activityContext.getActivityInputs());
            return;
        }
        if (activityContext.getInputDefinition() != null) {
            logger.debug(activityContext.getJobId(), "configuring activity with input definition [%s]", activityContext.getInputDefinition());
            try {
                activityContext.setActivityInputs(WorkflowElement.parse(activityContext.getInputDefinition()));
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error parsing inputs");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
            }
            return;
        }
        logger.debug(activityContext.getJobId(), "activity does not contain an input definition");
        String string = String.format("StepId = %s", activityContext.getStepId());
        try {
            list = WF_StepInputs_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(activityContext.getJobId(), "failed to select from WF_StepInputs");
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            activityContext.setStatus(ProcessStatus.PENDING);
            return;
        }
        if (list.size() > 0) {
            logger.debug(activityContext.getJobId(), "configuring activity with input definition [%s]", list.get((int)0).Inputs.get());
            try {
                activityContext.setActivityInputs(WorkflowElement.parse(list.get((int)0).Inputs.get()));
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error parsing inputs");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
            }
        }
    }
}

