/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.executor;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.WorkflowMultiThread;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.activities.ScriptActivity;
import commvault.cte.workflow.executor.Executor;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public abstract class StepExecutor
implements Executor {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(StepExecutor.class);
    protected ActivityContext activity;
    private volatile WorkflowThread thread;
    private List<ProcessHandler> phases;
    private long executionStart;
    private boolean interrupted = false;
    private volatile boolean running = true;
    private ProcessManager manager;

    public StepExecutor(ActivityContext activityContext, ProcessManager processManager, WorkflowThread workflowThread) {
        this.activity = activityContext;
        this.manager = processManager;
        this.thread = workflowThread;
    }

    @Override
    public void start() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StepExecutor.this.executionStart = Calendar.getInstance().getTimeInMillis();
                    logger.trace(StepExecutor.this.activity.getJobId(), "begin execution of step");
                    StepExecutor.this.execute();
                    logger.trace(StepExecutor.this.activity.getJobId(), "completed execution of step");
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception executing activity", throwable);
                    StepExecutor.this.activity.setFailureReason(throwable.getMessage());
                    StepExecutor.this.activity.setStatus(ProcessStatus.PENDING);
                }
                Object object = StepExecutor.this.manager.getWorkflow().getLock();
                synchronized (object) {
                    StepExecutor.this.running = false;
                    StepExecutor.this.manager.onCompleteExecutor(StepExecutor.this);
                }
            }
        };
        if (WorkflowRegistry.getInstance().isReuseThreads()) {
            if (this.thread == null) {
                this.thread = new WorkflowMultiThread(runnable, "StepThread-" + this.activity.getProcessStepId(), this.activity);
            } else {
                ((WorkflowMultiThread)this.thread).add(runnable, "StepThread-" + this.activity.getProcessStepId(), this.activity);
            }
        } else {
            this.thread = new WorkflowThread(runnable, "StepThread-" + this.activity.getProcessStepId(), this.activity);
        }
        this.activity.getParent().removeFailures(this.activity.getFailures());
        this.activity.getFailures().clear();
        this.thread.start();
    }

    protected void execute() {
        this.activity.setThreadId(Thread.currentThread().getId());
        this.activity.setStatus(ProcessStatus.RUNNING);
        this.activity.setExecutionCount(this.activity.getExecutionCount() + 1);
        this.activity.setRepeatInterval(null);
        this.activity.setRepeat(false);
        this.activity.save();
        this.phases = new ArrayList<ProcessHandler>(Arrays.asList(this.activity.getExecutionPhases()));
        this.activity.getJobManager().setCurrentAttempt(this.activity);
        this.executeStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        Object object = this.activity.getLock();
        synchronized (object) {
            this.activity.getLock().notifyAll();
        }
    }

    private void executeStep() {
        try {
            while (this.activity.getCurrentPhase() < this.phases.size()) {
                try {
                    ProcessHandler processHandler = this.phases.get(this.activity.getCurrentPhase());
                    logger.trace(this.activity.getJobId(), "begining phase [%s], handler [%s]", this.activity.getCurrentPhase(), processHandler.getClass());
                    processHandler.executeHandler(this.activity);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn(this.activity.getJobId(), "thread for activity was interrupted");
                    this.activity.setStatus(ProcessStatus.INTERRUPT_PENDING);
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception executing activity", throwable);
                    EvMessageContainer evMessageContainer = new EvMessageContainer(throwable.getMessage());
                    this.activity.setFailureReason(evMessageContainer);
                    this.activity.setStatus(ProcessStatus.PENDING);
                }
                if (this.activity.getStatus() == ProcessStatus.WAITING) {
                    this.activity.setStatus(ProcessStatus.RUNNING);
                }
                this.activity.setCurrentPhase(this.activity.getCurrentPhase() + 1);
                if (this.activity.getStatus() == ProcessStatus.RUNNING) {
                    if (this.activity.isRepeat()) {
                        logger.debug(this.activity.getJobId(), "resetting current phase to 0 and exiting step since activity is set for repeat");
                        this.activity.setCurrentPhase(0);
                        return;
                    }
                    if (!this.activity.isDebug() || !this.activity.isBreakPoint() || this.activity.getActivity() instanceof ScriptActivity || this.activity.getCurrentPhase() >= this.phases.size() || !(this.phases.get(this.activity.getCurrentPhase()) instanceof ExecuteActivity)) continue;
                    return;
                }
                if (this.activity.getStatus() == ProcessStatus.SUSPEND_PENDING) {
                    if (this.activity.isRepeat()) {
                        logger.debug(this.activity.getJobId(), "resetting current phase to 0 and exiting step executing since activity is set for repeat");
                        this.activity.setCurrentPhase(0);
                        this.activity.setStatus(ProcessStatus.SUSPENDED);
                        this.activity.setRepeat(false);
                        return;
                    }
                    logger.debug(this.activity.getJobId(), "activity has a status of [%s] continuing execution", this.activity.getStatus().toString());
                    continue;
                }
                if (this.activity.getStatus() == ProcessStatus.SUSPENDED) {
                    logger.debug(this.activity.getJobId(), "exiting step executor since it has a status of [%s]", this.activity.getStatus().toString());
                    return;
                }
                if (this.activity.getStatus() == ProcessStatus.PENDING) {
                    if (this.activity.getRestarts() >= this.activity.getMaxRestarts()) {
                        if (this.activity.isContinueOnFailure()) {
                            logger.debug(this.activity.getJobId(), "activity has a pending status and has exceed maximum restarts [%s] but is configured to continue", this.activity.getMaxRestarts());
                            continue;
                        }
                        logger.debug(this.activity.getJobId(), "exiting step executor since activity has a pending status and has exceeded maximum restarts [%s]", this.activity.getMaxRestarts());
                        return;
                    }
                    logger.debug(this.activity.getJobId(), "exiting step executor since activity has a pending status");
                    return;
                }
                if (this.activity.isContinueOnFailure()) {
                    logger.debug(this.activity.getJobId(), "activity has a status of [%s] but is configured to continue on failure", this.activity.getStatus().toString());
                    continue;
                }
                logger.debug(this.activity.getJobId(), "exiting step executor since it has a status of [%s]", this.activity.getStatus().toString());
                return;
            }
        }
        catch (Throwable throwable) {
            logger.error("uncaught exception executing activity", throwable);
            EvMessageContainer evMessageContainer = new EvMessageContainer(throwable.getMessage());
            this.activity.setFailureReason(evMessageContainer);
            this.activity.setStatus(ProcessStatus.PENDING);
        }
        if (this.activity.getStatus() == ProcessStatus.RUNNING) {
            this.activity.setStatus(ProcessStatus.COMPLETED);
        }
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.activity;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        if (this.thread != null) {
            logger.debug(this.activity.getJobId(), "interrupting thread for activity");
            this.thread.interrupt();
        }
    }

    @Override
    public WorkflowThread getThread() {
        return this.thread;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public int getStepId() {
        return this.activity.getStepId();
    }

    @Override
    public long getExecutionStart() {
        return this.executionStart;
    }

    @Override
    public boolean isAlive() {
        return this.running;
    }

    public String toString() {
        return this.activity.getUniqueName();
    }
}

