/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.workflow;

import commvault.cte.common.workflow.CompletionStatus;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.db.cs.JMAdminJobAttemptInfoTable_t;
import commvault.cte.workflow.db.cs.JMJobOptions_t;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.events.WorkflowEndHandler;
import commvault.cte.workflow.events.WorkflowStartHandler;
import commvault.cte.workflow.logger.CTELogger;

public class ScriptEvents
implements WorkflowStartHandler,
WorkflowEndHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ScriptEvents.class);

    @Override
    public void onWorkflowEnd(WorkflowProcess workflowProcess) {
        try {
            EvalManager evalManager = new EvalManager(workflowProcess);
            if (workflowProcess.getOnComplete() != null && workflowProcess.getOnComplete().getScript().length() > 0) {
                logger.debug(workflowProcess.getJobId(), "processing onComplete script");
                Object object = evalManager.evaluate(workflowProcess.getOnComplete());
                logger.debug(workflowProcess.getJobId(), "onComplete script returned [%s]", String.valueOf(object));
            }
        }
        catch (EvFailureException evFailureException) {
            logger.error(workflowProcess.getJobId(), "error executing workflow onComplete script [" + workflowProcess.getOnComplete().getScript() + "]");
            workflowProcess.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
            workflowProcess.setStatus(ProcessStatus.FAILED);
            this.writeFailure(workflowProcess, "Workflow-OnComplete", evFailureException.getMessageContainer());
        }
    }

    @Override
    public void onWorkflowStart(WorkflowProcess workflowProcess) {
        Object object;
        try {
            object = new EvalManager(workflowProcess);
            if (workflowProcess.getOnStart() != null && workflowProcess.getOnStart().getScript().length() > 0) {
                logger.debug(workflowProcess.getJobId(), "processing onStart script");
                Object object2 = ((EvalManager)object).evaluate(workflowProcess.getOnStart());
                logger.debug(workflowProcess.getJobId(), "onStart script returned [%s]", String.valueOf(object2));
            }
        }
        catch (EvFailureException evFailureException) {
            logger.error(workflowProcess.getJobId(), "error executing workflow onStart script [" + workflowProcess.getOnStart().getScript() + "]");
            workflowProcess.setFailureReason(evFailureException.getMessageContainer());
            workflowProcess.setStatus(ProcessStatus.FAILED);
            this.writeFailure(workflowProcess, "Workflow-OnStart", evFailureException.getMessageContainer());
            return;
        }
        if (workflowProcess.getStatus() == ProcessStatus.FAILED) {
            object = workflowProcess.getLastFailure() != null ? workflowProcess.getLastFailure().getMessageContainer() : new EvMessageContainer("");
            this.writeFailure(workflowProcess, "Workflow-OnStart", (EvMessageContainer)object);
        }
    }

    private void writeFailure(WorkflowProcess workflowProcess, String string, EvMessageContainer evMessageContainer) {
        EvFailureReason evFailureReason = new EvFailureReason(workflowProcess, evMessageContainer);
        JMJobOptions_t jMJobOptions_t = new JMJobOptions_t();
        jMJobOptions_t.jobId.set(Integer.valueOf((int)workflowProcess.getJobId()));
        jMJobOptions_t.commCellId.set(Integer.valueOf(workflowProcess.getCommCellId()));
        jMJobOptions_t.attributeId.set(Integer.valueOf(0));
        jMJobOptions_t.attributeName.set("WF_Phase");
        jMJobOptions_t.attributeValue.set(string);
        jMJobOptions_t.attributeValueInt.set(Long.valueOf(0L));
        try {
            jMJobOptions_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowProcess.getJobId(), "error saving commcell job options for phase [" + string + "]", cTEDBException);
            return;
        }
        JMAdminJobAttemptInfoTable_t jMAdminJobAttemptInfoTable_t = new JMAdminJobAttemptInfoTable_t();
        jMAdminJobAttemptInfoTable_t.zero();
        jMAdminJobAttemptInfoTable_t.jobId.set(Integer.valueOf((int)workflowProcess.getJobId()));
        jMAdminJobAttemptInfoTable_t.commCellId.set(Integer.valueOf(workflowProcess.getCommCellId()));
        jMAdminJobAttemptInfoTable_t.phaseNum.set(Integer.valueOf(0));
        jMAdminJobAttemptInfoTable_t.attemptNum.set(Integer.valueOf(1));
        jMAdminJobAttemptInfoTable_t.phaseName.set(string);
        jMAdminJobAttemptInfoTable_t.startTime.set(Integer.valueOf(DateUtilities.getNow()));
        jMAdminJobAttemptInfoTable_t.status.set(Integer.valueOf(CompletionStatus.FAILED.toInt()));
        jMAdminJobAttemptInfoTable_t.endTime.set(Integer.valueOf(DateUtilities.getNow()));
        jMAdminJobAttemptInfoTable_t.elapsedTime.set(Integer.valueOf(0));
        jMAdminJobAttemptInfoTable_t.failureReason.set(evFailureReason.getFailureId());
        try {
            jMAdminJobAttemptInfoTable_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowProcess.getJobId(), "error saving job manager attempt row for script [" + string + "]", cTEDBException);
        }
    }
}

