/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.db.cs.WF_Interaction_t;
import commvault.cte.workflow.events.WorkflowEndHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.msgs.Workflow.InteractionStatus;
import java.util.List;

public class CleanInteractions
implements WorkflowEndHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CleanInteractions.class);

    @Override
    public void onWorkflowEnd(WorkflowProcess workflowProcess) {
        logger.trace(workflowProcess.getJobId(), "checking for any user interactions that were not processed");
        List<WF_Interaction_t> list = null;
        try {
            String string = String.format("jobId = %s AND commCellId = %s", workflowProcess.getJobId(), workflowProcess.getCommCellId());
            list = WF_Interaction_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowProcess.getJobId(), "failed to retrieve interactions for job", cTEDBException);
            return;
        }
        for (WF_Interaction_t wF_Interaction_t : list) {
            if (wF_Interaction_t.status.get().intValue() != InteractionStatus.NEW.getEnumValue()) continue;
            logger.info(workflowProcess.getJobId(), "marking user interaction [%s] killed", wF_Interaction_t.InteractionId.get());
            wF_Interaction_t.status.set(Integer.valueOf(InteractionStatus.KILLED.getEnumValue()));
            wF_Interaction_t.completedBy.set(Integer.valueOf(0));
            wF_Interaction_t.completed.set(Integer.valueOf(CommServUtils.getCommCellTimeUnix()));
            try {
                wF_Interaction_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowProcess.getJobId(), "failed to retrieve tokens for job", cTEDBException);
            }
        }
    }
}

