/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeRunningJobs
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UpgradeRunningJobs.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEngineStart() {
        logger.trace("checking for any job to upgrade");
        String string = String.format("Select DeploymentId from WF_Deployments Where (DeployedRel IS NULL OR DeployedRel < %s) AND DeploymentId IN (SELECT DeploymentId FROM WF_Process Where State < 3)", WorkflowProperties.getInstance().getVersion());
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.updateRunningJob(resultSet.getInt("DeploymentId"));
            }
        }
    }

    private void updateRunningJob(int n) {
        List<WF_Process_t> list;
        WF_Deployments_t wF_Deployments_t;
        WF_Deployments_t wF_Deployments_t2 = new WF_Deployments_t();
        try {
            wF_Deployments_t2.fill("DeploymentId = " + n);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve deployment for id [" + n + "]", cTEDBException);
            return;
        }
        try {
            wF_Deployments_t = DeploymentManager.redeploy(wF_Deployments_t2);
        }
        catch (EvFailureException evFailureException) {
            logger.error("failed to re-deploy workflow deployment id [" + n + "]", evFailureException);
            return;
        }
        try {
            list = WF_Process_t.select("DeploymentId = " + n);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve jobs for deployment id [" + n + "]", cTEDBException);
            return;
        }
        for (WF_Process_t wF_Process_t : list) {
            try {
                CommServUtils.updateJobVersion(wF_Process_t, wF_Deployments_t2, wF_Deployments_t);
            }
            catch (EvFailureException evFailureException) {
                logger.error(wF_Process_t.jobId.get(), "failed to update deployment version for workflow [" + wF_Deployments_t2.WorkflowName.get() + "]", evFailureException);
            }
        }
    }
}

