/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.SetWorkflowRequest;
import commvault.msgs.Workflow.WorkflowDefinition;
import commvault.msgs.Workflow.WorkflowFlags;
import java.io.File;
import java.sql.PreparedStatement;
import org.apache.commons.io.FileUtils;

public class ImportWorkflowsEvent
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ImportWorkflowsEvent.class);
    private static final String IMPORT_FOLDER = "built-in";
    private static final String XML_FILE = ".xml";

    @Override
    public void onEngineStart() {
        File file = new File(WorkflowRegistry.getInstance().getInstallFolder(), IMPORT_FOLDER);
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.isFile() || !file2.canRead() || !file2.getName().toLowerCase().endsWith(XML_FILE)) continue;
                try {
                    this.importFile(file2);
                    if (file2.delete()) continue;
                    logger.warn("could not delete file [" + file2.getAbsolutePath() + "]");
                }
                catch (Exception exception) {
                    logger.error("failed to import xml file [" + file2.getAbsolutePath() + "]", exception);
                }
            }
        } else {
            logger.info("skip importing workflow definitions since folder [" + file.getAbsolutePath() + "] doesn't exist");
        }
    }

    private void importFile(File file) throws Exception {
        String string = FileUtils.readFileToString((File)file, (String)"UTF-8");
        Object object = XMLDecoder.decode((String)string);
        if (object instanceof WorkflowDefinition) {
            this.importWorkflow(file, (WorkflowDefinition)object);
        }
        logger.error("unknown file type [" + object.getClass().getSimpleName() + "] from file [" + file.getAbsolutePath() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importWorkflow(File file, WorkflowDefinition workflowDefinition) throws Exception {
        if (workflowDefinition.getName().length() == 0) {
            logger.info("xml file [" + file.getAbsolutePath() + "] does not appear to be a valid workflow definition");
        }
        logger.debug("importing workflow definition [" + workflowDefinition.getName() + "], guid [" + workflowDefinition.getUniqueGuid() + "] from file [" + file.getAbsolutePath() + "]");
        int n = 0;
        if (workflowDefinition.getDisabled()) {
            n |= WorkflowFlags.DISABLED.getEnumValue();
        }
        if (workflowDefinition.getReadOnly()) {
            n |= WorkflowFlags.READONLY.getEnumValue();
        }
        if (workflowDefinition.getHidden()) {
            n |= WorkflowFlags.HIDDEN.getEnumValue();
        }
        SetWorkflowRequest setWorkflowRequest = new SetWorkflowRequest();
        setWorkflowRequest.setWorkflow(workflowDefinition);
        setWorkflowRequest.setFlags(n);
        String string = XMLEncoder.encode((Object)setWorkflowRequest);
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("{call WFSetWorkflow(?,1,0)}");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
    }
}

