/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.PackageImporter;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.CvEntities.UserEntity;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class ImportAPIActivities
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ImportAPIActivities.class);
    private static final String api_activities = "workflow_apiActivities.jar";

    @Override
    public void onEngineStart() {
        int n;
        WF_SchemaLocation_t wF_SchemaLocation_t = new WF_SchemaLocation_t();
        String string = String.format("LocationUrl = '%s'", api_activities);
        try {
            if (!wF_SchemaLocation_t.fill(string)) {
                logger.error("cannot find WF_SchemaLocation package [workflow_apiActivities.jar]");
                return;
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_SchemaLocation package [workflow_apiActivities.jar]", cTEDBException);
            return;
        }
        try {
            n = this.getPackageTimestamp();
        }
        catch (Exception exception) {
            logger.error("failed to retrieve build time of package [workflow_apiActivities.jar]", exception);
            return;
        }
        if (n > wF_SchemaLocation_t.Modified.get()) {
            UserEntity userEntity = new UserEntity();
            userEntity.setUserName("admin");
            userEntity.setUserId(2);
            try {
                PackageImporter.refresh(wF_SchemaLocation_t, userEntity);
            }
            catch (EvFailureException evFailureException) {
                logger.error("failed to import api activity package [workflow_apiActivities.jar]");
                return;
            }
            wF_SchemaLocation_t.Modified.set(Integer.valueOf(n));
            try {
                wF_SchemaLocation_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to save WF_SchemaLocation for package [workflow_apiActivities.jar]", cTEDBException);
                return;
            }
        }
        logger.info("package [workflow_apiActivities.jar] up to date");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPackageTimestamp() throws Exception {
        File file = new File(ImportAPIActivities.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
        try (JarFile jarFile = new JarFile(new File(file, api_activities));){
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            Date date = simpleDateFormat.parse(attributes.getValue("BuildDate"));
            int n = Long.valueOf(WorkflowUtils.getUnixTime(date)).intValue();
            return n;
        }
    }
}

