/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.DatabaseQuery;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.Evaluator;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ScriptLanguage;
import workflow.types.data.DataSet;

public class CommServQueryEvaluator
implements Evaluator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommServQueryEvaluator.class);

    @Override
    public boolean canEvaluate(String string) {
        return string.matches("(?i)csdb:\\{[\\S\\s]*}:java");
    }

    @Override
    public Object eval(String string, EvalContext evalContext) throws EvFailureException {
        DataSet dataSet;
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(evalContext);
        String string2 = workflowEvaluator.parseString(string);
        DatabaseQuery databaseQuery = new DatabaseQuery(evalContext.getWorkflow().getContext(), WorkflowProperties.getInstance().getCommCellConnection());
        logger.trace(evalContext.getJobId(), "begin execution of csdb query [%s]", string2);
        try {
            dataSet = databaseQuery.execute(string2);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(evalContext.getJobId(), "failed to execute query [" + string2 + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (dataSet.hasNext()) {
            logger.debug(evalContext.getJobId(), "csdb query returned value [%s]", dataSet.get(0));
            return dataSet.get(0);
        }
        logger.error(evalContext.getJobId(), "query [" + string2 + "] did not return a result");
        return null;
    }

    @Override
    public ScriptLanguage getLanguage() {
        return null;
    }

    @Override
    public String getTag() {
        return "csdb";
    }
}

