/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.workflow.logger.LoggerLevel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.Walker;
import org.jdom2.util.NamespaceStack;
import workflow.types.EncryptedString;

public class WorkflowOutputter
extends AbstractXMLOutputProcessor {
    private int level;

    public WorkflowOutputter() {
        this(LoggerLevel.INFO);
    }

    public WorkflowOutputter(LoggerLevel loggerLevel) {
        this.level = loggerLevel.toInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printElement(Writer writer, FormatStack formatStack, NamespaceStack namespaceStack, Element element) throws IOException {
        String string = element.getAttributeValue("class");
        boolean bl = string != null && string.equals(EncryptedString.class.getName());
        namespaceStack.push(element);
        try {
            List list = element.getContent();
            this.write(writer, "<");
            this.write(writer, element.getQualifiedName());
            for (Namespace namespace : namespaceStack.addedForward()) {
                this.printNamespace(writer, formatStack, namespace);
            }
            if (element.hasAttributes()) {
                for (Namespace namespace : element.getAttributes()) {
                    if (this.level > LoggerLevel.INFO.toInt()) {
                        this.printAttribute(writer, formatStack, (Attribute)namespace);
                        continue;
                    }
                    if (namespace.getName().equals("class") || namespace.getName().equals("_list_") || namespace.getName().equals("_nil_")) continue;
                    this.printAttribute(writer, formatStack, (Attribute)namespace);
                }
            }
            if (list.isEmpty()) {
                if (formatStack.isExpandEmptyElements()) {
                    this.write(writer, "></");
                    this.write(writer, element.getQualifiedName());
                    this.write(writer, ">");
                } else {
                    this.write(writer, " />");
                }
                return;
            }
            if (bl || element.getQualifiedName().equalsIgnoreCase("impersonateUserPassword")) {
                this.write(writer, ">*******</");
                this.write(writer, element.getQualifiedName());
                this.write(writer, ">");
                return;
            }
            formatStack.push();
            try {
                Namespace namespace;
                String string2 = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
                if ("default".equals(string2)) {
                    formatStack.setTextMode(formatStack.getDefaultMode());
                } else if ("preserve".equals(string2)) {
                    formatStack.setTextMode(Format.TextMode.PRESERVE);
                }
                namespace = this.buildWalker(formatStack, list, true);
                if (!namespace.hasNext()) {
                    if (formatStack.isExpandEmptyElements()) {
                        this.write(writer, "></");
                        this.write(writer, element.getQualifiedName());
                        this.write(writer, ">");
                    } else {
                        this.write(writer, " />");
                    }
                    return;
                }
                this.write(writer, ">");
                if (!namespace.isAllText()) {
                    this.textRaw(writer, formatStack.getPadBetween());
                }
                this.printContent(writer, formatStack, namespaceStack, (Walker)namespace);
                if (!namespace.isAllText()) {
                    this.textRaw(writer, formatStack.getPadLast());
                }
                this.write(writer, "</");
                this.write(writer, element.getQualifiedName());
                this.write(writer, ">");
            }
            finally {
                formatStack.pop();
            }
        }
        finally {
            namespaceStack.pop();
        }
    }
}

