/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.common.workflow.WorkflowSystem;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.dom.Execution;
import commvault.cte.workflow.dom.WorkflowAttribute;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.dom.xpath.XPath;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.WorkflowEntity;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import workflow.types.XPathQuery;

public class WorkflowExecution
implements XPathQuery {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowExecution.class);
    public static final String ELEMENT_UPLOADED_FILE = "_upload_";
    public static final String ELEMENT_JOIN_COMPLETED = "_joins_";
    private ProcessContext workflow;
    private WorkflowSystem systemXml;
    private Execution executionRoot;
    private Document executionDocument;
    private final Object lock = new Object();

    public static WorkflowExecution createInstance(ProcessContext processContext) throws EvFailureException {
        WorkflowExecution workflowExecution = new WorkflowExecution(processContext);
        if (processContext.getExecutionXml() == null || processContext.getExecutionXml().length() == 0) {
            logger.debug(processContext.getJobId(), "creating new workflow execution document");
            workflowExecution.systemXml = new WorkflowSystem();
            workflowExecution.executionRoot.addContent((Content)workflowExecution.systemXml.getElement());
        } else {
            SAXBuilder sAXBuilder;
            try {
                logger.debug(processContext.getJobId(), "loading existing workflow outputs [%s]", processContext.getExecutionXml());
                sAXBuilder = new SAXBuilder();
                Document document = sAXBuilder.build((Reader)new StringReader(processContext.getExecutionXml()));
                workflowExecution.executionRoot.addContent(document.getRootElement().cloneContent());
                for (Attribute attribute : document.getRootElement().getAttributes()) {
                    workflowExecution.executionRoot.setAttribute(attribute.clone());
                }
            }
            catch (Exception exception) {
                logger.error(processContext.getJobId(), "error parsing workflow execution [" + processContext.getExecutionXml() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            sAXBuilder = workflowExecution.executionRoot.getChild("system");
            if (sAXBuilder == null) {
                workflowExecution.systemXml = new WorkflowSystem();
                workflowExecution.executionRoot.addContent((Content)workflowExecution.systemXml.getElement());
            } else {
                workflowExecution.systemXml = new WorkflowSystem((Element)sAXBuilder);
            }
        }
        return workflowExecution;
    }

    private WorkflowExecution(ProcessContext processContext) {
        this.workflow = processContext;
        this.executionRoot = new Execution(processContext.getContext().getId());
        this.executionDocument = new Document((Element)this.executionRoot);
    }

    protected Execution getExecutionRoot() {
        return this.executionRoot;
    }

    protected Element getInputElement() {
        return this.executionRoot.getChild("inputs");
    }

    protected Element getVariableElement() {
        return this.executionRoot.getChild("variables");
    }

    protected Element getOutputElement() {
        return this.executionRoot.getChild("outputs");
    }

    protected Element getConfigurationElement() {
        return this.executionRoot.getChild("configuration");
    }

    public WorkflowElement getInputs() {
        Element element = this.getInputElement();
        if (element == null) {
            return null;
        }
        return new WorkflowElement(element);
    }

    public WorkflowElement getVariables() {
        Element element = this.getVariableElement();
        if (element == null) {
            return null;
        }
        return new WorkflowElement(element);
    }

    public WorkflowElement getOutputs() {
        Element element = this.getOutputElement();
        if (element == null) {
            return null;
        }
        return new WorkflowElement(element);
    }

    public WorkflowElement getConfiguration() {
        Element element = this.getConfigurationElement();
        if (element == null) {
            return null;
        }
        return new WorkflowElement(element);
    }

    public WorkflowElement getWorkflowInputs() {
        return this.getInputs();
    }

    public WorkflowElement getWorkflowVariables() {
        return this.getVariables();
    }

    public WorkflowElement getWorkflowOutputs() {
        return this.getOutputs();
    }

    public WorkflowElement getWorkflowConfiguration() {
        return this.getConfiguration();
    }

    public boolean isVariableExists(String string) {
        return this.getVariableElement().getChild(string) != null;
    }

    public WorkflowElement getSystem() {
        return new WorkflowElement(this.systemXml.getElement());
    }

    public Class getElementClass(WorkflowElement workflowElement) {
        logger.trace(this.workflow.getJobId(), "retrieving class for element [%s]", workflowElement.getName());
        if (workflowElement.getParent().getName().equalsIgnoreCase("inputs")) {
            return this.getElementClass(this.workflow.getInputSchema(), workflowElement.getName(), workflowElement.getParent().getName());
        }
        if (workflowElement.getParent().getName().equalsIgnoreCase("variables")) {
            return this.getElementClass(this.workflow.getVariableSchema(), workflowElement.getName(), workflowElement.getParent().getName());
        }
        if (workflowElement.getParent().getName().equalsIgnoreCase("outputs")) {
            return this.getElementClass(this.workflow.getOutputSchema(), workflowElement.getName(), workflowElement.getParent().getName());
        }
        logger.debug(this.workflow.getJobId(), "cannot get class for element [%s], unknown parent element [%s]", workflowElement.getName(), workflowElement.getParent().getName());
        return null;
    }

    private Class getElementClass(XMLSchema xMLSchema, String string, String string2) {
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            if (!xMLSchema2.getName().equalsIgnoreCase(string)) continue;
            if (xMLSchema2.getClassName().length() > 0) {
                try {
                    return this.getClass().getClassLoader().loadClass(xMLSchema2.getClassName());
                }
                catch (Exception exception) {
                    logger.error(this.workflow.getJobId(), "failed to load class [" + xMLSchema2.getClassName() + "] for schema [" + string + "] in [" + string2 + "]", exception);
                    return null;
                }
            }
            logger.debug(this.workflow.getJobId(), "schema [%s] under [%s] has no java class associated with it", string, string2);
            return null;
        }
        logger.debug(this.workflow.getJobId(), "could not find schema [%s] under [%s]", string, string2);
        return null;
    }

    public void setInput(String string, Object object) throws EvFailureException {
        this.updateValue(this.getInputElement(), string, object);
    }

    public void setVariable(String string, Object object) throws EvFailureException {
        this.updateValue(this.getVariableElement(), string, object);
    }

    public void setOutput(String string, Object object) throws EvFailureException {
        this.updateValue(this.getOutputElement(), string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(Element element, String string, Object object) throws EvFailureException {
        Object object2 = this.lock;
        synchronized (object2) {
            Element element2 = element.getChild(string);
            List<WorkflowElement> list = this.workflow.getMarshaller().encode(string, object);
            element.removeChildren(string);
            if (list != null) {
                for (WorkflowElement workflowElement : list) {
                    if (element2 != null) {
                        workflowElement.copyAttributesFrom(element2);
                    }
                    element.addContent((Content)workflowElement.element.clone());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeInputs(WorkflowElement workflowElement) {
        Object object = this.lock;
        synchronized (object) {
            this.mergeInputs(workflowElement.element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeVariables(WorkflowElement workflowElement) {
        Object object = this.lock;
        synchronized (object) {
            this.mergeVariables(workflowElement.element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeOutputs(WorkflowElement workflowElement) {
        Object object = this.lock;
        synchronized (object) {
            this.mergeOutputs(workflowElement.element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeConfiguration(WorkflowElement workflowElement) {
        Object object = this.lock;
        synchronized (object) {
            this.mergeConfiguration(workflowElement.element);
        }
    }

    protected void mergeInputs(Element element) {
        this.mergeXml(this.getInputElement(), element);
    }

    protected void mergeVariables(Element element) {
        this.mergeXml(this.getVariableElement(), element);
    }

    protected void mergeOutputs(Element element) {
        this.mergeXml(this.getOutputElement(), element);
    }

    protected void mergeConfiguration(Element element) {
        this.mergeXml(this.getConfigurationElement(), element);
    }

    private void mergeXml(Element element, Element element2) {
        if (element2 == null) {
            return;
        }
        if (element.getName().equals(element2.getName())) {
            Set<String> set = JDOMUtil.getChildTags(element2);
            for (String string : set) {
                List list = element2.getChildren(string);
                element.removeChildren(string);
                for (Element element3 : list) {
                    element.addContent((Content)element3.clone());
                }
            }
            logger.debug(this.workflow.getJobId(), "process inputs merge results [%s]", JDOMUtil.serialize(element));
        } else {
            logger.error(this.workflow.getJobId(), "cannot merge element with different names dest: [" + element.getName() + "], source: [" + element2.getName() + "]");
        }
    }

    public Object selectSingleNode(String string, WorkflowElement workflowElement) throws Exception {
        if (workflowElement == null) {
            return this.selectSingleNode(string);
        }
        Execution execution = new Execution(this.workflow.getContext().getId());
        execution.setContent(workflowElement.element.cloneContent());
        for (String string2 : Execution.RESERVED_ELEMENTS) {
            execution.removeChildren(string2);
            Element element = this.executionRoot.getChild(string2);
            if (element == null) continue;
            execution.addContent((Content)element.clone());
        }
        return this.selectSingleNode(string, new Document((Element)execution));
    }

    public Object selectSingleNode(String string) throws Exception {
        return this.selectSingleNode(string, this.executionDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object selectSingleNode(String string, Document document) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = XPath.selectSingleNode(document, string);
            logger.xml(this.workflow.getJobId(), "evaluation of xpath expression [%s] returned [%s]", string, JDOMUtil.toString(object2));
            if (object2 instanceof Element) {
                return new WorkflowElement((Element)object2);
            }
            if (object2 instanceof Attribute) {
                return new WorkflowAttribute((Attribute)object2);
            }
            return object2;
        }
    }

    public List select(String string, WorkflowElement workflowElement) throws Exception {
        if (workflowElement == null) {
            return this.select(string);
        }
        Execution execution = new Execution(this.workflow.getContext().getId());
        execution.setContent(workflowElement.element.cloneContent());
        for (String string2 : Execution.RESERVED_ELEMENTS) {
            execution.removeChildren(string2);
            Element element = this.executionRoot.getChild(string2);
            if (element == null) continue;
            execution.addContent((Content)element.clone());
        }
        return this.select(string, new Document((Element)execution));
    }

    public List select(String string) throws Exception {
        return this.select(string, this.executionDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List select(String string, Document document) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            List list = XPath.selectNodes(document, string);
            logger.xml(this.workflow.getJobId(), "evaluation of xpath expression [%s] returned [%s]", string, JDOMUtil.toString(list));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object e : list) {
                if (e instanceof Element) {
                    arrayList.add(new WorkflowElement((Element)e));
                    continue;
                }
                if (e instanceof Attribute) {
                    arrayList.add(new WorkflowAttribute((Attribute)e));
                    continue;
                }
                arrayList.add(e);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowElement getOutput(String string) {
        Object object = this.lock;
        synchronized (object) {
            Element element = this.executionRoot.getChild(string);
            if (element == null) {
                return null;
            }
            return new WorkflowElement(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.lock;
        synchronized (object) {
            this.systemXml.set("workflowEngine", (Object)WorkflowProperties.getInstance().getClient());
            WorkflowEntity workflowEntity = new WorkflowEntity();
            workflowEntity.setWorkflowId(this.workflow.getWorkflowId());
            workflowEntity.setWorkflowName(this.workflow.getWorkflowName());
            workflowEntity.set_type_(EntityType.WORKFLOW_ENTITY);
            this.systemXml.set("workflow", (Object)workflowEntity);
            this.systemXml.set("description", (Object)this.workflow.getDescription());
            this.systemXml.set("version", (Object)this.workflow.getVersion());
            this.systemXml.set("status", (Object)this.workflow.getStatus().toString());
            this.systemXml.set("jobId", (Object)this.workflow.getJobId());
            this.systemXml.set("startTime", (Object)this.workflow.getStartTimeUnix());
            UserEntity userEntity = new UserEntity();
            userEntity.setUserId(this.workflow.getExecutorId());
            userEntity.setUserName(this.workflow.getExecutor());
            userEntity.set_type_(EntityType.USER_ENTITY);
            this.systemXml.set("executor", (Object)userEntity);
            UserEntity userEntity2 = new UserEntity();
            userEntity2.setUserId(this.workflow.getCreatorId());
            userEntity2.setUserName(this.workflow.getCreator());
            userEntity2.set_type_(EntityType.USER_ENTITY);
            this.systemXml.set("creator", (Object)userEntity2);
            this.systemXml.set("localeId", (Object)this.workflow.getLocaleId());
            this.systemXml.set("commCellName", (Object)this.workflow.getCommCell());
            this.systemXml.set("commCellHost", (Object)WorkflowProperties.getInstance().getCommServHost());
            this.systemXml.set("callerIP", (Object)this.workflow.getCallerIP());
            this.systemXml.set((Element)new TokenElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize() {
        Object object = this.lock;
        synchronized (object) {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            try {
                xMLOutputter.output((Element)this.executionRoot, (Writer)stringWriter);
                stringWriter.close();
            }
            catch (IOException iOException) {
                logger.error(this.workflow.getJobId(), "failed to serialize workflow execution document", iOException);
            }
            return stringWriter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialiazeInputs() {
        Object object = this.lock;
        synchronized (object) {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            try {
                xMLOutputter.output(this.getInputElement(), (Writer)stringWriter);
                stringWriter.close();
            }
            catch (IOException iOException) {
                logger.error(this.workflow.getJobId(), "failed to serialize workflow variables", iOException);
            }
            return stringWriter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialiazeSystem() {
        Object object = this.lock;
        synchronized (object) {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            try {
                xMLOutputter.output(this.systemXml.getElement(), (Writer)stringWriter);
                stringWriter.close();
            }
            catch (IOException iOException) {
                logger.error(this.workflow.getJobId(), "failed to serialize workflow system", iOException);
            }
            return stringWriter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialiazeVariables() {
        Object object = this.lock;
        synchronized (object) {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            try {
                xMLOutputter.output(this.getVariableElement(), (Writer)stringWriter);
                stringWriter.close();
            }
            catch (IOException iOException) {
                logger.error(this.workflow.getJobId(), "failed to serialize workflow variables", iOException);
            }
            return stringWriter.toString();
        }
    }

    public void addUploadedFile(String string) {
        Element element = new Element(ELEMENT_UPLOADED_FILE);
        element.addContent(string);
        this.executionDocument.getRootElement().addContent((Content)element);
    }

    public List<String> getUploadedFiles() throws EvFailureException {
        List list;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            list = this.select(String.format("/workflow/%s", ELEMENT_UPLOADED_FILE));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + String.format("/workflow/%s", ELEMENT_UPLOADED_FILE) + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        for (WorkflowElement workflowElement : list) {
            if (workflowElement.getText().length() <= 0) continue;
            arrayList.add(workflowElement.getText());
        }
        return arrayList;
    }

    public void setInputs(WorkflowElement workflowElement) {
        this.getInputElement().removeContent();
        this.getInputElement().setContent((Collection)workflowElement.element.cloneContent());
    }

    public void setVariables(WorkflowElement workflowElement) {
        this.getVariableElement().removeContent();
        this.getVariableElement().setContent((Collection)workflowElement.element.cloneContent());
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJoinCompleted(String string) {
        Object object = this.lock;
        synchronized (object) {
            Element element = new Element(ELEMENT_JOIN_COMPLETED);
            element.setText(string);
            this.executionDocument.getRootElement().addContent((Content)element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinCompleted(String string) throws EvFailureException {
        Object object = this.lock;
        synchronized (object) {
            List list = this.executionDocument.getRootElement().getChildren(ELEMENT_JOIN_COMPLETED);
            for (Element element : list) {
                if (!element.getText().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }

    private class TokenElement
    extends Element {
        public TokenElement() {
            super("token");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText() {
            Object object = WorkflowExecution.this.lock;
            synchronized (object) {
                if (Thread.currentThread() instanceof WorkflowThread) {
                    return ((WorkflowThread)Thread.currentThread()).getWorkflowContext().getContext().getToken();
                }
                return null;
            }
        }
    }
}

