/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.dom.WorkflowAttribute;
import commvault.cte.workflow.dom.WorkflowOutputter;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import commvault.cte.workflow.utils.JDOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.XMLOutputProcessor;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import workflow.types.XML;

public class WorkflowElement
implements XML {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowElement.class);
    protected Element element;

    public static WorkflowElement parseQuite(String string) {
        if (string != null && string.length() > 0) {
            Document document;
            SAXBuilder sAXBuilder = new SAXBuilder();
            try {
                document = sAXBuilder.build((Reader)new StringReader(string));
            }
            catch (Exception exception) {
                logger.debug("error parsing xml [%s], error [%s]", string, exception.getMessage());
                return null;
            }
            return new WorkflowElement(document.getRootElement().clone());
        }
        return null;
    }

    public static WorkflowElement parse(Element element) {
        if (element != null) {
            return new WorkflowElement(element.clone());
        }
        return null;
    }

    public static WorkflowElement parse(String string) throws EvFailureException {
        if (string != null && string.length() > 0) {
            Document document;
            SAXBuilder sAXBuilder = new SAXBuilder();
            if (!WorkflowRegistry.getInstance().isAllowXXE()) {
                sAXBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                sAXBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                sAXBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            try {
                document = sAXBuilder.build((Reader)new StringReader(string));
            }
            catch (Exception exception) {
                logger.error("error parsing xml [" + string + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            return new WorkflowElement(document.getRootElement().clone());
        }
        return null;
    }

    public static WorkflowElement parse(InputStream inputStream) throws EvFailureException {
        Document document;
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            document = sAXBuilder.build(inputStream);
        }
        catch (Exception exception) {
            logger.error("error parsing xml from input stream", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        return new WorkflowElement(document.getRootElement().clone());
    }

    public WorkflowElement(String string) {
        this(new Element(string));
    }

    protected WorkflowElement(Element element) {
        if (element == null) {
            throw new Error("element is null");
        }
        this.element = element;
    }

    public String clean(LoggerLevel loggerLevel) {
        XMLOutputter xMLOutputter = new XMLOutputter((XMLOutputProcessor)new WorkflowOutputter(loggerLevel));
        StringWriter stringWriter = new StringWriter();
        try {
            xMLOutputter.output(this.element, (Writer)stringWriter);
            stringWriter.close();
        }
        catch (IOException iOException) {
            logger.error("error serializing workflow object [" + this.element.getName() + "]", iOException);
        }
        return stringWriter.toString();
    }

    public String serialize() throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter();
        StringWriter stringWriter = new StringWriter();
        xMLOutputter.output(this.element, (Writer)stringWriter);
        stringWriter.close();
        return stringWriter.toString();
    }

    public String toString() {
        try {
            return this.serialize();
        }
        catch (IOException iOException) {
            logger.error("error serializing workflow object [" + this.element.getName() + "]", iOException);
            return "";
        }
    }

    public void replace(WorkflowElement workflowElement) {
        this.element.removeChildren(workflowElement.element.getName());
        this.element.addContent((Content)workflowElement.element);
    }

    public void addContent(List list) {
        for (WorkflowElement workflowElement : list) {
            this.addContent(workflowElement);
        }
    }

    public void cloneContent(List list) {
        for (WorkflowElement workflowElement : list) {
            this.addContent(workflowElement.clone());
        }
    }

    public void addContent(XML xML) {
        this.addContent((WorkflowElement)xML);
    }

    public void addContent(WorkflowElement workflowElement) {
        this.element.addContent((Content)workflowElement.element);
    }

    public void removeContent() {
        this.element.removeContent();
    }

    public void removeContent(String string) {
        this.element.removeChildren(string);
    }

    public void removeContent(XML xML) {
        if (xML instanceof WorkflowElement) {
            this.removeContent((WorkflowElement)xML);
        } else {
            this.element.removeAttribute(xML.getName());
        }
    }

    public void removeContent(WorkflowElement workflowElement) {
        this.element.removeContent((Content)workflowElement.element);
    }

    public void removeChildren(String string) {
        this.element.removeChildren(string);
    }

    public String getAttributeValue(String string) {
        return this.element.getAttributeValue(string);
    }

    public void setAttribute(String string, String string2) {
        this.element.setAttribute(string, string2);
    }

    public void removeAttribute(String string) {
        this.element.removeAttribute(string);
    }

    public WorkflowElement getChild(String string) {
        Element element = this.element.getChild(string);
        if (element != null) {
            return new WorkflowElement(element);
        }
        return null;
    }

    public WorkflowElement addChild(String string) {
        return this.createChild(string);
    }

    public WorkflowElement createChild(String string) {
        WorkflowElement workflowElement = new WorkflowElement(string);
        this.addContent(workflowElement);
        return workflowElement;
    }

    public WorkflowElement getFirstChild() {
        if (this.element.getChildren().size() > 0) {
            return new WorkflowElement((Element)this.element.getChildren().get(0));
        }
        return null;
    }

    public List getChildren(String string) {
        ArrayList<WorkflowElement> arrayList = new ArrayList<WorkflowElement>();
        for (Element element : this.element.getChildren(string)) {
            arrayList.add(new WorkflowElement(element));
        }
        return arrayList;
    }

    public List getChildren() {
        ArrayList<WorkflowElement> arrayList = new ArrayList<WorkflowElement>();
        for (Element element : this.element.getChildren()) {
            arrayList.add(new WorkflowElement(element));
        }
        return arrayList;
    }

    public Set<String> getDistinctChildNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element : this.element.getChildren()) {
            hashSet.add(element.getName());
        }
        return hashSet;
    }

    public List<WorkflowAttribute> getAttributes() {
        ArrayList<WorkflowAttribute> arrayList = new ArrayList<WorkflowAttribute>();
        for (Attribute attribute : this.element.getAttributes()) {
            arrayList.add(new WorkflowAttribute(attribute));
        }
        return arrayList;
    }

    public void copyAttributesFrom(WorkflowElement workflowElement) {
        this.copyAttributesFrom(workflowElement.element);
    }

    public void copyAttributesFrom(Element element) {
        for (Attribute attribute : element.getAttributes()) {
            if (attribute.getName().equals("class")) continue;
            this.element.setAttribute(attribute.clone());
        }
    }

    public WorkflowElement getParent() {
        return new WorkflowElement(this.element.getParentElement());
    }

    public String getName() {
        return this.element.getName();
    }

    public void setName(String string) {
        this.element.setName(string);
    }

    public String getValue() {
        return this.getText();
    }

    public String getText() {
        return this.element.getText();
    }

    public String getText(String string) {
        XPathExpression xPathExpression = XPathFactory.instance().compile(string);
        Object object = xPathExpression.evaluateFirst((Object)this.getSelectableDocument());
        if (object != null) {
            return this.getObjectText(object);
        }
        return null;
    }

    public void setValue(String string) {
        this.setText(string);
    }

    public void setText(String string) {
        this.element.setText(string);
    }

    public WorkflowElement clone() {
        return new WorkflowElement(this.element.clone());
    }

    private Document getSelectableDocument() {
        return new Document(this.element.clone());
    }

    public void createDocument() {
        if (this.element.getDocument() == null) {
            Document document = new Document(this.element);
        }
    }

    public void remove(String string) throws Exception {
        XPathExpression xPathExpression = XPathFactory.instance().compile(string);
        Object object = xPathExpression.evaluateFirst((Object)this.element.getDocument());
        if (object != null) {
            this.removeObject(object);
        }
    }

    private void removeObject(Object object) throws Exception {
        if (object instanceof Element) {
            Element element = (Element)object;
            element.getParentElement().removeContent((Content)element);
        } else if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            attribute.getParent().removeAttribute(attribute);
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.removeObject(e);
            }
        } else {
            throw new Exception("cannot remove child of type [" + object.getClass().getSimpleName() + "]");
        }
    }

    public void setText(String string, String string2) throws Exception {
        XPathExpression xPathExpression = XPathFactory.instance().compile(string);
        Object object = xPathExpression.evaluateFirst((Object)this.element.getDocument());
        if (object != null) {
            this.setObjectText(object, string2);
        }
    }

    private String getObjectText(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            return element.getValue();
        }
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            return attribute.getValue();
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                return this.getObjectText(e);
            }
            return null;
        }
        logger.error("cannot get text on child of type [" + object.getClass().getSimpleName() + "]");
        return null;
    }

    private void setObjectText(Object object, String string) throws Exception {
        if (object instanceof Element) {
            Element element = (Element)object;
            element.setText(string);
        } else if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            attribute.setValue(string);
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.setObjectText(e, string);
            }
        } else {
            throw new Exception("cannot set text on child of type [" + object.getClass().getSimpleName() + "]");
        }
    }

    public Object getNode(String string) throws Exception {
        return this.selectSingleNode(string, this.element.getDocument());
    }

    public List getNodes(String string) throws Exception {
        return this.select(string, this.element.getDocument());
    }

    public Object selectSingleNode(String string) throws Exception {
        return this.selectSingleNode(string, this.getSelectableDocument());
    }

    public List select(String string) throws Exception {
        return this.select(string, this.getSelectableDocument());
    }

    private Object selectSingleNode(String string, Document document) throws Exception {
        XPathExpression xPathExpression = XPathFactory.instance().compile(string);
        Object object = xPathExpression.evaluateFirst((Object)document);
        logger.xml("evaluation of xpath expression [%s] returned [%s]", string, JDOMUtil.toString(object));
        return this.convertDom(object);
    }

    private List select(String string, Document document) throws Exception {
        XPathExpression xPathExpression = XPathFactory.instance().compile(string);
        List list = xPathExpression.evaluate((Object)document);
        logger.xml("evaluation of xpath expression [%s] returned [%s]", string, JDOMUtil.toString(list));
        return this.convertDomList(list);
    }

    private List convertDomList(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            arrayList.add(this.convertDom(e));
        }
        return arrayList;
    }

    private Object convertDom(Object object) {
        if (object instanceof Element) {
            return new WorkflowElement((Element)object);
        }
        if (object instanceof Attribute) {
            return new WorkflowAttribute((Attribute)object);
        }
        return object;
    }

    public Element getElement() {
        return this.element;
    }
}

