/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.common.workflow.ActivitySystem;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.io.Reader;
import java.io.StringReader;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class OutputElement
extends WorkflowElement {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowElement.class);
    private ActivitySystem systemOutput;

    public static OutputElement parse(String string) throws EvFailureException {
        if (string != null && string.length() > 0) {
            Document document;
            SAXBuilder sAXBuilder = new SAXBuilder();
            try {
                document = sAXBuilder.build((Reader)new StringReader(string));
            }
            catch (Exception exception) {
                logger.error("error parsing xml [" + string + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            return new OutputElement(document.getRootElement().clone());
        }
        return null;
    }

    public OutputElement(String string) {
        this(new Element(string));
    }

    protected OutputElement(Element element) {
        super(element);
        element.removeChild("system");
        this.systemOutput = new ActivitySystem();
        element.addContent((Content)this.systemOutput.getElement());
    }

    public ActivitySystem getSystemOutputs() {
        return this.systemOutput;
    }
}

