/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Execution
extends Element {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(Execution.class);
    public static final List<String> RESERVED_ELEMENTS = Arrays.asList("configuration", "inputs", "variables", "outputs", "system", "_joins_", "_upload_");
    private int contextId;

    protected Execution(int n) {
        super("workflow");
        this.contextId = n;
    }

    public Element getChild(String string, Namespace namespace) {
        if (RESERVED_ELEMENTS.contains(string)) {
            return super.getChild(string, namespace);
        }
        Element element = this.getDBChild(string);
        if (element == null) {
            return super.getChild(string, namespace);
        }
        return element;
    }

    public List getChildren(String string, Namespace namespace) {
        if (RESERVED_ELEMENTS.contains(string)) {
            return super.getChildren(string, namespace);
        }
        Element element = this.getDBChild(string);
        if (element == null) {
            return super.getChildren(string, namespace);
        }
        return Arrays.asList(element);
    }

    protected Element getDBChild(String string) {
        if (!(Thread.currentThread() instanceof WorkflowThread)) {
            logger.error("illegal attempt to access child [" + string + "] with a non WorkflowThread, thread [" + Thread.currentThread() + "]");
            return new Element(string);
        }
        WorkflowThread workflowThread = (WorkflowThread)Thread.currentThread();
        List<WorkflowElement> list = workflowThread.getWorkflowContext().getParent().getProcessXml();
        for (WorkflowElement workflowElement : list) {
            if (!workflowElement.getName().equals(string)) continue;
            logger.xml(workflowThread.getJobId(), "retrieving xml for activity [%s] from staticXml in WorkflowThread", string);
            return workflowElement.element;
        }
        if (string.equals("_upload_") || string.equals("_joins_")) {
            return new Element("_upload_");
        }
        try {
            WorkflowElement workflowElement = workflowThread.getWorkflowContext().getDataAccess().getActivityOutputs(string, workflowThread.getWorkflowContext().getContext().getId(), this.contextId);
            if (workflowElement == null) {
                logger.debug(workflowThread.getJobId(), "did not find any outputs for activity [%s]", string);
                return null;
            }
            return workflowElement.element;
        }
        catch (Exception exception) {
            logger.error(workflowThread.getJobId(), "failed to retrieve the output for activity [" + string + "]", exception);
            return new Element(string);
        }
    }
}

