/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.util.Base64;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.converters.BinaryConverter;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.qnet.sys.CVPassword;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import workflow.types.EncryptedString;
import workflow.types.XML;

public class DOMUtil {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DOMUtil.class);

    public static String serialize(List<WorkflowElement> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<list-container>");
        for (WorkflowElement workflowElement : list) {
            stringBuffer.append(workflowElement.toString());
        }
        stringBuffer.append("</list-container>");
        return stringBuffer.toString();
    }

    public static void checkInputs(WorkflowElement workflowElement, EvalManager evalManager) throws EvFailureException {
        DOMUtil.checkInputs(workflowElement.element, evalManager);
    }

    protected static void checkInputs(Element element, EvalManager evalManager) throws EvFailureException {
        Element[] elementArray;
        for (Element element2 : elementArray = element.getChildren().toArray(new Element[0])) {
            Object object;
            Object object2;
            Object object32;
            Object object4;
            Object object5;
            Class<?> clazz;
            if (element2.getAttribute("class") == null) continue;
            String string = element2.getAttributeValue("class");
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.debug("could not instantiate class [%s] for input [%s], error [%s]", string, element2.getName(), classNotFoundException.getMessage());
                continue;
            }
            if (clazz.equals(String.class) && element2.getText().trim().length() == 0 && element2.getChildren().size() > 0) {
                logger.info("found inner xml for input [%s], will encode it as string", element2.getName());
                if (element2.getChildren().size() > 1) {
                    logger.warn("multiple child elements present with input [%s], will encode only first element", element2.getName());
                }
                object5 = (Element)element2.getChildren().get(0);
                element2.removeContent();
                element2.setText(JDOMUtil.serialize((Element)object5));
                logger.debug("encoded input [%s] with xml [%s]", element2.getName(), element2.getText());
            }
            if (workflow.types.File.class.isAssignableFrom(clazz)) {
                object5 = element2.getChild("bytes");
                object4 = element2.getChild("name");
                object32 = element2.getChild("destPath");
                if (object5 != null && (object32 == null || object32.getTextTrim().length() == 0)) {
                    object2 = new BinaryConverter();
                    object = (byte[])((BinaryConverter)object2).fromString(object5.getTextTrim());
                    File file = new File(WorkflowProperties.getInstance().getJobResultsDir(), UUID.randomUUID().toString());
                    file.mkdirs();
                    File file2 = new File(file, object4.getTextTrim());
                    try {
                        IOUtils.write((byte[])object, (OutputStream)new FileOutputStream(file2));
                        element2.removeChild("bytes");
                        Element element3 = new Element("destPath");
                        element3.setText(file2.getAbsolutePath());
                        element2.addContent((Content)element3);
                        Element element4 = new Element("fileSize");
                        element4.setText(String.valueOf(file2.length()));
                        element2.addContent((Content)element4);
                    }
                    catch (Exception exception) {
                        logger.error("failed to create file [" + element2.getName() + "] from input [" + object4.getTextTrim() + "], error [" + exception.getMessage() + "]");
                    }
                }
            }
            if (EncryptedString.class.isAssignableFrom(clazz) && (object5 = element2.getAttributeValue("reencrypt")) != null && ((String)object5).equals("1") && element2.getText().length() > 0) {
                try {
                    logger.xml("re-encrypting input entry [%s]", JDOMUtil.serialize(element2));
                    object4 = Base64.decode((byte[])element2.getText().getBytes());
                    object2 = element2.getAttributeValue("encoding");
                    object32 = object2 != null && ((String)object2).length() > 0 ? new String((byte[])object4, (String)object2) : new String((byte[])object4);
                    object = new CVPassword();
                    element2.setText(object.encrypt((String)object32));
                }
                catch (Throwable throwable) {
                    logger.error("failed to re-encrypt input entry [" + JDOMUtil.serialize(element2) + "], message [" + throwable.getMessage() + "]");
                }
            }
            if (XML.class.isAssignableFrom(clazz)) {
                object5 = WorkflowElement.parse(element2.getTextNormalize());
                if (object5 != null) {
                    logger.xml("loaded xml input property [%s], xml [%s]", element2.getName(), object5);
                    ((WorkflowElement)object5).setName(element2.getName());
                    for (Object object32 : element2.getAttributes()) {
                        ((WorkflowElement)object5).setAttribute(object32.getName(), object32.getValue());
                    }
                    element2.detach();
                    element.addContent((Content)((WorkflowElement)object5).element);
                    logger.xml("converted input property [%s] to xml [%s]", element2.getName(), ((WorkflowElement)object5).toString());
                } else {
                    logger.xml("xml input property [%s] does not contain any xml", element2.getName());
                }
            }
            if (!CTEProcessingModel.class.isAssignableFrom(clazz)) continue;
            if (element2.getChildren().size() == 0) {
                object5 = WorkflowUtils.convertStringToMessage(clazz, element2.getText());
                if (object5 != null) {
                    logger.xml("converting input entry [%s] to entity type [%s]", JDOMUtil.serialize(element2), object5.getClass().getName());
                    object4 = evalManager.getMarshaller().encode(element2.getName(), object5);
                    if (object4.size() > 0) {
                        element.removeContent((Content)element2);
                        element.addContent((Content)((WorkflowElement)object4.get((int)0)).element);
                        continue;
                    }
                    logger.warn("did not retrieve any elements from encoding message type [%s] for input [%s]", object5.getClass(), element2.getName());
                    continue;
                }
                logger.xml("could not convert xml [%s] to message class [%s]", JDOMUtil.serialize(element2), object5.getClass().getName());
                continue;
            }
            object5 = evalManager.getMarshaller().decode(new WorkflowElement(element2));
            object4 = evalManager.getMarshaller().encode(element2.getName(), object5);
            if (object4.size() > 0) {
                element.removeContent((Content)element2);
                element.addContent((Content)((WorkflowElement)object4.get((int)0)).element);
                continue;
            }
            logger.warn("did not retrieve any elements from encoding message type [%s] for input [%s]", object5.getClass(), element2.getName());
        }
    }
}

