/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.cs.WF_Deploy_t;
import commvault.cte.workflow.db.engine.WF_Context_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_Imports_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_ProcessTransitions_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.db.engine.WF_Session_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.db.engine.WF_Token_t;
import commvault.cte.workflow.db.engine.WF_Trigger_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;
import java.util.List;

public class WorkflowDatabase
implements DataAccessLayer {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowDatabase.class);

    @Override
    public WF_Process_t newProcessRow() {
        return new WF_Process_t();
    }

    @Override
    public WF_Deploy_t newCommServDeployment() {
        return new WF_Deploy_t();
    }

    @Override
    public WF_Deployments_t newEngineDeployment() {
        return new WF_Deployments_t();
    }

    @Override
    public WF_Imports_t newImport() {
        return new WF_Imports_t();
    }

    @Override
    public WF_Steps_t newStep() {
        return new WF_Steps_t();
    }

    @Override
    public WF_StepTransitions_t newStepTransition() {
        return new WF_StepTransitions_t();
    }

    @Override
    public WF_ProcessSteps_t newProcessStep() {
        return new WF_ProcessSteps_t(){

            public boolean save() throws CTEDBException {
                return super.save();
            }
        };
    }

    @Override
    public List<WF_Imports_t> getImports(Integer n) throws CTEDBException {
        String string = String.format("DeploymentId = %s", n);
        return WF_Imports_t.select(string);
    }

    @Override
    public List<WF_ProcessSteps_t> getActivitiesForContext(int n) throws Exception {
        throw new Exception("not implemented");
    }

    private WF_ProcessSteps_t getLatestProcessStep(String string, int n, int n2) throws Exception {
        String string2 = "Name = '%s' AND jobId IN (SELECT jobId FROM WF_Context Where contextId = %s) AND wfJobId IN (SELECT wfJobId FROM WF_ProcessSteps Where ContextId = %s) AND (ParentId IS NULL OR ParentId in (Select ParentId From WF_ProcessSteps Where ContextId = %s) OR ParentId not in (Select ProcessStepId As ParentId From WF_ProcessSteps p INNER JOIN WF_Steps s ON p.StepId = s.StepId WHERE s.ClassName = 'commvault.cte.workflow.activities.ExecuteSuperProcess'))";
        String string3 = "ProcessStepId Desc";
        WF_ProcessSteps_t wF_ProcessSteps_t = new WF_ProcessSteps_t();
        String string4 = String.format(string2, string, n, n2, n);
        if (wF_ProcessSteps_t.fill(string4, string3)) {
            return wF_ProcessSteps_t;
        }
        return null;
    }

    @Override
    public WorkflowElement getActivityOutputs(String string, int n, int n2) throws Exception {
        String string2 = "Name = '%s' AND ContextId IN (SELECT ContextId FROM dbo.fnContextPath(%s))";
        String string3 = "ProcessStepId Desc";
        WF_ProcessSteps_t wF_ProcessSteps_t = new WF_ProcessSteps_t();
        if (wF_ProcessSteps_t.fill(String.format(string2, string, n), string3)) {
            return WorkflowElement.parse(wF_ProcessSteps_t.Outputs.get());
        }
        wF_ProcessSteps_t = this.getLatestProcessStep(string, n, n2);
        if (wF_ProcessSteps_t != null) {
            return WorkflowElement.parse(wF_ProcessSteps_t.Outputs.get());
        }
        logger.debug("did not find any activity for name [%s], contextId [%s]", string, n);
        return null;
    }

    @Override
    public WF_Context_t newContext() {
        return new WF_Context_t();
    }

    @Override
    public WF_Context_t getRootContext(long l, int n) throws CTEDBException {
        WF_Context_t wF_Context_t = new WF_Context_t();
        String string = String.format("jobId = %s AND commCellId = %s AND ParentId IS NULL", l, n);
        if (wF_Context_t.fill(string)) {
            return wF_Context_t;
        }
        return null;
    }

    @Override
    public WF_Context_t getContext(int n) throws CTEDBException {
        WF_Context_t wF_Context_t = new WF_Context_t();
        String string = String.format("ContextId = %s", n);
        if (wF_Context_t.fill(string)) {
            return wF_Context_t;
        }
        return null;
    }

    @Override
    public WF_Token_t newToken() {
        return new WF_Token_t();
    }

    @Override
    public WF_Token_t getToken(int n) throws CTEDBException {
        WF_Token_t wF_Token_t = new WF_Token_t();
        String string = String.format("TokenId = %s", n);
        if (wF_Token_t.fill(string)) {
            return wF_Token_t;
        }
        return null;
    }

    @Override
    public WF_Steps_t getStartStep(Integer n, Integer n2) throws CTEDBException {
        WF_Steps_t wF_Steps_t = new WF_Steps_t();
        String string = n2 == null ? String.format("DeploymentId = %s AND ParentStepId IS NULL AND WorkflowStart = 1", n) : String.format("ParentStepId = %s AND WorkflowStart = 1", n2);
        if (wF_Steps_t.fill(string)) {
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public WF_Steps_t getStep(int n) throws CTEDBException {
        WF_Steps_t wF_Steps_t = new WF_Steps_t();
        String string = String.format("StepId = %s", n);
        if (wF_Steps_t.fill(string)) {
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public WF_ProcessTransitions_t newProcessTransition() {
        return new WF_ProcessTransitions_t();
    }

    @Override
    public WF_ProcessSteps_t getProcessStep(int n) throws CTEDBException {
        WF_ProcessSteps_t wF_ProcessSteps_t = new WF_ProcessSteps_t();
        String string = String.format("ProcessStepId = %s", n);
        if (wF_ProcessSteps_t.fill(string)) {
            return wF_ProcessSteps_t;
        }
        return null;
    }

    @Override
    public WF_ProcessSteps_t getProcessStep(String string, int n) throws CTEDBException {
        return null;
    }

    @Override
    public WF_ProcessTransitions_t getTransition(int n) throws CTEDBException {
        WF_ProcessTransitions_t wF_ProcessTransitions_t = new WF_ProcessTransitions_t();
        String string = String.format("TransitionId = %s", n);
        if (wF_ProcessTransitions_t.fill(string)) {
            return wF_ProcessTransitions_t;
        }
        return null;
    }

    @Override
    public WF_ProcessTransitions_t getSourceTransition(int n) throws CTEDBException {
        WF_ProcessTransitions_t wF_ProcessTransitions_t = new WF_ProcessTransitions_t();
        String string = String.format("TargetProcessStepId = %s", n);
        if (wF_ProcessTransitions_t.fill(string)) {
            return wF_ProcessTransitions_t;
        }
        return null;
    }

    @Override
    public List<WF_ProcessTransitions_t> getTargetTransition(int n) throws CTEDBException {
        String string = String.format("TargetProcessStepId = %s", n);
        return WF_ProcessTransitions_t.select(string);
    }

    @Override
    public WF_Steps_t getStep(String string, Integer n) throws CTEDBException {
        WF_Steps_t wF_Steps_t = new WF_Steps_t();
        String string2 = String.format("UniqueName = '%s' AND DeploymentId = %s", string, n);
        if (wF_Steps_t.fill(string2)) {
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public WF_SuperProcess_t newSuperProcess() {
        return new WF_SuperProcess_t();
    }

    @Override
    public WF_Trigger_t newTrigger() {
        return new WF_Trigger_t();
    }

    @Override
    public WF_SuperProcess_t getSuperProcess(long l) throws CTEDBException {
        WF_SuperProcess_t wF_SuperProcess_t = new WF_SuperProcess_t();
        String string = String.format("SuperProcessId = %s", l);
        if (wF_SuperProcess_t.fill(string)) {
            return wF_SuperProcess_t;
        }
        return null;
    }

    @Override
    public List<WF_SuperProcess_t> getSuperProcesses(int n) throws CTEDBException {
        String string = String.format("ProcessStepId = %s", n);
        return WF_SuperProcess_t.select(string);
    }

    @Override
    public List<WF_SuperProcess_t> getSuperProcesses(int n, ExecutionState executionState) throws CTEDBException {
        String string = String.format("ProcessStepId = %s AND State = %s", n, executionState.toInt());
        return WF_SuperProcess_t.select(string);
    }

    @Override
    public List<WF_Token_t> getTokens(long l, int n) throws CTEDBException {
        String string = String.format("jobId = %s AND commCellId = %s", l, n);
        return WF_Token_t.select(string);
    }

    @Override
    public List<WF_Trigger_t> getTriggers(long l, int n) throws CTEDBException {
        String string = String.format("jobId = %s AND commCellId = %s", l, n);
        return WF_Trigger_t.select(string);
    }

    @Override
    public WF_ProcessSteps_t getLastProcessStep(String string) throws CTEDBException {
        return null;
    }

    @Override
    public List<WF_ProcessSteps_t> getRunningSteps(long l) throws CTEDBException {
        String string = String.format("jobId = %s AND State < 3", l);
        return WF_ProcessSteps_t.select(string);
    }

    @Override
    public void setStepsCompleted() throws CTEDBException {
    }

    @Override
    public List<WF_ProcessSteps_t> getProcessSteps(int n) throws CTEDBException {
        String string = String.format("ProcessStepId IN (Select Max(ProcessStepId) As ProcessStepId FROM WF_ProcessSteps Where superProcessId = %s GROUP BY Name)", n);
        return WF_ProcessSteps_t.select(string);
    }

    @Override
    public List<WF_ProcessSteps_t> getProcessSteps(long l, Integer n, ExecutionState executionState) throws CTEDBException {
        String string = n == null ? String.format("jobId = %s AND ParentId IS NULL", l) : String.format("SuperProcessId = %s", n);
        if (executionState != null) {
            string = string + String.format(" AND State = %s", executionState.toInt());
        }
        return WF_ProcessSteps_t.select(string);
    }

    @Override
    public List<WF_Steps_t> getEventSteps(Integer n, String string) throws CTEDBException {
        String string2 = String.format("DeploymentId = %s AND ParentStepId IS NULL AND ClassName = '%s'", n, string);
        return WF_Steps_t.select(string2);
    }

    @Override
    public List<WF_StepTransitions_t> getStepTransitions(int n) throws CTEDBException {
        String string = String.format("StepId = %s", n);
        return WF_StepTransitions_t.select(string);
    }

    @Override
    public List<WF_StepTransitions_t> getStepTransitionsForTarget(int n) throws CTEDBException {
        String string = String.format("TargetStepId = %s", n);
        return WF_StepTransitions_t.select(string);
    }

    @Override
    public int setBreakpoint(long l, int n, String string, boolean bl) throws CTEDBException {
        return 0;
    }

    @Override
    public int clearBreakpoints(long l, int n) throws CTEDBException {
        return 0;
    }

    @Override
    public boolean removeProcessStep(int n) throws CTEDBException {
        WF_ProcessSteps_t wF_ProcessSteps_t = this.getProcessStep(n);
        if (wF_ProcessSteps_t != null) {
            return wF_ProcessSteps_t.delete();
        }
        return false;
    }

    @Override
    public List<WF_Session_t> getExistingSessions(long l, int n) throws CTEDBException {
        String string = String.format("jobId = %s AND commCellId = %s", l, n);
        return WF_Session_t.select(string);
    }

    @Override
    public WF_Session_t newSessionRow() {
        return new WF_Session_t();
    }

    @Override
    public List<WF_ProcessTransitions_t> getCompletedTransitions(int n, int n2) throws CTEDBException {
        String string = String.format("TargetStepId = %s AND ContextId = %s", n, n2);
        return WF_ProcessTransitions_t.select(string);
    }

    @Override
    public DataAccessLayer getChildDataAccess(int n) {
        return new WorkflowDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreviousActivityInstance(int n, int n2) {
        String string = "WITH ctx AS (SELECT ProcessStepId FROM WF_ProcessSteps WHERE ProcessStepId IN (Select ProcessStepId FROM WF_ProcessSteps Where StepId = ? AND ContextId = ?) UNION ALL SELECT s.ProcessStepId FROM WF_ProcessSteps s INNER JOIN ctx t ON t.ProcessStepId = s.ParentId) DELETE WF_ProcessSteps WHERE ProcessStepId IN (SELECT ProcessStepId FROM ctx)";
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
        }
    }
}

