/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.DBConn;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WorkflowConnection
implements CTEDBConnection,
Repeatable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowConnection.class);
    private static final String NAMED_PIPES = "np:";
    private static final String[] PROTOCOL_PREFIX = new String[]{"np:", "tcp:", "lpc:"};
    private static final int MAX_ATTEMPTS = 3;
    private static final int ALERT_TIME = WorkflowRegistry.getInstance().getAlertQueryTime();
    private static final int MAX_CONNECTIONS = WorkflowRegistry.getInstance().getMaxDatabaseConnections();
    private static final int MAX_IDLE_TIME = WorkflowRegistry.getInstance().getDatabaseConnectionLength();
    public static final boolean JTDS_CONNECTION = WorkflowRegistry.getInstance().isUseJTDS();
    public static final boolean INTEGRATED_SECURITY = WorkflowRegistry.getInstance().isUseIntegratedSecurity();
    private final LinkedList<ConnectionObject> availableConnections = new LinkedList();
    private final List<ConnectionObject> usedConnections = new ArrayList<ConnectionObject>();
    private final DBConn connectionType;
    private final String databaseName;
    private Object lock = new Object[0];

    public static String getDatabaseURL(CTEDBConnInfo cTEDBConnInfo, String string) {
        return WorkflowConnection.getDatabaseURL(cTEDBConnInfo.getInstance(), string, cTEDBConnInfo.getPort());
    }

    public static String getDatabaseURL(String string, String string2) {
        return WorkflowConnection.getDatabaseURL(string, string2, 0);
    }

    private static String parseName(String string) {
        String[] stringArray = string.split(",");
        return stringArray[0].trim();
    }

    /*
     * WARNING - void declaration
     */
    public static String getDatabaseURL(String string, String string2, int n) {
        void var4_13;
        boolean bl = false;
        for (String string3 : PROTOCOL_PREFIX) {
            if (!string.toLowerCase().startsWith(string3)) continue;
            if (string3.equals(NAMED_PIPES)) {
                bl = true;
            }
            string = string.substring(string3.length());
            break;
        }
        if (JTDS_CONNECTION) {
            String string4;
            Object var4_5 = null;
            int n2 = string.indexOf(92);
            if (n2 > -1) {
                String string5 = WorkflowConnection.parseName(string.substring(n2 + 1));
                string = WorkflowConnection.parseName(string.substring(0, n2));
            }
            if (n > 0) {
                string4 = String.format("jdbc:jtds:sqlserver://%s:%s/%s", string, n, string2);
            } else {
                void var4_7;
                string4 = String.format("jdbc:jtds:sqlserver://%s/%s", string, string2);
                if (var4_7 != null) {
                    string4 = string4 + String.format(";instance=%s", var4_7);
                }
            }
            if (bl) {
                string4 = string4 + ";namedPipe=true";
            }
            if (INTEGRATED_SECURITY) {
                string4 = string4 + ";useNTLMv2=true";
            }
            return string4;
        }
        String string6 = null;
        int n3 = string.indexOf(92);
        if (n3 > -1) {
            string6 = WorkflowConnection.parseName(string.substring(n3 + 1));
            string = WorkflowConnection.parseName(string.substring(0, n3));
        }
        if (n > 0) {
            String string7 = String.format("jdbc:sqlserver://%s:%s;databaseName=%s;", string, n, string2);
        } else if (string6 != null && string6.length() > 0) {
            String string8 = String.format("jdbc:sqlserver://%s\\%s;databaseName=%s;", string, string6, string2);
        } else {
            String string9 = String.format("jdbc:sqlserver://%s;databaseName=%s;", string, string2);
        }
        if (INTEGRATED_SECURITY) {
            void var4_11;
            String string10 = (String)var4_11 + ";integratedSecurity=true";
        }
        return var4_13;
    }

    public WorkflowConnection(DBConn dBConn, String string) {
        this.connectionType = dBConn;
        this.databaseName = string;
    }

    private CTEDBConnInfo getConnInfo() {
        if (this.connectionType == DBConn.WFENGINE) {
            return WorkflowRegistry.getInstance().getEngineDatabaseConnection();
        }
        return WorkflowRegistry.getInstance().getCommServDatabaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAlive() throws Exception {
        int n = DateUtilities.getNow();
        while (true) {
            CTEDBConnInfo cTEDBConnInfo = this.getConnInfo();
            String string = WorkflowConnection.getDatabaseURL(cTEDBConnInfo, this.databaseName);
            Connection connection = null;
            try {
                if (INTEGRATED_SECURITY) {
                    connection = DriverManager.getConnection(string);
                    break;
                }
                connection = DriverManager.getConnection(string, cTEDBConnInfo.getUserId(), cTEDBConnInfo.getPassword());
                break;
            }
            catch (SQLException sQLException) {
                if (DateUtilities.getNow() - n > 120) {
                    throw sQLException;
                }
                logger.error("failed to connect to url [" + string + "], retry in 10 seconds, error [" + sQLException.getMessage() + "]");
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            Thread.sleep(10000L);
        }
    }

    public Connection createConnection() throws InterruptedException {
        while (true) {
            try {
                CTEDBConnInfo cTEDBConnInfo = this.getConnInfo();
                String string = WorkflowConnection.getDatabaseURL(cTEDBConnInfo, this.databaseName);
                if (INTEGRATED_SECURITY) {
                    return DriverManager.getConnection(string);
                }
                return DriverManager.getConnection(string, cTEDBConnInfo.getUserId(), cTEDBConnInfo.getPassword());
            }
            catch (SQLException sQLException) {
                logger.debug("error connecting to database [%s], message [%s], will retry", this.connectionType.toString(), sQLException.getMessage());
                Thread.sleep(60000L);
                continue;
            }
            break;
        }
    }

    public String toString() {
        return String.valueOf((Object)this.connectionType);
    }

    public CTEDBReservation createReservation() {
        return new WorkflowReservation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.trace("beginning check on database [%s]", this.connectionType.toString());
        Object object = this.lock;
        synchronized (object) {
            if (this.availableConnections.size() > 0) {
                Iterator iterator = this.availableConnections.iterator();
                while (iterator.hasNext()) {
                    ConnectionObject connectionObject = (ConnectionObject)iterator.next();
                    int n = DateUtilities.getNow() - connectionObject.checkoutTime;
                    if (n < MAX_IDLE_TIME) continue;
                    iterator.remove();
                    connectionObject.close();
                }
            }
        }
        logger.trace("completed check on database [%s]", this.connectionType.toString());
    }

    @Override
    public int getInterval() {
        return 60;
    }

    private class ConnectionObject {
        private Connection conn = null;
        private int checkoutTime;

        private ConnectionObject() {
        }

        private void update() {
            this.checkoutTime = DateUtilities.getNow();
        }

        public Connection getConnection() throws SQLException {
            if (this.conn == null) {
                CTEDBConnInfo cTEDBConnInfo = WorkflowConnection.this.getConnInfo();
                String string = WorkflowConnection.getDatabaseURL(cTEDBConnInfo, WorkflowConnection.this.databaseName);
                this.conn = INTEGRATED_SECURITY ? DriverManager.getConnection(string) : DriverManager.getConnection(string, cTEDBConnInfo.getUserId(), cTEDBConnInfo.getPassword());
            }
            return this.conn;
        }

        public boolean isValid() throws SQLException {
            if (this.conn == null) {
                return true;
            }
            if (JTDS_CONNECTION) {
                return this.isJTDSValid();
            }
            return this.getConnection().isValid(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isJTDSValid() {
            boolean bl;
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery("select @@spid");
                boolean bl2 = resultSet.next() && resultSet.getObject(1) != null;
                resultSet.close();
                statement.close();
                bl = bl2;
                if (statement == null) return bl;
            }
            catch (Throwable throwable) {
                try {
                    boolean bl3 = false;
                    return bl3;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            try {
                statement.close();
                return bl;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return bl;
        }

        private void close() {
            try {
                logger.trace("closing connection for [%s]", WorkflowConnection.this.connectionType.toString());
                this.conn.close();
            }
            catch (SQLException sQLException) {
                logger.error("error closing connection for [" + WorkflowConnection.this.connectionType.toString() + "]", sQLException);
            }
        }
    }

    public class WorkflowReservation
    implements CTEDBReservation {
        private boolean b_closed = false;
        private Statement m_statement = null;
        private ConnectionObject m_connection = null;
        private int createdTime = DateUtilities.getNow();
        private int checkoutTime;
        private int poolWaitTime;
        private int queryStartTime;
        private int queryEndTime;
        private int connectionTime;
        private String sqlStatement = null;
        private int attempts = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkin() {
            Object object = WorkflowConnection.this.lock;
            synchronized (object) {
                WorkflowConnection.this.usedConnections.remove(this.m_connection);
                WorkflowConnection.this.availableConnections.addFirst(this.m_connection);
                WorkflowConnection.this.lock.notify();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ConnectionObject checkout() throws CTEDBException {
            Object object = WorkflowConnection.this.lock;
            synchronized (object) {
                int n = DateUtilities.getNow();
                ConnectionObject connectionObject = null;
                while (true) {
                    if ((connectionObject = (ConnectionObject)WorkflowConnection.this.availableConnections.pollFirst()) == null && (MAX_CONNECTIONS <= 0 || WorkflowConnection.this.usedConnections.size() < MAX_CONNECTIONS)) {
                        logger.debug("no connections available in pool [%s], creating a new one", WorkflowConnection.this.connectionType.toString());
                        connectionObject = new ConnectionObject();
                    }
                    if (connectionObject != null) {
                        WorkflowConnection.this.usedConnections.add(connectionObject);
                        connectionObject.update();
                        this.poolWaitTime = DateUtilities.getNow() - n;
                        return connectionObject;
                    }
                    logger.info("database connection pool for [%s] has reached max connections [%s]", WorkflowConnection.this.connectionType.toString(), WorkflowConnection.this.usedConnections.size());
                    try {
                        WorkflowConnection.this.lock.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CTEDBException((Throwable)interruptedException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection() throws CTEDBException {
            int n = DateUtilities.getNow();
            while (true) {
                if (this.m_connection == null) {
                    this.m_connection = this.checkout();
                }
                try {
                    if (this.m_connection.isValid()) break;
                    this.m_connection.close();
                    logger.warn("removing connection from pool [%s] becuase it is no longer valid", WorkflowConnection.this.connectionType.toString());
                    Object object = WorkflowConnection.this.lock;
                    synchronized (object) {
                        WorkflowConnection.this.usedConnections.remove(this.m_connection);
                    }
                    this.m_connection = null;
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error validing connection", sQLException);
                }
            }
            int n2 = DateUtilities.getNow();
            this.checkoutTime = n2 - n;
            try {
                Connection connection = this.m_connection.getConnection();
                return connection;
            }
            catch (SQLException sQLException) {
                throw new CTEDBException(sQLException);
            }
            finally {
                this.connectionTime = DateUtilities.getNow() - n2;
            }
        }

        private void validate() throws CTEDBException {
            if (this.b_closed) {
                throw new CTEDBException("the reservation has already been closed");
            }
            if (this.m_statement != null) {
                throw new CTEDBException("statement already exists for reservation");
            }
        }

        public PreparedStatement createStatement(String string) throws CTEDBException {
            return this.createStatement(string, false);
        }

        public CallableStatement createCallableStatement(String string) throws CTEDBException {
            CallableStatement callableStatement;
            this.validate();
            this.sqlStatement = string;
            try {
                callableStatement = this.getConnection().prepareCall(string);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error creating callable statement for sql [" + string + "]", sQLException);
            }
            this.m_statement = callableStatement;
            this.queryStartTime = DateUtilities.getNow();
            return callableStatement;
        }

        public PreparedStatement createStatement(String string, boolean bl) throws CTEDBException {
            PreparedStatement preparedStatement;
            this.validate();
            this.sqlStatement = string;
            try {
                preparedStatement = bl ? this.getConnection().prepareStatement(string, 1) : this.getConnection().prepareStatement(string, 2);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error preparing statement for sql [" + string + "]", sQLException);
            }
            this.m_statement = preparedStatement;
            this.queryStartTime = DateUtilities.getNow();
            return preparedStatement;
        }

        public Statement createStatement() throws CTEDBException {
            this.validate();
            try {
                this.m_statement = this.getConnection().createStatement();
                this.queryStartTime = DateUtilities.getNow();
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error creating statement", sQLException);
            }
            return this.m_statement;
        }

        public ResultSet executeQuery(String string) throws CTEDBException {
            while (true) {
                try {
                    this.createStatement();
                    this.sqlStatement = string;
                    this.queryStartTime = DateUtilities.getNow();
                    return this.m_statement.executeQuery(string);
                }
                catch (SQLException sQLException) {
                    if (this.attempts <= 3 && sQLException.getMessage().contains("deadlocked")) {
                        logger.info("caught sql exception [" + sQLException.getMessage() + "], error code [" + sQLException.getErrorCode() + "], attempt [" + this.attempts + " of " + 3 + "]");
                        this.closeStatement();
                        ++this.attempts;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new CTEDBException("failed to execute query [" + string + "]", (Throwable)interruptedException);
                        }
                        continue;
                    }
                    throw new CTEDBException("failed to execute query [" + string + "]", sQLException);
                }
                break;
            }
        }

        public boolean execute(String string) throws CTEDBException {
            while (true) {
                try {
                    this.createStatement();
                    this.sqlStatement = string;
                    this.queryStartTime = DateUtilities.getNow();
                    return this.m_statement.execute(string);
                }
                catch (SQLException sQLException) {
                    if (this.attempts <= 3 && sQLException.getMessage().contains("deadlocked")) {
                        logger.info("caught sql exception [" + sQLException.getMessage() + "], error code [" + sQLException.getErrorCode() + "], attempt [" + this.attempts + " of " + 3 + "]");
                        this.closeStatement();
                        ++this.attempts;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new CTEDBException("failed to execute query [" + string + "]", (Throwable)interruptedException);
                        }
                        continue;
                    }
                    throw new CTEDBException("failed to execute query [" + string + "]", sQLException);
                }
                break;
            }
        }

        public int executeUpdate(String string) throws CTEDBException {
            try {
                this.createStatement();
                this.sqlStatement = string;
                this.queryStartTime = DateUtilities.getNow();
                return this.m_statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("failed to execute update [" + string + "]", sQLException);
            }
        }

        private void closeStatement() {
            if (this.m_statement != null) {
                try {
                    this.m_statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.m_statement = null;
            }
        }

        public void close() {
            this.queryEndTime = DateUtilities.getNow();
            this.closeStatement();
            if (this.m_connection != null) {
                this.checkin();
            }
            this.b_closed = true;
            int n = DateUtilities.getNow();
            int n2 = n - this.queryEndTime;
            int n3 = n - this.createdTime;
            int n4 = this.queryEndTime - this.queryStartTime;
            if (this.sqlStatement != null && n3 >= ALERT_TIME) {
                logger.info("query time=[%s] seconds, conn=[%s] seconds, checkout time=[%s] seconds, pool time=[%s] seconds, checkin time=[%s] seconds, total=[%s] seconds, query: %s", n4, this.connectionTime, this.checkoutTime, this.poolWaitTime, n2, n3, this.sqlStatement);
            }
        }
    }
}

