/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.db.WorkflowConnection;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SimpleConnection
implements CTEDBConnection {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SimpleConnection.class);
    private String m_URLString = null;
    private String m_UserName = null;
    private String m_Password = null;

    public SimpleConnection(CTEDBConnInfo cTEDBConnInfo, String string) {
        this(WorkflowConnection.getDatabaseURL(cTEDBConnInfo, string), cTEDBConnInfo.getUserId(), cTEDBConnInfo.getPassword());
    }

    public SimpleConnection(String string, String string2, String string3) {
        this.m_URLString = string;
        this.m_UserName = string2;
        this.m_Password = string3;
    }

    private Connection checkout() throws CTEDBException {
        try {
            return DriverManager.getConnection(this.m_URLString, this.m_UserName, this.m_Password);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
    }

    public void checkAlive() throws Exception {
    }

    public Connection createConnection() throws InterruptedException {
        while (true) {
            try {
                return DriverManager.getConnection(this.m_URLString, this.m_UserName, this.m_Password);
            }
            catch (SQLException sQLException) {
                logger.debug("error connecting to url [%s], message [%s], will retry", this.m_URLString, sQLException.getMessage());
                Thread.sleep(60000L);
                continue;
            }
            break;
        }
    }

    public CTEDBReservation createReservation() {
        return new SimpleReservation();
    }

    public String toString() {
        return this.m_URLString;
    }

    public class SimpleReservation
    implements CTEDBReservation {
        private boolean b_closed = false;
        private Statement m_statement = null;
        private Connection m_connection = null;

        private Connection getConnection() throws CTEDBException {
            if (this.m_connection == null) {
                this.m_connection = SimpleConnection.this.checkout();
            }
            return this.m_connection;
        }

        private void validate() throws CTEDBException {
            if (this.b_closed) {
                throw new CTEDBException("the reservation has already been closed");
            }
            if (this.m_statement != null) {
                throw new CTEDBException("statement already exists for reservation");
            }
        }

        public PreparedStatement createStatement(String string) throws CTEDBException {
            return this.createStatement(string, false);
        }

        public CallableStatement createCallableStatement(String string) throws CTEDBException {
            CallableStatement callableStatement;
            this.validate();
            try {
                callableStatement = this.getConnection().prepareCall(string);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error creating callable statement for sql [" + string + "]", sQLException);
            }
            this.m_statement = callableStatement;
            return callableStatement;
        }

        public PreparedStatement createStatement(String string, boolean bl) throws CTEDBException {
            PreparedStatement preparedStatement;
            this.validate();
            try {
                preparedStatement = bl ? this.getConnection().prepareStatement(string, 1) : this.getConnection().prepareStatement(string, 2);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error preparing statement for sql [" + string + "]", sQLException);
            }
            this.m_statement = preparedStatement;
            return preparedStatement;
        }

        public Statement createStatement() throws CTEDBException {
            this.validate();
            try {
                this.m_statement = this.getConnection().createStatement();
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error creating statement", sQLException);
            }
            return this.m_statement;
        }

        public ResultSet executeQuery(String string) throws CTEDBException {
            try {
                return this.createStatement().executeQuery(string);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("failed to execute query [" + string + "]", sQLException);
            }
        }

        public boolean execute(String string) throws CTEDBException {
            try {
                return this.createStatement().execute(string);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("failed to execute [" + string + "]", sQLException);
            }
        }

        public int executeUpdate(String string) throws CTEDBException {
            try {
                return this.createStatement().executeUpdate(string);
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("failed to execute update [" + string + "]", sQLException);
            }
        }

        public void close() {
            if (this.m_statement != null) {
                try {
                    this.m_statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.b_closed = true;
        }
    }
}

