/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.db.ApplicationDatabase;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.cs.WF_Deploy_t;
import commvault.cte.workflow.db.engine.WF_Context_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_Imports_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_ProcessTransitions_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.db.engine.WF_Session_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.db.engine.WF_Token_t;
import commvault.cte.workflow.db.engine.WF_Trigger_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.StepFlags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OnDemandDatabase
implements DataAccessLayer {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OnDemandDatabase.class);
    private static AtomicInteger IDENTITY = new AtomicInteger(1);
    public WF_Deploy_t commservDeploymentRow;
    public WF_Deployments_t engineDeploymentRow;
    public List<WF_Imports_t> importRows = new ArrayList<WF_Imports_t>();
    public List<WF_Steps_t> stepRows = new ArrayList<WF_Steps_t>();
    public List<WF_StepTransitions_t> stepTransitionRows = new ArrayList<WF_StepTransitions_t>();
    public List<WF_Context_t> contextRows = new ArrayList<WF_Context_t>();
    public List<WF_Token_t> tokenRows = new ArrayList<WF_Token_t>();
    public List<WF_ProcessSteps_t> processStepRows = new ArrayList<WF_ProcessSteps_t>();
    public List<WF_ProcessTransitions_t> processTransitionRows = new ArrayList<WF_ProcessTransitions_t>();
    public List<WF_SuperProcess_t> superProcessRows = new ArrayList<WF_SuperProcess_t>();
    public List<WF_Trigger_t> triggerRows = new ArrayList<WF_Trigger_t>();
    public List<WF_Session_t> sessionRows = new ArrayList<WF_Session_t>();
    private Map<Integer, DataAccessLayer> childLayers = new HashMap<Integer, DataAccessLayer>();

    private static int NEXT_ID() {
        return IDENTITY.getAndIncrement();
    }

    @Override
    public DataAccessLayer getChildDataAccess(int n) {
        DataAccessLayer dataAccessLayer = this.childLayers.get(n);
        if (dataAccessLayer == null) {
            dataAccessLayer = new ApplicationDatabase();
            this.childLayers.put(n, dataAccessLayer);
        }
        return dataAccessLayer;
    }

    public synchronized void update(OnDemandDatabase onDemandDatabase) throws EvFailureException {
        Object object;
        Object object2;
        this.commservDeploymentRow.setValues(onDemandDatabase.commservDeploymentRow);
        this.engineDeploymentRow.setValues(onDemandDatabase.engineDeploymentRow);
        for (WF_Steps_t engineStorage : this.stepRows) {
            object2 = onDemandDatabase.getStep(engineStorage.StepId.get());
            if (object2 != null) {
                object = engineStorage.ParentStepId.get();
                engineStorage.setValues((WF_Steps_t)((Object)object2));
                engineStorage.ParentStepId.set((Integer)object);
                continue;
            }
            logger.warn("could not find step id [%s] for activity [%s] in new deployed database", engineStorage.StepId.get(), engineStorage.UniqueName.get());
        }
        for (WF_StepTransitions_t wF_StepTransitions_t : this.stepTransitionRows) {
            object2 = null;
            for (Object object3 : onDemandDatabase.stepTransitionRows) {
                if (!object3.SourceActivity.get().equalsIgnoreCase(wF_StepTransitions_t.SourceActivity.get()) || !object3.TargetActivity.get().equalsIgnoreCase(wF_StepTransitions_t.TargetActivity.get())) continue;
                object2 = object3;
                break;
            }
            if (object2 != null) {
                Object object3;
                object = wF_StepTransitions_t.StepId.get();
                object3 = wF_StepTransitions_t.TargetStepId.get();
                wF_StepTransitions_t.setValues((WF_StepTransitions_t)((Object)object2));
                wF_StepTransitions_t.StepId.set((Integer)object);
                wF_StepTransitions_t.TargetStepId.set((Integer)object3);
                continue;
            }
            logger.warn("could not find transition for source activity [%s] target activity [%s] in new deployed database ", wF_StepTransitions_t.SourceActivity.get(), wF_StepTransitions_t.TargetActivity.get());
        }
    }

    @Override
    public WF_Process_t newProcessRow() {
        return new WF_Process_t();
    }

    @Override
    public synchronized WF_Deploy_t newCommServDeployment() {
        this.commservDeploymentRow = new WF_Deploy_t(){

            public boolean save() {
                this.DeployId.set(Integer.valueOf(0));
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return this.commservDeploymentRow;
    }

    public synchronized WF_Deploy_t getCommServDeployment() {
        return this.commservDeploymentRow;
    }

    @Override
    public synchronized WF_Deployments_t newEngineDeployment() {
        this.engineDeploymentRow = new WF_Deployments_t(){

            public boolean save() {
                this.DeploymentId.set(Integer.valueOf(0));
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return this.engineDeploymentRow;
    }

    public synchronized WF_Deployments_t getEngineDeployment() {
        return this.engineDeploymentRow;
    }

    @Override
    public synchronized WF_Imports_t newImport() {
        WF_Imports_t wF_Imports_t = new WF_Imports_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.ImportId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.importRows.add(this);
                        this.ImportId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_Imports_t;
    }

    @Override
    public synchronized WF_Steps_t newStep() {
        WF_Steps_t wF_Steps_t = new WF_Steps_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.StepId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.stepRows.add(this);
                        this.StepId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_Steps_t;
    }

    @Override
    public synchronized WF_StepTransitions_t newStepTransition() {
        WF_StepTransitions_t wF_StepTransitions_t = new WF_StepTransitions_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.TransitionId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.stepTransitionRows.add(this);
                        this.TransitionId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_StepTransitions_t;
    }

    @Override
    public synchronized WF_ProcessSteps_t newProcessStep() {
        WF_ProcessSteps_t wF_ProcessSteps_t = new WF_ProcessSteps_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.ProcessStepId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.processStepRows.add(this);
                        this.ProcessStepId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_ProcessSteps_t;
    }

    @Override
    public synchronized List<WF_Imports_t> getImports(Integer n) {
        return this.importRows;
    }

    @Override
    public synchronized WF_Context_t newContext() {
        WF_Context_t wF_Context_t = new WF_Context_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.ContextId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.contextRows.add(this);
                        this.ContextId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_Context_t;
    }

    @Override
    public synchronized WF_Context_t getContext(int n) {
        ListIterator<WF_Context_t> listIterator = this.contextRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Context_t wF_Context_t = listIterator.next();
            if (wF_Context_t.ContextId.get() != n) continue;
            return wF_Context_t;
        }
        return null;
    }

    @Override
    public synchronized List<WF_ProcessSteps_t> getActivitiesForContext(int n) throws Exception {
        List<Integer> list = this.getContextPath(n);
        HashMap<String, WF_ProcessSteps_t> hashMap = new HashMap<String, WF_ProcessSteps_t>();
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t = listIterator.next();
            if (!list.contains(wF_ProcessSteps_t.ContextId.get())) continue;
            if (hashMap.containsKey(wF_ProcessSteps_t.Name.get())) {
                if (wF_ProcessSteps_t.ProcessStepId.get() <= ((WF_ProcessSteps_t)((Object)hashMap.get((Object)wF_ProcessSteps_t.Name.get()))).ProcessStepId.get()) continue;
                hashMap.put(wF_ProcessSteps_t.Name.get(), wF_ProcessSteps_t);
                continue;
            }
            hashMap.put(wF_ProcessSteps_t.Name.get(), wF_ProcessSteps_t);
        }
        return new ArrayList<WF_ProcessSteps_t>(hashMap.values());
    }

    @Override
    public synchronized WorkflowElement getActivityOutputs(String string, int n, int n2) throws Exception {
        List<Integer> list = this.getContextPath(n);
        WF_ProcessSteps_t wF_ProcessSteps_t = null;
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t2 = listIterator.next();
            if (!wF_ProcessSteps_t2.Name.get().equals(string) || !list.contains(wF_ProcessSteps_t2.ContextId.get()) || wF_ProcessSteps_t != null && wF_ProcessSteps_t2.ProcessStepId.get() <= wF_ProcessSteps_t.ProcessStepId.get()) continue;
            wF_ProcessSteps_t = wF_ProcessSteps_t2;
        }
        if (wF_ProcessSteps_t == null) {
            wF_ProcessSteps_t = this.getProcessStep(string, -1);
            if (wF_ProcessSteps_t == null) {
                logger.warn("did not find any activity for name [%s], contextId [%s]", string, n);
                return null;
            }
            logger.debug("did not find activity outputs for [%s], contextId [%s], so returning latest executed step version", string, n);
        }
        return WorkflowElement.parse(wF_ProcessSteps_t.Outputs.get());
    }

    private List<Integer> getContextPath(int n) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n);
        this.updateContextPath(this.getContext(n), arrayList);
        return arrayList;
    }

    private void updateContextPath(WF_Context_t wF_Context_t, List<Integer> list) {
        if (wF_Context_t != null && !wF_Context_t.ParentId.isNull()) {
            list.add(wF_Context_t.ParentId.get());
            this.updateContextPath(this.getContext(wF_Context_t.ParentId.get()), list);
        }
    }

    @Override
    public synchronized WF_Context_t getRootContext(long l, int n) {
        ListIterator<WF_Context_t> listIterator = this.contextRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Context_t wF_Context_t = listIterator.next();
            if (!wF_Context_t.ParentId.isNull()) continue;
            return wF_Context_t;
        }
        return null;
    }

    @Override
    public synchronized WF_Token_t newToken() {
        WF_Token_t wF_Token_t = new WF_Token_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.TokenId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.tokenRows.add(this);
                        this.TokenId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_Token_t;
    }

    @Override
    public synchronized WF_Token_t getToken(int n) {
        ListIterator<WF_Token_t> listIterator = this.tokenRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Token_t wF_Token_t = listIterator.next();
            if (wF_Token_t.TokenId.get() != n) continue;
            return wF_Token_t;
        }
        return null;
    }

    @Override
    public synchronized WF_Steps_t getStartStep(Integer n, Integer n2) {
        ListIterator<WF_Steps_t> listIterator = this.stepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Steps_t wF_Steps_t = listIterator.next();
            if (!(n2 == null ? wF_Steps_t.ParentStepId.isNull() && wF_Steps_t.WorkflowStart.get() != false : !wF_Steps_t.ParentStepId.isNull() && wF_Steps_t.ParentStepId.get().intValue() == n2.intValue() && wF_Steps_t.WorkflowStart.get() != false)) continue;
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public synchronized WF_Steps_t getStep(int n) {
        ListIterator<WF_Steps_t> listIterator = this.stepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Steps_t wF_Steps_t = listIterator.next();
            if (wF_Steps_t.StepId.get() != n) continue;
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public synchronized WF_ProcessTransitions_t newProcessTransition() {
        WF_ProcessTransitions_t wF_ProcessTransitions_t = new WF_ProcessTransitions_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.ProcessTransitionId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.processTransitionRows.add(this);
                        this.ProcessTransitionId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_ProcessTransitions_t;
    }

    @Override
    public synchronized WF_ProcessSteps_t getLastProcessStep(String string) {
        WF_ProcessSteps_t wF_ProcessSteps_t = null;
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t2 = listIterator.next();
            if (!wF_ProcessSteps_t2.Name.get().equals(string) || wF_ProcessSteps_t != null && wF_ProcessSteps_t2.ProcessStepId.get() <= wF_ProcessSteps_t.ProcessStepId.get()) continue;
            wF_ProcessSteps_t = wF_ProcessSteps_t2;
        }
        return wF_ProcessSteps_t;
    }

    @Override
    public List<WF_ProcessSteps_t> getRunningSteps(long l) throws CTEDBException {
        ArrayList<WF_ProcessSteps_t> arrayList = new ArrayList<WF_ProcessSteps_t>();
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t = listIterator.next();
            if (wF_ProcessSteps_t.State.get() >= ExecutionState.COMPLETED.toInt()) continue;
            arrayList.add(wF_ProcessSteps_t);
        }
        return arrayList;
    }

    @Override
    public synchronized void setStepsCompleted() {
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t = listIterator.next();
            if (wF_ProcessSteps_t.State.get() >= ExecutionState.COMPLETED.toInt()) continue;
            wF_ProcessSteps_t.Status.set(Integer.valueOf(ProcessStatus.COMPLETED.toInt()));
            wF_ProcessSteps_t.State.set(Integer.valueOf(ExecutionState.COMPLETED.toInt()));
        }
    }

    @Override
    public synchronized WF_SuperProcess_t getSuperProcess(long l) {
        ListIterator<WF_SuperProcess_t> listIterator = this.superProcessRows.listIterator();
        while (listIterator.hasNext()) {
            WF_SuperProcess_t wF_SuperProcess_t = listIterator.next();
            if ((long)wF_SuperProcess_t.SuperProcessId.get().intValue() != l) continue;
            return wF_SuperProcess_t;
        }
        return null;
    }

    @Override
    public synchronized WF_ProcessSteps_t getProcessStep(String string, int n) {
        WF_ProcessSteps_t wF_ProcessSteps_t = null;
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t2 = listIterator.next();
            if (!wF_ProcessSteps_t2.Name.get().equals(string) || n != -1 && wF_ProcessSteps_t2.ContextId.get() != n || wF_ProcessSteps_t != null && wF_ProcessSteps_t2.ProcessStepId.get() <= wF_ProcessSteps_t.ProcessStepId.get()) continue;
            wF_ProcessSteps_t = wF_ProcessSteps_t2;
        }
        return wF_ProcessSteps_t;
    }

    @Override
    public synchronized WF_ProcessSteps_t getProcessStep(int n) {
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t = listIterator.next();
            if (wF_ProcessSteps_t.ProcessStepId.get() != n) continue;
            return wF_ProcessSteps_t;
        }
        return null;
    }

    @Override
    public synchronized WF_ProcessTransitions_t getTransition(int n) {
        ListIterator<WF_ProcessTransitions_t> listIterator = this.processTransitionRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessTransitions_t wF_ProcessTransitions_t = listIterator.next();
            if (wF_ProcessTransitions_t.TransitionId.get() != n) continue;
            return wF_ProcessTransitions_t;
        }
        return null;
    }

    @Override
    public synchronized WF_ProcessTransitions_t getSourceTransition(int n) {
        ListIterator<WF_ProcessTransitions_t> listIterator = this.processTransitionRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessTransitions_t wF_ProcessTransitions_t = listIterator.next();
            if (wF_ProcessTransitions_t.TargetProcessStepId.get() != n) continue;
            return wF_ProcessTransitions_t;
        }
        return null;
    }

    @Override
    public synchronized List<WF_ProcessTransitions_t> getTargetTransition(int n) {
        ArrayList<WF_ProcessTransitions_t> arrayList = new ArrayList<WF_ProcessTransitions_t>();
        ListIterator<WF_ProcessTransitions_t> listIterator = this.processTransitionRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessTransitions_t wF_ProcessTransitions_t = listIterator.next();
            if (wF_ProcessTransitions_t.SourceProcessStepId.get() != n) continue;
            arrayList.add(wF_ProcessTransitions_t);
        }
        return arrayList;
    }

    @Override
    public synchronized WF_SuperProcess_t newSuperProcess() {
        WF_SuperProcess_t wF_SuperProcess_t = new WF_SuperProcess_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.SuperProcessId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.superProcessRows.add(this);
                        this.SuperProcessId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_SuperProcess_t;
    }

    @Override
    public synchronized WF_Trigger_t newTrigger() {
        WF_Trigger_t wF_Trigger_t = new WF_Trigger_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.TriggerId.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.triggerRows.add(this);
                        this.TriggerId.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_Trigger_t;
    }

    @Override
    public synchronized WF_Steps_t getStep(String string, Integer n) {
        ListIterator<WF_Steps_t> listIterator = this.stepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Steps_t wF_Steps_t = listIterator.next();
            if (!wF_Steps_t.UniqueName.get().equalsIgnoreCase(string)) continue;
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public synchronized List<WF_SuperProcess_t> getSuperProcesses(int n) {
        ArrayList<WF_SuperProcess_t> arrayList = new ArrayList<WF_SuperProcess_t>();
        ListIterator<WF_SuperProcess_t> listIterator = this.superProcessRows.listIterator();
        while (listIterator.hasNext()) {
            WF_SuperProcess_t wF_SuperProcess_t = listIterator.next();
            if (wF_SuperProcess_t.ProcessStepId.get() != n) continue;
            arrayList.add(wF_SuperProcess_t);
        }
        return arrayList;
    }

    @Override
    public synchronized List<WF_SuperProcess_t> getSuperProcesses(int n, ExecutionState executionState) {
        ArrayList<WF_SuperProcess_t> arrayList = new ArrayList<WF_SuperProcess_t>();
        ListIterator<WF_SuperProcess_t> listIterator = this.superProcessRows.listIterator();
        while (listIterator.hasNext()) {
            WF_SuperProcess_t wF_SuperProcess_t = listIterator.next();
            if (wF_SuperProcess_t.ProcessStepId.get() != n || wF_SuperProcess_t.State.get().intValue() != executionState.toInt()) continue;
            arrayList.add(wF_SuperProcess_t);
        }
        return arrayList;
    }

    @Override
    public synchronized List<WF_Token_t> getTokens(long l, int n) {
        return this.tokenRows;
    }

    @Override
    public synchronized List<WF_Trigger_t> getTriggers(long l, int n) {
        return this.triggerRows;
    }

    @Override
    public synchronized List<WF_ProcessSteps_t> getProcessSteps(int n) {
        ArrayList<WF_ProcessSteps_t> arrayList = new ArrayList<WF_ProcessSteps_t>();
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t = listIterator.next();
            if (wF_ProcessSteps_t.superProcessId.isNull() || wF_ProcessSteps_t.superProcessId.get() != n) continue;
            arrayList.add(wF_ProcessSteps_t);
        }
        return arrayList;
    }

    @Override
    public synchronized List<WF_ProcessSteps_t> getProcessSteps(long l, Integer n, ExecutionState executionState) {
        ArrayList<WF_ProcessSteps_t> arrayList = new ArrayList<WF_ProcessSteps_t>();
        ListIterator<WF_ProcessSteps_t> listIterator = this.processStepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessSteps_t wF_ProcessSteps_t = listIterator.next();
            if (n == null) {
                if (!wF_ProcessSteps_t.ParentId.isNull() || executionState != null && wF_ProcessSteps_t.State.get().intValue() != executionState.toInt()) continue;
                arrayList.add(wF_ProcessSteps_t);
                continue;
            }
            if (wF_ProcessSteps_t.superProcessId.get() != n || executionState != null && wF_ProcessSteps_t.State.get().intValue() != executionState.toInt()) continue;
            arrayList.add(wF_ProcessSteps_t);
        }
        return arrayList;
    }

    @Override
    public synchronized List<WF_Steps_t> getEventSteps(Integer n, String string) {
        ArrayList<WF_Steps_t> arrayList = new ArrayList<WF_Steps_t>();
        ListIterator<WF_Steps_t> listIterator = this.stepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Steps_t wF_Steps_t = listIterator.next();
            if (!wF_Steps_t.ClassName.get().equalsIgnoreCase(string)) continue;
            arrayList.add(wF_Steps_t);
        }
        return arrayList;
    }

    @Override
    public synchronized List<WF_StepTransitions_t> getStepTransitions(int n) {
        ArrayList<WF_StepTransitions_t> arrayList = new ArrayList<WF_StepTransitions_t>();
        ListIterator<WF_StepTransitions_t> listIterator = this.stepTransitionRows.listIterator();
        while (listIterator.hasNext()) {
            WF_StepTransitions_t wF_StepTransitions_t = listIterator.next();
            if (wF_StepTransitions_t.StepId.get() != n) continue;
            arrayList.add(wF_StepTransitions_t);
        }
        return arrayList;
    }

    @Override
    public synchronized List<WF_StepTransitions_t> getStepTransitionsForTarget(int n) {
        ArrayList<WF_StepTransitions_t> arrayList = new ArrayList<WF_StepTransitions_t>();
        ListIterator<WF_StepTransitions_t> listIterator = this.stepTransitionRows.listIterator();
        while (listIterator.hasNext()) {
            WF_StepTransitions_t wF_StepTransitions_t = listIterator.next();
            if (wF_StepTransitions_t.TargetStepId.get() != n) continue;
            arrayList.add(wF_StepTransitions_t);
        }
        return arrayList;
    }

    @Override
    public synchronized int setBreakpoint(long l, int n, String string, boolean bl) {
        ListIterator<WF_Steps_t> listIterator = this.stepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Steps_t wF_Steps_t = listIterator.next();
            if (!wF_Steps_t.UniqueName.get().equalsIgnoreCase(string)) continue;
            if (bl) {
                wF_Steps_t.flags.set(Integer.valueOf(wF_Steps_t.flags.get() | StepFlags.BREAKPOINT.getEnumValue()));
            } else {
                wF_Steps_t.flags.set(Integer.valueOf(wF_Steps_t.flags.get() & ~StepFlags.BREAKPOINT.getEnumValue()));
            }
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized int clearBreakpoints(long l, int n) {
        int n2 = 0;
        ListIterator<WF_Steps_t> listIterator = this.stepRows.listIterator();
        while (listIterator.hasNext()) {
            WF_Steps_t wF_Steps_t = listIterator.next();
            wF_Steps_t.flags.set(Integer.valueOf(wF_Steps_t.flags.get() & ~StepFlags.BREAKPOINT.getEnumValue()));
            ++n2;
        }
        return n2;
    }

    @Override
    public synchronized boolean removeProcessStep(int n) {
        WF_ProcessSteps_t wF_ProcessSteps_t = this.getProcessStep(n);
        if (wF_ProcessSteps_t == null) {
            return false;
        }
        wF_ProcessSteps_t.zero();
        return true;
    }

    @Override
    public synchronized List<WF_Session_t> getExistingSessions(long l, int n) throws CTEDBException {
        return this.sessionRows;
    }

    @Override
    public synchronized WF_Session_t newSessionRow() {
        WF_Session_t wF_Session_t = new WF_Session_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save() {
                if (this.id.isNull()) {
                    OnDemandDatabase onDemandDatabase = OnDemandDatabase.this;
                    synchronized (onDemandDatabase) {
                        OnDemandDatabase.this.sessionRows.add(this);
                        this.id.set(Integer.valueOf(OnDemandDatabase.NEXT_ID()));
                    }
                }
                return true;
            }

            public boolean fill(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public List executeSelect(String string, String string2) {
                throw new Error("illegal access to on-demand data object");
            }

            public boolean delete() {
                return true;
            }
        };
        return wF_Session_t;
    }

    @Override
    public synchronized List<WF_ProcessTransitions_t> getCompletedTransitions(int n, int n2) throws CTEDBException {
        ArrayList<WF_ProcessTransitions_t> arrayList = new ArrayList<WF_ProcessTransitions_t>();
        ListIterator<WF_ProcessTransitions_t> listIterator = this.processTransitionRows.listIterator();
        while (listIterator.hasNext()) {
            WF_ProcessTransitions_t wF_ProcessTransitions_t = listIterator.next();
            if (!wF_ProcessTransitions_t.ContextId.isNull() && wF_ProcessTransitions_t.ContextId.get() != n2 || wF_ProcessTransitions_t.TargetStepId.get() != n) continue;
            arrayList.add(wF_ProcessTransitions_t);
        }
        return arrayList;
    }

    @Override
    public void removePreviousActivityInstance(int n, int n2) {
    }
}

