/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBProcedure;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.db.CTEDBStorage;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseProcedure
extends CTEDBProcedure {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(BaseProcedure.class);
    private static final int ALERT_TIME = WorkflowRegistry.getInstance().getAlertQueryTime();

    public BaseProcedure(CTEDBConnection cTEDBConnection) {
        super(cTEDBConnection);
    }

    private String getInputs() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (CTEDBColumn cTEDBColumn : this.m_params) {
            if (bl) {
                stringBuffer.append(",");
            }
            bl = true;
            stringBuffer.append(String.valueOf(cTEDBColumn.getValue()));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CTEDBStorage executeQuery(CTEDBStorage cTEDBStorage) throws CTEDBException {
        int n;
        int n2;
        int n3 = DateUtilities.getNow();
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = this.buildProcStatement();
            try {
                preparedStatement = cTEDBReservation.createStatement(string);
            }
            catch (CTEDBException cTEDBException) {
                throw new CTEDBException("error creating statement for procedure [" + this.getName() + "]", cTEDBException);
            }
            this.setParameters(preparedStatement);
            n2 = DateUtilities.getNow();
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error executing procedure [" + this.getName() + "]", sQLException);
            }
            this.populateResult(resultSet, cTEDBStorage);
            n = DateUtilities.getNow();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
        int n4 = DateUtilities.getNow() - n3;
        if (n4 >= ALERT_TIME) {
            logger.info("stored procedure [%s %s], time=[%s] seconds, total=[%s] seconds", this.getName(), this.getInputs(), n - n2, n4);
        }
        return cTEDBStorage;
    }
}

