/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowStep;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ScriptDefinition;
import commvault.msgs.Workflow.TransitionDefinition;
import commvault.msgs.Workflow.TransitionFlags;
import commvault.msgs.Workflow.TransitionStatus;
import java.util.ArrayList;
import java.util.List;

public class WorkflowTransition {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowTransition.class);
    protected WF_StepTransitions_t stepTransition;
    private TransitionStatus status;
    private ScriptDefinition condition;
    private ActivityContext sourceStep;
    private Integer virtualProcessStepId = null;

    public static WorkflowTransition[] load(WorkflowStep workflowStep, List<WF_StepTransitions_t> list) throws EvFailureException {
        ArrayList<WorkflowTransition> arrayList = new ArrayList<WorkflowTransition>();
        if (list != null) {
            for (WF_StepTransitions_t wF_StepTransitions_t : list) {
                arrayList.add(new WorkflowTransition(workflowStep, wF_StepTransitions_t));
            }
        }
        return arrayList.toArray(new WorkflowTransition[0]);
    }

    public WorkflowTransition(ActivityContext activityContext, WF_StepTransitions_t wF_StepTransitions_t) throws EvFailureException {
        this.sourceStep = activityContext;
        this.stepTransition = wF_StepTransitions_t;
        this.initialize();
    }

    private void initialize() throws EvFailureException {
        if (!this.stepTransition.Status.isNull()) {
            for (TransitionStatus transitionStatus : TransitionStatus.values()) {
                if (transitionStatus.getEnumValue() != this.stepTransition.Status.get().intValue()) continue;
                this.status = transitionStatus;
                break;
            }
        }
        if (this.status == null) {
            this.status = TransitionStatus.ANY;
        }
        if (!this.stepTransition.Condition.isNull() && this.stepTransition.Condition.get().length() > 0) {
            try {
                this.condition = (ScriptDefinition)XMLDecoder.decode((String)this.stepTransition.Condition.get());
            }
            catch (Exception exception) {
                logger.error("failed to decode condition from activity [" + this.stepTransition.SourceActivity.get() + "] transition", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
    }

    public ActivityContext getSourceStep() {
        return this.sourceStep;
    }

    protected void setDefinition(TransitionDefinition transitionDefinition) throws EvFailureException {
        DeploymentManager.populateStepTransition(this.stepTransition, transitionDefinition);
        this.initialize();
    }

    public String getSourceActivity() {
        return this.stepTransition.SourceActivity.get();
    }

    public String getTargetActivity() {
        return this.stepTransition.TargetActivity.get();
    }

    public ScriptDefinition getCondition() {
        return this.condition;
    }

    public int getTransitionId() {
        return this.stepTransition.TransitionId.get();
    }

    public TransitionStatus getStatus() {
        return this.status;
    }

    public String getValue() {
        return this.stepTransition.Value.get();
    }

    public String toString() {
        return this.getTargetActivity();
    }

    public Integer getTransitionIndex() {
        return this.stepTransition.TransitionIndex.get();
    }

    public int getTargetStepId() {
        return this.stepTransition.TargetStepId.get();
    }

    public boolean isCommented() {
        if (this.stepTransition.flags.isNull()) {
            return false;
        }
        return (this.stepTransition.flags.get() & TransitionFlags.COMMENTED.getEnumValue()) > 0;
    }

    public void setVirtualProcessStepId(Integer n) {
        this.virtualProcessStepId = n;
    }

    public Integer getVirtualProcessStepId() {
        return this.virtualProcessStepId;
    }
}

