/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.schema.util.SchemaEncoder;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.CVInitiatedFrom;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.JobManagerContext;
import commvault.cte.workflow.JobSettings;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ScheduleView;
import commvault.cte.workflow.SessionContext;
import commvault.cte.workflow.WorkflowImport;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.activity.StatusChangeHandler;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.cs.JMAdminJobAttemptInfoTable_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_ProcessTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.dom.OutputElement;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.dom.WorkflowExecution;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessCommentedActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RepeatActivity;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.schema.SchemaManager;
import commvault.cte.workflow.stream.Marshaller;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.ReflectionUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.FormProperties;
import commvault.msgs.Workflow.ProcessUpdate;
import commvault.msgs.Workflow.ScriptDefinition;
import commvault.msgs.Workflow.StepFlags;
import commvault.msgs.Workflow.TransitionDefinition;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Element;

public class WorkflowStep
implements ActivityContext,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowStep.class);
    private final WF_Steps_t step;
    private final WF_ProcessSteps_t processStep;
    private final WF_ProcessTransitions_t sourceTransition;
    private final ProcessContext parent;
    private final EvalManager eval;
    private SessionContext context;
    private ProcessUpdate postOperation = null;
    private EvFailureReason lastFailure = null;
    private final Set<EvFailureReason> failures = Collections.synchronizedSet(new HashSet());
    private WorkflowTransition[] outboundTransitions;
    private WorkflowTransition[] inboundTransitions;
    private ScriptDefinition onEnter;
    private ScriptDefinition onExit;
    private FormProperties formProperties;
    private Activity activity;
    private int definitionTimeout = 0;
    private OutputElement activityOutputs;
    private WorkflowElement activityInputs;
    private int forEachCount = 0;
    private int activityId = 0;
    private Integer repeatInterval = null;
    private final List<WorkflowTransition> transitionTo = new ArrayList<WorkflowTransition>();
    private Long attemptStart;
    private boolean repeatStep = false;
    private boolean forkTransitions = false;
    private Object lock = new Object();
    private boolean timedOut = false;
    private ActivitySchema schema = null;
    private boolean completedWithErrors = false;
    private String displayName;
    private long threadId;
    private boolean transitionCancelled = false;
    private String activityDefinition;
    private final JMAdminJobAttemptInfoTable_t attemptRow = new JMAdminJobAttemptInfoTable_t();
    private Integer userMaxRestarts = null;
    private Boolean userContinueAfterMaxRestarts = null;
    private Integer userTimeout = null;

    protected WorkflowStep(ProcessContext processContext, WF_Steps_t wF_Steps_t, WF_ProcessSteps_t wF_ProcessSteps_t, WF_ProcessTransitions_t wF_ProcessTransitions_t, SessionContext sessionContext) throws EvFailureException {
        this.parent = processContext;
        this.step = wF_Steps_t;
        this.processStep = wF_ProcessSteps_t;
        this.sourceTransition = wF_ProcessTransitions_t;
        this.context = sessionContext;
        try {
            logger.debug(this.getJobId(), "instantiating activity class [%s]", this.getClassName());
            Class<?> clazz = this.getClass().getClassLoader().loadClass(this.getClassName());
            this.activity = (Activity)ReflectionUtils.newInstance(clazz);
        }
        catch (Exception exception) {
            logger.error(this.getJobId(), "error instantiating activity class [" + this.getClassName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        this.eval = new EvalManager(this, this.activity);
        try {
            logger.trace(this.getJobId(), "loading inbound transitions");
            this.inboundTransitions = WorkflowTransition.load(this, this.getDataAccess().getStepTransitionsForTarget(this.getStepId()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving inbound transitions", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.getJobId(), "failed to load inbound transitions");
            throw evFailureException;
        }
        this.processStep.wfJobId.set(Long.valueOf(this.getWorkflowJobId()));
        this.initialize();
    }

    private void initialize() throws EvFailureException {
        Object object;
        try {
            logger.trace(this.getJobId(), "loading outbound transitions");
            this.outboundTransitions = WorkflowTransition.load(this, this.getDataAccess().getStepTransitions(this.getStepId()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving outbound transitions", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.getJobId(), "failed to load outbound transitions");
            throw evFailureException;
        }
        if (!this.step.OnEnter.isNull() && this.step.OnEnter.get().length() > 0 && this.onEnter == null) {
            try {
                this.onEnter = (ScriptDefinition)XMLDecoder.decode((String)this.step.OnEnter.get(), (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "failed to decode Workflow::ScriptDefinition from xml [" + this.step.OnEnter.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (!this.step.OnExit.isNull() && this.step.OnExit.get().length() > 0 && this.onExit == null) {
            try {
                this.onExit = (ScriptDefinition)XMLDecoder.decode((String)this.step.OnExit.get(), (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "failed to decode Workflow::ScriptDefinition from xml [" + this.step.OnExit.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (!this.step.Outputs.isNull() && this.step.Outputs.get().length() > 0 && this.postOperation == null) {
            try {
                this.postOperation = (ProcessUpdate)XMLDecoder.decode((String)this.step.Outputs.get(), (Object)new ProcessUpdate());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "failed to decode Workflow::ProcessUpdate from xml [" + this.step.Outputs.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (this.step.ActivitySchema.isNull()) {
            try {
                object = (ActivityDefinition)XMLDecoder.decode((String)this.step.StepXml.get(), (Object)new ActivityDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "activity [" + this.getFriendlyName() + "] failed to decode Workflow::ActivityDefinition from xml [" + this.step.StepXml.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            String string = object.getSchema();
            this.schema = this.getActivitySchema(string, this.getName());
        } else {
            try {
                this.schema = (ActivitySchema)WorkflowUtils.decodeMessage(this.step.ActivitySchema.get(), (Object)new ActivitySchema());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "failed to decode Workflow::ActivitySchema from xml [" + this.step.ActivitySchema.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (!this.step.FormProperties.isNull()) {
            try {
                this.formProperties = (FormProperties)WorkflowUtils.decodeMessage(this.step.FormProperties.get(), (Object)new FormProperties());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "failed to decode Workflow::FormProperties from xml [" + this.step.FormProperties.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (this.context != null && this.context.isDebugNext()) {
            this.setBreakPoint(true);
        }
        if (!this.step.DisplayName.isNull() && this.step.DisplayName.get().length() > 0) {
            object = new WorkflowEvaluator(this.eval);
            this.displayName = ((WorkflowEvaluator)object).parseString(this.step.DisplayName.get());
        } else {
            this.displayName = this.getName();
        }
    }

    private ActivitySchema getActivitySchema(String string, String string2) throws EvFailureException {
        SchemaDocument schemaDocument;
        ActivitySchema activitySchema = new ActivitySchema();
        if (string.length() == 0) {
            return activitySchema;
        }
        SchemaManager schemaManager = SchemaManager.newInstance();
        try {
            schemaDocument = SchemaTypeSystem.parse((Element)JDOMUtil.parseXml(string), (SchemaTypeSystem)schemaManager);
        }
        catch (Exception exception) {
            logger.error("failed to parse schema for activity [" + string2 + "], schema [" + string + "]", exception);
            return activitySchema;
        }
        SchemaType schemaType = schemaDocument.getType(string2);
        if (schemaType == null) {
            logger.warn("failed to locate schema type for activity name [%s], schema [%s]", string2, string);
            return activitySchema;
        }
        if (schemaType.getProperties() != null) {
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                if (schemaProperty.getName().getLocalPart().equalsIgnoreCase("inputs")) {
                    activitySchema.setInputs(SchemaEncoder.encode((SchemaProperty)schemaProperty));
                    continue;
                }
                if (!schemaProperty.getName().getLocalPart().equalsIgnoreCase("outputs")) continue;
                activitySchema.setOutputs(SchemaEncoder.encode((SchemaProperty)schemaProperty));
            }
        }
        return activitySchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getStatus() == ProcessStatus.COMPLETED && !this.isCompletedWithErrors()) {
                this.clearFailures();
            }
            if (this.getStatus() == ProcessStatus.KILL_PENDING) {
                this.setStatus(ProcessStatus.KILLED);
            }
            if (this.getStatus() == ProcessStatus.SUSPEND_PENDING) {
                this.setStatus(ProcessStatus.SUSPENDED);
            }
            if (this.activityOutputs == null) {
                logger.trace(this.getJobId(), "activity is missing outputs, creating one for system outputs");
                try {
                    this.activityOutputs = OutputElement.parse(this.processStep.Outputs.getString());
                }
                catch (EvFailureException evFailureException) {
                    logger.warn(this.getJobId(), "failed to parse previous activity outputs xml [" + this.processStep.Outputs.get() + "]");
                }
            }
            if (this.getStatus().isJobComplete() || this.getStatus() == ProcessStatus.INTERRUPT_PENDING) {
                if (this.activityOutputs == null) {
                    this.activityOutputs = new OutputElement(this.getUniqueName());
                }
                this.processStep.EndTime.set(Integer.valueOf(DateUtilities.getNow()));
                this.processStep.State.set(Integer.valueOf(ExecutionState.COMPLETED.toInt()));
                logger.info(this.getJobId(), "completing activity with status [%s], outputs [%s]", this.getStatus().getCompletionStatus().toString(), this.getActivityOutput());
            }
            if (this.activityOutputs != null) {
                this.activityOutputs.getSystemOutputs().set("startTime", (Object)this.getStartTimeUnix());
                this.activityOutputs.getSystemOutputs().set("endTime", (Object)this.getEndTimeUnix());
                this.activityOutputs.getSystemOutputs().set("timedOut", (Object)this.isTimedOut());
                this.activityOutputs.getSystemOutputs().set("status", (Object)this.getStatus().toString());
                this.processStep.Outputs.set(this.activityOutputs.getElement());
            }
            this.processStep.Modified.set(Integer.valueOf(DateUtilities.getNow()));
            this.getJobManager().saveAttempt(this);
            try {
                this.processStep.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.getJobId(), "error saving process step to database", cTEDBException);
            }
        }
    }

    @Override
    public ProcessHandler[] getExecutionPhases() {
        if (this.isCommented()) {
            return new ProcessHandler[]{new ProcessCommentedActivity()};
        }
        if (this.activity instanceof PhaseHandler) {
            return ((PhaseHandler)((Object)this.activity)).getExecutionPhases();
        }
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new RepeatActivity(), new DetermineTransitions()};
    }

    @Override
    public void setRepeat(boolean bl) {
        this.repeatStep = bl;
    }

    @Override
    public void repeat() {
        this.repeat(this.getRepeatInterval());
    }

    @Override
    public void repeat(Integer n) {
        this.repeatInterval = n;
        this.repeatStep = true;
    }

    @Override
    public boolean isRepeat() {
        return this.repeatStep;
    }

    @Override
    public void setFailureReason(String string) {
        EvMessageContainer evMessageContainer = new EvMessageContainer(string);
        this.setFailureReason(evMessageContainer);
    }

    @Override
    public void setFailureReason(String string, Object ... objectArray) {
        this.setFailureReason(String.format(string, objectArray));
    }

    @Override
    public void setFailureReason(EvMessageContainer evMessageContainer) {
        EvFailureReason evFailureReason = new EvFailureReason(this, evMessageContainer);
        this.setFailureReason(evFailureReason);
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public OutputElement getActivityOutput() {
        return this.activityOutputs;
    }

    @Override
    public EvalManager getEvaluator() {
        return this.eval;
    }

    @Override
    public WorkflowElement getActivityInputs() {
        return this.activityInputs;
    }

    @Override
    public void setDefinition(ActivityDefinition activityDefinition) throws EvFailureException {
        this.activityInputs = null;
        this.transitionTo.clear();
        DeploymentManager.populateStepRow(activityDefinition, this.step);
        this.initialize();
        block0: for (WorkflowTransition workflowTransition : this.outboundTransitions) {
            for (TransitionDefinition transitionDefinition : activityDefinition.getTransition()) {
                if (!workflowTransition.getTargetActivity().equalsIgnoreCase(transitionDefinition.getActivity())) continue;
                workflowTransition.setDefinition(transitionDefinition);
                continue block0;
            }
        }
    }

    @Override
    public void setActivityInputs(WorkflowElement workflowElement) {
        this.activityInputs = workflowElement;
        if (this.activityInputs == null) {
            this.activityInputs = new WorkflowElement("inputs");
        }
        if (this.isDebug()) {
            this.processStep.Inputs.set(this.activityInputs.getElement());
        }
    }

    public WorkflowElement getActivityOutputs() {
        return this.activityOutputs;
    }

    @Override
    public void setActivityOutputs(OutputElement outputElement) {
        this.activityOutputs = outputElement;
        this.save();
    }

    @Override
    public WorkflowTransition[] getTransitions() {
        return this.transitionTo.toArray(new WorkflowTransition[0]);
    }

    @Override
    public void setTransition(String string) {
        WorkflowTransition workflowTransition = this.findOutboundTransition(string);
        if (workflowTransition != null) {
            logger.info(this.getJobId(), "setting transiton to target activity [%s]", string);
            if (this.transitionTo.size() > 0) {
                logger.info(this.getJobId(), "clearing current transitions %s", this.transitionTo.toString());
                this.transitionTo.clear();
            }
            this.transitionTo.add(workflowTransition);
        } else {
            logger.warn(this.getJobId(), "could not find transition for target activity [%s]", string);
        }
    }

    @Override
    public void setRepeatInterval(Integer n) {
        this.repeatInterval = n;
    }

    @Override
    public Integer getRepeatInterval() {
        if (this.repeatInterval == null) {
            return this.getRestartInterval();
        }
        return this.repeatInterval;
    }

    @Override
    public Integer getRestartInterval() {
        if (this.step.RestartInterval.isNull()) {
            return this.getJobSettings().getRestartInterval();
        }
        return this.step.RestartInterval.get();
    }

    @Override
    public Integer getMaxRestarts() {
        if (this.userMaxRestarts != null) {
            return this.userMaxRestarts;
        }
        if (this.step.MaxRestarts.isNull()) {
            if (this.getParent().isApiWorkflow()) {
                return 0;
            }
            return this.getJobSettings().getMaxRestarts();
        }
        return this.step.MaxRestarts.get();
    }

    @Override
    public Integer getCalculatedMaxRestarts() {
        Integer n = this.getParent().getCalculatedMaxRestarts();
        Integer n2 = this.getMaxRestarts();
        if (n == null || n > n2) {
            return n2;
        }
        return n;
    }

    @Override
    public void addTransitionTo(WorkflowTransition workflowTransition) {
        this.transitionTo.add(workflowTransition);
    }

    @Override
    public void setAttemptStart(long l) {
        this.attemptStart = l;
    }

    @Override
    public Long getAttemptStart() {
        return this.attemptStart;
    }

    public String toString() {
        return this.getUniqueName() + " (" + this.getProcessStepId() + ")";
    }

    public boolean equals(Object object) {
        return this.getProcessStepId() == ((WorkflowStep)object).getProcessStepId();
    }

    public int hashCode() {
        return this.getProcessStepId().hashCode();
    }

    @Override
    public void setFailed(String string) {
        this.setFailureReason(new EvMessageContainer(string));
        this.setStatus(ProcessStatus.PENDING);
    }

    @Override
    public int getAutoResumeInterval() {
        return this.getParent().getAutoResumeInterval();
    }

    @Override
    public void setAutoResumeInterval(int n) {
        this.getParent().setAutoResumeInterval(n);
    }

    @Override
    public void suspend(String string) {
        this.setFailureReason(new EvMessageContainer(string));
        this.setStatus(ProcessStatus.SUSPENDED);
    }

    @Override
    public void setCompletedWithErrors(boolean bl) {
        this.getParent().setCompletedWithErrors(bl);
        this.completedWithErrors = bl;
    }

    @Override
    public boolean isCompletedWithErrors() {
        return this.completedWithErrors;
    }

    @Override
    public String impersonateLogin(String string, String string2, String string3) throws EvFailureException {
        return this.getContext().impersonateLogin(string, string2, string3);
    }

    @Override
    public String impersonateLogin(String string, String string2) throws EvFailureException {
        return this.getContext().impersonateLogin(string, string2);
    }

    @Override
    public String impersonateCommCell(String string) throws EvFailureException {
        return this.getContext().impersonateCommCell(string);
    }

    @Override
    public String impersonateCreator() throws EvFailureException {
        return this.getContext().impersonateCreator();
    }

    @Override
    public String impersonateExecutor() throws EvFailureException {
        return this.getContext().impersonateExecutor();
    }

    @Override
    public String getCurrentUserToken() {
        return this.getContext().getCurrentUserToken();
    }

    @Override
    public void logoutImpersonatedUser() {
        this.getContext().logoutImpersonatedUser();
    }

    @Override
    public Object getVariable(String string) throws EvFailureException {
        return this.getParent().getVariable(string);
    }

    @Override
    public Object getInput(String string) throws EvFailureException {
        return this.getParent().getInput(string);
    }

    @Override
    public Object getObject(String string) throws EvFailureException {
        return this.getParent().getObject(string);
    }

    @Override
    public Object getVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getVariable(string, clazz);
    }

    @Override
    public Object getInput(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getInput(string, clazz);
    }

    @Override
    public Object getObject(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getObject(string, clazz);
    }

    @Override
    public Object getConfiguration(String string) throws EvFailureException {
        return this.getParent().getConfiguration(string);
    }

    @Override
    public Object getConfiguration(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getConfiguration(string, clazz);
    }

    @Override
    public Object getParentVariable(String string) throws EvFailureException {
        return this.getParent().getParentVariable(string);
    }

    @Override
    public Object getParentVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getParentVariable(string, clazz);
    }

    @Override
    public void setVariable(String string, Object object) throws EvFailureException {
        this.getParent().setVariable(string, object);
    }

    @Override
    public Object getLocalVariable(String string) throws EvFailureException {
        return this.getParent().getLocalVariable(string);
    }

    @Override
    public Object getLocalVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getLocalVariable(string, clazz);
    }

    @Override
    public void setLocalVariable(String string, Object object) throws EvFailureException {
        this.getParent().setLocalVariable(string, object);
    }

    @Override
    public void setInput(String string, Object object) throws EvFailureException {
        this.getParent().setInput(string, object);
    }

    @Override
    public Object getOutput(String string) throws EvFailureException {
        return this.getParent().getOutput(string);
    }

    @Override
    public Object getOutput(String string, Class<?> clazz) throws EvFailureException {
        return this.getParent().getOutput(string, clazz);
    }

    @Override
    public void setOutput(String string, Object object) throws EvFailureException {
        this.getParent().setOutput(string, object);
    }

    @Override
    public String getExecutor() {
        return this.getParent().getExecutor();
    }

    @Override
    public String getCreator() {
        return this.getParent().getCreator();
    }

    @Override
    public int getExecutorId() {
        return this.getParent().getExecutorId();
    }

    @Override
    public int getCreatorId() {
        return this.getParent().getCreatorId();
    }

    @Override
    public int getLocaleId() {
        return this.getParent().getLocaleId();
    }

    @Override
    public String getStepName() {
        return this.getDisplayName();
    }

    @Override
    public Integer getProcessStepId() {
        return this.processStep.ProcessStepId.get();
    }

    public Integer getTransitionId() {
        if (this.sourceTransition != null) {
            return this.sourceTransition.TransitionId.get();
        }
        return null;
    }

    public Integer getPreviousStepId() {
        if (this.sourceTransition != null) {
            return this.sourceTransition.ProcessTransitionId.get();
        }
        return null;
    }

    @Override
    public WorkflowTransition[] getInboundTransitions() {
        return this.inboundTransitions;
    }

    @Override
    public WorkflowTransition[] getOutboundTransitions() {
        return this.outboundTransitions;
    }

    private WorkflowTransition findOutboundTransition(String string) {
        for (WorkflowTransition workflowTransition : this.getOutboundTransitions()) {
            if (!workflowTransition.getTargetActivity().equals(string)) continue;
            return workflowTransition;
        }
        return null;
    }

    @Override
    public String getInputDefinition() {
        return this.step.Inputs.get();
    }

    @Override
    public ExecutionState getExecutionState() {
        return ExecutionState.fromInt(this.processStep.State.get());
    }

    @Override
    public void setExecutionState(ExecutionState executionState) {
        this.processStep.State.set(Integer.valueOf(executionState.toInt()));
    }

    @Override
    public ProcessStatus getStatus() {
        return ProcessStatus.fromInt((int)this.processStep.Status.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(ProcessStatus processStatus) {
        Object object = this.lock;
        synchronized (object) {
            logger.trace(this.getJobId(), "updating status to [%s]", processStatus.toString());
            this.processStep.Status.set(Integer.valueOf(processStatus.toInt()));
            if (this.activity instanceof StatusChangeHandler) {
                logger.trace(this.getJobId(), "activity [%s] is configured as a %s, passing new status [%s] to it", this.activity.getClass(), StatusChangeHandler.class.getName(), this.getStatus().toString());
                ((StatusChangeHandler)((Object)this.activity)).onStatusChanged(this);
            }
        }
    }

    @Override
    public Long getSubJobId() {
        return this.processStep.subJobId.get();
    }

    @Override
    public void setSubJobId(long l) {
        this.processStep.subJobId.set(Long.valueOf(l));
    }

    @Override
    public SessionContext getContext() {
        return this.context;
    }

    @Override
    public void setContextInstance(SessionContext sessionContext) {
        this.context = sessionContext;
        this.processStep.ContextId.set(Integer.valueOf(sessionContext.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailureReason() {
        Set<EvFailureReason> set = this.failures;
        synchronized (set) {
            StringBuffer stringBuffer = new StringBuffer();
            for (EvFailureReason evFailureReason : this.failures) {
                String string = evFailureReason.getFailureId();
                if (stringBuffer.length() + string.length() < 256) {
                    stringBuffer.append(string);
                    continue;
                }
                logger.warn(this.getJobId(), "max failure reason length reached [256] from total number of failures [%s]", this.failures.size());
                return stringBuffer.toString();
            }
            return stringBuffer.toString();
        }
    }

    @Override
    public Set<EvFailureReason> getFailures() {
        return this.failures;
    }

    @Override
    public void setFailureReason(EvFailureReason evFailureReason) {
        this.failures.add(evFailureReason);
        this.getParent().setFailureReason(evFailureReason);
        this.lastFailure = evFailureReason;
        this.processStep.failureReason.set(evFailureReason.getMessage());
    }

    @Override
    public void removeFailure(EvFailureReason evFailureReason) {
        this.failures.remove(evFailureReason);
        this.getParent().removeFailure(evFailureReason);
    }

    @Override
    public void clearFailures() {
        this.getParent().removeFailures(this.failures);
        this.failures.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFailures(Set<EvFailureReason> set) {
        Set<EvFailureReason> set2 = this.failures;
        synchronized (set2) {
            for (EvFailureReason evFailureReason : set) {
                this.failures.remove(evFailureReason);
            }
        }
        this.getParent().removeFailures(set);
    }

    @Override
    public ProcessContext getParent() {
        return this.parent;
    }

    @Override
    public void setExecutionCount(int n) {
        this.processStep.Executions.set(Integer.valueOf(n));
    }

    @Override
    public int getExecutionCount() {
        return this.processStep.Executions.get();
    }

    @Override
    public int getAttemptCount() {
        return this.processStep.Attempts.get();
    }

    @Override
    public void setAttemptCount(int n) {
        this.processStep.Attempts.set(Integer.valueOf(n));
    }

    @Override
    public long getJobId() {
        return this.getParent().getJobId();
    }

    @Override
    public String getProcessId() {
        return this.getParent().getProcessId();
    }

    @Override
    public int getCommCellId() {
        return this.getParent().getCommCellId();
    }

    @Override
    public int getStepId() {
        return this.step.StepId.get();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getUniqueName() {
        return this.step.UniqueName.get();
    }

    @Override
    public String getFriendlyName() {
        return String.format("%s (%s)", this.getDisplayName(), this.step.UniqueName.get());
    }

    @Override
    public String getRepeatExpression() {
        return this.step.RepeatUntil.get();
    }

    @Override
    public void setActivityId(int n) {
        this.activityId = n;
    }

    @Override
    public int getActivityId() {
        if (this.activityId > 0) {
            return this.activityId;
        }
        return this.step.ActivityId.get();
    }

    @Override
    public String getOperation() {
        return this.step.Operation.get();
    }

    @Override
    public int getLocationId() {
        return this.step.LocationId.get();
    }

    @Override
    public String getServiceLocation() {
        return this.step.ServiceLocation.get();
    }

    @Override
    public boolean isSuperProcess() {
        return this.step.SuperProcess.get();
    }

    @Override
    public Date getStartTime() {
        return new Date((long)this.processStep.StartTime.get().intValue() * 1000L);
    }

    @Override
    public Integer getStartTimeUnix() {
        return this.processStep.StartTime.get();
    }

    @Override
    public Date getEndTime() {
        if (this.processStep.EndTime.isNull()) {
            return null;
        }
        return new Date((long)this.processStep.EndTime.get().intValue() * 1000L);
    }

    public Integer getEndTimeUnix() {
        return this.processStep.EndTime.get();
    }

    @Override
    public String getDescription() {
        return this.step.Description.get();
    }

    @Override
    public String getName() {
        return this.step.Name.get();
    }

    @Override
    public String getClassName() {
        return this.step.ClassName.get();
    }

    @Override
    public boolean isContinueOnFailure() {
        if (this.userContinueAfterMaxRestarts != null) {
            return this.userContinueAfterMaxRestarts;
        }
        return this.step.ContinueOnFailure.get();
    }

    @Override
    public String getSourceActivity() {
        if (this.sourceTransition != null) {
            return this.sourceTransition.SourceActivity.get();
        }
        return null;
    }

    @Override
    public ScriptDefinition getOnEnter() {
        return this.onEnter;
    }

    @Override
    public ScriptDefinition getOnExit() {
        return this.onExit;
    }

    @Override
    public ProcessUpdate getPostOperations() {
        return this.postOperation;
    }

    @Override
    public boolean isForkTransitions() {
        return this.forkTransitions;
    }

    @Override
    public void setForkTransitions(boolean bl) {
        this.forkTransitions = bl;
    }

    @Override
    public Integer getRawRepeatInterval() {
        if (this.repeatInterval == null) {
            return this.getRawRestartInterval();
        }
        return this.repeatInterval;
    }

    @Override
    public Integer getRawRestartInterval() {
        return this.step.RestartInterval.get();
    }

    @Override
    public int getRestarts() {
        return this.processStep.Restarts.get();
    }

    @Override
    public void setRestarts(int n) {
        this.processStep.Restarts.set(Integer.valueOf(n));
    }

    @Override
    public String getWorkflowName() {
        return this.getParent().getWorkflowName();
    }

    @Override
    public CVInitiatedFrom getInitFrom() {
        return this.getParent().getInitFrom();
    }

    @Override
    public List<WorkflowImport> getImports() {
        return this.getParent().getImports();
    }

    @Override
    public int getSubTaskId() {
        return this.getParent().getSubTaskId();
    }

    @Override
    public int getTaskId() {
        return this.getParent().getTaskId();
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.getParent().getWorkflowExecution();
    }

    @Override
    public EvFailureReason getLastFailure() {
        return this.lastFailure;
    }

    @Override
    public Marshaller getMarshaller() {
        return this.getParent().getMarshaller();
    }

    @Override
    public int getCurrentPhase() {
        if (this.processStep.Phase.isNull()) {
            return 0;
        }
        return this.processStep.Phase.get();
    }

    @Override
    public void setCurrentPhase(int n) {
        this.processStep.Phase.set(Integer.valueOf(n));
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public String getCommCell() {
        return this.getParent().getCommCell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefinition() {
        if (this.activityDefinition == null) {
            CTEDBReservation cTEDBReservation;
            block7: {
                if (this.step.Definition.isNull() || this.step.Definition.get().length() == 0) {
                    this.activityDefinition = "";
                    return this.activityDefinition;
                }
                String string = "Select Definition From WF_Activity Where activityId = " + this.step.ActivityId.get();
                cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
                PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block7;
                String string2 = this.activityDefinition = resultSet.getString("Definition");
                cTEDBReservation.close();
                return string2;
            }
            try {
                try {
                    logger.error(this.getJobId(), "could not find activity definition for activity id [" + this.step.ActivityId.get() + "]");
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_DEFINITION", new Object[0]);
                    throw new EvFailureException(evMessageContainer);
                }
                catch (Exception exception) {
                    logger.error(this.getJobId(), "error retrieving activity definition for activity [" + this.step.ActivityId.get() + "]", exception);
                    cTEDBReservation.close();
                }
            }
            catch (Throwable throwable) {
                cTEDBReservation.close();
                throw throwable;
            }
            this.activityDefinition = this.step.Definition.get();
        }
        return this.activityDefinition;
    }

    @Override
    public JobManagerContext getJobManager() {
        return this.getParent().getJobManager();
    }

    @Override
    public boolean isRunning() {
        return this.getParent().isRunning();
    }

    @Override
    public int getVersion() {
        return this.getParent().getVersion();
    }

    @Override
    public int getWorkflowId() {
        return this.getParent().getWorkflowId();
    }

    @Override
    public String getJobDescription() {
        return this.getParent().getJobDescription();
    }

    @Override
    public void setJobDescription(String string) {
        this.getParent().setJobDescription(string);
    }

    @Override
    public JobSettings getJobSettings() {
        return this.getParent().getJobSettings();
    }

    private int getCurrentFlags() {
        if (this.processStep.flags.isNull()) {
            return 0;
        }
        return this.processStep.flags.get();
    }

    @Override
    public void interrupt() {
        this.processStep.flags.set(Integer.valueOf(this.getCurrentFlags() | StepFlags.INTERRUPTED.getEnumValue()));
    }

    @Override
    public boolean interrupted() {
        return (this.getCurrentFlags() & StepFlags.INTERRUPTED.getEnumValue()) > 0;
    }

    @Override
    public void setLoggingDisabled(boolean bl, boolean bl2) {
        this.getParent().setLoggingDisabled(bl, bl2);
    }

    @Override
    public void setLoggingDisabled(boolean bl) {
        this.getParent().setLoggingDisabled(bl);
    }

    @Override
    public boolean isLoggingDisabled() {
        return this.getParent().isLoggingDisabled();
    }

    @Override
    public boolean isLogRedirected() {
        return this.getParent().isLogRedirected();
    }

    @Override
    public void setLogFile(String string) throws Exception {
        this.getParent().setLogFile(string);
    }

    @Override
    public void resetLogFile() {
        this.getParent().resetLogFile();
    }

    @Override
    public ScheduleView getScheduleView() {
        return this.getParent().getScheduleView();
    }

    @Override
    public int getActivityTimeout() {
        if (this.userTimeout != null && this.userTimeout > 0) {
            return this.userTimeout;
        }
        if (this.step.timeout.get() > 0) {
            return this.step.timeout.get();
        }
        return this.definitionTimeout;
    }

    @Override
    public int getTimeout() {
        int n = this.getActivityTimeout();
        if (n > 0) {
            return n * 60;
        }
        if (this.getJobSettings().isEnableTotalRunningTime()) {
            return this.getJobSettings().getTotalRunningTime();
        }
        return 0;
    }

    @Override
    public boolean isEnableTotalRunningTime() {
        if (this.getActivityTimeout() > 0) {
            return true;
        }
        return this.getJobSettings().isEnableTotalRunningTime();
    }

    @Override
    public boolean isKillJobIfRunningTimeExpires() {
        if (this.getActivityTimeout() > 0) {
            return true;
        }
        return this.getJobSettings().isKillJobIfRunningTimeExpires();
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    public void setTimedOut(boolean bl) {
        this.timedOut = bl;
    }

    @Override
    public ActivitySchema getSchema() {
        return this.schema;
    }

    @Override
    public ProcessContext getRoot() {
        return this.getParent().getRoot();
    }

    @Override
    public Integer getDeploymentId() {
        return this.getParent().getDeploymentId();
    }

    @Override
    public boolean isStartInteractiveSession() {
        return !this.isDebug() && (this.step.flags.get() & StepFlags.INTERACTIVE.getEnumValue()) == StepFlags.INTERACTIVE.getEnumValue();
    }

    @Override
    public boolean isCustomWait() {
        return (this.step.flags.get() & StepFlags.WAIT_OBJ.getEnumValue()) == StepFlags.WAIT_OBJ.getEnumValue();
    }

    @Override
    public boolean isSkipAttempt() {
        return (this.step.flags.get() & StepFlags.SKIP_ATTEMPT.getEnumValue()) == StepFlags.SKIP_ATTEMPT.getEnumValue();
    }

    @Override
    public boolean isJobMode() {
        return (this.step.flags.get() & StepFlags.JOB_MODE.getEnumValue()) == StepFlags.JOB_MODE.getEnumValue();
    }

    @Override
    public String sendMessage(String string) throws Exception {
        return WorkflowUtils.executeXml(string, this.context, this.getJobId());
    }

    @Override
    public Integer getSuperProcessId() {
        return this.getParent().getSuperProcessId();
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public void setThreadId(long l) {
        this.threadId = l;
    }

    @Override
    public DataAccessLayer getDataAccess() {
        return this.getParent().getDataAccess();
    }

    @Override
    public boolean isOnDemand() {
        return this.getParent().isOnDemand();
    }

    @Override
    public boolean isCommented() {
        return (this.step.flags.get() & StepFlags.COMMENTED.getEnumValue()) > 0;
    }

    @Override
    public boolean isDebug() {
        return this.getParent().isDebug();
    }

    @Override
    public void setDebug(boolean bl) {
        this.getParent().setDebug(bl);
    }

    @Override
    public boolean isBreakPoint() {
        return (this.getCurrentFlags() & StepFlags.BREAKPOINT.getEnumValue()) > 0;
    }

    @Override
    public void setBreakPoint(boolean bl) {
        if (bl) {
            this.processStep.flags.set(Integer.valueOf(this.getCurrentFlags() | StepFlags.BREAKPOINT.getEnumValue()));
        } else {
            this.processStep.flags.set(Integer.valueOf(this.getCurrentFlags() & ~StepFlags.BREAKPOINT.getEnumValue()));
        }
    }

    @Override
    public ProcessStatus getWorkflowStatus() {
        return this.getParent().getWorkflowStatus();
    }

    @Override
    public void addCache(String string, Object object) {
        this.getParent().addCache(string, object);
    }

    @Override
    public Object getCache(String string) {
        return this.getParent().getCache(string);
    }

    @Override
    public int getCacheSize() {
        return this.getParent().getCacheSize();
    }

    @Override
    public void addDebugMessage(String string) {
        this.getParent().addDebugMessage(string);
    }

    @Override
    public List<String> getDebugLog() {
        return this.getParent().getDebugLog();
    }

    @Override
    public int getCustomFlag() {
        return this.processStep.PathId.get();
    }

    @Override
    public void setCustomFlag(int n) {
        this.processStep.PathId.set(Integer.valueOf(n));
    }

    @Override
    public String getSessionId() {
        return this.processStep.sessionId.get();
    }

    @Override
    public void setSessionId(String string) {
        this.processStep.sessionId.set(string);
    }

    @Override
    public String getInstanceId() {
        return this.getParent().getInstanceId();
    }

    public void setTimeout(int n) throws EvFailureException {
        this.userTimeout = n;
    }

    public void setMaxRestarts(int n) throws EvFailureException {
        this.userMaxRestarts = n;
    }

    public void setContinueAfterMaxRestarts(boolean bl) throws EvFailureException {
        this.userContinueAfterMaxRestarts = bl;
    }

    @Override
    public boolean isTransitionCancelled() {
        return this.transitionCancelled;
    }

    @Override
    public void setTransitionCancelled(boolean bl) {
        logger.debug("setTransitionCancelled(%s) called", bl);
        this.transitionCancelled = bl;
    }

    @Override
    public ProcessContext getParentWorkflow() {
        return this.getParent().getParentWorkflow();
    }

    @Override
    public long getWorkflowJobId() {
        return this.getParent().getWorkflowJobId();
    }

    @Override
    public JMAdminJobAttemptInfoTable_t getAttemptRow() {
        return this.attemptRow;
    }

    @Override
    public void setAttemptCreation(int n) {
        this.getParent().setAttemptCreation(n);
    }

    @Override
    public boolean isGlobalLock() {
        return this.getParent().isGlobalLock();
    }

    @Override
    public boolean isSessionActive() {
        return this.getParent().isSessionActive();
    }

    @Override
    public void setCompletionPercentage(int n) {
        this.getParent().setCompletionPercentage(n);
    }

    @Override
    public int getCompletionPercentage() {
        return this.getParent().getCompletionPercentage();
    }

    @Override
    public FormProperties getFormProperties() {
        return this.formProperties;
    }
}

