/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.logger.LoggerLevel;
import commvault.cte.workflow.python.ScriptTask;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WorkflowRegistry {
    private static WorkflowRegistry instance;
    public static final String WORKFLOWENGINE_JAR = "workflowEngine.jar";
    private static final int PFT_COMMSERVER = 1;
    private static final int WORKFLOW_OPTYPE = 90;
    public static final String WORKFLOW_FOLDER = "WFEngine";
    public static final String BASE_FOLDER = "Base";
    private static final String CVPI_USE_JTDS = "UseJTDS";
    public static final String CVPI_WORKFLOW = "WFEngine";
    private static final String CVPI_EVM = "EventManager";
    private static final String CVPI_EVLOGDIR = "dEVLOGDIR";
    private static final String CVPI_CMPYNAME = "CommVault Systems";
    private static final String CVPI_GALAXY = "Galaxy";
    private static final String CVPI_BASE = "Base";
    private static final String CVPI_MACHINES = "Machines";
    private static final String CVPI_WEBCONSOLE = "WebConsole";
    private static final String CVPI_SESSION = "Session";
    private static final String CVPI_GALAXYHOME = "dGALAXYHOME";
    private static final String CVPI_DATABASE = "Database";
    private static final String CVPI_CSINSTANCE = "sINSTANCE";
    private static final String CVPI_WFINSTANCE = "sWFINSTANCE";
    private static final String CVPI_CSACCESS = "pACCESS";
    private static final String CVPI_WFACCESS = "pWFACCESS";
    private static final String CVPI_CSPORT = "nPort";
    private static final String CVPI_WFPORT = "nWFPort";
    private static final String CVPI_COMMSERVER = "CommServe";
    private static final String CVPI_COMMCELL_NAME = "sCSCLIENTNAME";
    private static final String CVPI_COMMCELL_ID = "nCOMMCELLID";
    private static final String CVPI_PHYSICAL_NODE_NAME = "sPhysicalNodeName";
    private static final String CVPI_PLATFORM_TYPE = "nPLATTYPE";
    private static final String CVPI_TEMP_DIR = "dGALAXYTEMPDIR";
    private static final String CVPI_JOBRESULTS_DIR = "dJOBRESULTSDIR";
    private static final String CVPI_JOB_PULLING_INTERAVAL = "nJobPullingInterval";
    private static final String CVPI_CSDBNAME = "sCSDBNAME";
    private static final String CVPI_MESSAGE_PORT = "nWFEPORT";
    private static final String CVPI_WFDBNAME = "sWFDBNAME";
    private static final String CVPI_REUSE_THREADS = "workflowReuseThreads";
    private static final String CVPI_TRUST_SQL_CERT = "trustServerCertificate";
    private static final String CVPI_STRIP_XML_CHARS = "stripInvalidXmlCharacters";
    private static final String CVPI_ESCAPE_SQL_STRINGS = "autoEscapeSQLStrings";
    private static final String CVPI_ENABLE_STALE_JOB_CHECK = "enableStaleJobCheck";
    private static final String CVPI_FORCE_HTTP_UTF8 = "forceHttpUtf8";
    private static final String CVPI_AUTO_ESCAPE_SQL_STRING = "autoEscapeSQLString";
    private static final String CVPI_ALLOW_EMPTY_TO = "allowEmptyToRecipients";
    private static final String CVPI_QSDK_SESSION_TIMEOUT = "qsdkTokenTimeout";
    private static final String CVPI_APPEND_WORKFLOW_OP = "prependWorkflowToOperation";
    private static final String CVPI_ALLOW_XXE = "allowXXE";
    private static final String CVPI_FAIL_ON_NON_DETERMINED_TRANSITION = "failOnNonDeterminedTransition";
    private static final String CVPI_WORKFLOW_MAXLOGFILEBACKUPS = "WORKFLOWENGINE_MAXLOGFILEBACKUPS";
    private static final String CVPI_WORKFLOW_MAXLOGFILESIZE = "WORKFLOWENGINE_MAXLOGFILESIZE";
    private static final String CVPI_WORKFLOW_DEBUGLEVEL = "WORKFLOWENGINE_DEBUGLEVEL";
    private static final String CVPI_APPEND_ACTIVITY_TO_EXECUTION = "bAppendActivityOutputsToExecution";
    private static final String CVPI_CLEANUP_INTERVAL = "nCleanupDelay";
    private static final String CVPI_CLASSPATH_REFRESH = "nClassPathRefreshInterval";
    private static final String CVPI_MONITOR_INTERVAL = "nMonitorInterval";
    private static final String CVPI_MAX_WORKFLOWS = "nMaxWorkflows";
    private static final String CVPI_PYTHON_CLEANUP = "nPythonCleanup";
    private static final String CVPI_CHUNK_SIZE = "nChunkSize";
    private static final String CVPI_EDGE_FILE_CHUNK_SIZE = "nedgeDriveFileChunkSize";
    private static final String CVPI_REFRESH_SETTINGS_INTERVAL = "nSettingsRefresh";
    private static final String CVPI_REFRESH_LOGGER = "nUpdateLogger";
    private static final String CVPI_VALIDATE_XPATH = "nValidateXPath";
    private static final String CVPI_MAX_DB_CONNECTIONS = "nMaxDatabaseConnections";
    private static final String CVPI_DB_CONNECTION_LENGTH = "nDatabaseConnectionLength";
    private static final String CVPI_JMX_ENABLE = "nEnableJMX";
    private static final String CVPI_JMX_PORT = "nJMXPort";
    private static final String CVPI_SERVICE_ENABLE = "nEnableService";
    private static final String CVPI_SERVICE_PORT = "nServicePort";
    private static final String CVPI_MAX_FAILED_SHUTDOWNS = "nMaxFailedShutdowns";
    private static final String CVPI_ENABLE_SHUTDOWN_CHECK = "nServiceShutdownCheck";
    private static final String CVPI_JOB_RETENTION_DAYS = "nJobRetentionDays";
    private static final String CVPI_INTERACTION_RETENTION_DAYS = "nInteractionRetentionDays";
    private static final String CVPI_DATAAGING_INTERVAL = "nDataAgingInterval";
    private static final String CVPI_QOP_EXEC_JNI = "ExecuteQCommandJNI";
    private static final String CVPI_RELAY_EMAIL = "sendWorkflowEmailsViaCommserver";
    private static final String CVPI_STRICT_TYPE_CHECKING = "workflowStrictTypeChecking";
    private static final String CVPI_OUTPUT_CACHE_SIZE = "nOutputCacheSize";
    private static final String CVPI_DIRECT_SESSION = "UseDirectCVDConnection";
    private static final String CVPI_DEFAULT_WEBSERVER = "WF_defaultWebservice";
    private static final String CVPI_DEFAULT_EDGEWEBSERVER = "WF_EdgeWebservice";
    private static final String CVPI_DEFAULT_WEBCONSOLE = "WF_defaultWebconsole";
    private static final String CVPI_WEBSERVER_HOSTNAME = "sZDM2WEBSERVERHOSTNAME";
    private static final String CVPI_WEBSERVER_POST = "nDM2WEBSITEPORT";
    private static final String CVPI_DELETE_APPROVAL_EMAILS = "DeleteApprovalEmails";
    private static final String CVPI_APPROVAL_EMAIL_COPY_FOLDER = "ApprovalEmailCopyFolder";
    private static final String CVPI_APPROVAL_EMAIL_POLLING_INTERVAL = "ApprovalEmailPollingInterval";
    private static final String CVPI_GLOBAL_CC_RECIPS = "workflowGlobalCCRecipients";
    private static final String CVPI_WRITE_RUNNING_ATTEMPTS = "workflowWriteRunningAttempts";
    private static final String CVPI_REMOVE_PREVIOUS_STEPS = "RemovePreviousSteps";
    private static final String CVPI_AUTO_RESTART_JOBS = "autoRestartJobs";
    private static final String CVPI_AUTO_IMPERSONATE = "autoImpersonate";
    private static final String CVPI_CREATE_DISABLED_HISTORY = "createJobHistoryForDisabledWorkflow";
    private static final String CVPI_HTTP_TIMEOUT = "httpTimeout";
    private static final String CVPI_SKIP_ATTEMPTS = "SkipAttemptCreation";
    private static final String CVPI_VALIDATE_SSL = "ValidateSSL";
    private static final String CVPI_READ_UNCOMMITTED = "UseDatabaseReadUncomitted";
    private static final String CVPI_RETRY_SEC_PROC = "RetryCapbilityChecks";
    private static final String CVPI_ALERT_QUERY_TIME = "AlertQueryTime";
    private static final String CVPI_ALERT_RESPONSE_TIME = "AlertResponseTime";
    private static final String CVPI_SECURITY_CACHE_TIME = "SecurityCacheTime";
    private static final String CVPI_JOBMANAGER_THREADS = "JobManagerThreads";
    private static final String CVPI_USE_HTTPPROXY = "UseHTTPProxy";
    private static final String CVPI_ENABLE_MAILBOX = "KeepMailboxOpen";
    private static final String CVPI_REPLY_CLOSED_ACTIONS = "ReplyToClosedActions";
    private static final String CVPI_USE_INTEGRATED_SECURITY = "nSQLAuthType";
    private static final String CVPI_USE_GLOBAL_LOCK = "UseGlobalLock";
    private static final String CVPI_SCRIPT_ENGINE = "ScriptEngine";
    private static final String CVPI_JAVA_ENGINE = "JavaEngine";
    private static final String CVPI_JAVA_ADD_IMPORTS = "JavaAddImports";
    public static final String DEFAULT_CLASSPATH_FOLDER = "classpath";
    private File installFolder = null;
    private boolean reuseThreads = false;
    private Boolean removePreviousSteps = null;
    private final String CVPI_INSTANCE;

    public static void newInstance(String string) {
        instance = new WorkflowRegistry(string);
    }

    public static WorkflowRegistry getInstance() {
        return instance;
    }

    public boolean isUseJTDS() {
        int n = this.getRegistryNumber("WFEngine", CVPI_USE_JTDS, 0);
        return n == 1;
    }

    private WorkflowRegistry(String string) {
        this.CVPI_INSTANCE = string;
        this.installFolder = new File(this.getGalaxyHome(), "WFEngine");
        this.reuseThreads = this.getReuseThreads();
    }

    public String getVmInstance() {
        return this.CVPI_INSTANCE;
    }

    public File getInstallFolder() {
        return this.installFolder;
    }

    public CTEDBConnInfo getCommServDatabaseConnection() {
        return this.getDatabaseConnection(CVPI_CSINSTANCE, CVPI_CSACCESS, CVPI_CSPORT);
    }

    public CTEDBConnInfo getEngineDatabaseConnection() {
        return this.getDatabaseConnection(CVPI_WFINSTANCE, CVPI_WFACCESS, CVPI_WFPORT);
    }

    private CTEDBConnInfo getDatabaseConnection(String string, String string2, String string3) {
        String string4 = this.getRegistryString(CVPI_DATABASE, string);
        String[] stringArray = WorkflowUtils.getAccessCredentials(this.getRegistryString(CVPI_DATABASE, string2));
        CTEDBConnInfo cTEDBConnInfo = new CTEDBConnInfo();
        cTEDBConnInfo.setInstance(string4);
        cTEDBConnInfo.setUserId(stringArray[0]);
        cTEDBConnInfo.setPassword(stringArray[1]);
        cTEDBConnInfo.setPort(this.getRegistryNumber(CVPI_DATABASE, string3, 0));
        return cTEDBConnInfo;
    }

    public String getCommServDatabaseName() {
        return this.getRegistryString(CVPI_DATABASE, CVPI_CSDBNAME);
    }

    public String getWorkflowEngineDatabaseName() {
        return this.getRegistryString(CVPI_DATABASE, CVPI_WFDBNAME);
    }

    public boolean isRemovePreviousSteps() {
        if (this.removePreviousSteps == null) {
            this.removePreviousSteps = this.getRegistryNumber("WFEngine", CVPI_REMOVE_PREVIOUS_STEPS, 0) == 1;
        }
        return this.removePreviousSteps;
    }

    public boolean isUseIntegratedSecurity() {
        int n = this.getRegistryNumber(CVPI_DATABASE, CVPI_USE_INTEGRATED_SECURITY, 0);
        return n == 1;
    }

    public boolean isUseGlobalLock() {
        int n = this.getRegistryNumber("WFEngine", CVPI_USE_GLOBAL_LOCK, 0);
        return n == 1;
    }

    public String getPhysicalNodeName() {
        return this.getRegistryString("", CVPI_PHYSICAL_NODE_NAME);
    }

    public List<String> getInstalledClients() throws Exception {
        String[] stringArray = this.getChildKeys(CVPI_MACHINES);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            String string2 = String.format("%s\\%s", CVPI_MACHINES, string);
            String string3 = this.getRegistryString(string2, "sGUID", "");
            if (string3.length() == 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String getJobResultsDirectory(String string) {
        String string2 = "Machines\\" + string;
        return this.getRegistryString(string2, CVPI_JOBRESULTS_DIR);
    }

    public String getCommCellName() {
        return this.getRegistryString(CVPI_COMMSERVER, CVPI_COMMCELL_NAME);
    }

    public int getCommCellId() {
        return this.getRegistryNumber(CVPI_COMMSERVER, CVPI_COMMCELL_ID, 2);
    }

    public int getPlatformType() {
        return this.getRegistryNumber("Base", CVPI_PLATFORM_TYPE, 0);
    }

    public String getGalaxyTempDir() {
        return this.getRegistryString("Base", CVPI_TEMP_DIR);
    }

    public boolean isCommServ() {
        return (this.getPlatformType() & 1) == 1;
    }

    public int getJMOpType() {
        return 90;
    }

    public int getDebugLevel() {
        return this.getRegistryNumber(CVPI_EVM, CVPI_WORKFLOW_DEBUGLEVEL, LoggerLevel.INFO.toInt());
    }

    public int getMaxLogFileBackups() {
        return this.getRegistryNumber(CVPI_EVM, CVPI_WORKFLOW_MAXLOGFILEBACKUPS, 2);
    }

    public int getMaxLogFileSize() {
        return this.getRegistryNumber(CVPI_EVM, CVPI_WORKFLOW_MAXLOGFILESIZE, 5);
    }

    public int getCleanupInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_CLEANUP_INTERVAL, 1) * 60;
    }

    public boolean getAppendActivityOutputsToExecution() {
        return this.getRegistryNumber("WFEngine", CVPI_APPEND_ACTIVITY_TO_EXECUTION, 0) == 1;
    }

    public int getClassPathRefreshInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_CLASSPATH_REFRESH, 1) * 60;
    }

    public int getThreadMonitorInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_MONITOR_INTERVAL, 5) * 60;
    }

    public int getPythonCleanup() {
        return this.getRegistryNumber("WFEngine", CVPI_PYTHON_CLEANUP, ScriptTask.DELETE_NONE.toInt());
    }

    public int getRefreshSettingsInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_REFRESH_SETTINGS_INTERVAL, 15) * 60;
    }

    public int getRefreshLoggerInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_REFRESH_LOGGER, 1) * 60;
    }

    public boolean isValidateXPath() {
        int n = this.getRegistryNumber("WFEngine", CVPI_VALIDATE_XPATH, 1);
        return n == 1;
    }

    public int getMaxDatabaseConnections() {
        return this.getRegistryNumber("WFEngine", CVPI_MAX_DB_CONNECTIONS, 200);
    }

    public int getDatabaseConnectionLength() {
        return this.getRegistryNumber("WFEngine", CVPI_DB_CONNECTION_LENGTH, 5) * 60;
    }

    public boolean getEnableJMX() {
        int n = this.getRegistryNumber("WFEngine", CVPI_JMX_ENABLE, 0);
        return n == 1;
    }

    public boolean getEnableService() {
        int n = this.getRegistryNumber("WFEngine", CVPI_SERVICE_ENABLE, 0);
        return n == 1;
    }

    public int getJMXPort() {
        return this.getRegistryNumber("WFEngine", CVPI_JMX_PORT, 1099);
    }

    public int getServicePort() {
        return this.getRegistryNumber("WFEngine", CVPI_SERVICE_PORT, 8909);
    }

    public int getHttpTimeout() {
        return this.getRegistryNumber("WFEngine", CVPI_HTTP_TIMEOUT, 0);
    }

    public int getMaxFailedShutdowns() {
        return this.getRegistryNumber("WFEngine", CVPI_MAX_FAILED_SHUTDOWNS, 3);
    }

    public boolean isEnableServiceShutdownCheck() {
        int n = this.getRegistryNumber("WFEngine", CVPI_ENABLE_SHUTDOWN_CHECK, 0);
        return n == 1;
    }

    public int getJobRetentionDays() {
        return this.getRegistryNumber("WFEngine", CVPI_JOB_RETENTION_DAYS, 7);
    }

    public int getInteractionRetentionDays() {
        return this.getRegistryNumber("WFEngine", CVPI_INTERACTION_RETENTION_DAYS, 90);
    }

    public int getDataAgingInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_DATAAGING_INTERVAL, 24) * 60 * 60;
    }

    public int getJobPullingInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_JOB_PULLING_INTERAVAL, 10);
    }

    public int getApprovalEmailPullingInterval() {
        return this.getRegistryNumber("WFEngine", CVPI_APPROVAL_EMAIL_POLLING_INTERVAL, 30);
    }

    public int getOutputCacheSize() {
        return this.getRegistryNumber("WFEngine", CVPI_OUTPUT_CACHE_SIZE, 10);
    }

    public boolean isRelayEmail() {
        int n = this.getRegistryNumber("WFEngine", CVPI_RELAY_EMAIL, 0);
        return n == 1;
    }

    public boolean isExecuteQOPJNI() {
        int n = this.getRegistryNumber("WFEngine", CVPI_QOP_EXEC_JNI, 0);
        return n == 1;
    }

    public boolean isDirectCVDConnection() {
        int n = this.getRegistryNumber("WFEngine", CVPI_DIRECT_SESSION, 0);
        return n == 1;
    }

    public boolean isDeleteApprovalEmails() {
        int n = this.getRegistryNumber("WFEngine", CVPI_DELETE_APPROVAL_EMAILS, 1);
        return n == 1;
    }

    public boolean isReuseThreads() {
        return this.reuseThreads;
    }

    public boolean getReuseThreads() {
        int n = this.getRegistryNumber("WFEngine", CVPI_REUSE_THREADS, 0);
        return n == 1;
    }

    public boolean isStipXmlChars() {
        int n = this.getRegistryNumber("WFEngine", CVPI_STRIP_XML_CHARS, 1);
        return n == 1;
    }

    public boolean isEscapeSQLStrings() {
        int n = this.getRegistryNumber("WFEngine", CVPI_ESCAPE_SQL_STRINGS, 1);
        return n == 1;
    }

    public boolean isForceHttpUtf8() {
        int n = this.getRegistryNumber("WFEngine", CVPI_FORCE_HTTP_UTF8, 0);
        return n == 1;
    }

    public boolean isAutoRestartJobs() {
        int n = this.getRegistryNumber("WFEngine", CVPI_AUTO_RESTART_JOBS, 0);
        return n == 1;
    }

    public boolean isAutoImpersonate() {
        int n = this.getRegistryNumber("WFEngine", CVPI_AUTO_IMPERSONATE, 1);
        return n == 1;
    }

    public boolean isCreateJobHistoryForDisabledWorkflow() {
        int n = this.getRegistryNumber("WFEngine", CVPI_CREATE_DISABLED_HISTORY, 0);
        return n == 1;
    }

    public boolean isAppendWorkflowOperation() {
        int n = this.getRegistryNumber("WFEngine", CVPI_APPEND_WORKFLOW_OP, 0);
        return n == 1;
    }

    public boolean isAllowXXE() {
        int n = this.getRegistryNumber("WFEngine", CVPI_ALLOW_XXE, 0);
        return n == 1;
    }

    public boolean isFailOnNonDeterminedTransition() {
        int n = this.getRegistryNumber("WFEngine", CVPI_FAIL_ON_NON_DETERMINED_TRANSITION, 0);
        return n == 1;
    }

    public boolean isAutoEscapeSQLString() {
        int n = this.getRegistryNumber("WFEngine", CVPI_AUTO_ESCAPE_SQL_STRING, 1);
        return n == 1;
    }

    public boolean isAllowEmptyToRecipients() {
        int n = this.getRegistryNumber("WFEngine", CVPI_ALLOW_EMPTY_TO, 0);
        return n == 1;
    }

    public boolean isEnableStateJobCheck() {
        int n = this.getRegistryNumber("WFEngine", CVPI_ENABLE_STALE_JOB_CHECK, 1);
        return n == 1;
    }

    public String getTrustSqlCertificate() {
        int n = this.getRegistryNumber("WFEngine", CVPI_TRUST_SQL_CERT, 1);
        if (n == 1) {
            return "true";
        }
        return "false";
    }

    public boolean isWriteRunningAttempts() {
        int n = this.getRegistryNumber("WFEngine", CVPI_WRITE_RUNNING_ATTEMPTS, 1);
        return n == 1;
    }

    public boolean isStrictTypeChecking() {
        int n = this.getRegistryNumber("WFEngine", CVPI_STRICT_TYPE_CHECKING, 1);
        return n == 1;
    }

    public boolean isSkipCreateAttempts() {
        int n = this.getRegistryNumber("WFEngine", CVPI_SKIP_ATTEMPTS, 0);
        return n == 1;
    }

    public boolean isValidateSSL() {
        int n = this.getRegistryNumber("WFEngine", CVPI_VALIDATE_SSL, 1);
        return n == 1;
    }

    public boolean isUseHttpProxy() {
        int n = this.getRegistryNumber("WFEngine", CVPI_USE_HTTPPROXY, 0);
        return n == 1;
    }

    public boolean isEnableMailbox() {
        int n = this.getRegistryNumber("WFEngine", CVPI_ENABLE_MAILBOX, 0);
        return n == 1;
    }

    public boolean isReplyClosedActions() {
        int n = this.getRegistryNumber("WFEngine", CVPI_REPLY_CLOSED_ACTIONS, 0);
        return n == 1;
    }

    public boolean isReadUncommitted() {
        int n = this.getRegistryNumber("WFEngine", CVPI_READ_UNCOMMITTED, 1);
        return n == 1;
    }

    public int getJobManagerThreads() {
        return this.getRegistryNumber("WFEngine", CVPI_JOBMANAGER_THREADS, 20);
    }

    public boolean isRetrySecurityProcedure() {
        int n = this.getRegistryNumber("WFEngine", CVPI_RETRY_SEC_PROC, 0);
        return n == 1;
    }

    public int getAlertQueryTime() {
        return this.getRegistryNumber("WFEngine", CVPI_ALERT_QUERY_TIME, 10);
    }

    public int getAlertResponseTime() {
        return this.getRegistryNumber("WFEngine", CVPI_ALERT_RESPONSE_TIME, 10);
    }

    public int getSecurityCacheTime() {
        return this.getRegistryNumber("WFEngine", CVPI_SECURITY_CACHE_TIME, 300);
    }

    public int getQSDKSessionTimeout() {
        return this.getRegistryNumber("WFEngine", CVPI_QSDK_SESSION_TIMEOUT, 0);
    }

    public int getMaxWorkflows() {
        int n = this.getRegistryNumber("WFEngine", CVPI_MAX_WORKFLOWS, 0);
        if (n <= 0) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    public int getChunkSize() {
        int n = this.getRegistryNumber("WFEngine", CVPI_CHUNK_SIZE, 2048);
        if (n <= 0) {
            return 2048;
        }
        return n;
    }

    public int getDefaultLocaleId() {
        return 0;
    }

    public String getClassPathFolder() {
        return DEFAULT_CLASSPATH_FOLDER;
    }

    public int getWebServerPort() {
        return this.getRegistryNumber(CVPI_WEBCONSOLE, CVPI_WEBSERVER_POST, 81);
    }

    public String getWebServerHostName() {
        try {
            return this.getRegistryString(CVPI_WEBCONSOLE, CVPI_WEBSERVER_HOSTNAME);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public int getEdgeDriveFileChunkSize() {
        int n = this.getRegistryNumber("WFEngine", CVPI_EDGE_FILE_CHUNK_SIZE, 4096);
        if (n <= 0) {
            return 4096;
        }
        return n;
    }

    public String getDefaultWebServer() {
        try {
            return this.getRegistryString("WFEngine", CVPI_DEFAULT_WEBSERVER);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public String getEdgeDriveWebServer() {
        try {
            return this.getRegistryString("WFEngine", CVPI_DEFAULT_EDGEWEBSERVER);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public String getDefaultWebconsole() {
        try {
            return this.getRegistryString("WFEngine", CVPI_DEFAULT_WEBCONSOLE);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public String getLoggingDirectory() {
        return this.getRegistryString(CVPI_EVM, CVPI_EVLOGDIR);
    }

    public String getWorkflowLoggingDirectory() {
        return this.getRegistryString("WFEngine", CVPI_EVLOGDIR);
    }

    public String getGalaxyHome() {
        return this.getRegistryString("Base", CVPI_GALAXYHOME);
    }

    public String getGlobalEmailRecipients() {
        return this.getRegistryString("WFEngine", CVPI_GLOBAL_CC_RECIPS, "");
    }

    public String getScriptEngine() {
        return this.getRegistryString("WFEngine", CVPI_SCRIPT_ENGINE, "GraalVM");
    }

    public String getJavaEngine() {
        return this.getRegistryString("WFEngine", CVPI_JAVA_ENGINE, "");
    }

    public boolean isAddImports() {
        return this.getRegistryNumber("WFEngine", CVPI_JAVA_ADD_IMPORTS, 1) == 1;
    }

    public String getMailCopyFolder() {
        return this.getRegistryString("WFEngine", CVPI_APPROVAL_EMAIL_COPY_FOLDER, "");
    }

    public String getRegistryString(String string, String string2, String string3) {
        String string4 = UUID.randomUUID().toString();
        String string5 = EventMessage.getInstance().getRegistryString(string, string2, string4);
        if (string5.equals(string4)) {
            return string3;
        }
        return string5;
    }

    public String getRegistryString(String string, String string2) {
        String string3 = UUID.randomUUID().toString();
        String string4 = EventMessage.getInstance().getRegistryString(string, string2, string3);
        if (string4.equals(string3)) {
            throw new Error("failed to get registry value for [" + string + "\\" + string2 + "]");
        }
        return string4;
    }

    public String getRegistryExpandedString(String string, String string2) {
        return this.getRegistryString(string, string2);
    }

    public int getRegistryNumber(String string, String string2, int n) {
        String string3 = EventMessage.getInstance().getRegistryNumber(string, string2, n);
        if (string3 != null && string3.length() > 0) {
            return Integer.parseInt(string3);
        }
        return n;
    }

    public void setMessagePort(int n) {
        this.setRegistryNumber(CVPI_SESSION, CVPI_MESSAGE_PORT, n);
    }

    public boolean setRegistryNumber(String string, String string2, int n) {
        return EventMessage.getInstance().setRegistryNumber(string, string2, n);
    }

    private String[] getChildKeys(String string) {
        return EventMessage.getInstance().getRegistryChildKeys("~" + string);
    }
}

