/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import bsh.Interpreter;
import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LogConfig;
import commvault.cte.workflow.logger.LoggerLevel;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class WorkflowLogger
implements Repeatable {
    private static CTELogger customLogger = new CTELogger(WorkflowLogger.buildConfig("WorkflowCustom", "Custom", false));
    private static Map<String, CTELogger> loggers = new HashMap<String, CTELogger>();
    private static WorkflowLogger instance = new WorkflowLogger();

    public static WorkflowLogger getInstance() {
        return instance;
    }

    public static LogConfig buildConfig(String string, String string2, boolean bl) {
        File file = new File(WorkflowRegistry.getInstance().getLoggingDirectory());
        if (!file.exists()) {
            throw new Error("could not retrieve logging path from registry");
        }
        String string3 = new File(file, string).getAbsolutePath();
        System.out.println("logging to file [" + string3 + "]");
        return WorkflowLogger.build(string3, string2, bl);
    }

    private static LogConfig build(String string, String string2, boolean bl) {
        Object object;
        Object object2;
        if (string.toLowerCase().endsWith(".log")) {
            string = string.substring(0, string.length() - 4);
        }
        LogConfig logConfig = new LogConfig(string2, string, bl);
        logConfig.setLevel(WorkflowRegistry.getInstance().getDebugLevel());
        logConfig.setNumFiles(WorkflowRegistry.getInstance().getMaxLogFileBackups());
        logConfig.setMaxSize(WorkflowRegistry.getInstance().getMaxLogFileSize());
        String string3 = "";
        String string4 = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string3 = inetAddress.getHostName();
            string4 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("error retrieving InetAddress");
            unknownHostException.printStackTrace();
        }
        File file = new File(WorkflowRegistry.getInstance().getInstallFolder(), "workflowEngine.jar");
        String string5 = "";
        if (file.exists()) {
            try {
                object2 = new JarFile(file);
                object = ((JarFile)object2).getManifest();
                string5 = String.format("%s(BUILD%s)", ((Manifest)object).getMainAttributes().getValue("Specification-Version").trim(), ((Manifest)object).getMainAttributes().getValue("BuildNumber").trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = System.getProperty("os.name");
        object = System.getProperty("os.version");
        String string6 = System.getProperty("sun.arch.data.model");
        logConfig.addFileHeader("Machine", String.format("%s:%s (%s) (%s)", WorkflowRegistry.getInstance().getPhysicalNodeName(), string3.toLowerCase(), string3.toLowerCase(), WorkflowRegistry.getInstance().getVmInstance()));
        logConfig.addFileHeader("IP Addrs", string4);
        logConfig.addFileHeader("Module", "Workflow Engine");
        logConfig.addFileHeader("Commserver", WorkflowRegistry.getInstance().getCommCellName());
        logConfig.addFileHeader("Version", string5);
        logConfig.addDateHeader("Date");
        logConfig.addFileHeader("OS Type", String.format("%s (%s)", object2, object));
        logConfig.addFileHeader("Processor", String.format("%s bit", string6));
        return logConfig;
    }

    private WorkflowLogger() {
    }

    public WorkflowCustomLogger getCustomLogger(WorkflowContext workflowContext) {
        return new WorkflowCustomLogger(customLogger, workflowContext);
    }

    public WorkflowCustomLogger getCustomLogger(String string, WorkflowContext workflowContext) {
        CTELogger cTELogger = loggers.get(string.toLowerCase());
        if (cTELogger == null) {
            String string2;
            if (!Paths.get(string, new String[0]).isAbsolute()) {
                File file = new File(WorkflowRegistry.getInstance().getLoggingDirectory(), string);
                string2 = file.getAbsolutePath();
            } else {
                string2 = string;
            }
            cTELogger = new CTELogger(WorkflowLogger.build(string2, string2, true));
            loggers.put(string.toLowerCase(), cTELogger);
        }
        return new WorkflowCustomLogger(cTELogger, workflowContext);
    }

    @Override
    public void run() {
        LoggerLevel loggerLevel = LoggerLevel.fromInt(WorkflowRegistry.getInstance().getDebugLevel());
        if (CTELogger.getInstance().getLevel() != loggerLevel) {
            CTELogger.getLogger(WorkflowLogger.class).info("******** logging debug level changed to [%s] ********", loggerLevel.toString());
            CTELogger.getInstance().setLevel(loggerLevel);
            customLogger.setLevel(loggerLevel);
            for (CTELogger object : loggers.values()) {
                object.setLevel(loggerLevel);
            }
        }
        int n = WorkflowRegistry.getInstance().getMaxLogFileBackups();
        if (CTELogger.getInstance().getNumFiles() != n) {
            CTELogger.getLogger(WorkflowLogger.class).info("******** max log file backups changed to [%s] ********", n);
            CTELogger.getInstance().setNumFiles(n);
            customLogger.setNumFiles(n);
            for (CTELogger cTELogger : loggers.values()) {
                cTELogger.setNumFiles(n);
            }
        }
        int n2 = WorkflowRegistry.getInstance().getMaxLogFileSize();
        if (CTELogger.getInstance().getMaxSize() != n2) {
            CTELogger.getLogger(WorkflowLogger.class).info("******** max log file size changed to [%s] ********", n2);
            CTELogger.getInstance().setMaxSize(n2);
            customLogger.setMaxSize(n2);
            for (CTELogger cTELogger : loggers.values()) {
                cTELogger.setMaxSize(n2);
            }
        }
    }

    public void close() {
        CTELogger.getInstance().close();
        customLogger.close();
        for (CTELogger cTELogger : loggers.values()) {
            cTELogger.close();
        }
    }

    @Override
    public int getInterval() {
        return WorkflowRegistry.getInstance().getRefreshLoggerInterval();
    }

    public class WorkflowCustomLogger {
        private CTELogger.JobLoggerInstance engineLog;
        private WorkflowContext context;
        private CTELogger customLogger;

        public WorkflowCustomLogger(CTELogger cTELogger, WorkflowContext workflowContext) {
            this.customLogger = cTELogger;
            this.context = workflowContext;
            this.engineLog = CTELogger.getLogger(Interpreter.class, workflowContext.getJobId());
        }

        public void debug(Object object) {
            this.debug(String.valueOf(object));
        }

        public void debug(String string) {
            this.engineLog.info(string);
            if (!this.context.isLogRedirected()) {
                this.customLogger.log(LoggerLevel.DEBUG, this.context.getWorkflowName(), (Long)this.context.getJobId(), string);
            }
        }

        public void info(Object object) {
            this.info(String.valueOf(object));
        }

        public void info(String string) {
            this.engineLog.info(string);
            if (!this.context.isLogRedirected()) {
                this.customLogger.log(LoggerLevel.INFO, this.context.getWorkflowName(), (Long)this.context.getJobId(), string);
            }
        }

        public void warn(Object object) {
            this.warn(String.valueOf(object));
        }

        public void warn(String string) {
            this.engineLog.warn(string);
            if (!this.context.isLogRedirected()) {
                this.customLogger.log(LoggerLevel.WARNING, this.context.getWorkflowName(), (Long)this.context.getJobId(), string);
            }
        }

        public void error(Object object) {
            this.error(String.valueOf(object));
        }

        public void error(String string) {
            this.engineLog.error(string);
            if (!this.context.isLogRedirected()) {
                this.customLogger.log(LoggerLevel.ERROR, this.context.getWorkflowName(), (Long)this.context.getJobId(), string);
            }
        }

        public void disable() {
            this.context.setLoggingDisabled(true);
        }

        public void enable() {
            this.context.setLoggingDisabled(false);
        }

        public void setLogFile(String string) throws Exception {
            this.context.setLogFile(string);
        }

        public void resetLogFile() {
            this.context.resetLogFile();
        }

        public WorkflowCustomLogger path(String string) {
            return WorkflowLogger.this.getCustomLogger(string, this.context);
        }
    }
}

