/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.engine.WF_LockObjects_t;
import commvault.cte.workflow.db.engine.WF_Lock_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;

public class WorkflowLock
implements Runnable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowLock.class);
    private static final int FLAG_AUTO_UNLOCK = 1;
    private static final WorkflowLock instance = new WorkflowLock();

    public static final WorkflowLock getInstance() {
        return instance;
    }

    @Override
    public void run() {
    }

    private boolean jobExists(Long l) {
        if (l == null) {
            return true;
        }
        String string = String.format("jobId = %s AND commCellId = %s", l, 2);
        WF_Process_t wF_Process_t = new WF_Process_t();
        try {
            if (!wF_Process_t.fill(string)) {
                logger.debug("could not find workflow job using where clause [%s]", string);
                return false;
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error looking up job id [" + l + "]", cTEDBException);
            return true;
        }
        return wF_Process_t.State.get().intValue() != ExecutionState.COMPLETED.toInt();
    }

    public boolean aquireLock(ActivityContext activityContext, String string, boolean bl) throws EvFailureException {
        WF_Lock_t wF_Lock_t = this.getLock("name = '" + string.replace("'", "''") + "'");
        boolean bl2 = false;
        if (wF_Lock_t != null) {
            List<WF_LockObjects_t> list = this.getLockObjects("lockId = " + wF_Lock_t.lockId.get());
            for (WF_LockObjects_t wF_LockObjects_t : list) {
                if (wF_LockObjects_t.stepId.get() == activityContext.getProcessStepId()) {
                    return true;
                }
                if (!this.jobExists(wF_LockObjects_t.jobId.get())) {
                    try {
                        wF_LockObjects_t.delete();
                    }
                    catch (CTEDBException cTEDBException) {
                        logger.error("failed to delete lock object [" + wF_LockObjects_t.objectId.get() + "] for name [" + string + "]", cTEDBException);
                    }
                    continue;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            return false;
        }
        if (wF_Lock_t == null) {
            wF_Lock_t = new WF_Lock_t();
        }
        wF_Lock_t.name.set(string);
        wF_Lock_t.created.set(Integer.valueOf(DateUtilities.getNow()));
        wF_Lock_t.counter.set(Integer.valueOf(1));
        wF_Lock_t.maxcount.set(Integer.valueOf(1));
        try {
            wF_Lock_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to create lock [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer("failed to create lock"));
        }
        int n = 0;
        if (bl) {
            n |= 1;
        }
        Object object = new WF_LockObjects_t();
        ((WF_LockObjects_t)((Object)object)).lockId.set(wF_Lock_t.lockId.get());
        ((WF_LockObjects_t)((Object)object)).jobId.set(Long.valueOf(activityContext.getJobId()));
        ((WF_LockObjects_t)((Object)object)).created.set(Integer.valueOf(DateUtilities.getNow()));
        ((WF_LockObjects_t)((Object)object)).stepId.set(activityContext.getProcessStepId());
        ((WF_LockObjects_t)((Object)object)).flags.set(Integer.valueOf(n));
        try {
            object.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to create lock [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer("failed to create lock"));
        }
        return true;
    }

    public void releaseLock(ActivityContext activityContext, String string) throws EvFailureException {
        WF_Lock_t wF_Lock_t = this.getLock("name = '" + string.replace("'", "''") + "'");
        if (wF_Lock_t == null) {
            logger.warn(activityContext.getJobId(), "could not find an existing lock for name [%s]", string);
            return;
        }
        this.deleteLockObjects(wF_Lock_t.lockId.get());
        try {
            wF_Lock_t.delete();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to release lock [" + string + "]", cTEDBException);
        }
    }

    public void onWorkflowEnd(WorkflowProcess workflowProcess) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (WF_LockObjects_t object : this.getLockObjects("jobId = " + workflowProcess.getJobId())) {
                try {
                    object.delete();
                    arrayList.add(object.lockId.get());
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(workflowProcess.getJobId(), "failed to delete lock object [" + object.objectId.get() + "]", cTEDBException);
                }
            }
            if (arrayList.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Integer n : arrayList) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(n);
                }
                for (WF_Lock_t wF_Lock_t : this.getLocks("lockId IN (" + stringBuffer.toString() + ")")) {
                    try {
                        wF_Lock_t.delete();
                    }
                    catch (CTEDBException cTEDBException) {
                        logger.error(workflowProcess.getJobId(), "failed to delete lock [" + wF_Lock_t.name.get() + "]", cTEDBException);
                    }
                }
            }
        }
        catch (EvFailureException evFailureException) {
            // empty catch block
        }
    }

    private List<WF_Lock_t> getLocks(String string) throws EvFailureException {
        try {
            return WF_Lock_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_Lock for where clause [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    private WF_Lock_t getLock(String string) throws EvFailureException {
        WF_Lock_t wF_Lock_t = new WF_Lock_t();
        try {
            if (wF_Lock_t.fill(string)) {
                return wF_Lock_t;
            }
            return null;
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_Lock for where clause [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    private List<WF_LockObjects_t> getLockObjects(String string) throws EvFailureException {
        try {
            return WF_LockObjects_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_LockObjects for where clause [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    public void deleteLockObjects(int n) throws EvFailureException {
        String string = "DELETE FROM WF_LockObjects Where lockId = " + n;
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
            cTEDBReservation.executeUpdate(string);
        }
    }
}

