/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.schema.util.SchemaEncoder;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.AsyncWorkflowResponse;
import commvault.cte.workflow.DataAging;
import commvault.cte.workflow.DecoupledWorkflowManager;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.Engine;
import commvault.cte.workflow.EngineProperties;
import commvault.cte.workflow.EngineQueue;
import commvault.cte.workflow.EvEvent;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventManager;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.JobManager;
import commvault.cte.workflow.Mailbox;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowAlert;
import commvault.cte.workflow.WorkflowApplicationManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowLock;
import commvault.cte.workflow.WorkflowLogger;
import commvault.cte.workflow.WorkflowManager;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.WorkflowInputDesigner;
import commvault.cte.workflow.db.ApplicationDatabase;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.OnDemandAppDatabase;
import commvault.cte.workflow.db.OnDemandDatabase;
import commvault.cte.workflow.db.WorkflowConnection;
import commvault.cte.workflow.db.WorkflowDatabase;
import commvault.cte.workflow.db.cs.JMGetNextJobId_p;
import commvault.cte.workflow.db.cs.JMJobInfo_t;
import commvault.cte.workflow.db.cs.WF_Definition_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.DebugHelper;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.EventSeverity;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.AlertCriteria;
import commvault.msgs.Workflow.AlertStatus;
import commvault.msgs.Workflow.AlertType;
import commvault.msgs.Workflow.BreakpointTask;
import commvault.msgs.Workflow.DebugBreakpointRequest;
import commvault.msgs.Workflow.DebugControl;
import commvault.msgs.Workflow.DebugSetActivityRequest;
import commvault.msgs.Workflow.DebugWorkflowRequest;
import commvault.msgs.Workflow.DeploymentFlags;
import commvault.msgs.Workflow.GenericResp;
import commvault.msgs.Workflow.GetOnDemandWorkflowInputsReq;
import commvault.msgs.Workflow.GetWorkflowInputsReq;
import commvault.msgs.Workflow.GetWorkflowInputsResp;
import commvault.msgs.Workflow.InitFromType;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.ModifyOnDemandRequest;
import commvault.msgs.Workflow.OnDemandWorkflow;
import commvault.msgs.Workflow.ProcessFlags;
import commvault.msgs.Workflow.SchemaDefinition;
import commvault.msgs.Workflow.SessionRequest;
import commvault.msgs.Workflow.SetCurrentStepReq;
import commvault.msgs.Workflow.SetWorkflowVariablesReq;
import commvault.msgs.Workflow.StartWorkflow;
import commvault.msgs.Workflow.StartWorkflowResponse;
import commvault.msgs.Workflow.StepFlags;
import commvault.msgs.Workflow.TransitionDefinition;
import commvault.msgs.Workflow.WorkflowCompletionResponse;
import commvault.msgs.Workflow.WorkflowExecution;
import commvault.msgs.Workflow.WorkflowFlags;
import commvault.msgs.Workflow.WorkflowResponse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkflowEngine
implements InteractiveAction,
Engine {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowEngine.class);
    private static WorkflowEngine instance = new WorkflowEngine();
    private static final int MAX_WORKFLOWS = WorkflowRegistry.getInstance().getMaxWorkflows();
    private final Map<Long, WorkflowManager> workflows = new ConcurrentHashMap<Long, WorkflowManager>();
    private final List<WorkflowManager> applicationWorkflows = Collections.synchronizedList(new ArrayList());
    private final ExecutorService service = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("LoaderThread-" + String.valueOf(this.count.incrementAndGet()));
            return thread;
        }
    });
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5, new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("SchedulerThread-" + String.valueOf(this.count.incrementAndGet()));
            return thread;
        }
    });
    private long appJobId = 0L;
    private Thread engineThread = null;
    private boolean running = true;
    private boolean maxStartupFailuresReached = false;
    private int currentBackupJobs;
    private int lastCheckTime = 0;

    public static Engine getInstance() {
        return instance;
    }

    public static WorkflowEngine instance() {
        return instance;
    }

    protected WorkflowEngine() {
    }

    protected void initialize() throws Exception {
        List<WF_Process_t> list;
        Object object;
        if (this.engineThread != null) {
            throw new Exception("engine all ready running");
        }
        logger.logAll(LoggerLevel.INFO, "********************************************", "          starting workflow engine          ", "********************************************");
        try {
            object = new WorkflowProperties();
            WorkflowProperties.setInstance((WorkflowProperties)object);
            ((WorkflowProperties)object).initialize();
        }
        catch (Exception exception) {
            throw new Exception("failed to initializing workflow properties", exception);
        }
        this.scheduler.scheduleWithFixedDelay(DataAging.getInstance(), 5L, 5L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay(WorkflowLogger.getInstance(), 1L, 1L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay((WorkflowConnection)WorkflowProperties.getInstance().getCommCellConnection(), 1L, 1L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay((WorkflowConnection)WorkflowProperties.getInstance().getEngineConnection(), 1L, 1L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay(ThreadManager.getInstance(), 5L, 5L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay(SessionManager.getInstance(), 5L, 5L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay(WorkflowLock.getInstance(), 5L, 5L, TimeUnit.MINUTES);
        if (Mailbox.getInstance().isEnabled()) {
            int n = WorkflowRegistry.getInstance().getApprovalEmailPullingInterval();
            this.scheduler.scheduleWithFixedDelay(Mailbox.getInstance(), n, n, TimeUnit.SECONDS);
        }
        EventManager.getInstance().fireEngineStartEvent();
        logger.trace("checking for any uncompleted workflow jobs");
        object = String.format("State <> %s", ExecutionState.COMPLETED.toInt());
        try {
            list = WF_Process_t.select((String)object);
        }
        catch (Exception exception) {
            throw new Exception("failed to initialize engine queue", exception);
        }
        Integer n = EngineProperties.getInstance().getLastStartTime();
        int n2 = 0;
        if (WorkflowRegistry.getInstance().isEnableServiceShutdownCheck() && n != null) {
            if (EngineProperties.getInstance().getLastShutdown() < n) {
                n2 = EngineProperties.getInstance().getBadShutdowns() + 1;
                EngineProperties.getInstance().setBadShutdowns(n2);
                logger.warn("workflow engine has failed to shutdown properly [%s] time(s) out of max [%s]", n2, WorkflowRegistry.getInstance().getMaxFailedShutdowns());
                EventMessage.getInstance().generateEvent(new EvEvent(EventSeverity.MAJOR, new EvMessageContainer("Workflow engine on client [%s] has failed to properly shutdown", WorkflowProperties.getInstance().getClient().getClientName())));
                this.maxStartupFailuresReached = n2 >= WorkflowRegistry.getInstance().getMaxFailedShutdowns();
            } else {
                EngineProperties.getInstance().setBadShutdowns(0);
            }
        }
        EngineProperties.getInstance().setLastStartTime(DateUtilities.getNow());
        if (list.size() > 0) {
            for (WF_Process_t wF_Process_t : list) {
                this.service.execute(new WorkflowLoader(wF_Process_t));
            }
        } else {
            logger.trace("no uncompleted jobs to resume");
        }
        this.service.shutdown();
        this.service.awaitTermination(1L, TimeUnit.HOURS);
        if (WorkflowRegistry.getInstance().isAutoRestartJobs()) {
            this.scheduler.scheduleWithFixedDelay(new WorkflowJobCheck(), 10L, 10L, TimeUnit.MINUTES);
        }
        this.engineThread = new Thread((Runnable)new WorkflowEngineMainThread(), "EngineThread");
        logger.trace("starting engine worker thread");
        this.engineThread.start();
    }

    private int getExecutingCount() {
        int n = 0;
        if (this.workflows.size() > 0) {
            for (WorkflowManager workflowManager : this.workflows.values()) {
                if (workflowManager.queue != EngineQueue.EXECUTING) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeManager(WorkflowManager workflowManager) {
        Object object;
        if (workflowManager.getWorkflow().isRunning() && workflowManager.getWorkflow().isDebug()) {
            try {
                object = DebugHelper.buildWorkflowResponse(workflowManager.getWorkflow());
            }
            catch (Exception exception) {
                logger.error(workflowManager.getJobId(), "failed to build workflow response", exception);
                object = RequestManager.getGenericResponse(1, exception.getMessage());
            }
            SessionManager.getInstance().close(workflowManager.getWorkflow(), (CTEProcessingModel)object);
            if (workflowManager.getWorkflow().getStatus().isJobComplete()) {
                workflowManager.queue = EngineQueue.CLEANUP;
                logger.debug(workflowManager.getJobId(), "workflow job [%s] moved to cleanup queue", workflowManager.getJobId());
            } else {
                workflowManager.queue = EngineQueue.ONDEMANDQUEUE;
            }
        } else {
            if (workflowManager.getWorkflow().isRunning() && workflowManager.getWorkflow().getStatus() == ProcessStatus.PENDING) {
                workflowManager.queue = EngineQueue.PENDING;
                logger.debug(workflowManager.getJobId(), "workflow job [%s] moved to pending queue", workflowManager.getJobId());
            } else if (workflowManager.getWorkflow().getStatus().isJobComplete()) {
                workflowManager.queue = EngineQueue.CLEANUP;
                logger.debug(workflowManager.getJobId(), "workflow job [%s] moved to cleanup queue", workflowManager.getJobId());
            } else if (workflowManager.getWorkflow().getStatus() == ProcessStatus.SUSPENDED && workflowManager.getWorkflow().getCacheSize() > 0 && !workflowManager.getWorkflow().isSwitchToJob()) {
                workflowManager.queue = EngineQueue.CACHED;
                logger.info(workflowManager.getJobId(), "workflow job [%s] moved to on-demand queue", workflowManager.getJobId());
            } else if (workflowManager.getWorkflow().isOnDemand()) {
                workflowManager.queue = EngineQueue.ONDEMANDQUEUE;
                logger.info(workflowManager.getJobId(), "workflow job [%s] moved to on-demand queue", workflowManager.getJobId());
                if (workflowManager.getWorkflow().getStatus() == ProcessStatus.RUNNING) {
                    workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
                }
            } else {
                workflowManager.dispose();
                this.workflows.remove(workflowManager.getJobId());
                logger.debug(workflowManager.getJobId(), "workflow job [%s] was removed from the engine with status [%s]", workflowManager.getJobId(), workflowManager.getWorkflow().getStatus());
            }
            this.closeSessions(workflowManager.getWorkflow());
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private boolean processManager(WorkflowManager workflowManager) {
        if (workflowManager.queue == null) {
            return false;
        }
        boolean bl = false;
        switch (workflowManager.queue) {
            case CLEANUP: {
                if (workflowManager.cleanupTime == 0) {
                    workflowManager.cleanupTime = DateUtilities.getNow();
                }
                if (DateUtilities.getNow() <= workflowManager.cleanupTime + WorkflowRegistry.getInstance().getCleanupInterval()) break;
                logger.debug(workflowManager.getJobId(), "finalizing workflow job [%s]", workflowManager.getJobId());
                if (workflowManager.getJobManager().cleanup()) {
                    workflowManager.getWorkflow().setExecutionState(ExecutionState.COMPLETED);
                    workflowManager.getWorkflow().save();
                    logger.debug(workflowManager.getJobId(), "workflow job [%s] finalized", workflowManager.getJobId());
                } else {
                    logger.error(workflowManager.getJobId(), "failed to finalize workflow job [" + workflowManager.getJobId() + "]");
                }
                workflowManager.dispose();
                bl = true;
                logger.debug(workflowManager.getJobId(), "workflow job [%s] was removed from the engine", workflowManager.getJobId());
                break;
            }
            case PENDING: {
                if (!this.isRunning() || !workflowManager.isResumable()) break;
                logger.info(workflowManager.getJobId(), "resuming pending workflow [%s]", workflowManager.getName());
                workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
                workflowManager.queue = EngineQueue.EXECUTING;
                workflowManager.start();
                break;
            }
            case EXECUTING: {
                if (workflowManager.isAlive()) break;
                logger.error(workflowManager.getJobId(), "workflow job thread is no longer running");
                bl = true;
                break;
            }
            case QUEUED: {
                if (this.getExecutingCount() < MAX_WORKFLOWS) {
                    if (workflowManager.getWorkflow().startWhenActivityIsLow()) {
                        if (this.isWorkflowExecuteAllowed()) {
                            workflowManager.queue = EngineQueue.EXECUTING;
                            workflowManager.start();
                            break;
                        }
                        logger.trace("skip starting workflow job [%s] since startWhenActivityIsLow is enabled and current backup job count is [%s]", workflowManager.getJobId(), this.currentBackupJobs);
                        break;
                    }
                    workflowManager.queue = EngineQueue.EXECUTING;
                    workflowManager.start();
                    break;
                }
                logger.trace("can't start workflow job [%s] since we have exceeded max running workflows [%s]", workflowManager.getJobId(), MAX_WORKFLOWS);
                break;
            }
            case CACHED: {
                break;
            }
            case ONDEMANDQUEUE: {
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSuspendedOptions(WorkflowProcess workflowProcess) {
        Object object;
        String string = "DELETE FROM JMMisc WHERE itemType = 21 and jobid=" + workflowProcess.getJobId();
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            object = cTEDBReservation.createStatement(string);
            object.executeUpdate();
        }
        object = "DELETE FROM JMJobOptions WHERE attributeName='Job AutoResume interval' and jobid=" + workflowProcess.getJobId();
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement((String)object);
            preparedStatement.executeUpdate();
        }
    }

    private void processQueues() {
        Iterator<WorkflowManager> iterator = this.workflows.values().iterator();
        while (iterator.hasNext()) {
            WorkflowManager workflowManager = iterator.next();
            try {
                if (!this.processManager(workflowManager)) continue;
                iterator.remove();
            }
            catch (Throwable throwable) {
                logger.error(workflowManager.getJobId(), "uncaught exception processing workflow [" + workflowManager.getWorkflow().getWorkflowName() + "], removing workflow from engine", throwable);
            }
        }
    }

    private void switchWorkflowToJob(WorkflowProcess workflowProcess) throws Exception {
        JMGetNextJobId_p jMGetNextJobId_p = new JMGetNextJobId_p();
        int n = jMGetNextJobId_p.returnInteger();
        logger.debug("retrieved CommServ job id [%s]", n);
        WF_Process_t wF_Process_t = ((ApplicationDatabase)workflowProcess.getDataAccess()).saveToDatabase(n);
        WorkflowLoader workflowLoader = new WorkflowLoader(wF_Process_t);
        workflowLoader.run();
    }

    @Override
    public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
        DebugWorkflowRequest debugWorkflowRequest = (DebugWorkflowRequest)interactiveRequest;
        WorkflowManager workflowManager = this.workflows.get(workflowContext.getJobId());
        if (workflowManager == null) {
            logger.warn(workflowContext.getJobId(), "could not find workflow manager for job id [%s] in the engine", workflowContext.getJobId());
            return;
        }
        if (workflowManager.getWorkflow().getStatus() != ProcessStatus.SUSPENDED) {
            logger.warn(workflowContext.getJobId(), "cannot pass debug control to workflow job [%s] as it has a status of [%s]", workflowContext.getJobId(), workflowManager.getWorkflow().getStatus().toString());
            return;
        }
        if (debugWorkflowRequest.getDebugControl() == DebugControl.TERMINATE) {
            logger.info(workflowContext.getJobId(), "recieved terminate control from debugger");
            workflowManager.getWorkflow().getFailures().clear();
            workflowManager.getWorkflow().setStatus(ProcessStatus.KILL_PENDING);
            workflowManager.getWorkflow().setFailureReason(new EvMessageContainer("debug terminated"));
            workflowManager.save();
            workflowManager.queue = EngineQueue.EXECUTING;
            workflowManager.start();
        } else {
            if (interactiveRequest instanceof DebugWorkflowRequest) {
                workflowManager.update((DebugWorkflowRequest)interactiveRequest);
            }
            this.resume(workflowManager, interactiveRequest.getProcessingInstructionInfo().getUser());
        }
    }

    @Override
    public void onInteractiveSessionClosed() {
    }

    private void closeSessions(WorkflowProcess workflowProcess) {
        if (!workflowProcess.isAutoCloseSessions()) {
            logger.debug(workflowProcess.getJobId(), "skip auto closing sessions due to workflow setting");
            return;
        }
        logger.debug(workflowProcess.getJobId(), "closing all sessions for workflow [" + workflowProcess.getWorkflowName() + "]");
        if (SessionManager.getInstance().contains(workflowProcess)) {
            WorkflowCompletionResponse workflowCompletionResponse;
            if (workflowProcess.getStatus().isJobComplete()) {
                workflowCompletionResponse = RequestManager.buildCompletionResponse(workflowProcess);
            } else {
                String string = null;
                string = workflowProcess.getLastFailure() != null ? EventMessage.getInstance().formatMessage(workflowProcess.getLastFailure().getMessageContainer(), 0) : "";
                if (workflowProcess.getProcessId() != null) {
                    GenericResp genericResp = new GenericResp();
                    genericResp.setErrorCode(workflowProcess.getStatus().toInt());
                    genericResp.setErrorMessage(string);
                    RequestManager.populateWorkflowResponse((WorkflowResponse)genericResp, workflowProcess);
                    workflowCompletionResponse = genericResp;
                } else {
                    commvault.msgs.App.GenericResp genericResp = new commvault.msgs.App.GenericResp();
                    genericResp.setErrorCode(workflowProcess.getStatus().toInt());
                    genericResp.setErrorMessage(string);
                    workflowCompletionResponse = genericResp;
                }
            }
            SessionManager.getInstance().close(workflowProcess, (CTEProcessingModel)workflowCompletionResponse);
        }
    }

    @Override
    public void suspendAll(UserEntity userEntity, String string, int n) throws EvFailureException {
        List<WF_Process_t> list = this.getUncompletedJobs();
        if (list.size() > 0) {
            for (WF_Process_t wF_Process_t : list) {
                if (!ProcessStatus.fromInt((int)wF_Process_t.Status.get()).isSuspendable()) continue;
                this.suspend(wF_Process_t.jobId.get(), wF_Process_t.commCellId.get(), userEntity, string, n);
            }
        } else {
            logger.info("no uncompleted jobs to suspend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(long l, int n, UserEntity userEntity, String string, int n2) throws EvFailureException {
        WorkflowManager workflowManager = this.workflows.get(l);
        if (workflowManager == null) {
            workflowManager = this.retrieveWorkflow(l, n);
        }
        if (userEntity.getUserId() > 0 && !CommServUtils.canManageWorkflow(workflowManager.getWorkflow().getWorkflowId(), workflowManager.getWorkflow().getWorkflowName(), userEntity)) {
            logger.warn("cannot resume job [%s] as user [%s] does not have required job management capability for workflow [%s]", l, userEntity.getUserName(), workflowManager.getWorkflow().getWorkflowName());
            return;
        }
        Object object = workflowManager.getWorkflow().getLock();
        synchronized (object) {
            if (workflowManager.getWorkflow().getStatus().isSuspendable()) {
                Object object2;
                if (!this.workflows.containsKey(l)) {
                    this.workflows.put(l, workflowManager);
                }
                logger.info(l, "suspending workflow [%s], job id [%s]", workflowManager.getName(), workflowManager.getJobId());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_STOPPED_BY_USER", userEntity.getUserName());
                EvFailureReason evFailureReason = new EvFailureReason(workflowManager.getWorkflow(), evMessageContainer);
                workflowManager.getWorkflow().setFailureReason(evFailureReason);
                workflowManager.getWorkflow().setAutoResumeInterval(n2);
                if (string != null && string.length() > 0) {
                    logger.debug(workflowManager.getJobId(), "adding failure reason from user description [%s]", string);
                    object2 = new EvFailureReason(workflowManager.getWorkflow(), new EvMessageContainer(string));
                    workflowManager.getWorkflow().setFailureReason((EvFailureReason)object2);
                }
                object2 = EventMessage.getContainer("JM_WORKFLOW_JOB_SUSPENDED", workflowManager.getName(), userEntity.getUserName());
                workflowManager.getWorkflow().getJobManager().writeEvent(EventSeverity.MAJOR, (EvMessageContainer)object2);
                WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_JOB_ACTIVITY, workflowManager.getWorkflow(), userEntity.getUserId(), AlertStatus.SUSPENDED);
                workflowManager.getWorkflow().getJobManager().writeAlert(workflowAlert);
                if (workflowManager.queue == EngineQueue.EXECUTING) {
                    workflowManager.getWorkflow().setStatus(ProcessStatus.SUSPEND_PENDING);
                    workflowManager.save();
                } else {
                    workflowManager.getWorkflow().setStatus(ProcessStatus.SUSPENDED);
                    workflowManager.save();
                    workflowManager.dispose();
                    this.workflows.remove(workflowManager.getJobId());
                    logger.info(l, "workflow [%s], job id [%s] suspended", workflowManager.getName(), workflowManager.getJobId());
                }
            } else {
                logger.warn(l, "cannot suspend workflow [%s] since it has a status of [%s]", workflowManager.getName(), workflowManager.getWorkflow().getStatus());
            }
        }
    }

    @Override
    public void killAll(UserEntity userEntity, String string) throws EvFailureException {
        List<WF_Process_t> list = this.getUncompletedJobs();
        if (list.size() > 0) {
            for (WF_Process_t wF_Process_t : list) {
                if (!ProcessStatus.fromInt((int)wF_Process_t.Status.get()).isKillable()) continue;
                this.kill(wF_Process_t.jobId.get(), wF_Process_t.commCellId.get(), userEntity, string);
            }
        } else {
            logger.info("no uncompleted jobs to kill");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill(long l, int n, UserEntity userEntity, String string) throws EvFailureException {
        Object object;
        WorkflowManager workflowManager = this.workflows.get(l);
        if (workflowManager == null) {
            object = this.getJobRecordQuiet(l, n);
            if (object == null) {
                try {
                    if (JobManager.killJob(l, n, userEntity.getUserId())) {
                        logger.debug("cleaned up stale records in CommServ database for job id [%s]", l);
                    } else {
                        logger.warn("could not find job id [" + l + "] in WFEngine or CommServ database");
                    }
                }
                catch (CTEDBException cTEDBException) {
                    logger.error("failed to cleanup stale job record in CommServ database for job id [" + l + "]", cTEDBException);
                }
                return;
            }
            workflowManager = this.retrieveWorkflow((WF_Process_t)((Object)object));
        }
        if (userEntity.getUserId() > 0 && !CommServUtils.canManageWorkflow(workflowManager.getWorkflow().getWorkflowId(), workflowManager.getWorkflow().getWorkflowName(), userEntity)) {
            logger.warn("cannot kill job [%s] as user [%s] does not have required job management capability for workflow [%s]", l, userEntity.getUserName(), workflowManager.getWorkflow().getWorkflowName());
            return;
        }
        object = workflowManager.getWorkflow().getLock();
        synchronized (object) {
            if (workflowManager.getWorkflow().getStatus().isKillable()) {
                Object object2;
                if (!this.workflows.containsKey(l)) {
                    this.workflows.put(l, workflowManager);
                }
                logger.info(l, "killing workflow [%s], job id [%s]", workflowManager.getName(), l);
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_KILLED_BY_USER", userEntity.getUserName());
                EvFailureReason evFailureReason = new EvFailureReason(workflowManager.getWorkflow(), evMessageContainer);
                workflowManager.getWorkflow().setFailureReason(evFailureReason);
                if (string != null && string.length() > 0) {
                    object2 = new EvFailureReason(workflowManager.getWorkflow(), new EvMessageContainer(string));
                    workflowManager.getWorkflow().setFailureReason((EvFailureReason)object2);
                }
                if (workflowManager.queue == EngineQueue.EXECUTING) {
                    workflowManager.getWorkflow().setStatus(ProcessStatus.KILL_PENDING);
                } else {
                    workflowManager.queue = EngineQueue.EXECUTING;
                    workflowManager.getWorkflow().setStatus(ProcessStatus.KILL_PENDING);
                    workflowManager.start();
                }
                workflowManager.save();
                object2 = EventMessage.getContainer("JM_WORKFLOW_JOB_KILLED", workflowManager.getName(), userEntity.getUserName());
                workflowManager.getWorkflow().getJobManager().writeEvent(EventSeverity.MAJOR, (EvMessageContainer)object2);
                WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_JOB_ACTIVITY, workflowManager.getWorkflow(), userEntity.getUserId(), AlertStatus.KILLED);
                workflowManager.getWorkflow().getJobManager().writeAlert(workflowAlert);
            } else {
                logger.warn(l, "cannot kill workflow [%s] since it has a status of [%s]", workflowManager.getName(), workflowManager.getWorkflow().getStatus());
                if (workflowManager.getWorkflow().getExecutionState() == ExecutionState.COMPLETED) {
                    workflowManager.getJobManager().checkStaleRecords();
                }
            }
        }
    }

    @Override
    public void resumeAll(UserEntity userEntity) throws EvFailureException {
        List<WF_Process_t> list = this.getUncompletedJobs();
        if (list.size() > 0) {
            for (WF_Process_t wF_Process_t : list) {
                if (!ProcessStatus.fromInt((int)wF_Process_t.Status.get()).isResumable()) continue;
                this.resume(wF_Process_t.jobId.get(), wF_Process_t.commCellId.get(), userEntity);
            }
        } else {
            logger.info("no uncompleted jobs to resume");
        }
    }

    @Override
    public void resume(long l, int n, UserEntity userEntity) throws EvFailureException {
        WorkflowManager workflowManager = this.workflows.get(l);
        if (workflowManager == null) {
            workflowManager = this.retrieveWorkflow(l, n);
        }
        if (userEntity.getUserId() > 0 && !CommServUtils.canManageWorkflow(workflowManager.getWorkflow().getWorkflowId(), workflowManager.getWorkflow().getWorkflowName(), userEntity)) {
            logger.warn("cannot resume job [%s] as user [%s] does not have required job management capability for workflow [%s]", l, userEntity.getUserName(), workflowManager.getWorkflow().getWorkflowName());
            return;
        }
        this.resume(workflowManager, userEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(WorkflowManager workflowManager, UserEntity userEntity) throws EvFailureException {
        Object object = workflowManager.getWorkflow().getLock();
        synchronized (object) {
            if (workflowManager.getWorkflow().getStatus().isResumable()) {
                if (!this.workflows.containsKey(workflowManager.getJobId())) {
                    this.workflows.put(workflowManager.getJobId(), workflowManager);
                }
                logger.info(workflowManager.getJobId(), "resuming workflow [%s], job id [%s]", workflowManager.getName(), workflowManager.getJobId());
                workflowManager.resumePendingActivities();
                workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
                this.clearSuspendedOptions(workflowManager.getWorkflow());
                workflowManager.queue = EngineQueue.EXECUTING;
                workflowManager.start();
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_JOB_RESUMED", workflowManager.getName(), userEntity.getUserName());
                workflowManager.getWorkflow().getJobManager().writeEvent(EventSeverity.INFO, evMessageContainer);
                WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_JOB_ACTIVITY, workflowManager.getWorkflow(), userEntity.getUserId(), AlertStatus.RESUMED);
                workflowManager.getWorkflow().getJobManager().writeAlert(workflowAlert);
            } else {
                logger.info(workflowManager.getJobId(), "cannot resume workflow [%s] since it has a status of [%s]", workflowManager.getName(), workflowManager.getWorkflow().getStatus());
                this.workflows.remove(workflowManager.getJobId());
            }
        }
    }

    public void processSetCurrentStepRequest(SetCurrentStepReq setCurrentStepReq, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        Object object;
        WF_ProcessSteps_t wF_ProcessSteps_t2;
        List<WF_ProcessSteps_t> list;
        logger.info("updating workflow job [" + setCurrentStepReq.getJobId() + "] and setting current process step to id [" + setCurrentStepReq.getProcessStepId() + "]");
        WorkflowManager workflowManager = this.workflows.get(setCurrentStepReq.getJobId());
        if (workflowManager == null) {
            workflowManager = this.retrieveWorkflow(setCurrentStepReq.getJobId(), WorkflowProperties.getInstance().getCommCell().getCommCellId());
        }
        if (workflowManager.getWorkflow().getStatus() != ProcessStatus.SUSPENDED && !workflowManager.getWorkflow().getStatus().isJobComplete()) {
            logger.error("cannot modify job id [" + setCurrentStepReq.getJobId() + "] since it has a status of [" + workflowManager.getWorkflow().getStatus() + "]");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "invalid status"));
            return;
        }
        logger.info(workflowManager.getJobId(), "retrieved manager for job id [%s]", workflowManager.getJobId());
        try {
            list = workflowManager.getWorkflow().getDataAccess().getRunningSteps(workflowManager.getJobId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to complete all running steps", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        logger.info(workflowManager.getJobId(), "retrieved running step count [%s]", list.size());
        for (WF_ProcessSteps_t wF_ProcessSteps_t2 : list) {
            logger.info(workflowManager.getJobId(), "completing process step [" + wF_ProcessSteps_t2.Name.get() + "]");
            try {
                wF_ProcessSteps_t2.Status.set(Integer.valueOf(ProcessStatus.COMPLETED.toInt()));
                wF_ProcessSteps_t2.State.set(Integer.valueOf(ExecutionState.COMPLETED.toInt()));
                wF_ProcessSteps_t2.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to complete process step [" + wF_ProcessSteps_t2.getName() + "], id [" + wF_ProcessSteps_t2.ProcessStepId.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            try {
                JobManager.updateAttempt(workflowManager.getJobId(), workflowManager.getCommCellId(), wF_ProcessSteps_t2.ProcessStepId.get(), true);
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to update job attempt [" + wF_ProcessSteps_t2.getName() + "], id [" + wF_ProcessSteps_t2.ProcessStepId.get() + "]", cTEDBException);
            }
        }
        HashSet hashSet = new HashSet();
        try {
            wF_ProcessSteps_t2 = workflowManager.getWorkflow().getDataAccess().getProcessStep(setCurrentStepReq.getProcessStepId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to retrieve process step for activity [" + setCurrentStepReq.getProcessStepId() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_ProcessSteps_t2 == null) {
            logger.error(workflowManager.getJobId(), "could not find process for id [" + setCurrentStepReq.getProcessStepId() + "]");
            throw new EvFailureException(new EvMessageContainer("failed to find process step"));
        }
        logger.info(workflowManager.getJobId(), "configuring step [" + wF_ProcessSteps_t2.Name.get() + "], id [" + wF_ProcessSteps_t2.ProcessStepId.get() + "] with status of running");
        if (!wF_ProcessSteps_t2.superProcessId.isNull() && wF_ProcessSteps_t2.superProcessId.get() > 0) {
            hashSet.add(wF_ProcessSteps_t2.superProcessId.get());
        }
        wF_ProcessSteps_t2.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
        wF_ProcessSteps_t2.Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
        try {
            wF_ProcessSteps_t2.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to save process step [" + wF_ProcessSteps_t2.Name.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        try {
            JobManager.updateAttempt(wF_ProcessSteps_t2.jobId.get(), wF_ProcessSteps_t2.commCellId.get(), wF_ProcessSteps_t2.ProcessStepId.get(), false);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to update job attempt [" + wF_ProcessSteps_t2.getName() + "], id [" + wF_ProcessSteps_t2.ProcessStepId.get() + "]", cTEDBException);
        }
        while (!wF_ProcessSteps_t2.ParentId.isNull()) {
            object = wF_ProcessSteps_t2.Name.get();
            try {
                wF_ProcessSteps_t2 = workflowManager.getWorkflow().getDataAccess().getProcessStep(wF_ProcessSteps_t2.ParentId.get());
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to load parent for process step [" + wF_ProcessSteps_t2.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            if (wF_ProcessSteps_t2 == null) {
                logger.error(workflowManager.getJobId(), "could not find parent for process step [" + (String)object + "]");
                throw new EvFailureException(new EvMessageContainer("failed to retrieve execution path for activity"));
            }
            logger.info(workflowManager.getJobId(), "configuring parent step [" + wF_ProcessSteps_t2.Name.get() + "], id [" + wF_ProcessSteps_t2.ProcessStepId.get() + "] with status of running");
            if (!wF_ProcessSteps_t2.superProcessId.isNull() && wF_ProcessSteps_t2.superProcessId.get() > 0) {
                hashSet.add(wF_ProcessSteps_t2.superProcessId.get());
            }
            wF_ProcessSteps_t2.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
            wF_ProcessSteps_t2.Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
            try {
                wF_ProcessSteps_t2.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to save process step [" + wF_ProcessSteps_t2.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            try {
                JobManager.updateAttempt(wF_ProcessSteps_t2.jobId.get(), wF_ProcessSteps_t2.commCellId.get(), wF_ProcessSteps_t2.ProcessStepId.get(), false);
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to update job attempt [" + wF_ProcessSteps_t2.getName() + "], id [" + wF_ProcessSteps_t2.ProcessStepId.get() + "]", cTEDBException);
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            WF_SuperProcess_t wF_SuperProcess_t;
            Integer n = (Integer)object.next();
            try {
                wF_SuperProcess_t = workflowManager.getWorkflow().getDataAccess().getSuperProcess(n.intValue());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to retrieve super process id [" + n + "]", cTEDBException);
                continue;
            }
            logger.info(workflowManager.getJobId(), "configuring super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "] with status of running");
            wF_SuperProcess_t.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
            try {
                wF_SuperProcess_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to save super process id [" + n + "]", cTEDBException);
            }
        }
        logger.info(workflowManager.getJobId(), "saving workflow manager");
        workflowManager.save();
        asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDebugSetActivity(DebugSetActivityRequest debugSetActivityRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        WorkflowManager workflowManager = this.workflows.get(debugSetActivityRequest.getJobId());
        if (workflowManager == null) {
            logger.error("failed to process set activity request as job id [" + debugSetActivityRequest.getJobId() + "] does not exist in engine");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "job doesn't exist"));
            return;
        }
        if (workflowManager.getWorkflow().getStatus().isJobComplete()) {
            logger.error(workflowManager.getJobId(), "cannot modify execution of job [" + workflowManager.getJobId() + "] as it has already completed");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "job already completed"));
            return;
        }
        if (workflowManager.queue == EngineQueue.EXECUTING) {
            workflowManager.getWorkflow().setAutoCloseSessions(false);
            workflowManager.getWorkflow().setRunning(false);
        }
        while (workflowManager.queue == EngineQueue.EXECUTING) {
            logger.info(workflowManager.getJobId(), "execution modification request is waiting for workflow [%s] to become idle", workflowManager.getWorkflow().getName());
            WorkflowEngine workflowEngine = this;
            synchronized (workflowEngine) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.processModifyExecution(workflowManager, debugSetActivityRequest);
            logger.debug(workflowManager.getJobId(), "completed request for setting current debug activity [%s], resuming workflow", debugSetActivityRequest.getUniqueName());
            SessionManager.getInstance().reset((SessionRequest)debugSetActivityRequest, asyncWorkflowResponse);
            workflowManager.clearQueues();
            workflowManager.getWorkflow().setAutoCloseSessions(true);
            workflowManager.getWorkflow().setRunning(true);
            this.resume(workflowManager, debugSetActivityRequest.getProcessingInstructionInfo().getUser());
        }
        catch (EvFailureException evFailureException) {
            workflowManager.getWorkflow().setStatus(ProcessStatus.FAILED);
            workflowManager.queue = EngineQueue.EXECUTING;
            workflowManager.clearQueues();
            workflowManager.getWorkflow().setAutoCloseSessions(true);
            workflowManager.getWorkflow().setRunning(true);
            throw evFailureException;
        }
    }

    private void processModifyExecution(WorkflowManager workflowManager, DebugSetActivityRequest debugSetActivityRequest) throws EvFailureException {
        OnDemandDatabase onDemandDatabase;
        WF_Steps_t wF_Steps_t;
        WF_ProcessSteps_t wF_ProcessSteps_t;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        try {
            wF_ProcessSteps_t = workflowManager.getWorkflow().getDataAccess().getLastProcessStep(debugSetActivityRequest.getUniqueName());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to retrieve process step for activity [" + debugSetActivityRequest.getUniqueName() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_ProcessSteps_t == null) {
            logger.error(workflowManager.getJobId(), "could not find process step for activity [" + debugSetActivityRequest.getUniqueName() + "]");
            throw new EvFailureException(new EvMessageContainer("failed to retrieve activity"));
        }
        if (!wF_ProcessSteps_t.superProcessId.isNull() && wF_ProcessSteps_t.superProcessId.get() > 0) {
            hashSet.add(wF_ProcessSteps_t.superProcessId.get());
        }
        if ((wF_Steps_t = (onDemandDatabase = (OnDemandDatabase)workflowManager.getWorkflow().getDataAccess()).getStep(wF_ProcessSteps_t.StepId.get())) == null) {
            logger.error(workflowManager.getJobId(), "could not find definition step for activity [" + wF_ProcessSteps_t.Name.get() + "]");
            throw new EvFailureException(new EvMessageContainer("failed to retrieve activity"));
        }
        if (debugSetActivityRequest.getActivity(false) != null) {
            DeploymentManager.populateStepRow(debugSetActivityRequest.getActivity(), wF_Steps_t);
            block16: for (WF_StepTransitions_t object : onDemandDatabase.getStepTransitions(wF_Steps_t.StepId.get())) {
                for (TransitionDefinition cTEDBException : debugSetActivityRequest.getActivity().getTransition()) {
                    if (!object.TargetActivity.get().equalsIgnoreCase(cTEDBException.getActivity())) continue;
                    DeploymentManager.populateStepTransition(object, cTEDBException);
                    continue block16;
                }
            }
        }
        try {
            wF_Steps_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to save step definition for activity [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        try {
            workflowManager.getWorkflow().getDataAccess().setStepsCompleted();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to complete all running steps", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        wF_ProcessSteps_t.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
        wF_ProcessSteps_t.Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
        wF_ProcessSteps_t.flags.set(Integer.valueOf(wF_ProcessSteps_t.flags.get() | StepFlags.BREAKPOINT.getEnumValue()));
        try {
            wF_ProcessSteps_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to save process step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        while (!wF_ProcessSteps_t.ParentId.isNull()) {
            String string = wF_ProcessSteps_t.Name.get();
            try {
                wF_ProcessSteps_t = workflowManager.getWorkflow().getDataAccess().getProcessStep(wF_ProcessSteps_t.ParentId.get());
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to load parent for process step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            if (wF_ProcessSteps_t == null) {
                logger.error(workflowManager.getJobId(), "could not find parent for process step [" + (String)string + "]");
                throw new EvFailureException(new EvMessageContainer("failed to retrieve execution path for activity"));
            }
            if (!wF_ProcessSteps_t.superProcessId.isNull() && wF_ProcessSteps_t.superProcessId.get() > 0) {
                hashSet.add(wF_ProcessSteps_t.superProcessId.get());
            }
            wF_ProcessSteps_t.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
            wF_ProcessSteps_t.Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
            try {
                wF_ProcessSteps_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to save process step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
        for (Integer n : hashSet) {
            Object object;
            try {
                object = workflowManager.getWorkflow().getDataAccess().getSuperProcess(n.intValue());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to retrieve super process id [" + n + "]", cTEDBException);
                continue;
            }
            ((WF_SuperProcess_t)((Object)object)).State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
            try {
                object.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowManager.getJobId(), "failed to save super process id [" + n + "]", cTEDBException);
            }
        }
    }

    @Override
    public void processBreakpointRequest(DebugBreakpointRequest debugBreakpointRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        WorkflowManager workflowManager = this.workflows.get(debugBreakpointRequest.getJobId());
        if (workflowManager == null) {
            logger.error("failed to process break point request as job id [" + debugBreakpointRequest.getJobId() + "] does not exist in engine");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "job doesn't exist"));
            return;
        }
        int n = 0;
        try {
            if (debugBreakpointRequest.getTask() == BreakpointTask.ADD || debugBreakpointRequest.getTask() == BreakpointTask.REMOVE) {
                logger.info(workflowManager.getJobId(), "processing breakpoint request [%s] for activity [%s]", debugBreakpointRequest.getTask(), debugBreakpointRequest.getUniqueName());
                n = workflowManager.getWorkflow().getDataAccess().setBreakpoint(debugBreakpointRequest.getJobId(), WorkflowProperties.getInstance().getCommCell().getCommCellId(), debugBreakpointRequest.getUniqueName(), debugBreakpointRequest.getTask() == BreakpointTask.ADD);
            } else {
                logger.info(workflowManager.getJobId(), "clearing all breakpoints for job [%s]", debugBreakpointRequest.getJobId());
                n = workflowManager.getWorkflow().getDataAccess().clearBreakpoints(debugBreakpointRequest.getJobId(), WorkflowProperties.getInstance().getCommCell().getCommCellId());
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowManager.getJobId(), "failed to process break point request", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (n > 0) {
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse());
        } else {
            logger.error(workflowManager.getJobId(), "failed to update any step rows for breakpoint request");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "no records updated"));
        }
    }

    @Override
    public void modifyDebugJob(ModifyOnDemandRequest modifyOnDemandRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        WorkflowManager workflowManager = this.workflows.get(modifyOnDemandRequest.getJobId());
        if (workflowManager == null) {
            logger.error("failed to update job as job id [" + modifyOnDemandRequest.getJobId() + "] does not exist in engine");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "job doesn't exist"));
            return;
        }
        if (!workflowManager.getWorkflow().isOnDemand()) {
            logger.error("cannot update job id [" + modifyOnDemandRequest.getJobId() + "] since it's not an on-demand job");
            asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "invalid on-demand job"));
            return;
        }
        OnDemandDatabase onDemandDatabase = new OnDemandDatabase();
        DeploymentManager.deploy(modifyOnDemandRequest.getDefinition(), modifyOnDemandRequest.getProcessingInstructionInfo().getUser(), onDemandDatabase);
        ((OnDemandDatabase)workflowManager.getWorkflow().getDataAccess()).update(onDemandDatabase);
        asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse());
    }

    private WF_Steps_t getDesignerStep(int n, DataAccessLayer dataAccessLayer) throws EvFailureException {
        List<WF_Steps_t> list;
        try {
            list = dataAccessLayer.getEventSteps(n, WorkflowInputDesigner.class.getName());
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to lookup activity [" + WorkflowInputDesigner.class.getName() + "] for deployment id [" + n + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        for (WF_Steps_t wF_Steps_t : list) {
            if (!wF_Steps_t.ParentStepId.isNull()) continue;
            return wF_Steps_t;
        }
        return null;
    }

    @Override
    public void retrieveInputs(GetWorkflowInputsReq getWorkflowInputsReq, UserEntity userEntity, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        WF_Deployments_t wF_Deployments_t;
        DataAccessLayer dataAccessLayer;
        boolean bl = false;
        if (getWorkflowInputsReq instanceof GetOnDemandWorkflowInputsReq) {
            dataAccessLayer = new OnDemandAppDatabase();
            DeploymentManager.deploy(((GetOnDemandWorkflowInputsReq)getWorkflowInputsReq).getDefinition(), getWorkflowInputsReq.getProcessingInstructionInfo().getUser(), (OnDemandDatabase)dataAccessLayer);
            wF_Deployments_t = ((OnDemandDatabase)dataAccessLayer).getEngineDeployment();
            bl = ((GetOnDemandWorkflowInputsReq)getWorkflowInputsReq).getDebug();
        } else {
            dataAccessLayer = new ApplicationDatabase();
            wF_Deployments_t = CommServUtils.getWorkflowDeployment(getWorkflowInputsReq.getWorkflow(), getWorkflowInputsReq.getVersion());
        }
        final WF_Steps_t wF_Steps_t = this.getDesignerStep(wF_Deployments_t.DeploymentId.get(), dataAccessLayer);
        if (wF_Steps_t == null) {
            GetWorkflowInputsResp getWorkflowInputsResp = new GetWorkflowInputsResp();
            if (!wF_Deployments_t.SchemaDefinition.isNull()) {
                try {
                    SchemaDefinition schemaDefinition = (SchemaDefinition)WorkflowUtils.decodeMessage(wF_Deployments_t.SchemaDefinition.get(), (Object)new SchemaDefinition());
                    getWorkflowInputsResp.setInputForm(SchemaEncoder.encodeForm((XMLSchema)schemaDefinition.getInputs()));
                }
                catch (Exception exception) {
                    logger.error("failed to decode Workflow::SchemaDefinition [" + wF_Deployments_t.SchemaDefinition.get() + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            } else {
                getWorkflowInputsResp.setErrorCode(1);
                getWorkflowInputsResp.setErrorMessage("input schema not present for workflow [" + wF_Deployments_t.WorkflowName.get() + "]");
            }
            asyncWorkflowResponse.setResponse((CTEProcessingModel)getWorkflowInputsResp);
            return;
        }
        --this.appJobId;
        WF_Process_t wF_Process_t = dataAccessLayer.newProcessRow();
        wF_Process_t.zero();
        wF_Process_t.jobId.set(Long.valueOf(this.appJobId));
        wF_Process_t.DeploymentId.set(wF_Deployments_t.DeploymentId.get());
        wF_Process_t.Status.set(Integer.valueOf(ProcessStatus.RUNNING.toInt()));
        wF_Process_t.State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
        wF_Process_t.userId.set(Integer.valueOf(userEntity.getUserId()));
        WorkflowProcess workflowProcess = new WorkflowProcess(dataAccessLayer, wF_Deployments_t, wF_Process_t, new UserModel(userEntity), 0){

            @Override
            public WF_Steps_t getStartStep() throws EvFailureException {
                return wF_Steps_t;
            }
        };
        workflowProcess.setDebug(bl);
        SessionManager.getInstance().createSession((WorkflowContext)workflowProcess, asyncWorkflowResponse);
        DecoupledWorkflowManager decoupledWorkflowManager = new DecoupledWorkflowManager(workflowProcess){

            @Override
            protected void worker() {
                try {
                    super.worker();
                }
                catch (Throwable throwable) {
                    logger.error(this.workflow.getJobId(), "uncaught exception in executing workflow manager, exiting workflow manager!", throwable);
                }
                WorkflowEngine.this.applicationWorkflows.remove(this);
                if (SessionManager.getInstance().contains(this.getWorkflow())) {
                    GetWorkflowInputsResp getWorkflowInputsResp = new GetWorkflowInputsResp();
                    if (this.getWorkflow().getStatus() == ProcessStatus.COMPLETED) {
                        getWorkflowInputsResp.setErrorCode(-1);
                        getWorkflowInputsResp.setErrorMessage("");
                    } else {
                        getWorkflowInputsResp.setErrorCode(this.getWorkflow().getStatus().toInt());
                        if (this.getWorkflow().getLastFailure() != null) {
                            getWorkflowInputsResp.setErrorMessage(this.getWorkflow().getLastFailure().getMessage());
                        }
                    }
                    SessionManager.getInstance().close(this.getWorkflow(), (CTEProcessingModel)getWorkflowInputsResp);
                }
            }
        };
        this.applicationWorkflows.add(decoupledWorkflowManager);
        decoupledWorkflowManager.start();
    }

    @Override
    public long submit(OnDemandWorkflow onDemandWorkflow, UserEntity userEntity, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        OnDemandDatabase onDemandDatabase = !onDemandWorkflow.getDebug() && onDemandWorkflow.getDefinition().getApiMode() ? new OnDemandAppDatabase() : new OnDemandDatabase();
        DeploymentManager.deploy(onDemandWorkflow.getDefinition(), onDemandWorkflow.getProcessingInstructionInfo().getUser(), onDemandDatabase);
        WF_Deployments_t wF_Deployments_t = onDemandDatabase.getEngineDeployment();
        WF_Definition_t wF_Definition_t = new WF_Definition_t();
        wF_Definition_t.flags.set(Integer.valueOf(0));
        return this.submit((StartWorkflow)onDemandWorkflow, userEntity, asyncWorkflowResponse, wF_Deployments_t, wF_Definition_t, onDemandWorkflow.getDebug(), onDemandDatabase);
    }

    @Override
    public long submit(StartWorkflow startWorkflow, UserEntity userEntity, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        WF_Deployments_t wF_Deployments_t = CommServUtils.getWorkflowDeployment(startWorkflow.getWorkflow(), startWorkflow.getVersion());
        WF_Definition_t wF_Definition_t = CommServUtils.getCommCellDefinition(wF_Deployments_t);
        DataAccessLayer dataAccessLayer = (wF_Deployments_t.flags.get() & DeploymentFlags.API_MODE.getEnumValue()) > 0 ? new ApplicationDatabase() : new WorkflowDatabase();
        return this.submit(startWorkflow, userEntity, asyncWorkflowResponse, wF_Deployments_t, wF_Definition_t, false, dataAccessLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long submit(StartWorkflow startWorkflow, UserEntity userEntity, AsyncWorkflowResponse asyncWorkflowResponse, WF_Deployments_t wF_Deployments_t, WF_Definition_t wF_Definition_t, boolean bl, DataAccessLayer dataAccessLayer) throws EvFailureException {
        Object object;
        Object object22;
        Object object3;
        UserModel userModel;
        if (!WorkflowRegistry.getInstance().isCreateJobHistoryForDisabledWorkflow() && (wF_Definition_t.flags.get() & WorkflowFlags.DISABLED.getEnumValue()) == WorkflowFlags.DISABLED.getEnumValue()) {
            logger.info("cannot start workflow [" + wF_Deployments_t.WorkflowName.get() + "] since it is disabled");
            throw new EvFailureException(new EvMessageContainer("workflow disabled"));
        }
        try {
            userModel = UserModel.load(userEntity.getUserId());
        }
        catch (EvFailureException evFailureException) {
            logger.info("cannot start workflow [%s] due to missing or invalid user id", wF_Deployments_t.WorkflowName.get());
            throw new EvFailureException(evFailureException.getMessageContainer());
        }
        long l = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            bl2 = true;
        } else {
            bl3 = (wF_Deployments_t.flags.get() & DeploymentFlags.API_MODE.getEnumValue()) > 0;
            boolean bl4 = bl2 = startWorkflow.getInitiatedFrom() != InitFromType.SCHEDULE && startWorkflow.getInitiatedFrom() != InitFromType.SYSTEM && (startWorkflow.getWaitForResponse() || (wF_Deployments_t.flags.get() & DeploymentFlags.INTERACTIVE.getEnumValue()) == DeploymentFlags.INTERACTIVE.getEnumValue());
        }
        if (!bl3) {
            if (startWorkflow.getJobId() > 0L) {
                l = startWorkflow.getJobId();
            } else {
                try {
                    logger.debug("retrieving next job id from commserve");
                    object3 = new JMGetNextJobId_p();
                    l = object3.returnInteger().intValue();
                    logger.debug("retrieved next CommServ job id [%s]", l);
                }
                catch (CTEDBException cTEDBException) {
                    logger.error("failed to retrieve next job id from commcell", cTEDBException);
                    throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
                }
                if (this.workflows.containsKey(l)) {
                    logger.error("workflow engine already contains job id [" + l + "]");
                    object3 = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_NEXT_JOB", new Object[0]);
                    throw new EvFailureException((EvMessageContainer)object3);
                }
            }
        }
        startWorkflow.setJobId(0L);
        logger.debug(l, "creating workflow process for [%s]", wF_Deployments_t.WorkflowName.get());
        object3 = dataAccessLayer.newProcessRow();
        ((WF_Process_t)((Object)object3)).jobId.set(Long.valueOf(l));
        ((WF_Process_t)((Object)object3)).commCellId.set(Integer.valueOf(WorkflowRegistry.getInstance().getCommCellId()));
        if (wF_Deployments_t.DeploymentId.get() > 0) {
            ((WF_Process_t)((Object)object3)).DeploymentId.set(wF_Deployments_t.DeploymentId.get());
        }
        ((WF_Process_t)((Object)object3)).Inputs.set(WorkflowUtils.getWorkflowInputs(startWorkflow.getOptions()));
        ((WF_Process_t)((Object)object3)).StartTime.set(Integer.valueOf(DateUtilities.getNow()));
        ((WF_Process_t)((Object)object3)).Modified.set(Integer.valueOf(DateUtilities.getNow()));
        ((WF_Process_t)((Object)object3)).Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
        ((WF_Process_t)((Object)object3)).State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
        ((WF_Process_t)((Object)object3)).userId.set(Integer.valueOf(userEntity.getUserId()));
        ((WF_Process_t)((Object)object3)).taskId.set(Integer.valueOf(startWorkflow.getSubTask().getTaskId()));
        ((WF_Process_t)((Object)object3)).subTaskId.set(Integer.valueOf(startWorkflow.getSubTask().getSubtaskId()));
        ((WF_Process_t)((Object)object3)).initFrom.set(Integer.valueOf(startWorkflow.getInitiatedFrom().getEnumValue()));
        ((WF_Process_t)((Object)object3)).processId.set(startWorkflow.getContextId(false));
        ((WF_Process_t)((Object)object3)).localeId.set(Integer.valueOf(startWorkflow.getProcessingInstructionInfo().getLocale().getLocaleId()));
        if (WorkflowRegistry.getInstance().isUseGlobalLock()) {
            ((WF_Process_t)((Object)object3)).flags.set(Integer.valueOf(ProcessFlags.GLOBAL_LOCK.getEnumValue()));
        } else {
            ((WF_Process_t)((Object)object3)).flags.set(Integer.valueOf(0));
        }
        try {
            ((WF_Process_t)((Object)object3)).xmlJobInfo.set(XMLEncoder.encodeWithoutXmlHeader((Object)startWorkflow));
        }
        catch (Exception exception) {
            logger.error("failed to encode start workflow request", exception);
            ((WF_Process_t)((Object)object3)).xmlJobInfo.set("");
        }
        try {
            object3.save();
        }
        catch (Exception exception) {
            logger.error("failed to create workflow job", exception);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_JOB", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        for (Object object22 : startWorkflow.getTriggers()) {
            logger.debug("adding trigger to job id [%s], xml [%s]", ((WF_Process_t)((Object)object3)).jobId.get(), object22);
            object = dataAccessLayer.newTrigger();
            object.jobId.set(((WF_Process_t)((Object)object3)).jobId.get());
            object.commCellId.set(((WF_Process_t)((Object)object3)).commCellId.get());
            object.Message.set((String)object22);
            try {
                object.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to add trigger to WF_Trigger table, job Id [" + ((WF_Process_t)((Object)object3)).jobId.get() + "], message [" + (String)object22 + "]", cTEDBException);
            }
        }
        WorkflowProcess workflowProcess = new WorkflowProcess(dataAccessLayer, wF_Deployments_t, (WF_Process_t)((Object)object3), userModel, wF_Definition_t.flags.get());
        workflowProcess.setDebug(bl);
        if (bl2) {
            SessionManager.getInstance().createSession((WorkflowContext)workflowProcess, asyncWorkflowResponse);
        }
        if (bl3) {
            object22 = new WorkflowApplicationManager(workflowProcess, asyncWorkflowResponse){

                @Override
                protected void worker() {
                    try {
                        super.worker();
                    }
                    catch (Throwable throwable) {
                        logger.error(this.workflow.getJobId(), "uncaught exception in executing workflow manager, exiting workflow manager!", throwable);
                    }
                    WorkflowEngine.this.applicationWorkflows.remove(this);
                    WorkflowEngine.this.closeSessions(this.getWorkflow());
                    if (this.getWorkflow().isSwitchToJob()) {
                        try {
                            WorkflowEngine.this.switchWorkflowToJob(this.getWorkflow());
                        }
                        catch (Exception exception) {
                            logger.error("failed to switch api workflow [" + this.getWorkflow().getWorkflowName() + "] to standard job", exception);
                        }
                    }
                }
            };
            this.applicationWorkflows.add((WorkflowManager)object22);
        } else {
            object22 = new WorkflowManager(workflowProcess);
            this.workflows.put(((ProcessManager)object22).getJobId(), (WorkflowManager)object22);
        }
        ((WorkflowManager)object22).save();
        if (((WorkflowManager)object22).getWorkflow().getStatus() == ProcessStatus.FAILED) {
            object = ((WorkflowManager)object22).getWorkflow().getLastFailure() != null ? ((WorkflowManager)object22).getWorkflow().getLastFailure().getMessageContainer() : EventMessage.getContainer("JM_APPLICATION_ERROR", new Object[0]);
            EvFailureException evFailureException = new EvFailureException((EvMessageContainer)object);
            logger.error("workflow failed to start with message [" + evFailureException.getMessage() + "]");
            ((WorkflowManager)object22).queue = EngineQueue.CLEANUP;
            WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_JOB_ACTIVITY, ((WorkflowManager)object22).getWorkflow(), userEntity.getUserId(), AlertStatus.FAILED_TO_START);
            ((WorkflowManager)object22).getWorkflow().getJobManager().writeAlert(workflowAlert);
            throw evFailureException;
        }
        if (bl3) {
            ((WorkflowManager)object22).getWorkflow().setStatus(ProcessStatus.QUEUED);
            ((WorkflowManager)object22).queue = EngineQueue.EXECUTING;
            ((WorkflowManager)object22).start();
        } else {
            if (((WorkflowManager)object22).getWorkflow().getSubTaskId() > 0) {
                ((WorkflowManager)object22).getWorkflow().setStatus(ProcessStatus.QUEUED);
                ((WorkflowManager)object22).queue = EngineQueue.QUEUED;
                ((WorkflowManager)object22).save();
                object = this;
                synchronized (object) {
                    this.notify();
                }
            } else {
                ((WorkflowManager)object22).getWorkflow().setStatus(ProcessStatus.QUEUED);
                ((WorkflowManager)object22).queue = EngineQueue.EXECUTING;
                ((WorkflowManager)object22).start();
            }
            object = new WorkflowAlert(AlertType.NT_JOB_STARTED, ((WorkflowManager)object22).getWorkflow(), userEntity.getUserId(), AlertStatus.NO_STATUS);
            ((WorkflowManager)object22).getWorkflow().getJobManager().writeAlert((AlertCriteria)object);
        }
        if (asyncWorkflowResponse != null && !bl2) {
            object = new StartWorkflowResponse();
            object.setJobId(l);
            object.setProcessId(l);
            asyncWorkflowResponse.setResponse((CTEProcessingModel)object);
        }
        return l;
    }

    public boolean isWorkflowExecuteAllowed() {
        return this.getRunningBackupCount() < this.getMaxBackupCount();
    }

    public int getRunningBackupCount() {
        int n = DateUtilities.getNow();
        if (this.lastCheckTime == 0 || DateUtilities.getNow() - this.lastCheckTime > 60) {
            this.lastCheckTime = n;
            this.currentBackupJobs = this.getRunningBackupCount2();
        }
        return this.currentBackupJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRunningBackupCount2() {
        String string = "SELECT COUNT(*) FROM RunningBackups WHERE state IN(1,3)";
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            logger.info("no results retrieved from RunningBackups view");
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxBackupCount() {
        String string = "Select value from GXGlobalParam Where name = 'JMMaxBkpOpCountForMaintenance'";
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = Integer.parseInt(resultSet.getString(1));
                return n;
            }
            int n = 100;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateVersion(long l, int n, int n2, UserEntity userEntity) throws EvFailureException {
        WF_Process_t wF_Process_t;
        WorkflowManager workflowManager;
        boolean bl;
        block14: {
            boolean bl2 = false;
            bl = false;
            logger.info(l, "request recieved to modify job id [%s] to latest version from user [%s]", l, userEntity.getUserName());
            workflowManager = this.workflows.get(l);
            if (workflowManager != null) {
                if (workflowManager.getWorkflow().getDeploymentId() == null) {
                    logger.warn(l, "cannot update version of on-demand job [%s]", l);
                    throw new EvFailureException(new EvMessageContainer("cannot update on-demand job"));
                }
                if (workflowManager.getWorkflow().getStatus().isJobComplete()) {
                    logger.warn(l, "cannot update version of job [%s] since it has a status of [%s]", l, workflowManager.getWorkflow().getStatus().toString());
                    return;
                }
                bl = true;
                if (workflowManager.queue == EngineQueue.EXECUTING) {
                    workflowManager.getWorkflow().setRunning(false);
                    bl2 = true;
                } else {
                    this.workflows.remove(l);
                }
            }
            while (bl2) {
                logger.debug(l, "version modification request is waiting for workflow [%s] to become idle", workflowManager.getWorkflow().getName());
                logger.info(l, "waiting for job id [%s] to shutdown", l);
                WorkflowEngine workflowEngine = this;
                synchronized (workflowEngine) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                bl2 = this.workflows.get(l) != null;
            }
            try {
                wF_Process_t = this.getJobRecord(l, n);
                ProcessStatus processStatus = ProcessStatus.fromInt((int)wF_Process_t.Status.get());
                if (!processStatus.isJobComplete()) break block14;
                logger.warn(l, "cannot update version of job [%s] since it has a status of [%s]", l, processStatus.toString());
                if (!bl) return;
            }
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                logger.debug(l, "resuming workflow [%s], job id [%s]", workflowManager.getName(), l);
                workflowManager = this.retrieveWorkflow(l, n);
                this.workflows.put(l, workflowManager);
                workflowManager.resumePendingActivities();
                workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
                workflowManager.queue = EngineQueue.EXECUTING;
                workflowManager.start();
                throw throwable;
            }
            logger.debug(l, "resuming workflow [%s], job id [%s]", workflowManager.getName(), l);
            workflowManager = this.retrieveWorkflow(l, n);
            this.workflows.put(l, workflowManager);
            workflowManager.resumePendingActivities();
            workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
            workflowManager.queue = EngineQueue.EXECUTING;
            workflowManager.start();
            return;
        }
        WF_Deployments_t wF_Deployments_t = this.getDeploymentRecord(wF_Process_t);
        WF_Deployments_t wF_Deployments_t2 = CommServUtils.getWorkflowDeployment(wF_Deployments_t.WorkflowId.get(), 0);
        logger.info(wF_Process_t.jobId.get(), "updating job id [%s] for workflow [%s] to version [%s], requested by user [%s]", wF_Process_t.jobId.get(), wF_Deployments_t.WorkflowName.get(), wF_Deployments_t2.Version.get(), userEntity.getUserName());
        CommServUtils.updateJobVersion(wF_Process_t, wF_Deployments_t, wF_Deployments_t2);
        if (!bl) return;
        logger.debug(l, "resuming workflow [%s], job id [%s]", workflowManager.getName(), l);
        workflowManager = this.retrieveWorkflow(l, n);
        this.workflows.put(l, workflowManager);
        workflowManager.resumePendingActivities();
        workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
        workflowManager.queue = EngineQueue.EXECUTING;
        workflowManager.start();
    }

    @Override
    public synchronized void shutdown() {
        if (this.isRunning()) {
            logger.debug("shutdown() called for workflow engine");
            this.running = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isAlive() {
        if (this.engineThread == null) {
            return false;
        }
        return this.engineThread.isAlive();
    }

    private List<WF_Process_t> getUncompletedJobs() throws EvFailureException {
        List<WF_Process_t> list;
        String string = String.format("State <> %s", ExecutionState.COMPLETED.toInt());
        try {
            list = WF_Process_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error retrieving uncompleted workflow jobs", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return list;
    }

    @Override
    public void updateWorkflowVariables(SetWorkflowVariablesReq setWorkflowVariablesReq) throws EvFailureException {
        WF_Process_t wF_Process_t = this.getJobRecord(setWorkflowVariablesReq.getJobId(), setWorkflowVariablesReq.getCommCellId());
        WF_Deployments_t wF_Deployments_t = this.getDeploymentRecord(wF_Process_t);
        UserEntity userEntity = setWorkflowVariablesReq.getProcessingInstructionInfo().getUser();
        if (!CommServUtils.canManageWorkflow(wF_Deployments_t.WorkflowId.get(), wF_Deployments_t.WorkflowName.get(), userEntity)) {
            logger.error("cannot update job [" + wF_Process_t.jobId.get() + "] as user [" + userEntity.getUserName() + "] does not have required job management capability for workflow [" + wF_Deployments_t.WorkflowName.get() + "]");
            throw new EvFailureException(new EvMessageContainer("failed to update job"));
        }
        if (wF_Process_t.Status.get().intValue() != ProcessStatus.SUSPENDED.toInt()) {
            logger.error(setWorkflowVariablesReq.getJobId(), "cannot update variables on workflow job [" + setWorkflowVariablesReq.getJobId() + "] since its not suspended");
            throw new EvFailureException(new EvMessageContainer("job not suspended"));
        }
        WorkflowElement workflowElement = WorkflowElement.parse(wF_Process_t.Execution.get());
        workflowElement.createDocument();
        HashMap<Integer, ChildRecord> hashMap = new HashMap<Integer, ChildRecord>();
        for (Object object : setWorkflowVariablesReq.getVariables()) {
            if (object.getProcessId() == 0) {
                try {
                    logger.info(wF_Process_t.jobId.get(), "setting workflow variable path [" + object.getXpath() + "] with value [" + object.getValue() + "]");
                    workflowElement.setText(object.getXpath(), object.getValue());
                    continue;
                }
                catch (Exception exception) {
                    logger.error(setWorkflowVariablesReq.getJobId(), "failed to set xpath [" + object.getXpath() + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            }
            ChildRecord childRecord = (ChildRecord)hashMap.get(object.getProcessId());
            if (childRecord == null) {
                try {
                    childRecord = this.getSuperProcess(object.getProcessId());
                }
                catch (Exception exception) {
                    logger.error(setWorkflowVariablesReq.getJobId(), "failed to retrieve embedded process [" + object.getProcessId() + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
                if (childRecord == null) {
                    logger.error(setWorkflowVariablesReq.getJobId(), "did not find embedded process [" + object.getProcessId() + "]");
                    throw new EvFailureException(new EvMessageContainer("unknown embedded process [" + object.getProcessId() + "]"));
                }
                hashMap.put(object.getProcessId(), childRecord);
            }
            try {
                logger.info(wF_Process_t.jobId.get(), "setting emedded workflow variable path [" + object.getXpath() + "] with value [" + object.getValue() + "], super process id [" + object.getProcessId() + "]");
                childRecord.exec.setText(object.getXpath(), object.getValue());
            }
            catch (Exception exception) {
                logger.error(setWorkflowVariablesReq.getJobId(), "failed to set xpath [" + object.getXpath() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        try {
            wF_Process_t.Execution.set(workflowElement.serialize());
            wF_Process_t.save();
        }
        catch (Exception exception) {
            logger.error(wF_Process_t.jobId.get(), "failed to update variables in workflow job [" + wF_Process_t.jobId.get() + "]", exception);
        }
        for (Object object : hashMap.values()) {
            try {
                object.row.Execution.set(object.exec.serialize());
                object.row.save();
            }
            catch (Exception exception) {
                logger.error(wF_Process_t.jobId.get(), "failed to update variables in emedded workflow job [" + wF_Process_t.jobId.get() + "], process id [" + object.row.SuperProcessId.get() + "]", exception);
            }
        }
    }

    public ChildRecord getSuperProcess(int n) throws Exception {
        WF_SuperProcess_t wF_SuperProcess_t = new WF_SuperProcess_t();
        String string = String.format("SuperProcessId = %s", n);
        if (wF_SuperProcess_t.fill(string)) {
            ChildRecord childRecord = new ChildRecord();
            childRecord.row = wF_SuperProcess_t;
            childRecord.exec = WorkflowElement.parse(wF_SuperProcess_t.Execution.get());
            childRecord.exec.createDocument();
            return childRecord;
        }
        return null;
    }

    @Override
    public void updateWorkflowExecution(WorkflowExecution workflowExecution) throws EvFailureException {
        WorkflowManager workflowManager = this.getWorkflowManager(workflowExecution.getJobId(), workflowExecution.getCommCellId());
        if (workflowManager.getWorkflow().getStatus().isJobComplete()) {
            logger.error(workflowManager.getJobId(), "cannot update workflow [" + workflowManager.getWorkflow().getWorkflowName() + "] since it has already completed");
            throw new EvFailureException(new EvMessageContainer("job already completed"));
        }
        logger.info(workflowManager.getJobId(), "updating inputs for workflow [%s], xml [%s]", workflowManager.getWorkflow().getWorkflowName(), workflowExecution.getInputs());
        workflowManager.getWorkflow().getWorkflowExecution().mergeInputs(WorkflowElement.parse(workflowExecution.getInputs()));
        logger.info(workflowManager.getJobId(), "updating variables for workflow [%s], xml [%s]", workflowManager.getWorkflow().getWorkflowName(), workflowExecution.getVariables());
        workflowManager.getWorkflow().getWorkflowExecution().mergeVariables(WorkflowElement.parse(workflowExecution.getVariables()));
        workflowManager.save();
        if (workflowManager.getWorkflow().getStatus() == ProcessStatus.SUSPENDED) {
            for (WorkflowExecution workflowExecution2 : workflowExecution.getChildren()) {
                WF_SuperProcess_t wF_SuperProcess_t = new WF_SuperProcess_t();
                try {
                    if (!wF_SuperProcess_t.fill("ProcessStepId = " + workflowExecution2.getJobId())) {
                        logger.warn(workflowManager.getJobId(), "failed to find child workflow name [%s], super process id [%s]", workflowExecution2.getEntity().getWorkflowName(), workflowExecution2.getJobId());
                        continue;
                    }
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(workflowManager.getJobId(), "failed to retrieve super process record for process step id [" + workflowExecution2.getJobId() + "]", cTEDBException);
                    throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
                }
                WorkflowElement workflowElement = WorkflowElement.parse(wF_SuperProcess_t.Execution.get());
                logger.info(workflowManager.getJobId(), "updating inputs for embedded workflow [%s], xml [%s]", workflowExecution2.getEntity().getWorkflowName(), workflowExecution2.getInputs());
                workflowElement.removeContent("inputs");
                workflowElement.addContent(WorkflowElement.parse(workflowExecution2.getInputs()).clone());
                logger.info(workflowManager.getJobId(), "updating variables for embedded workflow [%s], xml [%s]", workflowExecution2.getEntity().getWorkflowName(), workflowExecution2.getVariables());
                workflowElement.removeContent("variables");
                workflowElement.addContent(WorkflowElement.parse(workflowExecution2.getVariables()).clone());
                wF_SuperProcess_t.Execution.set(workflowElement.toString());
                try {
                    wF_SuperProcess_t.save();
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(workflowManager.getJobId(), "failed to save super process record for process step id [" + workflowExecution2.getJobId() + "]", cTEDBException);
                    throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
                }
            }
        } else {
            for (WorkflowExecution workflowExecution3 : workflowExecution.getChildren()) {
                ProcessContext processContext = workflowManager.getWorkflow().getChildProcess(Long.valueOf(workflowExecution3.getJobId()).intValue());
                if (processContext != null) {
                    logger.info(workflowManager.getJobId(), "updating inputs for embedded workflow [%s], xml [%s]", processContext.getName(), workflowExecution3.getInputs());
                    processContext.getWorkflowExecution().mergeInputs(WorkflowElement.parse(workflowExecution3.getInputs()));
                    logger.info(workflowManager.getJobId(), "updating variables for embedded workflow [%s], xml [%s]", processContext.getName(), workflowExecution3.getVariables());
                    processContext.getWorkflowExecution().mergeVariables(WorkflowElement.parse(workflowExecution3.getVariables()));
                    processContext.save();
                    continue;
                }
                logger.warn(workflowManager.getJobId(), "failed to find child workflow name [%s], super process id [%s]", workflowExecution3.getEntity().getWorkflowName(), workflowExecution3.getJobId());
            }
        }
    }

    public WF_Process_t getJobRecordQuiet(long l, int n) throws EvFailureException {
        String string = String.format("jobId = %s AND commCellId = %s", l, n);
        WF_Process_t wF_Process_t = new WF_Process_t();
        try {
            if (!wF_Process_t.fill(string)) {
                return null;
            }
            return wF_Process_t;
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error looking up job id [" + l + "]", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer("Failed to load job [%s]", String.valueOf(l));
            throw new EvFailureException(evMessageContainer);
        }
    }

    @Override
    public WF_Process_t getJobRecord(long l, int n) throws EvFailureException {
        WF_Process_t wF_Process_t = this.getJobRecordQuiet(l, n);
        if (wF_Process_t == null) {
            logger.error("could not find workflow job for jobId [" + l + "], commCellId [" + n + "]");
            EvMessageContainer evMessageContainer = new EvMessageContainer("Failed to load job [%s]", String.valueOf(l));
            throw new EvFailureException(evMessageContainer);
        }
        return wF_Process_t;
    }

    private WF_Deployments_t getDeploymentRecord(WF_Process_t wF_Process_t) throws EvFailureException {
        WF_Deployments_t wF_Deployments_t = new WF_Deployments_t();
        String string = String.format("DeploymentId = %s", wF_Process_t.DeploymentId.get());
        try {
            if (!wF_Deployments_t.fill(string)) {
                logger.error("could not find deployment information for job [" + wF_Process_t.jobId.get() + "] using where clause [" + string + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_DEPLOYMENT", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error looking up deployment for job [" + wF_Process_t.jobId.get() + "], deployment id [" + wF_Process_t.DeploymentId.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return wF_Deployments_t;
    }

    @Override
    public WorkflowManager getWorkflowManager(long l, int n) throws EvFailureException {
        WorkflowManager workflowManager = this.workflows.get(l);
        if (workflowManager == null) {
            workflowManager = this.retrieveWorkflow(l, n);
        }
        return workflowManager;
    }

    private WorkflowManager retrieveWorkflow(long l, int n) throws EvFailureException {
        return this.retrieveWorkflow(this.getJobRecord(l, n));
    }

    private WorkflowManager retrieveWorkflow(WF_Process_t wF_Process_t) throws EvFailureException {
        UserModel userModel;
        if (wF_Process_t.DeploymentId.isNull()) {
            logger.error(wF_Process_t.jobId.get(), "illegal call to retrieve deployment information of an on-demand job");
            throw new EvFailureException(new EvMessageContainer("cannot retrieve on-demand job"));
        }
        WF_Deployments_t wF_Deployments_t = this.getDeploymentRecord(wF_Process_t);
        try {
            logger.trace("loading executor user id [%s]", wF_Process_t.userId.get());
            userModel = UserModel.load(wF_Process_t.userId.get());
        }
        catch (EvFailureException evFailureException) {
            logger.error(wF_Process_t.jobId.get(), "failed to load executor user from id [" + wF_Process_t.userId.get() + "]");
            throw new EvFailureException(evFailureException.getMessageContainer());
        }
        WorkflowDatabase workflowDatabase = new WorkflowDatabase();
        WorkflowProcess workflowProcess = new WorkflowProcess(workflowDatabase, wF_Deployments_t, wF_Process_t, userModel, 0);
        return new WorkflowManager(workflowProcess);
    }

    private WorkflowManager retrieveWorkflow(WF_Process_t wF_Process_t, UserModel userModel) throws EvFailureException {
        if (wF_Process_t.DeploymentId.isNull()) {
            logger.error(wF_Process_t.jobId.get(), "illegal call to retrieve deployment information of an on-demand job");
            throw new EvFailureException(new EvMessageContainer("cannot retrieve on-demand job"));
        }
        WF_Deployments_t wF_Deployments_t = this.getDeploymentRecord(wF_Process_t);
        WorkflowDatabase workflowDatabase = new WorkflowDatabase();
        WorkflowProcess workflowProcess = new WorkflowProcess(workflowDatabase, wF_Deployments_t, wF_Process_t, userModel, 0);
        return new WorkflowManager(workflowProcess);
    }

    public static class ChildRecord {
        WF_SuperProcess_t row;
        WorkflowElement exec;
    }

    private class WorkflowEngineMainThread
    implements Runnable {
        private WorkflowEngineMainThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        WorkflowEngine workflowEngine = WorkflowEngine.this;
                        synchronized (workflowEngine) {
                            WorkflowEngine.this.wait(10000L);
                            if (WorkflowEngine.this.workflows.size() > 0) {
                                WorkflowEngine.this.processQueues();
                            }
                            if (!WorkflowEngine.this.isRunning()) {
                                if (WorkflowEngine.this.getExecutingCount() == 0) {
                                    break block4;
                                }
                                logger.details("waiting to shutdown, [" + WorkflowEngine.this.getExecutingCount() + "] workflows still running");
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception during execution of engine thread", throwable);
                    continue;
                }
                break;
            }
            ThreadManager.getInstance().shutdown();
            EngineProperties.getInstance().setLastShutdown(DateUtilities.getNow());
        }
    }

    private class WorkflowLoader
    implements Runnable {
        private WF_Process_t processRow;

        private WorkflowLoader(WF_Process_t wF_Process_t) {
            this.processRow = wF_Process_t;
        }

        private void load() throws Exception {
            WorkflowManager workflowManager;
            UserModel userModel;
            if (this.processRow.DeploymentId.isNull()) {
                logger.info(this.processRow.jobId.get(), "cannot restart on-demand job [%s]", this.processRow.jobId.get());
                EvFailureReason evFailureReason = null;
                JobManager.completeJob(this.processRow, ProcessStatus.KILLED, evFailureReason);
                return;
            }
            try {
                userModel = UserModel.loadQuite(this.processRow.userId.get());
            }
            catch (EvFailureException evFailureException) {
                return;
            }
            if (userModel == null) {
                logger.info(this.processRow.jobId.get(), "cannot restart workflow job as exector user id [%s] does not exist, failing workflow", this.processRow.userId.get());
                EvFailureReason evFailureReason = null;
                JobManager.completeJob(this.processRow, ProcessStatus.FAILED, evFailureReason);
                return;
            }
            if (ProcessStatus.fromInt((int)this.processRow.Status.get()) == ProcessStatus.SUSPENDED) {
                boolean bl;
                JMJobInfo_t jMJobInfo_t = new JMJobInfo_t();
                String string = String.format("jobId = %s AND commCellId = %s", this.processRow.jobId.get(), this.processRow.commCellId.get());
                if (!jMJobInfo_t.fill(string)) {
                    bl = true;
                } else {
                    boolean bl2 = bl = jMJobInfo_t.state.get().intValue() != ProcessStatus.SUSPENDED.toInt();
                }
                if (bl) {
                    WorkflowManager workflowManager2;
                    logger.debug(this.processRow.jobId.get(), "workflow job [%s] is suspended but CommServ is missing JM records", this.processRow.jobId.get());
                    try {
                        workflowManager2 = WorkflowEngine.this.retrieveWorkflow(this.processRow, userModel);
                    }
                    catch (EvFailureException evFailureException) {
                        logger.error(this.processRow.jobId.get(), "failed to retrieve suspended workflow job [" + this.processRow.jobId.get() + "]");
                        return;
                    }
                    workflowManager2.getWorkflow().setStatus(ProcessStatus.SUSPENDED);
                    workflowManager2.save();
                } else {
                    logger.debug(this.processRow.jobId.get(), "workflow job [%s] is suspended, skipping resume", this.processRow.jobId.get());
                }
                return;
            }
            try {
                workflowManager = WorkflowEngine.this.retrieveWorkflow(this.processRow, userModel);
            }
            catch (EvFailureException evFailureException) {
                return;
            }
            if (WorkflowEngine.this.workflows.containsKey(workflowManager.getJobId())) {
                return;
            }
            logger.info(this.processRow.jobId.get(), "initiating workflow job [%s]", this.processRow.jobId.get());
            WorkflowEngine.this.workflows.put(workflowManager.getJobId(), workflowManager);
            if (workflowManager.getWorkflow().getStatus() == ProcessStatus.QUEUED || workflowManager.getWorkflow().getStatus() == ProcessStatus.WAITING || workflowManager.getWorkflow().getStatus() == ProcessStatus.RUNNING || workflowManager.getWorkflow().getStatus() == ProcessStatus.PENDING) {
                if (WorkflowEngine.this.maxStartupFailuresReached) {
                    logger.warn(workflowManager.getJobId(), "suspending job [%s] due to max shutdown failures reached [%s]", workflowManager.getJobId(), WorkflowRegistry.getInstance().getMaxFailedShutdowns());
                    workflowManager.getWorkflow().setFailureReason(new EvMessageContainer("Workflow engine on client [%s] has failed to properly shutdown", WorkflowProperties.getInstance().getClient().getClientName()));
                    workflowManager.getWorkflow().setStatus(ProcessStatus.SUSPEND_PENDING);
                } else {
                    logger.info(workflowManager.getJobId(), "queuing workflow [%s]", workflowManager.getName());
                    if (workflowManager.getWorkflow().getStatus() == ProcessStatus.QUEUED && workflowManager.getWorkflow().getSubTaskId() > 0) {
                        workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
                        workflowManager.queue = EngineQueue.QUEUED;
                        workflowManager.save();
                    } else {
                        workflowManager.getWorkflow().setStatus(ProcessStatus.QUEUED);
                        workflowManager.queue = EngineQueue.EXECUTING;
                        workflowManager.start();
                    }
                    return;
                }
            }
            if (workflowManager.getWorkflow().getStatus() == ProcessStatus.SUSPEND_PENDING) {
                logger.info(workflowManager.getJobId(), "resuming workflow [%s]", workflowManager.getName());
                workflowManager.queue = EngineQueue.EXECUTING;
                workflowManager.start();
                return;
            }
            if (workflowManager.getWorkflow().getStatus() == ProcessStatus.KILL_PENDING || workflowManager.getWorkflow().getStatus() == ProcessStatus.INTERRUPT_PENDING) {
                if (WorkflowEngine.this.maxStartupFailuresReached) {
                    logger.warn(workflowManager.getJobId(), "forcing job, with status [%s], complete due to maximum shutdown failures reached", workflowManager.getWorkflow().getStatus().toString());
                    if (workflowManager.getWorkflow().getStatus() == ProcessStatus.KILL_PENDING) {
                        workflowManager.getWorkflow().setStatus(ProcessStatus.KILLED);
                    } else {
                        workflowManager.getWorkflow().setStatus(ProcessStatus.FAILED);
                    }
                    workflowManager.save();
                } else {
                    logger.info(workflowManager.getJobId(), "resuming workflow [%s]", workflowManager.getName());
                    workflowManager.queue = EngineQueue.EXECUTING;
                    workflowManager.start();
                    return;
                }
            }
            if (workflowManager.getWorkflow().getStatus().isJobComplete()) {
                logger.info(workflowManager.getJobId(), "workflow [%s] was already completed with status [%s]", workflowManager.getName(), workflowManager.getWorkflow().getStatus());
            } else {
                logger.error(workflowManager.getJobId(), "can not auto start job id [" + workflowManager.getJobId() + "] with status [" + workflowManager.getWorkflow().getStatus() + "], failing job");
                workflowManager.getWorkflow().setStatus(ProcessStatus.FAILED);
            }
            workflowManager.getWorkflow().setExecutionState(ExecutionState.CLEANUP);
            workflowManager.save();
            workflowManager.queue = EngineQueue.CLEANUP;
        }

        @Override
        public void run() {
            try {
                this.load();
            }
            catch (Throwable throwable) {
                logger.error("uncaught exception during loading of job [" + this.processRow.jobId.get() + "]", throwable);
            }
        }
    }

    private class WorkflowJobCheck
    implements Runnable {
        private WorkflowJobCheck() {
        }

        @Override
        public void run() {
            try {
                this.checkJobs();
            }
            catch (Throwable throwable) {
                logger.error("failed to check for running jobs that aren't in the engine", throwable);
            }
        }

        private void checkJobs() throws Exception {
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object2 : WorkflowEngine.this.workflows.values()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(((ProcessManager)object2).getJobId());
            }
            String string = stringBuffer.length() > 0 ? "State = 1 and Status = 1 AND jobId not in (" + stringBuffer.toString() + ")" : "State = 1 and Status = 1";
            object2 = WF_Process_t.select(string);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                WF_Process_t wF_Process_t = (WF_Process_t)((Object)iterator.next());
                WorkflowLoader workflowLoader = new WorkflowLoader(wF_Process_t);
                workflowLoader.run();
            }
        }
    }
}

