/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.AlertCriteria;
import commvault.msgs.Workflow.AlertStatus;
import commvault.msgs.Workflow.AlertType;
import commvault.msgs.Workflow.MessageContainer;

public class WorkflowAlert
extends AlertCriteria {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowAlert.class);

    public WorkflowAlert(AlertType alertType, ActivityContext activityContext) {
        this.init(alertType, activityContext, 0, AlertStatus.NO_STATUS);
        this.getContainer().setPhaseName(activityContext.getStepName());
        this.setPhaseFailureCount(activityContext.getRestarts() + 1);
    }

    public WorkflowAlert(AlertType alertType, ProcessContext processContext) {
        this(alertType, processContext, 0, AlertStatus.NO_STATUS);
    }

    public WorkflowAlert(AlertType alertType, ProcessContext processContext, int n, AlertStatus alertStatus) {
        this.init(alertType, processContext, n, alertStatus);
    }

    private void init(AlertType alertType, WorkflowContext workflowContext, int n, AlertStatus alertStatus) {
        this.setAlertType(alertType);
        this.setStatus(alertStatus);
        this.setJobId(workflowContext.getJobId());
        this.setTaskId(workflowContext.getTaskId());
        this.setSubTaskId(workflowContext.getSubTaskId());
        this.setWorkflowName(workflowContext.getWorkflowName());
        this.setStartTime((int)(workflowContext.getStartTime().getTime() / 1000L));
        if (workflowContext.getScheduleView() != null) {
            this.setScheduledTime((int)(workflowContext.getScheduleView().getNextScheduledTime().getTime() / 1000L));
        }
        if (workflowContext.getEndTime() != null) {
            this.setEndTime((int)(workflowContext.getEndTime().getTime() / 1000L));
        }
        this.setUserId(n);
        this.setClient(WorkflowProperties.getInstance().getClient());
        this.getContainer().getWorkflow().getEntity().setWorkflowId(workflowContext.getWorkflowId());
        for (EvFailureReason evFailureReason : workflowContext.getFailures()) {
            MessageContainer messageContainer = new MessageContainer();
            messageContainer.setMessageId(evFailureReason.getMessageContainer().getMessageId());
            messageContainer.setArgumentGroup(evFailureReason.getMessageContainer().getArgumentInfo());
            this.getFailures().add(messageContainer);
        }
        this.setJobErrString(workflowContext.getFailureReason());
        this.getContainer().setPhaseName("");
        this.setPhaseFailureCount(0);
    }
}

