/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.UserEntity;

public class UserModel
extends UserEntity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UserModel.class);
    private UMUsers_t user;

    public static UserModel loadQuite(int n) throws EvFailureException {
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string = String.format("id = %s", n);
        try {
            if (!uMUsers_t.fill(string)) {
                return null;
            }
        }
        catch (CTEDBException cTEDBException) {
            String string2 = String.format("failed to retrieve user information for id [%s]", n);
            logger.error(string2, cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return new UserModel(uMUsers_t);
    }

    public static UserModel load(int n) throws EvFailureException {
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string = String.format("id = %s", n);
        try {
            if (!uMUsers_t.fill(string)) {
                logger.error("could not find user information for id [" + n + "]");
                throw new EvFailureException(EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_USER", new Object[0]));
            }
        }
        catch (CTEDBException cTEDBException) {
            String string2 = String.format("failed to retrieve user information for id [%s]", n);
            logger.error(string2, cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return new UserModel(uMUsers_t);
    }

    public static UserModel load(String string) throws EvFailureException {
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string2 = String.format("login = '%s'", string);
        try {
            if (!uMUsers_t.fill(string2)) {
                logger.error("could not find user information for [" + string + "]");
                throw new EvFailureException(EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_USER", new Object[0]));
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve user information for [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return new UserModel(uMUsers_t);
    }

    public UserModel(UserEntity userEntity) {
        super(userEntity);
        this.user = new UMUsers_t();
        this.user.login.set(userEntity.getUserName());
        this.user.userGuid.set(userEntity.getUserGUID());
        this.user.id.set(Integer.valueOf(userEntity.getUserId()));
    }

    public UserModel(UMUsers_t uMUsers_t) {
        this.user = uMUsers_t;
        this.setUserName(uMUsers_t.login.get());
        this.setUserGUID(uMUsers_t.userGuid.get());
        this.setUserId(uMUsers_t.id.get());
    }

    public String getPassword() {
        return this.user.password.get();
    }

    public String getFullName() {
        return this.user.name.get();
    }

    public String getEmail() {
        return this.user.email.get();
    }
}

