/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.db.cs.WF_Interaction_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.GenericResp;
import commvault.msgs.Workflow.SetWebFormInteractionRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UserInteractionTask {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UserInteractionTask.class);
    private static final UserInteractionTask instance = new UserInteractionTask();
    private Map<Integer, InteractionTask> tasks = Collections.synchronizedMap(new HashMap());

    public static UserInteractionTask getInstance() {
        return instance;
    }

    private UserInteractionTask() {
    }

    public void addTask(InteractionTask interactionTask) {
        this.tasks.put(interactionTask.getInteractionId(), interactionTask);
    }

    public void removeTask(InteractionTask interactionTask) {
        this.tasks.remove(interactionTask.getInteractionId());
    }

    public GenericResp completeTask(SetWebFormInteractionRequest setWebFormInteractionRequest) throws EvFailureException {
        Object object;
        if (setWebFormInteractionRequest.getInteractionId() == 0 && setWebFormInteractionRequest.getInteractionGuid().length() > 0 && (object = this.getInteractionRow(setWebFormInteractionRequest.getInteractionGuid())) != null) {
            setWebFormInteractionRequest.setInteractionId(((WF_Interaction_t)((Object)object)).InteractionId.get().intValue());
        }
        if (setWebFormInteractionRequest.getInteractionId() == 0) {
            logger.error("invalid interaction request");
            throw new EvFailureException(new EvMessageContainer("invalid interaction request"));
        }
        object = this.tasks.get(setWebFormInteractionRequest.getInteractionId());
        if (object == null) {
            logger.error("workflow interaction id [" + setWebFormInteractionRequest.getInteractionId() + "] not found or already completed");
            throw new EvFailureException(new EvMessageContainer("action not found or already completed"));
        }
        GenericResp genericResp = object.performTask(setWebFormInteractionRequest);
        return genericResp;
    }

    private WF_Interaction_t getInteractionRow(String string) throws EvFailureException {
        String string2 = String.format("interactionGuid = '%s'", string.replace("'", "''"));
        WF_Interaction_t wF_Interaction_t = new WF_Interaction_t();
        try {
            if (wF_Interaction_t.fill(string2)) {
                return wF_Interaction_t;
            }
            return null;
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_Interaction record for interaction id [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    public static interface InteractionTask {
        public GenericResp performTask(SetWebFormInteractionRequest var1) throws EvFailureException;

        public int getInteractionId();
    }
}

