/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.logger.CTELogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadManager
implements Repeatable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ThreadManager.class);
    private static final ThreadManager instance = new ThreadManager();
    private ExecutorService service = Executors.newCachedThreadPool(new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("SharedThread-" + String.valueOf(this.count.incrementAndGet()));
            return thread;
        }
    });

    public static ThreadManager getInstance() {
        return instance;
    }

    public void execute(Runnable runnable) {
        this.service.execute(runnable);
    }

    public Future submitTask(Callable callable) {
        return this.service.submit(callable);
    }

    public void shutdown() {
        this.service.shutdown();
    }

    public synchronized void add(WorkflowThread workflowThread) {
    }

    public synchronized void remove(Long l) {
    }

    public synchronized int size() {
        return 0;
    }

    @Override
    public void run() {
        this.checkMemoryUsuage();
        this.findDeadLocks();
    }

    private void checkMemoryUsuage() {
        long l = Runtime.getRuntime().maxMemory() / 0x100000L;
        long l2 = Runtime.getRuntime().totalMemory() / 0x100000L;
        long l3 = Runtime.getRuntime().freeMemory() / 0x100000L;
        long l4 = l2 - l3;
        long l5 = l3 + (l - l2);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        logger.trace("MEMORY USAGE: max [%s], allocated [%s], free [%s], consumed [%s], available [%s], threads [%s]", l, l2, l3, l4, l5, threadMXBean.getThreadCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDeadLocks() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.findDeadlockedThreads();
        if (lArray != null) {
            ThreadManager threadManager = this;
            synchronized (threadManager) {
                ThreadInfo[] threadInfoArray;
                for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.getThreadInfo(lArray)) {
                    String string = "!!!! DEADLOCK DETECTED !!!! " + threadInfo.toString().trim();
                    logger.error(string);
                }
            }
        }
    }

    @Override
    public int getInterval() {
        return 300;
    }
}

