/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.CommCellContext;
import commvault.cte.workflow.CommCellProperties;
import commvault.cte.workflow.EvSecurity;
import commvault.cte.workflow.ImpersonateUtil;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.SecurityToken;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.msgs.CvEntities.CommCellEntity;
import commvault.msgs.CvEntities.UserEntity;
import commvault.qnet.sys.CVPassword;
import java.util.HashSet;
import javax.security.auth.Subject;

public class SessionImpersonation
implements SecurityContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SessionImpersonation.class);
    private SecurityToken securityToken;
    private SecurityContext parent;
    private String token;
    private CommCellContext properties;

    public static SessionImpersonation impersonate(SecurityContext securityContext, String string) throws Exception {
        if (securityContext.getUser().getUserName() == null) {
            throw new Exception("user not logged in");
        }
        return SessionImpersonation.impersonate(securityContext, CommCellProperties.load(string));
    }

    public static SessionImpersonation impersonate(SecurityContext securityContext, int n) throws Exception {
        if (securityContext.getUser().getUserName() == null) {
            throw new Exception("user not logged in");
        }
        return SessionImpersonation.impersonate(securityContext, CommCellProperties.load(n));
    }

    private static SessionImpersonation impersonate(SecurityContext securityContext, CommCellContext commCellContext) throws Exception {
        UMUsers_t uMUsers_t = new UMUsers_t(securityContext.getCommCellConnection());
        UMUsers_t uMUsers_t2 = new UMUsers_t(commCellContext.getCommCellConnection());
        if (!uMUsers_t.fill(String.format("login = '%s'", securityContext.getUser().getUserName()))) {
            throw new Exception("failed to find user with login [" + securityContext.getUser().getUserName() + "] on commCell [" + securityContext.getCommCell().getCommCellName() + "]");
        }
        if (!uMUsers_t2.fill(String.format("login = '%s'", securityContext.getUser().getUserName()))) {
            throw new Exception("failed to find user with login [" + securityContext.getUser().getUserName() + "] on commCell [" + commCellContext.getCommCell().getCommCellName() + "]");
        }
        if (securityContext.getUser().getUserName().indexOf("\\") > -1) {
            return SessionImpersonation.impersonate(securityContext, commCellContext, new UserModel(uMUsers_t2));
        }
        CVPassword cVPassword = new CVPassword();
        if (cVPassword.decrypt(uMUsers_t.password.get()).equals(cVPassword.decrypt(uMUsers_t2.password.get()))) {
            return SessionImpersonation.impersonate(securityContext, commCellContext, new UserModel(uMUsers_t2));
        }
        throw new Exception("failed to authenticate user [" + securityContext.getUser().getUserName() + "] on commCell [" + commCellContext.getCommCell().getCommCellName() + "]");
    }

    private static SessionImpersonation impersonate(SecurityContext securityContext, CommCellContext commCellContext, UserModel userModel) throws Exception {
        logger.debug(securityContext.getWorkflow().getJobId(), "logging in user [%s] on commCell [%s]", userModel.getUserName(), commCellContext.getCommCell().getCommCellName());
        String string = CommServUtils.generateQSDKToken(userModel, commCellContext.getCommCellConnection());
        logger.trace(securityContext.getWorkflow().getJobId(), "encrypting guid [%s] for user [%s]", string, userModel.getUserName());
        String string2 = ImpersonateUtil.getInstance().generateToken(commCellContext.getCommServHost(), commCellContext.getCommServClient(), userModel.getUserName(), string);
        SecurityToken securityToken = SecurityToken.newInstance(userModel, string, string2, securityContext.getWorkflow());
        return new SessionImpersonation(securityToken, securityContext, commCellContext, string2);
    }

    private SessionImpersonation(SecurityToken securityToken, SecurityContext securityContext, CommCellContext commCellContext, String string) {
        this.securityToken = securityToken;
        this.parent = securityContext;
        this.token = string;
        this.properties = commCellContext;
    }

    @Override
    public UserEntity getUser() {
        return this.parent.getUser();
    }

    @Override
    public String getCommServHost() {
        return this.properties.getCommServHost();
    }

    @Override
    public String getCommServClient() {
        return this.properties.getCommServClient();
    }

    @Override
    public CTEDBConnection getCommCellConnection() {
        return this.properties.getCommCellConnection();
    }

    @Override
    public CommCellEntity getCommCell() {
        return this.properties.getCommCell();
    }

    @Override
    public WorkflowProperties.WebServiceParameters getDefaultWebService() {
        return this.properties.getDefaultWebService();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void logout() {
        this.securityToken.logout();
    }

    @Override
    public boolean isLoggedIn() {
        return this.securityToken != null && this.securityToken.isLoggedIn();
    }

    @Override
    public ProcessContext getWorkflow() {
        return this.parent.getWorkflow();
    }

    @Override
    public CTEDBConnInfo getConnInfo() {
        return this.properties.getConnInfo();
    }

    @Override
    public String getName() {
        return this.getUser().getUserName();
    }

    @Override
    public Subject getSubject() {
        HashSet<SessionImpersonation> hashSet = new HashSet<SessionImpersonation>();
        hashSet.add(this);
        return new Subject(false, hashSet, new HashSet(), new HashSet());
    }

    @Override
    public boolean isClientAdmin() {
        if (this.properties.getCommCell().getCommCellId() == WorkflowProperties.getInstance().getCommCell().getCommCellId() && this.isLoggedIn()) {
            try {
                return EvSecurity.isNodeCapability(WorkflowProperties.getInstance().getClient().getClientId(), Capability.ADMINISTRATIVE_MANAGEMENT, this);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check capabilties for user [" + this.getUser().getUserName() + "]", cTEDBException);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isCommCellAdmin() {
        if (this.isLoggedIn()) {
            try {
                return EvSecurity.isAdministrativeCapability(2, this);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check capabilties for user [" + this.getUser().getUserName() + "]", cTEDBException);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isEngineAdmin() {
        if (this.properties.getCommCell().getCommCellId() == WorkflowProperties.getInstance().getCommCell().getCommCellId() && this.isLoggedIn()) {
            try {
                return EvSecurity.isNodeCapability(WorkflowProperties.getInstance().getClient().getClientId(), Capability.AGENT_MANAGEMENT, this);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check capabilties for user [" + this.getUser().getUserName() + "]", cTEDBException);
                return false;
            }
        }
        return false;
    }
}

