/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ImpersonateUtil;
import commvault.cte.workflow.TokenInfo;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.engine.WF_Token_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.UserEntity;
import org.apache.commons.lang.StringUtils;

public class SecurityToken {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SecurityToken.class);
    private WF_Token_t token;

    public static SecurityToken newInstance(UserEntity userEntity, String string, String string2, WorkflowContext workflowContext) throws EvFailureException {
        WF_Token_t wF_Token_t = workflowContext.getDataAccess().newToken();
        wF_Token_t.userId.set(Integer.valueOf(userEntity.getUserId()));
        wF_Token_t.userName.set(userEntity.getUserName());
        wF_Token_t.Token.set(string2);
        wF_Token_t.SessionGuid.set(string);
        wF_Token_t.jobId.set(Long.valueOf(workflowContext.getJobId()));
        wF_Token_t.commCellId.set(Integer.valueOf(workflowContext.getCommCellId()));
        try {
            wF_Token_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowContext.getJobId(), "failed to save WF_Token for user [" + userEntity.getUserName() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return new SecurityToken(wF_Token_t);
    }

    public static void logout(WF_Token_t wF_Token_t) {
        SecurityToken securityToken = new SecurityToken(wF_Token_t);
        securityToken.logout();
    }

    public SecurityToken(WF_Token_t wF_Token_t) {
        this.token = wF_Token_t;
        if (this.token.Token.get() != null && this.token.Token.get().contains(",")) {
            String[] stringArray = StringUtils.split((String)this.token.Token.get(), (char)',');
            this.token.Token.set(stringArray[0]);
            this.token.SessionGuid.set(stringArray[1]);
        }
    }

    public int getTokenId() {
        return this.token.TokenId.get();
    }

    public int getUserId() {
        return this.token.userId.get();
    }

    public String getUserName() {
        return this.token.userName.get();
    }

    public long getJobId() {
        return this.token.jobId.get();
    }

    public int getCommCellId() {
        return this.token.commCellId.get();
    }

    public String getToken() {
        return this.token.Token.get();
    }

    public String getSessionGuid() {
        return this.token.SessionGuid.get();
    }

    public boolean isLoggedIn() {
        return !this.token.Token.isNull() && this.token.Token.get().length() > 0;
    }

    public String toString() {
        return this.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        TokenInfo tokenInfo;
        if (!this.isLoggedIn()) {
            logger.debug("token for user [%s] has already been logged out", this.getUserName());
            return;
        }
        logger.debug("logging out user token [%s]", this.token.userName.get());
        if (this.getSessionGuid() != null && this.getSessionGuid().length() > 0) {
            tokenInfo = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
            try {
                String string = String.format("DELETE FROM UMQSDKSessions WHERE GUID = '%s'", this.getSessionGuid());
                try {
                    tokenInfo.execute(string);
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(this.token.jobId.get(), "failed to delete guid [" + this.getSessionGuid() + "] from UMQSDKSessions table", cTEDBException);
                }
            }
            finally {
                tokenInfo.close();
            }
        } else {
            try {
                tokenInfo = TokenInfo.decrypt(this.token.Token.get());
                ImpersonateUtil.getInstance().logoutToken(tokenInfo.getCommServHost(), tokenInfo.getCommServClient(), this.token.Token.get());
            }
            catch (Throwable throwable) {
                logger.error(this.token.jobId.get(), "failed to logout token for user [" + this.token.userName.get() + "]", throwable);
            }
        }
        this.token.Token.setNull();
        try {
            this.token.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.token.jobId.get(), "failed to remove token for user [" + this.token.userName.get() + "]", cTEDBException);
        }
    }
}

