/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.JobContext;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.StepBuilder;
import commvault.cte.workflow.WorkflowAlert;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activities.OnWorkflowCompleteActivity;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.dom.OutputElement;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.executor.AttemptExecutor;
import commvault.cte.workflow.executor.ContinueExecutor;
import commvault.cte.workflow.executor.Executor;
import commvault.cte.workflow.executor.RepeatExecutor;
import commvault.cte.workflow.executor.RestartExecutor;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.queue.ImmediateActivty;
import commvault.cte.workflow.queue.PendingActivity;
import commvault.cte.workflow.queue.RepeatingActivity;
import commvault.cte.workflow.queue.TimedActivity;
import commvault.cte.workflow.utils.DebugHelper;
import commvault.msgs.App.EventSeverity;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.AlertCriteria;
import commvault.msgs.Workflow.AlertType;
import commvault.msgs.Workflow.DebugControl;
import commvault.msgs.Workflow.DebugWorkflowRequest;
import commvault.msgs.Workflow.DebugWorkflowResp;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.TransitionDefinition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProcessManager
implements JobContext,
InteractiveAction {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ProcessManager.class);
    protected ProcessContext workflow;
    protected Set<Executor> executingSteps = new HashSet<Executor>();
    protected List<Executor> queuedSteps = new ArrayList<Executor>();
    protected Set<TimedActivity> pendingSteps = new HashSet<TimedActivity>();
    protected Set<TimedActivity> repeatingSteps = new HashSet<TimedActivity>();
    private Set<ActivityContext> debugActivities = new HashSet<ActivityContext>();
    private boolean completing = false;
    private Set<ActivityContext> onCompleteSteps = new HashSet<ActivityContext>();
    private Long interruptTime = null;
    protected boolean saveContext;
    private long updateTime;
    private boolean sessionClosed = false;

    public ProcessManager(ProcessContext processContext) {
        this.workflow = processContext;
    }

    private void initQueues() {
        List<WF_ProcessSteps_t> list;
        try {
            logger.debug(this.getJobId(), "looking for any uncompleted activities for workflow [%s], class [%s]", this.getName(), this.workflow.getClass());
            list = this.workflow.getExecutingSteps();
        }
        catch (EvFailureException evFailureException) {
            this.workflow.setFailureReason(evFailureException.getMessageContainer());
            this.workflow.setStatus(ProcessStatus.PENDING);
            return;
        }
        if (this.workflow.getExecutionState() == ExecutionState.STARTING) {
            if (list.size() == 0) {
                Object object;
                Object object2;
                try {
                    object2 = this.workflow.getStartStep();
                    object = StepBuilder.create(this.workflow, null, (WF_Steps_t)((Object)object2), null, this.workflow.getContext());
                    this.queueActivity(new AttemptExecutor((ActivityContext)object, this));
                }
                catch (EvFailureException evFailureException) {
                    this.workflow.setFailureReason(evFailureException.getMessageContainer());
                    this.workflow.setStatus(ProcessStatus.PENDING);
                    return;
                }
                try {
                    object2 = this.workflow.getEventSteps(OnWorkflowCompleteActivity.class.getName());
                    object = object2.iterator();
                    while (object.hasNext()) {
                        WF_Steps_t wF_Steps_t = (WF_Steps_t)((Object)object.next());
                        ActivityContext activityContext = StepBuilder.create(this.workflow, null, wF_Steps_t, null, this.workflow.getContext());
                        this.onCompleteSteps.add(activityContext);
                    }
                }
                catch (EvFailureException evFailureException) {
                    this.workflow.setFailureReason(evFailureException.getMessageContainer());
                    this.workflow.setStatus(ProcessStatus.PENDING);
                    return;
                }
                this.workflow.setExecutionState(ExecutionState.RUNNING);
                this.save();
                return;
            }
            logger.warn(this.getJobId(), "workflow [%s] has a state of [%s] but contains executing steps, switching state to [%s]", new Object[]{this.getName(), ExecutionState.STARTING, ExecutionState.RUNNING});
            this.workflow.setExecutionState(ExecutionState.RUNNING);
            this.save();
        }
        if (this.workflow.getExecutionState() == ExecutionState.RUNNING) {
            try {
                if (list != null && list.size() > 0) {
                    for (WF_ProcessSteps_t wF_ProcessSteps_t : list) {
                        logger.debug(this.getJobId(), "initializing uncompleted activity [%s]", wF_ProcessSteps_t.Name.get());
                        ActivityContext activityContext = StepBuilder.create(this.workflow, wF_ProcessSteps_t);
                        if (activityContext.getClassName().equals(OnWorkflowCompleteActivity.class.getName())) {
                            this.onCompleteSteps.add(activityContext);
                            continue;
                        }
                        if (activityContext.getStatus() == ProcessStatus.PENDING) {
                            this.pendingSteps.add(new ImmediateActivty(activityContext));
                            continue;
                        }
                        if (activityContext.getStatus() == ProcessStatus.SUSPENDED) {
                            this.queueActivity(new ContinueExecutor(activityContext, this));
                            continue;
                        }
                        this.queueActivity(new AttemptExecutor(activityContext, this));
                    }
                } else {
                    logger.info(this.getJobId(), "could not find any running activities for workflow [%s]", this.getName());
                }
            }
            catch (EvFailureException evFailureException) {
                this.workflow.setFailureReason(evFailureException.getMessageContainer());
                this.workflow.setStatus(ProcessStatus.PENDING);
            }
        }
    }

    public void save() {
        this.workflow.save();
    }

    public ProcessContext getWorkflow() {
        return this.workflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void worker() {
        if (!this.workflow.getStatus().isJobComplete() && this.getSize() == 0) {
            this.initQueues();
        }
        this.interruptTime = null;
        this.saveContext = true;
        while (true) {
            this.updateTime = Calendar.getInstance().getTimeInMillis();
            if (this.workflow.getStatus() == ProcessStatus.QUEUED) {
                logger.debug(this.getJobId(), "switching workflow [%s] to running state", this.getName(), this.workflow.getStatus());
                this.workflow.setStatus(ProcessStatus.RUNNING);
                this.saveContext = true;
            }
            Object object = this.workflow.getLock();
            synchronized (object) {
                if (this.checkExecution()) {
                    this.processQueues();
                }
                if (this.workflow.isSaveExecution() || this.saveContext) {
                    this.save();
                    this.workflow.setSaveExecution(false);
                    this.saveContext = false;
                }
                if (!this.workflow.isRunning() && this.executingSteps.size() == 0) {
                    logger.debug(this.workflow.getJobId(), "exiting process manager for [%s] since workflow is shutting down", this.getName());
                    break;
                }
                if (this.getSize() == 0) {
                    if (this.getWorkflow().getStatus() != ProcessStatus.SUSPEND_PENDING && this.getWorkflow().getStatus() != ProcessStatus.SUSPENDED && this.onCompleteSteps.size() > 0) {
                        for (ActivityContext activityContext : this.onCompleteSteps) {
                            logger.info(this.workflow.getJobId(), "queing onComplete activity [%s] in workflow [%s]", activityContext.getFriendlyName(), this.getName());
                            this.queuedSteps.add(new AttemptExecutor(activityContext, this));
                        }
                        this.onCompleteSteps.clear();
                        this.completing = true;
                        this.processQueues();
                    }
                    if (this.getSize() == 0) {
                        logger.debug(this.workflow.getJobId(), "exiting manager for process [%s] since all queues are empty", this.getName());
                        break;
                    }
                }
                if (this.executingSteps.size() == 0 && this.debugActivities.size() == 0 && this.workflow.getStatus() == ProcessStatus.PENDING) {
                    logger.debug(this.workflow.getJobId(), "exiting manager for process [%s] since it has a status of [%s]", this.getName(), this.workflow.getStatus().toString());
                    break;
                }
                try {
                    this.workflow.getLock().wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void queueActivity(Executor executor) {
        logger.trace(this.workflow.getJobId(), "added activity [%s] to queued pool in process [%s]", executor.getActivityContext().getFriendlyName(), this.getName());
        executor.getActivityContext().setStatus(ProcessStatus.QUEUED);
        this.queuedSteps.add(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleteExecutor(Executor executor) {
        Object object = this.workflow.getLock();
        synchronized (object) {
            if (this.executingSteps.remove(executor)) {
                this.saveContext = true;
                if (this.workflow.isDebug() && (executor.getActivityContext().isBreakPoint() && executor.getActivityContext().getStatus() != ProcessStatus.SUSPENDED && executor.getActivityContext().getStatus() != ProcessStatus.SUSPEND_PENDING || executor.getActivityContext().getStatus() == ProcessStatus.PENDING)) {
                    logger.debug(this.workflow.getJobId(), "creating debug handler");
                    executor.getActivityContext().save();
                    this.sendDebugMessage(executor.getActivityContext());
                } else {
                    try {
                        this.completeActivity(executor.getActivityContext(), false, executor.getThread());
                    }
                    catch (Throwable throwable) {
                        logger.error(executor.getActivityContext().getJobId(), "failed to complete activity [" + executor.getActivityContext().getFriendlyName() + "]", throwable);
                    }
                }
            } else {
                logger.error(this.workflow.getJobId(), "onComplete called for activity [" + executor.getActivityContext().getFriendlyName() + "] which doesn't exist in executor pool");
            }
            this.workflow.getLock().notifyAll();
        }
    }

    protected void completeActivity(ActivityContext activityContext, boolean bl, WorkflowThread workflowThread) {
        Object object;
        if (activityContext.isRepeat()) {
            if (activityContext.getStatus() == ProcessStatus.RUNNING) {
                logger.debug(activityContext.getJobId(), "activity [%s] will repeat in [%s] seconds", activityContext.getFriendlyName(), activityContext.getRepeatInterval());
                this.repeatingSteps.add(new RepeatingActivity(activityContext));
                return;
            }
            logger.debug(activityContext.getJobId(), "cannot repeat activity [%s] with a status of [%s]", activityContext.getFriendlyName(), activityContext.getStatus());
        }
        boolean bl2 = false;
        if (activityContext.getStatus() == ProcessStatus.COMPLETED || activityContext.getStatus() == ProcessStatus.SKIPPED) {
            bl2 = true;
        } else if (activityContext.getStatus() == ProcessStatus.PENDING) {
            if (activityContext.getRestarts() < activityContext.getMaxRestarts()) {
                object = activityContext.getCalculatedMaxRestarts();
                if (activityContext.getMaxRestarts() > (Integer)object && activityContext.isContinueOnFailure()) {
                    logger.warn(activityContext.getJobId(), "activity [%s] is configured to continue on failure with a max restarts of [%s] but a parent process has a max restarts of [%s] so continue will not happend", activityContext.getFriendlyName(), activityContext.getMaxRestarts(), object);
                } else {
                    logger.debug(activityContext.getJobId(), "activity [%s] completed with status [%s], moving to pending queue", activityContext.getFriendlyName(), activityContext.getStatus());
                }
                if (bl) {
                    activityContext.setStatus(ProcessStatus.QUEUED);
                    this.queuedSteps.add(new RestartExecutor(activityContext, this, workflowThread));
                } else {
                    this.pendingSteps.add(new PendingActivity(activityContext));
                }
            } else if (activityContext.isContinueOnFailure()) {
                logger.debug(activityContext.getJobId(), "activity [%s] completed with status [%s], maximum restarts reached [%s], continuing process [%s]", activityContext.getFriendlyName(), activityContext.getStatus(), activityContext.getMaxRestarts(), this.workflow.getName());
                activityContext.setStatus(ProcessStatus.FAILED);
                bl2 = true;
            } else {
                logger.warn(activityContext.getJobId(), "activity [%s] completed with status [%s], maximum restarts reached [%s], failing process [%s]", activityContext.getFriendlyName(), activityContext.getStatus(), activityContext.getMaxRestarts(), this.workflow.getName());
                if (activityContext.getMaxRestarts() > 0) {
                    object = EventMessage.getContainer("JM_WORKFLOW_MAX_RESTARTS", activityContext.getMaxRestarts().toString());
                    activityContext.setFailureReason((EvMessageContainer)object);
                }
                activityContext.setStatus(ProcessStatus.FAILED);
                this.workflow.setStatus(ProcessStatus.INTERRUPT_PENDING);
            }
        } else if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.SUSPENDED) {
            if (this.workflow.getStatus() == ProcessStatus.RUNNING || this.workflow.getStatus() == ProcessStatus.WAITING) {
                logger.info(activityContext.getJobId(), "activity [%s] completed with status [%s], suspending process [%s]", activityContext.getFriendlyName(), activityContext.getStatus(), this.getName());
                this.workflow.setStatus(ProcessStatus.SUSPEND_PENDING);
            } else {
                logger.debug(activityContext.getJobId(), "activity [%s] completed with status [%s], cannot update process [%s] since it has a status of [%s]", activityContext.getFriendlyName(), activityContext.getStatus(), this.getName(), this.workflow.getStatus().toString());
            }
            if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING) {
                activityContext.setStatus(ProcessStatus.COMPLETED);
                bl2 = true;
            }
        } else if (activityContext.getStatus() == ProcessStatus.FAILED || activityContext.getStatus() == ProcessStatus.INTERRUPT_PENDING || activityContext.getStatus() == ProcessStatus.KILL_PENDING || activityContext.getStatus() == ProcessStatus.KILLED) {
            if (activityContext.isContinueOnFailure()) {
                logger.info(activityContext.getJobId(), "activity [%s] completed with status [%s] but is configured to continue on failure", activityContext.getFriendlyName(), activityContext.getStatus());
                bl2 = true;
            } else if (this.workflow.getStatus() == ProcessStatus.RUNNING || this.workflow.getStatus() == ProcessStatus.WAITING) {
                logger.warn(activityContext.getJobId(), "activity [%s] completed with status [%s], interrupting parent process [%s]", activityContext.getFriendlyName(), activityContext.getStatus(), this.getName());
                this.workflow.setStatus(ProcessStatus.INTERRUPT_PENDING);
            } else {
                logger.debug(activityContext.getJobId(), "activity [%s] completed with status [%s], cannot update process [%s] since it has a status of [%s]", activityContext.getFriendlyName(), activityContext.getStatus(), this.getName(), this.workflow.getStatus().toString());
            }
        } else {
            logger.warn(activityContext.getJobId(), "cannot handle completion status of [%s] from activity [%s], interrupting parent process [%s]", activityContext.getStatus(), activityContext.getFriendlyName(), this.getName());
            activityContext.setFailureReason(EventMessage.getContainer("JM_WORKFLOW_ACTIVITY_ABNORMAL_TERMINATION", new Object[0]));
            activityContext.setStatus(ProcessStatus.FAILED);
            this.workflow.setStatus(ProcessStatus.INTERRUPT_PENDING);
        }
        if (activityContext.getStatus() == ProcessStatus.PENDING || activityContext.getStatus() == ProcessStatus.FAILED || activityContext.getStatus() == ProcessStatus.INTERRUPT_PENDING) {
            object = new WorkflowAlert(AlertType.NT_FAILURE_ATTEMTS, activityContext);
            this.workflow.getJobManager().writeAlert((AlertCriteria)object);
            this.workflow.addFailedActivity(activityContext);
        }
        activityContext.save();
        if (bl2) {
            if (activityContext.isTransitionCancelled()) {
                logger.info(this.workflow.getJobId(), "transition out of activity [%s] has been terminated", activityContext.getFriendlyName());
            } else {
                this.processTransitions(activityContext, workflowThread);
            }
        } else if (activityContext.getTransitions().length > 0) {
            logger.warn(this.workflow.getJobId(), "activity [%s] had pending transitions but finished with a status of [%s] which doesn't allow transitioning", activityContext.getFriendlyName(), activityContext.getStatus().toString());
        }
    }

    protected void processTransitions(ActivityContext activityContext, WorkflowThread workflowThread) {
        try {
            if (activityContext.getTransitions().length > 0) {
                if (activityContext.isForkTransitions()) {
                    boolean bl = true;
                    for (WorkflowTransition workflowTransition : activityContext.getTransitions()) {
                        logger.debug(this.workflow.getJobId(), "forking from step [%s] to step [%s] ", activityContext.getFriendlyName(), workflowTransition.getTargetActivity());
                        ActivityContext activityContext2 = StepBuilder.create(this.workflow, activityContext, workflowTransition, activityContext.getContext().newInstance());
                        if (WorkflowRegistry.getInstance().isReuseThreads()) {
                            AttemptExecutor attemptExecutor;
                            if (bl) {
                                attemptExecutor = new AttemptExecutor(activityContext2, this, workflowThread);
                                bl = false;
                            } else {
                                attemptExecutor = new AttemptExecutor(activityContext2, this, null);
                            }
                            this.executingSteps.add(attemptExecutor);
                            attemptExecutor.start();
                            this.saveContext = true;
                            continue;
                        }
                        this.queueActivity(new AttemptExecutor(activityContext2, this));
                    }
                } else {
                    logger.debug(this.workflow.getJobId(), "transitioning from step [%s] to step [%s] ", activityContext.getFriendlyName(), activityContext.getTransitions()[0].getTargetActivity());
                    ActivityContext activityContext3 = StepBuilder.create(this.workflow, activityContext, activityContext.getTransitions()[0], activityContext.getContext());
                    if (WorkflowRegistry.getInstance().isReuseThreads()) {
                        AttemptExecutor attemptExecutor = new AttemptExecutor(activityContext3, this, workflowThread);
                        this.executingSteps.add(attemptExecutor);
                        attemptExecutor.start();
                        this.saveContext = true;
                    } else {
                        this.queueActivity(new AttemptExecutor(activityContext3, this));
                    }
                }
            } else {
                logger.debug(this.workflow.getJobId(), "no transitions to handle from activity [%s]", activityContext.getFriendlyName());
            }
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.workflow.getJobId(), "failed to process transition from activity [" + activityContext.getFriendlyName() + "], interrupting parent process");
            this.workflow.setFailureReason(evFailureException.getMessageContainer());
            this.workflow.setStatus(ProcessStatus.INTERRUPT_PENDING);
        }
    }

    protected void checkWaiting() {
        if (this.executingSteps.size() == 0) {
            if (this.workflow.getStatus() == ProcessStatus.WAITING) {
                logger.debug(this.getJobId(), "switching process [%s] back to running state since there are no more waiting activities", this.getWorkflow().getName());
                this.saveContext = true;
                this.workflow.setStatus(ProcessStatus.RUNNING);
            }
            return;
        }
        int n = 0;
        for (Executor executor : this.executingSteps) {
            if (executor.getActivityContext().getStatus() != ProcessStatus.WAITING) continue;
            ++n;
        }
        if (this.workflow.getStatus() == ProcessStatus.RUNNING) {
            if (n == this.executingSteps.size()) {
                logger.debug(this.getJobId(), "switching process [%s] to waiting status since all executing activities are in a waiting state", this.getWorkflow().getName());
                this.workflow.setStatus(ProcessStatus.WAITING);
                this.saveContext = true;
            }
        } else if (this.workflow.getStatus() == ProcessStatus.WAITING && n != this.executingSteps.size()) {
            logger.debug(this.getJobId(), "switching process [%s] back to running state since there is at least one non-waiting activity", this.getWorkflow().getName());
            this.workflow.setStatus(ProcessStatus.RUNNING);
            this.saveContext = true;
        }
    }

    private boolean checkExecution() {
        for (Executor object : this.executingSteps) {
            long l;
            if (!object.isAlive()) continue;
            if (!(this.getWorkflow().getStatus() != ProcessStatus.RUNNING && this.getWorkflow().getStatus() != ProcessStatus.WAITING || object.getActivityContext().getStatus() != ProcessStatus.SUSPEND_PENDING && object.getActivityContext().getStatus() != ProcessStatus.SUSPENDED)) {
                logger.info(this.workflow.getJobId(), "suspending process [%s] since executing activity [%s] has a status of [%s]", this.getWorkflow().getName(), object.getActivityContext().getName(), object.getActivityContext().getStatus());
                this.getWorkflow().setStatus(ProcessStatus.SUSPEND_PENDING);
                this.saveContext = true;
            }
            if (!object.getActivityContext().isEnableTotalRunningTime() || object.getActivityContext().isTimedOut() || (l = (Calendar.getInstance().getTimeInMillis() - object.getExecutionStart()) / 1000L) <= (long)object.getActivityContext().getTimeout()) continue;
            Integer n = object.getActivityContext().getTimeout() / 60;
            object.getActivityContext().setTimedOut(true);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_ACTIVITY_TIMEOUT", object.getActivityContext().getFriendlyName(), n.toString());
            this.workflow.getJobManager().writeEvent(EventSeverity.MAJOR, evMessageContainer);
            if (object.getActivityContext().isKillJobIfRunningTimeExpires()) {
                logger.warn(object.getActivityContext().getJobId(), "interrupting activity [%s] since runtime has exceeded total running time of [%s] minutes", object.getActivityContext().getFriendlyName(), n);
                object.interrupt();
                object.getActivityContext().setFailureReason(evMessageContainer);
                continue;
            }
            logger.warn(object.getActivityContext().getJobId(), "runtime for activity [%s] has exceeded total running time of [%s] minutes", object.getActivityContext().getFriendlyName(), n);
        }
        if (this.completing) {
            return true;
        }
        this.checkWaiting();
        if (this.workflow.getStatus() != ProcessStatus.RUNNING && this.workflow.getStatus() != ProcessStatus.WAITING || !this.workflow.isRunning()) {
            for (Executor executor : this.executingSteps) {
                executor.signal();
            }
        }
        if (this.workflow.getStatus() == ProcessStatus.FAILED || this.workflow.getStatus() == ProcessStatus.INTERRUPT_PENDING || this.workflow.isTimedOut()) {
            for (Executor executor : this.executingSteps) {
                if (executor.isInterrupted()) continue;
                if (executor.getActivityContext().getStatus() == ProcessStatus.RUNNING || executor.getActivityContext().getStatus() == ProcessStatus.WAITING || executor.getActivityContext().getStatus() == ProcessStatus.SUSPEND_PENDING) {
                    executor.getActivityContext().setStatus(ProcessStatus.INTERRUPT_PENDING);
                }
                logger.warn(executor.getActivityContext().getJobId(), "interrupting activity [%s] since process [%s] has a status of [%s]", executor.getActivityContext().getFriendlyName(), this.getName(), this.workflow.getStatus().toString());
                executor.interrupt();
            }
            this.clearQueues(ProcessStatus.INTERRUPT_PENDING);
            return false;
        }
        if (this.workflow.getStatus() == ProcessStatus.SUSPENDED || this.workflow.getStatus() == ProcessStatus.SUSPEND_PENDING) {
            logger.trace(this.getJobId(), "attempting to suspend process [%s]", this.getName());
            if (this.interruptTime == null) {
                this.interruptTime = Calendar.getInstance().getTimeInMillis() / 1000L;
            }
            long l = Calendar.getInstance().getTimeInMillis() / 1000L;
            long l2 = (long)(this.workflow.getJobSettings().getCleanupTimeout() / 1000) - (l - this.interruptTime);
            for (Executor executor : this.executingSteps) {
                if (executor.getActivityContext().getStatus() == ProcessStatus.RUNNING || executor.getActivityContext().getStatus() == ProcessStatus.WAITING) {
                    executor.getActivityContext().setStatus(ProcessStatus.SUSPEND_PENDING);
                }
                if (l2 <= 0L) {
                    if (executor.isInterrupted()) continue;
                    logger.warn(executor.getActivityContext().getJobId(), "interrupting activity [%s] since process [%s] has a status of [%s] and cleanup timeout has exceeded", executor.getActivityContext().getFriendlyName(), this.getName(), this.workflow.getStatus().toString());
                    executor.interrupt();
                    continue;
                }
                logger.trace(this.workflow.getJobId(), "activity [%s] is still executing will be terminated in [%s] seconds", executor.getActivityContext().getFriendlyName(), l2);
            }
            this.clearQueues(ProcessStatus.SUSPENDED);
            return false;
        }
        if (this.workflow.getStatus() == ProcessStatus.KILLED || this.workflow.getStatus() == ProcessStatus.KILL_PENDING) {
            logger.trace(this.getJobId(), "attempting to kill process [%s]", this.getName());
            for (Executor executor : this.executingSteps) {
                if (executor.getActivityContext().getStatus() == ProcessStatus.RUNNING || executor.getActivityContext().getStatus() == ProcessStatus.WAITING || executor.getActivityContext().getStatus() == ProcessStatus.SUSPEND_PENDING) {
                    executor.getActivityContext().setStatus(ProcessStatus.KILL_PENDING);
                }
                if (executor.isInterrupted()) continue;
                logger.warn(executor.getActivityContext().getJobId(), "interrupting activity [%s] since process [%s] has a status of [%s]", executor.getActivityContext().getFriendlyName(), this.getName(), this.workflow.getStatus().toString());
                executor.interrupt();
            }
            this.clearQueues(ProcessStatus.KILLED);
            return false;
        }
        return true;
    }

    private void processQueues() {
        long l;
        Object object;
        Iterator<Object> iterator;
        if (!this.workflow.isRunning()) {
            logger.trace(this.workflow.getJobId(), "skip processing of queues in workflow [%s] since workflow is shutting down", this.workflow.getName());
            return;
        }
        long l2 = Calendar.getInstance().getTimeInMillis() / 1000L;
        if (this.repeatingSteps.size() > 0) {
            iterator = this.repeatingSteps.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                l = ((TimedActivity)object).getInTime() + (long)((TimedActivity)object).getRestartInterval() - l2;
                if (l <= 0L) {
                    logger.debug(((TimedActivity)object).getJobId(), "restarting repeat activity [%s]", ((TimedActivity)object).getUniqueName());
                    iterator.remove();
                    this.queuedSteps.add(new RepeatExecutor(((TimedActivity)object).getActivity(), this));
                    continue;
                }
                logger.trace(((TimedActivity)object).getJobId(), "activity [%s] has [%s] seconds(s) until repeat", ((TimedActivity)object).getUniqueName(), l);
            }
        }
        if (this.pendingSteps.size() > 0) {
            iterator = this.pendingSteps.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                l = ((TimedActivity)object).getInTime() + (long)((TimedActivity)object).getRestartInterval() - l2;
                if (l <= 0L || ((TimedActivity)object).isResume()) {
                    logger.debug(((TimedActivity)object).getJobId(), "moving pending activity [%s] to queued queue", ((TimedActivity)object).getUniqueName());
                    iterator.remove();
                    ActivityContext object2 = ((TimedActivity)object).getActivity();
                    object2.setStatus(ProcessStatus.QUEUED);
                    this.queuedSteps.add(new RestartExecutor(object2, this));
                    continue;
                }
                logger.trace(((TimedActivity)object).getJobId(), "pending activity [%s] has [%s] seconds(s) until restart", ((TimedActivity)object).getUniqueName(), l);
            }
        }
        if (this.queuedSteps.size() > 0) {
            iterator = this.queuedSteps.iterator();
            while (iterator.hasNext()) {
                object = (Executor)iterator.next();
                boolean bl = true;
                for (Executor executor : this.executingSteps) {
                    if (object.getStepId() != executor.getStepId()) continue;
                    logger.debug(object.getActivityContext().getJobId(), "cannot start activity [%s] since another step with id [%s] is already executing", object.getActivityContext().getFriendlyName(), object.getStepId());
                    bl = false;
                    break;
                }
                if (!bl) continue;
                this.saveContext = true;
                iterator.remove();
                this.executingSteps.add((Executor)object);
                object.start();
            }
        }
        this.checkQueues();
    }

    protected void checkQueues() {
        if (this.getExecutingSize() > 0) {
            if (this.workflow.getStatus() == ProcessStatus.PENDING) {
                logger.debug(this.getJobId(), "switching workflow [%s] to running status since we still have activities to execute", this.getName());
                this.workflow.setStatus(ProcessStatus.RUNNING);
                this.saveContext = true;
            }
        } else if (this.pendingSteps.size() > 0 && this.workflow.getStatus() == ProcessStatus.RUNNING) {
            logger.debug(this.getJobId(), "switching workflow [%s] to pending status since no other activities are executing", this.getName());
            this.workflow.setStatus(ProcessStatus.PENDING);
            this.saveContext = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumePendingActivities() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            for (TimedActivity timedActivity : this.pendingSteps) {
                logger.info(timedActivity.getJobId(), "resuming pending activity [%s] in workflow [%s]", timedActivity.getUniqueName(), this.getName());
                timedActivity.setResume(true);
            }
        }
    }

    protected void clearQueues() {
        logger.debug(this.workflow.getJobId(), "clearing activity queues");
        this.debugActivities.clear();
        this.executingSteps.clear();
        this.queuedSteps.clear();
        this.pendingSteps.clear();
        this.repeatingSteps.clear();
        this.onCompleteSteps.clear();
    }

    private void clearQueues(ProcessStatus processStatus) {
        Object object;
        Iterator<ActivityContext> iterator;
        Object object2;
        logger.trace(this.workflow.getJobId(), "clearing queues with status [%s]", processStatus.toString());
        Iterator<Executor> iterator2 = this.queuedSteps.iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            iterator = object2.getActivityContext();
            logger.debug(iterator.getJobId(), "updating queued activity [%s] with status [%s]", iterator.getFriendlyName(), processStatus.toString());
            iterator.setStatus(processStatus);
            iterator.save();
            iterator2.remove();
        }
        object2 = this.pendingSteps.iterator();
        while (object2.hasNext()) {
            iterator = (TimedActivity)object2.next();
            logger.debug(((TimedActivity)((Object)iterator)).getJobId(), "removing activity [%s] from pending queue", ((TimedActivity)((Object)iterator)).getUniqueName());
            object2.remove();
        }
        iterator = this.debugActivities.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            logger.debug(object.getJobId(), "updating debugged activity [%s] with status [%s]", object.getUniqueName(), processStatus.toString());
            object.setStatus(processStatus);
            object.save();
            iterator.remove();
        }
        object = this.repeatingSteps.iterator();
        while (object.hasNext()) {
            TimedActivity timedActivity = (TimedActivity)object.next();
            logger.debug(timedActivity.getJobId(), "updating repeating activity [%s] with status [%s]", timedActivity.getUniqueName(), processStatus.toString());
            ActivityContext activityContext = timedActivity.getActivity();
            activityContext.setStatus(processStatus);
            activityContext.save();
            object.remove();
        }
    }

    public int hashCode() {
        return new Long(this.workflow.getJobId()).hashCode();
    }

    @Override
    public String getName() {
        return this.workflow.getName();
    }

    @Override
    public long getJobId() {
        return this.workflow.getJobId();
    }

    @Override
    public int getCommCellId() {
        return this.workflow.getCommCellId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            return this.executingSteps.size() + this.pendingSteps.size() + this.queuedSteps.size() + this.repeatingSteps.size() + this.debugActivities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecutingSize() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            return this.executingSteps.size() + this.queuedSteps.size() + this.repeatingSteps.size();
        }
    }

    public long getLastUpdateFromManager() {
        return this.updateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResumable() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            if (this.workflow.getStatus() == ProcessStatus.PENDING && this.getPendingCount() > 0) {
                long l = Calendar.getInstance().getTimeInMillis() / 1000L;
                for (TimedActivity timedActivity : this.pendingSteps) {
                    long l2 = timedActivity.getInTime() + (long)timedActivity.getRestartInterval() - l;
                    if (timedActivity.isResume() || l2 <= 0L) {
                        return true;
                    }
                    logger.trace(timedActivity.getJobId(), "pending activity [%s] in workflow [%s] has [%s] seconds(s) until restart", timedActivity.getUniqueName(), this.getName(), l2);
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingCount() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            return this.pendingSteps.size();
        }
    }

    protected void update(DebugWorkflowRequest debugWorkflowRequest) {
        try {
            logger.debug(this.getWorkflow().getJobId(), "retrieved debug inputs from request [%s]", debugWorkflowRequest.getWorkflowInputs());
            WorkflowElement workflowElement = WorkflowElement.parse(debugWorkflowRequest.getWorkflowInputs());
            this.getWorkflow().getWorkflowExecution().mergeInputs(workflowElement);
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.getWorkflow().getJobId(), "failed to parse inputs from debug request");
        }
        try {
            logger.debug(this.getWorkflow().getJobId(), "retrieved debug variables from request [%s]", debugWorkflowRequest.getWorkflowInputs());
            WorkflowElement workflowElement = WorkflowElement.parse(debugWorkflowRequest.getWorkflowVariables());
            this.getWorkflow().getWorkflowExecution().mergeVariables(workflowElement);
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.getWorkflow().getJobId(), "failed to parse variables from debug request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
        Object object = this.workflow.getLock();
        synchronized (object) {
            ActivityContext activityContext = (ActivityContext)workflowContext;
            this.debugActivities.remove(activityContext);
            DebugWorkflowRequest debugWorkflowRequest = (DebugWorkflowRequest)interactiveRequest;
            if (this.sessionClosed) {
                logger.warn(activityContext.getJobId(), "interactive session was closed");
                activityContext.setStatus(ProcessStatus.FAILED);
                this.workflow.setDebug(false);
                this.completeActivity(activityContext, true, null);
                return;
            }
            if (this.workflow.getStatus() == ProcessStatus.KILLED || this.workflow.getStatus() == ProcessStatus.KILL_PENDING) {
                logger.info(activityContext.getJobId(), "stopping debug action for activity [%s] since workflow is being killed", activityContext.getFriendlyName());
                activityContext.setStatus(ProcessStatus.KILLED);
                activityContext.save();
                return;
            }
            this.update(debugWorkflowRequest);
            if (debugWorkflowRequest.getDebugControl() == DebugControl.EXEC_SCRIPT) {
                logger.info(this.workflow.getJobId(), "executing debug script [%s]", debugWorkflowRequest.getScript().getScript());
                Object object2 = null;
                try {
                    object2 = activityContext.getEvaluator().evaluate(debugWorkflowRequest.getScript());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(this.workflow.getJobId(), "error evaluating debug script");
                }
                logger.info(this.workflow.getJobId(), "debug script returned value [%s]", String.valueOf(object2));
                this.sendDebugMessage(activityContext);
            } else if (debugWorkflowRequest.getDebugControl() == DebugControl.RETRY) {
                logger.info(this.workflow.getJobId(), "retrying activity [%s]", activityContext.getFriendlyName());
                try {
                    activityContext.setDefinition(debugWorkflowRequest.getActivity());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(this.workflow.getJobId(), "failed to update activity definition from retry request");
                }
                activityContext.setStatus(ProcessStatus.QUEUED);
                activityContext.setBreakPoint(true);
                this.queuedSteps.add(new RepeatExecutor(activityContext, this));
            } else if (debugWorkflowRequest.getDebugControl() == DebugControl.PREV_ACTIVITY) {
                ActivityContext activityContext2;
                if (activityContext.getSourceActivity() == null) {
                    this.sendDebugMessage(activityContext, 1, "failed to load previous activity");
                    return;
                }
                try {
                    activityContext2 = StepBuilder.create(this.workflow, activityContext.getSourceActivity(), activityContext.getContext().getId());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(activityContext.getJobId(), "failed to create actvity context for previous step [" + activityContext.getSourceActivity() + "]");
                    this.sendDebugMessage(activityContext, 1, "failed to load previous activity");
                    return;
                }
                if (activityContext2.getContext().getId() != activityContext.getContext().getId()) {
                    logger.error(activityContext.getJobId(), "previous activity [" + activityContext2.getUniqueName() + "] with context id [" + activityContext2.getContext().getId() + "] is not on the same thread line as activity [" + activityContext.getUniqueName() + "] with context id [" + activityContext.getContext().getId() + "]");
                    this.sendDebugMessage(activityContext, 1, "failed to load previous activity");
                    return;
                }
                boolean bl = false;
                for (WorkflowTransition workflowTransition : activityContext2.getOutboundTransitions()) {
                    if (!workflowTransition.getTargetActivity().equals(activityContext.getUniqueName())) continue;
                    bl = true;
                    activityContext2.addTransitionTo(workflowTransition);
                    break;
                }
                if (!bl) {
                    logger.error(activityContext.getJobId(), "could not find transition from previous activity [" + activityContext.getSourceActivity() + "] to current activity [" + activityContext.getUniqueName() + "]");
                    this.sendDebugMessage(activityContext, 1, "failed to load previous activity");
                    return;
                }
                try {
                    this.workflow.getDataAccess().removeProcessStep(activityContext.getProcessStepId());
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(activityContext.getJobId(), "failed to remove current activity [" + activityContext.getUniqueName() + "]", cTEDBException);
                }
                this.workflow.getJobManager().setCurrentAttempt(activityContext2);
                this.sendDebugMessage(activityContext2);
            } else if (debugWorkflowRequest.getDebugControl() == DebugControl.TERMINATE) {
                logger.info(activityContext.getJobId(), "recieved terminate control from debugger");
                activityContext.setStatus(ProcessStatus.FAILED);
                this.workflow.setDebug(false);
                this.completeActivity(activityContext, true, null);
            } else if (debugWorkflowRequest.getDebugControl() == DebugControl.NEXT_ACTIVITY || debugWorkflowRequest.getDebugControl() == DebugControl.CONTINUE) {
                if (activityContext.getStatus() == ProcessStatus.RUNNING) {
                    if (debugWorkflowRequest.getActivityInputs().length() > 0) {
                        try {
                            activityContext.setActivityInputs(WorkflowElement.parse(debugWorkflowRequest.getActivityInputs()));
                            new SetActivityInputs().executeHandler(activityContext);
                        }
                        catch (Exception exception) {
                            logger.error(activityContext.getJobId(), "failed to set debug inputs in activity [" + activityContext.getFriendlyName() + "]");
                        }
                    }
                    this.queuedSteps.add(new ContinueExecutor(activityContext, this));
                } else {
                    activityContext.getContext().setDebugNext(debugWorkflowRequest.getDebugControl() == DebugControl.NEXT_ACTIVITY);
                    if (debugWorkflowRequest.getActivityOutputs().length() > 0) {
                        try {
                            activityContext.setActivityOutputs(OutputElement.parse(debugWorkflowRequest.getActivityOutputs()));
                        }
                        catch (EvFailureException evFailureException) {
                            logger.error(activityContext.getJobId(), "failed to set debug outputs in activity [" + activityContext.getFriendlyName() + "]");
                        }
                    }
                    for (ActivityDefinition activityDefinition : debugWorkflowRequest.getNextActivities()) {
                        try {
                            WF_Steps_t wF_Steps_t = this.workflow.getDataAccess().getStep(activityDefinition.getUniqueName(), this.workflow.getDeploymentId());
                            if (wF_Steps_t == null) continue;
                            DeploymentManager.populateStepRow(activityDefinition, wF_Steps_t);
                            block19: for (WF_StepTransitions_t wF_StepTransitions_t : this.workflow.getDataAccess().getStepTransitions(wF_Steps_t.StepId.get())) {
                                for (TransitionDefinition transitionDefinition : activityDefinition.getTransition()) {
                                    if (!wF_StepTransitions_t.TargetActivity.get().equalsIgnoreCase(transitionDefinition.getActivity())) continue;
                                    DeploymentManager.populateStepTransition(wF_StepTransitions_t, transitionDefinition);
                                    continue block19;
                                }
                            }
                        }
                        catch (CTEDBException cTEDBException) {
                            logger.error(activityContext.getJobId(), "failed to update definition for next activity [" + activityDefinition.getUniqueName() + "]", cTEDBException);
                        }
                    }
                    this.completeActivity(activityContext, true, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInteractiveSessionClosed() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            this.sessionClosed = true;
        }
    }

    public void sendDebugMessage(ActivityContext activityContext) {
        this.sendDebugMessage(activityContext, 0, "");
    }

    public void sendDebugMessage(ActivityContext activityContext, int n, String string) {
        DebugWorkflowResp debugWorkflowResp;
        try {
            debugWorkflowResp = DebugHelper.buildThreadResponse(activityContext);
        }
        catch (Exception exception) {
            logger.error(activityContext.getJobId(), "failed to create debug response for activity [" + activityContext.getFriendlyName() + "]", exception);
            this.completeActivity(activityContext, true, null);
            return;
        }
        if (n != 0) {
            debugWorkflowResp.setErrorCode(n);
            debugWorkflowResp.setErrorMessage(string);
        }
        try {
            SessionManager.getInstance().sendResponse(activityContext, (CTEProcessingModel)debugWorkflowResp, this);
        }
        catch (EvFailureException evFailureException) {
            logger.error(activityContext.getJobId(), "failed to respond to workflow for activity [" + activityContext.getFriendlyName() + "]");
            this.completeActivity(activityContext, true, null);
            return;
        }
        this.debugActivities.add(activityContext);
    }
}

