/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ForEachProcessManager;
import commvault.cte.workflow.ParellelProcess;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.SuperProcess;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.logger.CTELogger;

public class ParellelProcessManager
extends ProcessManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ParellelProcessManager.class);
    private WorkflowThread thread;

    public ParellelProcessManager(SuperProcess superProcess) {
        super(superProcess);
    }

    public SuperProcess getSuperProcess() {
        return (ParellelProcess)this.workflow;
    }

    public void start(final ForEachProcessManager forEachProcessManager) {
        if (this.thread == null) {
            logger.debug(this.getJobId(), "starting thread manager for parellel process [%s]", this.getName());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ParellelProcessManager.this.worker();
                    }
                    catch (Throwable throwable) {
                        logger.error(ParellelProcessManager.this.workflow.getJobId(), "uncaught exception in executing process manager, exiting manager!", throwable);
                    }
                    logger.info(ParellelProcessManager.this.workflow.getJobId(), "process manager [%s] exiting with status [%s]", ParellelProcessManager.this.workflow.getName(), ParellelProcessManager.this.workflow.getStatus().toString());
                    ParellelProcessManager.this.thread = null;
                    forEachProcessManager.signal();
                }
            };
            this.thread = new WorkflowThread(runnable, "ParellelThread(" + this.workflow.getProcessStepId() + ")", this.workflow);
            this.thread.start();
        } else {
            logger.warn(this.getJobId(), "workflow thread manager was already started");
        }
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    @Override
    protected void checkQueues() {
        if (this.getExecutingSize() == 0 && this.pendingSteps.size() > 0 && this.workflow.getStatus() == ProcessStatus.RUNNING) {
            logger.debug(this.getJobId(), "switching workflow [%s] to pending status since no other activities are executing", this.getName());
            this.workflow.setStatus(ProcessStatus.PENDING);
            this.saveContext = true;
        }
    }
}

