/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.UserInteractionTask;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.logger.CTELogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class MonitorWorkflowTask
extends TimerTask {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UserInteractionTask.class);
    private static final MonitorWorkflowTask instance = new MonitorWorkflowTask();
    private static final long TIMER_INTERVAL = 5L;
    private Map<Long, MonitorTask> tasks = new HashMap<Long, MonitorTask>();

    public static MonitorWorkflowTask getInstance() {
        return instance;
    }

    private MonitorWorkflowTask() {
        long l = 5000L;
        new Timer(true).schedule((TimerTask)this, l, l);
    }

    public synchronized void addTask(MonitorTask monitorTask) {
        this.tasks.put(monitorTask.getJobId(), monitorTask);
    }

    public synchronized void removeTask(MonitorTask monitorTask) {
        this.tasks.remove(monitorTask.getJobId());
    }

    public synchronized void completeJob(WF_Process_t wF_Process_t) {
        MonitorTask monitorTask = this.tasks.get(wF_Process_t.jobId.get());
        if (monitorTask != null) {
            monitorTask.performTask(wF_Process_t);
            this.tasks.remove(wF_Process_t.jobId.get());
        }
    }

    @Override
    public synchronized void run() {
        List<WF_Process_t> list;
        if (this.tasks.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (MonitorTask object2 : this.tasks.values()) {
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            stringBuffer.append(object2.getJobId());
        }
        String string = String.format("jobId in (%s) and status in (4, 10, 11, 12, 25)", stringBuffer);
        try {
            list = WF_Process_t.select(string);
        }
        catch (CTEDBException iterator) {
            logger.error("failed to retrieve job rows with where clause [" + (String)string + "]", iterator);
            return;
        }
        for (WF_Process_t wF_Process_t : list) {
            MonitorTask monitorTask = this.tasks.get(wF_Process_t.jobId.get());
            if (monitorTask == null) continue;
            monitorTask.performTask(wF_Process_t);
            this.tasks.remove(wF_Process_t.jobId.get());
        }
    }

    public static interface MonitorTask {
        public void performTask(WF_Process_t var1);

        public long getJobId();

        public WorkflowContext getContext();
    }
}

