/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.message.SocketMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class MessageServer {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(MessageServer.class);
    private static MessageServer instance = new MessageServer();
    private boolean running = false;
    private ServerSocket srvr;

    public static MessageServer getInstance() {
        return instance;
    }

    private MessageServer() {
    }

    public void stop() {
        logger.debug("stop() called for Message Server");
        this.running = false;
        try {
            this.srvr.close();
        }
        catch (IOException iOException) {
            logger.error("failed to close service", iOException);
        }
    }

    public void start() throws Exception {
        if (this.running) {
            throw new Error("message server already running");
        }
        this.running = true;
        this.srvr = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
        EventMessage.getInstance().setPort(this.srvr.getLocalPort());
        logger.info("message server running on port [%s]", this.srvr.getLocalPort());
        WorkflowRegistry.getInstance().setMessagePort(this.srvr.getLocalPort());
        while (this.running) {
            try {
                this.onConnect(this.srvr.accept());
            }
            catch (Throwable throwable) {
                if (!this.running) continue;
                logger.error("failed to accept message socket", throwable);
            }
        }
    }

    private void onConnect(Socket socket) {
        SocketMessage socketMessage = new SocketMessage(socket);
        ThreadManager.getInstance().execute(new MessageProcessor(socketMessage));
    }

    private class MessageProcessor
    implements Runnable {
        private SocketMessage msg;

        public MessageProcessor(SocketMessage socketMessage) {
            this.msg = socketMessage;
        }

        @Override
        public void run() {
            logger.debug("new socket connection recieved");
            try {
                this.msg.read();
                RequestManager.getInstance().handle(this.msg);
            }
            catch (Throwable throwable) {
                logger.error("uncaught exception processing message", throwable);
                this.msg.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(-1, throwable.getMessage()));
            }
        }
    }
}

