/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.CompletionStatus;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvEvent;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventManager;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.JobManagerContext;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.JMAddJobPendingParam_p;
import commvault.cte.workflow.db.cs.JMAddJobPendingParam_t;
import commvault.cte.workflow.db.cs.JMAdminJobAttemptInfoTable_t;
import commvault.cte.workflow.db.cs.JMAdminJobAttemptStatsTable_t;
import commvault.cte.workflow.db.cs.JMAdminJobInfoTable_t;
import commvault.cte.workflow.db.cs.JMAdminJobStatsTable_t;
import commvault.cte.workflow.db.cs.JMBuildFailureReasonCache_p;
import commvault.cte.workflow.db.cs.JMFailureReasonMsgParamTmp_t;
import commvault.cte.workflow.db.cs.JMFailureReasonMsg_t;
import commvault.cte.workflow.db.cs.JMJobInfo_t;
import commvault.cte.workflow.db.cs.JMJobOptions_t;
import commvault.cte.workflow.db.cs.JMJobStats_t;
import commvault.cte.workflow.db.cs.JMMisc_t;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.ArgumentInfoXML;
import commvault.msgs.App.EventSeverity;
import commvault.msgs.Workflow.AlertCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringEscapeUtils;

public class JobManager
implements JobManagerContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JobManager.class);
    private static final String JM_WORKFLOW_JOB_INFO = "<JobManager_WorkflowJobInfo outputs=\"%s\" />";
    private static final boolean SKIP_ATTEMPT_CREATION = WorkflowRegistry.getInstance().isSkipCreateAttempts();
    public static final ExecutorService DB_EXEC;
    public static final int JMMISC_WORKFLOW_VERSION = 90;
    private WorkflowProcess workflow;
    private JMJobStats_t jobStatsRow;
    private JMJobInfo_t jobInfoRow;
    private JMAdminJobInfoTable_t adminJobInfoRow;
    private JMMisc_t jobVersionRow;
    private Object lock = new Object[0];
    private volatile boolean completed = false;
    private String previousJPR = "";

    public static void submit(Runnable runnable) {
        if (DB_EXEC != null) {
            DB_EXEC.submit(runnable);
        } else {
            runnable.run();
        }
    }

    public static void completeJob(WF_Process_t wF_Process_t) throws CTEDBException {
        JobManager.completeJob(wF_Process_t, ProcessStatus.fromInt((int)wF_Process_t.Status.get()), null);
    }

    public static void completeJob(final WF_Process_t wF_Process_t, final ProcessStatus processStatus, EvFailureReason evFailureReason) throws CTEDBException {
        JMJobStats_t jMJobStats_t = new JMJobStats_t();
        String string = String.format("jobId = %s AND commCellId = %s", wF_Process_t.jobId.get(), wF_Process_t.commCellId.get());
        if (!jMJobStats_t.fill(string)) {
            logger.error(wF_Process_t.jobId.get(), "could not find JMJobStats row for job id [" + wF_Process_t.jobId.get() + "]");
            JobManager.setProcessRowCompleted(wF_Process_t, processStatus);
            return;
        }
        final JMJobInfo_t jMJobInfo_t = new JMJobInfo_t();
        if (!jMJobInfo_t.fill(string)) {
            logger.error(wF_Process_t.jobId.get(), "could not find JMJobInfo row for job id [" + wF_Process_t.jobId.get() + "]");
            JobManager.setProcessRowCompleted(wF_Process_t, processStatus);
            return;
        }
        JMAdminJobInfoTable_t jMAdminJobInfoTable_t = new JMAdminJobInfoTable_t();
        if (!jMAdminJobInfoTable_t.fill(string)) {
            logger.error(wF_Process_t.jobId.get(), "could not find JMAdminJobInfoTable row for job id [" + wF_Process_t.jobId.get() + "]");
            JobManager.setProcessRowCompleted(wF_Process_t, processStatus);
            return;
        }
        long l = CommServUtils.getCommCellTime();
        final int n = (int)(l / 1000L);
        int n2 = wF_Process_t.EndTime.get() == null ? n : wF_Process_t.EndTime.get();
        jMJobInfo_t.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(l)));
        jMJobInfo_t.jobElapsedTime.set(Integer.valueOf(n2 - jMJobInfo_t.jobStartTime.get()));
        jMJobInfo_t.elapsedTime.set(Integer.valueOf(n2 - jMJobInfo_t.jobStartTime.get()));
        jMJobInfo_t.state.set(Integer.valueOf(processStatus.toInt()));
        jMJobInfo_t.displayState.set(Integer.valueOf(processStatus.toInt()));
        jMJobInfo_t.percentcomplete.set(Integer.valueOf(100));
        if (evFailureReason != null) {
            jMJobInfo_t.failureReason.set(WorkflowUtils.buildFailureReason(Arrays.asList(evFailureReason)));
        }
        jMAdminJobInfoTable_t.status.set(Integer.valueOf(processStatus.toInt()));
        jMJobInfo_t.noOfGUIMonitors.set(Integer.valueOf(1));
        jMJobInfo_t.timeToComplete.set(Integer.valueOf(0));
        jMJobStats_t.status.set(Integer.valueOf(2));
        jMJobInfo_t.serverEndTime.set(Integer.valueOf(n2));
        jMAdminJobInfoTable_t.servEnd.set(Integer.valueOf(n2));
        jMAdminJobInfoTable_t.save();
        jMJobStats_t.save();
        jMJobInfo_t.save();
        JobManager.updateFailureReasonCache(jMJobInfo_t);
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string2 = String.format("id = %s", wF_Process_t.userId.get());
        String string3 = uMUsers_t.fill(string2) ? uMUsers_t.name.get() : "";
        JobManager.copyAdminJobInfoStats(jMJobStats_t, jMJobInfo_t, jMAdminJobInfoTable_t, 0, string3);
        JobManager.copyAdminJobAttemptStats(jMJobStats_t);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (DateUtilities.getNow() - n < WorkflowRegistry.getInstance().getCleanupInterval()) {
                    try {
                        Thread.sleep(WorkflowRegistry.getInstance().getCleanupInterval() * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                logger.debug(wF_Process_t.jobId.get(), "cleaning up job manager records for workflow job [%s]", wF_Process_t.jobId.get());
                try {
                    if (!jMJobInfo_t.delete()) {
                        logger.info(wF_Process_t.jobId.get(), "no job manager records where cleaned for workflow [%s]", wF_Process_t.jobId.get());
                    }
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(wF_Process_t.jobId.get(), "failed to cleanup job manager records for workflow [" + wF_Process_t.jobId.get() + "]", cTEDBException);
                    return;
                }
                JobManager.setProcessRowCompleted(wF_Process_t, processStatus);
            }
        };
        ThreadManager.getInstance().execute(runnable);
    }

    public static boolean killJob(long l, int n, int n2) throws CTEDBException {
        int n3;
        JMAdminJobInfoTable_t jMAdminJobInfoTable_t = new JMAdminJobInfoTable_t();
        String string = String.format("jobId = %s AND commCellId = %s AND opType = 90 AND cloudId = %s", l, n, WorkflowProperties.getInstance().getClient().getClientId());
        if (!jMAdminJobInfoTable_t.fill(string)) {
            logger.debug(l, "could not find stale job id [%s] commserv database, where clause [%s]", l, string);
            return false;
        }
        String string2 = String.format("jobId = %s AND commCellId = %s", l, n);
        JMJobStats_t jMJobStats_t = new JMJobStats_t();
        jMJobStats_t.fill(string2);
        JMJobInfo_t jMJobInfo_t = new JMJobInfo_t();
        jMJobInfo_t.fill(string2);
        long l2 = CommServUtils.getCommCellTime();
        int n4 = n3 = (int)(l2 / 1000L);
        jMJobInfo_t.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(l2)));
        jMJobInfo_t.jobElapsedTime.set(Integer.valueOf(n4 - jMJobInfo_t.jobStartTime.get()));
        jMJobInfo_t.elapsedTime.set(Integer.valueOf(n4 - jMJobInfo_t.jobStartTime.get()));
        jMJobInfo_t.state.set(Integer.valueOf(ProcessStatus.KILLED.toInt()));
        jMJobInfo_t.displayState.set(Integer.valueOf(ProcessStatus.KILLED.toInt()));
        jMJobInfo_t.percentcomplete.set(Integer.valueOf(100));
        jMJobInfo_t.noOfGUIMonitors.set(Integer.valueOf(1));
        jMJobInfo_t.timeToComplete.set(Integer.valueOf(0));
        jMJobInfo_t.serverEndTime.set(Integer.valueOf(n4));
        jMJobInfo_t.save();
        jMAdminJobInfoTable_t.status.set(Integer.valueOf(ProcessStatus.KILLED.toInt()));
        jMAdminJobInfoTable_t.servEnd.set(Integer.valueOf(n4));
        jMAdminJobInfoTable_t.save();
        jMJobStats_t.status.set(Integer.valueOf(2));
        jMJobStats_t.save();
        JobManager.updateFailureReasonCache(jMJobInfo_t);
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string3 = String.format("id = %s", n2);
        String string4 = uMUsers_t.fill(string3) ? uMUsers_t.name.get() : "";
        JobManager.copyAdminJobInfoStats(jMJobStats_t, jMJobInfo_t, jMAdminJobInfoTable_t, 0, string4);
        JobManager.copyAdminJobAttemptStats(jMJobStats_t);
        logger.debug(l, "cleaning up job manager records for workflow job [%s]", l);
        jMJobInfo_t.delete();
        return true;
    }

    private static void setProcessRowCompleted(WF_Process_t wF_Process_t, ProcessStatus processStatus) {
        wF_Process_t.Status.set(Integer.valueOf(processStatus.toInt()));
        wF_Process_t.State.set(Integer.valueOf(ExecutionState.COMPLETED.toInt()));
        wF_Process_t.EndTime.set(Integer.valueOf(DateUtilities.getNow()));
        wF_Process_t.Modified.set(Integer.valueOf(DateUtilities.getNow()));
        logger.info(wF_Process_t.jobId.get(), "completing workflow job [%s] with status [%s]", wF_Process_t.jobId.get(), processStatus.toString());
        try {
            wF_Process_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(wF_Process_t.jobId.get(), "error saving WF_Process row for job id [" + wF_Process_t.jobId.get() + "]", cTEDBException);
        }
    }

    public static void updateAttempt(long l, int n, int n2, boolean bl) throws CTEDBException {
        JMAdminJobAttemptInfoTable_t jMAdminJobAttemptInfoTable_t = new JMAdminJobAttemptInfoTable_t();
        String string = String.format("jobId = %s AND commCellId = %s AND phaseNum = %s AND attemptNum = 0", l, n, n2);
        if (jMAdminJobAttemptInfoTable_t.fill(string)) {
            long l2 = CommServUtils.getCommCellTime();
            int n3 = (int)(l2 / 1000L);
            if (bl) {
                CompletionStatus completionStatus = CompletionStatus.COMPLETED;
                jMAdminJobAttemptInfoTable_t.status.set(Integer.valueOf(completionStatus.toInt()));
                jMAdminJobAttemptInfoTable_t.endTime.set(Integer.valueOf(n3));
                jMAdminJobAttemptInfoTable_t.embeddedObjects.set(Long.valueOf(0L));
            } else {
                jMAdminJobAttemptInfoTable_t.status.set(Integer.valueOf(0));
                jMAdminJobAttemptInfoTable_t.endTime.set(Integer.valueOf(0));
                jMAdminJobAttemptInfoTable_t.embeddedObjects.set(Long.valueOf(ProcessStatus.RUNNING.toInt()));
                jMAdminJobAttemptInfoTable_t.failureReason.set("");
            }
            jMAdminJobAttemptInfoTable_t.save();
        }
    }

    protected JobManager(WorkflowProcess workflowProcess) throws CTEDBException {
        this.workflow = workflowProcess;
        this.initJobManagerStatsRow();
        this.initJobInfoRow();
        this.initAdminJobInfoRow();
        this.initMiscRows();
    }

    private static long getLastStateChangeTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        long l2 = calendar.getTimeInMillis() / 1000L;
        long l3 = l2 * 0x80000000L;
        return l3 + (long)calendar.get(14);
    }

    @Override
    public void setCurrentAttempt(final ActivityContext activityContext) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = JobManager.this.lock;
                synchronized (object) {
                    if (JobManager.this.completed) {
                        return;
                    }
                    long l = CommServUtils.getCommCellTime();
                    int n = (int)(l / 1000L);
                    ((JobManager)JobManager.this).jobInfoRow.currentPhase.set(activityContext.getProcessStepId());
                    ((JobManager)JobManager.this).jobInfoRow.currentPhaseName.set(activityContext.getStepName());
                    ((JobManager)JobManager.this).jobInfoRow.attemptStartTime.set(Integer.valueOf(n));
                    ((JobManager)JobManager.this).jobInfoRow.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(l)));
                    try {
                        JobManager.this.jobInfoRow.save();
                    }
                    catch (CTEDBException cTEDBException) {
                        logger.error(JobManager.this.workflow.getJobId(), "failed to update table [JMJobInfo]", cTEDBException);
                    }
                }
            }
        };
        JobManager.submit(runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void saveAttempt(final ActivityContext activityContext) {
        Object object;
        if (activityContext.getStatus().isJobComplete() || activityContext.getStatus() == ProcessStatus.INTERRUPT_PENDING) {
            Object object2;
            if (activityContext.getStatus().getCompletionStatus() == CompletionStatus.FAILED) {
                object2 = "";
                if (activityContext.getLastFailure() != null) {
                    object2 = EventMessage.getInstance().formatMessage(activityContext.getLastFailure().getMessageContainer(), 0);
                }
                object = EventMessage.getContainer("JM_WORKFLOW_ACTIVITY_FAILED", activityContext.getDisplayName(), activityContext.getWorkflowName(), object2);
                this.writeEvent(EventSeverity.MAJOR, (EvMessageContainer)object);
            } else if (activityContext.getStatus().getCompletionStatus() == CompletionStatus.INTERRUPTED) {
                object2 = EventMessage.getContainer("JM_WORKFLOW_ACTIVITY_INTERRUPTED", activityContext.getDisplayName(), activityContext.getWorkflowName());
                this.writeEvent(EventSeverity.INFO, (EvMessageContainer)object2);
            }
        }
        if (SKIP_ATTEMPT_CREATION) {
            logger.trace(activityContext.getJobId(), "skip creating attempt per registry setting");
            return;
        }
        if (activityContext.isCommented()) {
            logger.debug(activityContext.getJobId(), "skip creating attempt for commented activity");
            return;
        }
        boolean bl = this.workflow.isForceWriteAttempts() ? false : (this.workflow.isForceDisableAttempts() ? true : activityContext.isSkipAttempt());
        if (bl) {
            if (!activityContext.getStatus().isJobComplete()) {
                logger.debug(activityContext.getJobId(), "activity is configure to skip creating attempt");
                return;
            }
            if (activityContext.getStatus() == ProcessStatus.COMPLETED && !activityContext.isCompletedWithErrors()) {
                logger.debug(activityContext.getJobId(), "activity is configure to skip creating attempt");
                return;
            }
            logger.debug(activityContext.getJobId(), "creating attempt for activity since it finished with status [%s]", activityContext.getStatus().toString());
        } else {
            logger.debug(activityContext.getJobId(), "creating attempt record for activity");
        }
        object = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = CommServUtils.getCommCellTime();
                int n = (int)(l / 1000L);
                int n2 = DateUtilities.getUnixTime((Date)activityContext.getStartTime());
                try {
                    JMAdminJobAttemptInfoTable_t jMAdminJobAttemptInfoTable_t;
                    JMAdminJobAttemptInfoTable_t jMAdminJobAttemptInfoTable_t2 = jMAdminJobAttemptInfoTable_t = activityContext.getAttemptRow();
                    synchronized (jMAdminJobAttemptInfoTable_t2) {
                        Object object;
                        if (!jMAdminJobAttemptInfoTable_t.isRowBound() && !jMAdminJobAttemptInfoTable_t.fill((String)(object = String.format("jobId = %s AND commCellId = %s AND phaseNum = %s AND attemptNum = 0", activityContext.getJobId(), activityContext.getCommCellId(), activityContext.getProcessStepId())))) {
                            JobManager.this.createJobOption(activityContext);
                            jMAdminJobAttemptInfoTable_t.zero();
                            jMAdminJobAttemptInfoTable_t.jobId.set(Integer.valueOf((int)activityContext.getJobId()));
                            jMAdminJobAttemptInfoTable_t.commCellId.set(Integer.valueOf(activityContext.getCommCellId()));
                            jMAdminJobAttemptInfoTable_t.phaseNum.set(activityContext.getProcessStepId());
                            jMAdminJobAttemptInfoTable_t.attemptNum.set(Integer.valueOf(0));
                            jMAdminJobAttemptInfoTable_t.phaseName.set(activityContext.getStepName());
                            jMAdminJobAttemptInfoTable_t.startTime.set(Integer.valueOf(n2));
                        }
                        if (activityContext.getStatus().isJobComplete() || activityContext.getStatus() == ProcessStatus.INTERRUPT_PENDING) {
                            object = activityContext.getStatus().getCompletionStatus();
                            jMAdminJobAttemptInfoTable_t.status.set(Integer.valueOf(object.toInt()));
                            jMAdminJobAttemptInfoTable_t.endTime.set(Integer.valueOf(n));
                            jMAdminJobAttemptInfoTable_t.embeddedObjects.set(Long.valueOf(0L));
                        } else {
                            jMAdminJobAttemptInfoTable_t.status.set(Integer.valueOf(0));
                            jMAdminJobAttemptInfoTable_t.elapsedTime.set(Integer.valueOf(n - n2));
                            jMAdminJobAttemptInfoTable_t.embeddedObjects.set(Long.valueOf(activityContext.getStatus().toInt()));
                            jMAdminJobAttemptInfoTable_t.failureReason.set(activityContext.getFailureReason());
                        }
                        jMAdminJobAttemptInfoTable_t.save();
                    }
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(activityContext.getJobId(), "error saving job manager attempt row", cTEDBException);
                }
            }
        };
        JobManager.submit((Runnable)object);
    }

    private void createJobOption(ActivityContext activityContext) throws CTEDBException {
        JMJobOptions_t jMJobOptions_t = new JMJobOptions_t();
        jMJobOptions_t.jobId.set(Integer.valueOf((int)activityContext.getJobId()));
        jMJobOptions_t.commCellId.set(Integer.valueOf(activityContext.getCommCellId()));
        jMJobOptions_t.attributeId.set(activityContext.getProcessStepId());
        jMJobOptions_t.attributeName.set("WF_Phase");
        jMJobOptions_t.attributeValue.set(activityContext.getDisplayName());
        jMJobOptions_t.attributeValueInt.set(Long.valueOf(0L));
        jMJobOptions_t.save();
    }

    @Override
    public void save() {
        try {
            this.saveJob();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error saving job manager for workflow [" + this.workflow.getName() + "]", cTEDBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePendingReason() {
        Object object = this.lock;
        synchronized (object) {
            this.jobInfoRow.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(CommServUtils.getCommCellTime())));
            this.jobInfoRow.failureReason.set(this.workflow.getFailureReason());
            try {
                this.jobInfoRow.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.workflow.getJobId(), "failed to update table [JMJobInfo]", cTEDBException);
                return;
            }
            this.updateFailureReasonCache();
        }
    }

    private int updateJob() {
        long l = CommServUtils.getCommCellTime();
        int n = (int)(l / 1000L);
        ProcessStatus processStatus = this.workflow.getStatus();
        this.jobInfoRow.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(l)));
        this.jobInfoRow.jobElapsedTime.set(Integer.valueOf(n - this.jobInfoRow.jobStartTime.get()));
        this.jobInfoRow.elapsedTime.set(Integer.valueOf(n - this.jobInfoRow.jobStartTime.get()));
        this.jobInfoRow.state.set(Integer.valueOf(processStatus.toInt()));
        this.jobInfoRow.displayState.set(Integer.valueOf(processStatus.toInt()));
        this.jobInfoRow.percentcomplete.set(Integer.valueOf(this.workflow.getCompletionPercentage()));
        this.jobInfoRow.failureReason.set(this.workflow.getFailureReason());
        this.jobInfoRow.lastUpdateFromClient.set(Integer.valueOf(n));
        this.jobStatsRow.jobDescription.set(this.workflow.getJobDescription());
        this.jobInfoRow.jobDescription.set(this.workflow.getJobDescription());
        this.adminJobInfoRow.status.set(Integer.valueOf(processStatus.toInt()));
        this.adminJobInfoRow.cloudId.set(Integer.valueOf(WorkflowProperties.getInstance().getClient().getClientId()));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveJob() throws CTEDBException {
        if (!this.jobInfoRow.isRowBound() || !this.adminJobInfoRow.isRowBound()) {
            logger.warn(this.workflow.getJobId(), "cannot save job manager records since they are not present");
            return;
        }
        ProcessStatus processStatus = this.workflow.getStatus();
        if (processStatus.isJobComplete()) {
            if (this.workflow.getExecutionState() == ExecutionState.STARTING || this.workflow.getExecutionState() == ExecutionState.RUNNING) {
                Object object = this.lock;
                synchronized (object) {
                    this.verifyJobManagerStatsRow();
                    this.completed = true;
                    logger.debug(this.workflow.getJobId(), "completing workflow [%s] with status [%s]", this.workflow.getName(), this.workflow.getStatus());
                    if (this.workflow.getStatus() == ProcessStatus.COMPLETED) {
                        this.workflow.getFailures().clear();
                    }
                    int n = this.updateJob();
                    EventManager.getInstance().fireWorkflowEndEvent(this.workflow);
                    logger.debug(this.workflow.getJobId(), "workflow [%s] completed with status [%s]", this.workflow.getName(), this.workflow.getStatus());
                    this.jobInfoRow.serverEndTime.set(Integer.valueOf(n));
                    this.adminJobInfoRow.servEnd.set(Integer.valueOf(n));
                    if (processStatus == ProcessStatus.COMPLETED || processStatus == ProcessStatus.COMPLETED_PARTIAL) {
                        this.jobInfoRow.percentcomplete.set(Integer.valueOf(100));
                    }
                    this.jobInfoRow.noOfGUIMonitors.set(Integer.valueOf(1));
                    this.jobInfoRow.timeToComplete.set(Integer.valueOf(0));
                    this.jobStatsRow.status.set(Integer.valueOf(2));
                    this.adminJobInfoRow.save();
                    this.jobStatsRow.save();
                    this.jobInfoRow.save();
                    JobManager.copyAdminJobInfoStats(this.jobStatsRow, this.jobInfoRow, this.adminJobInfoRow, this.workflow.getVersion(), this.workflow.getExecutorModel().getUserName());
                    JobManager.copyAdminJobAttemptStats(this.jobStatsRow);
                    this.jobInfoRow.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(CommServUtils.getCommCellTime())));
                    this.jobInfoRow.save();
                    this.saveWorkflowOutputs();
                    this.updateFailureReasonCache();
                }
            } else {
                logger.debug(this.workflow.getJobId(), "workflow [%s] was already completed", this.workflow.getName());
            }
        } else {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = JobManager.this.lock;
                        synchronized (object) {
                            if (JobManager.this.completed) {
                                return;
                            }
                            JobManager.this.updateJob();
                            JobManager.this.adminJobInfoRow.save();
                            JobManager.this.jobStatsRow.save();
                            JobManager.this.jobInfoRow.save();
                            if (((JobManager)JobManager.this).jobVersionRow.intData.get().intValue() != JobManager.this.workflow.getVersion()) {
                                ((JobManager)JobManager.this).jobVersionRow.intData.set(Integer.valueOf(JobManager.this.workflow.getVersion()));
                                JobManager.this.jobVersionRow.save();
                            }
                            JobManager.this.updateFailureReasonCache();
                        }
                    }
                    catch (Throwable throwable) {
                        logger.error(JobManager.this.workflow.getJobId(), "failed to save job manager tables for workflow job", throwable);
                    }
                }
            };
            JobManager.submit(runnable);
        }
    }

    private void saveWorkflowOutputs() {
        JMMisc_t jMMisc_t = new JMMisc_t();
        try {
            if (!jMMisc_t.fill("itemType = 28 and jobid=" + this.workflow.getJobId())) {
                jMMisc_t.zero();
                jMMisc_t.jobId.set(Integer.valueOf(Long.valueOf(this.workflow.getJobId()).intValue()));
                jMMisc_t.itemType.set(Integer.valueOf(28));
                jMMisc_t.commcellId.set(Integer.valueOf(2));
            }
            String string = String.format(JM_WORKFLOW_JOB_INFO, StringEscapeUtils.escapeXml((String)this.workflow.getOutputs()));
            jMMisc_t.data.set(string);
            jMMisc_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to update JMMisc table with workflow outputs", cTEDBException);
        }
    }

    private void updateFailureReasonCache() {
        if (!this.jobInfoRow.failureReason.get().equals(this.previousJPR)) {
            JobManager.updateFailureReasonCache(this.jobInfoRow);
            this.previousJPR = this.jobInfoRow.failureReason.get();
        }
    }

    private static void updateFailureReasonCache(JMJobInfo_t jMJobInfo_t) {
        JMBuildFailureReasonCache_p jMBuildFailureReasonCache_p = new JMBuildFailureReasonCache_p();
        jMBuildFailureReasonCache_p.i_jobId.set(jMJobInfo_t.jobId.get());
        jMBuildFailureReasonCache_p.i_commCellId.set(jMJobInfo_t.commCellId.get());
        jMBuildFailureReasonCache_p.i_reasonCode.set(jMJobInfo_t.failureReason.get());
        jMBuildFailureReasonCache_p.i_localeId.set(Integer.valueOf(0));
        jMBuildFailureReasonCache_p.i_clearOldCache.set(Integer.valueOf(0));
        try {
            jMBuildFailureReasonCache_p.execute();
        }
        catch (CTEDBException cTEDBException) {
            logger.error((long)jMJobInfo_t.jobId.get(), "failed to execute stored procedure [JMBuildFailureReasonCache]", cTEDBException);
        }
    }

    @Override
    public synchronized int getArchGroupId() {
        return this.adminJobInfoRow.archGrpID.get();
    }

    @Override
    public synchronized void setArchGroupId(int n) {
        this.adminJobInfoRow.archGrpID.set(Integer.valueOf(n));
    }

    @Override
    public synchronized int getReportType() {
        return this.adminJobInfoRow.reportType.get();
    }

    @Override
    public synchronized void setReportType(int n) {
        this.adminJobInfoRow.reportType.set(Integer.valueOf(n));
    }

    @Override
    public int getJobStartTime() {
        return this.jobInfoRow.jobStartTime.get();
    }

    @Override
    public boolean cleanup() {
        logger.debug(this.workflow.getJobId(), "cleaning up job manager records for workflow [%s]", this.workflow.getName());
        try {
            if (this.jobInfoRow.delete()) {
                logger.debug(this.workflow.getJobId(), "cleaned up JMJobInfo records for workflow [%s]", this.workflow.getName());
            } else {
                logger.debug(this.workflow.getJobId(), "no job manager records where cleaned for workflow [%s]", this.workflow.getName());
            }
            return true;
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to cleanup job manager records for workflow [" + this.workflow.getName() + "]", cTEDBException);
            return false;
        }
    }

    @Override
    public void checkStaleRecords() {
        if (this.workflow.getExecutionState() == ExecutionState.COMPLETED) {
            JMJobInfo_t jMJobInfo_t = new JMJobInfo_t();
            String string = String.format("jobId = %s AND commCellId = %s", this.workflow.getJobId(), this.workflow.getCommCellId());
            try {
                if (jMJobInfo_t.fill(string)) {
                    logger.info(this.workflow.getJobId(), "cleaning up stale JMJobInfo records for workflow [%s]", this.workflow.getName());
                    try {
                        jMJobInfo_t.delete();
                    }
                    catch (CTEDBException cTEDBException) {
                        logger.error(this.workflow.getJobId(), "failed to cleanup stale job records for workflow [" + this.workflow.getName() + "]", cTEDBException);
                    }
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.workflow.getJobId(), "failed to check for stale job records for workflow [" + this.workflow.getName() + "]", cTEDBException);
            }
        }
    }

    @Override
    public void writeEvent(EventSeverity eventSeverity, EvMessageContainer evMessageContainer) {
        EvEvent evEvent = new EvEvent(eventSeverity, this.workflow.getJobId(), this.workflow.getTaskId(), this.workflow.getSubTaskId(), evMessageContainer);
        EventMessage.getInstance().generateEvent(evEvent);
    }

    @Override
    public void writeAlert(AlertCriteria alertCriteria) {
        String string;
        try {
            string = XMLEncoder.encode((Object)alertCriteria);
        }
        catch (Exception exception) {
            logger.error("failed to encode Workflow::AlertCriteria", exception);
            return;
        }
        logger.xml("sending alert type [%s], criteria xml [%s]", alertCriteria.getAlertType().toString(), string);
        try {
            if (!EventMessage.getInstance().sendAlert(string)) {
                logger.error(alertCriteria.getJobId(), "failed to send alert type [" + alertCriteria.getAlertType().toString() + "], check Workflow.log for additional details, xml [" + string + "]");
            }
        }
        catch (Throwable throwable) {
            logger.error(alertCriteria.getJobId(), "failed to send alert type [" + alertCriteria.getAlertType().toString() + "], xml [" + string + "]", throwable);
        }
    }

    @Override
    public Integer writeFailure(int n, EvMessageContainer evMessageContainer) throws Exception {
        Object object;
        JMFailureReasonMsg_t jMFailureReasonMsg_t = new JMFailureReasonMsg_t();
        jMFailureReasonMsg_t.messageId.set(Integer.valueOf(evMessageContainer.getMessageId()));
        jMFailureReasonMsg_t.paramNum.set(Integer.valueOf(evMessageContainer.getArgumentInfo().getArguments().size()));
        jMFailureReasonMsg_t.errorType.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.commCellId.set(Integer.valueOf(this.workflow.getCommCellId()));
        jMFailureReasonMsg_t.jobId.set(Integer.valueOf((int)this.workflow.getJobId()));
        jMFailureReasonMsg_t.client.set(WorkflowProperties.getInstance().getClient().getClientName());
        jMFailureReasonMsg_t.subsystem.set("Workflow");
        jMFailureReasonMsg_t.copyId.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.rcId.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.reservationId.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.flags.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.guiAlertColorLevel.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.clientVersion.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.serverVersion.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.iDA.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.opType.set(Integer.valueOf(WorkflowRegistry.getInstance().getJMOpType()));
        jMFailureReasonMsg_t.phaseNumber.set(Integer.valueOf(n));
        jMFailureReasonMsg_t.customMessageId.set(Integer.valueOf(0));
        jMFailureReasonMsg_t.failureReasonTime.set(Integer.valueOf(DateUtilities.getNow()));
        try {
            jMFailureReasonMsg_t.save();
        }
        catch (CTEDBException cTEDBException) {
            throw new Exception("failed to write error information to CommCell", cTEDBException);
        }
        ArrayList arrayList = new ArrayList();
        try {
            object = evMessageContainer.getArgumentInfo().getArguments();
            if (object.size() > 0) {
                for (int i = 0; i < object.size(); ++i) {
                    logger.debug(this.workflow.getJobId(), "adding argument to procedure [%s]", ((ArgumentInfoXML)object.get(i)).getArg());
                    JMFailureReasonMsgParamTmp_t jMFailureReasonMsgParamTmp_t = new JMFailureReasonMsgParamTmp_t();
                    jMFailureReasonMsgParamTmp_t.msgId.set(jMFailureReasonMsg_t.id.get());
                    jMFailureReasonMsgParamTmp_t.position.set(Integer.valueOf(i + 1));
                    jMFailureReasonMsgParamTmp_t.type.set(Integer.valueOf(((ArgumentInfoXML)object.get(i)).getType()));
                    jMFailureReasonMsgParamTmp_t.size.set(Integer.valueOf((int)((ArgumentInfoXML)object.get(i)).getSize()));
                    jMFailureReasonMsgParamTmp_t.data.set(((ArgumentInfoXML)object.get(i)).getArg());
                    jMFailureReasonMsgParamTmp_t.save();
                }
            }
        }
        catch (Exception exception) {
            this.cleanupParamTable(jMFailureReasonMsg_t.id.get());
            throw new Exception("failed to add JPR paramter", exception);
        }
        try {
            object = new JMAddJobPendingParam_p();
            ((JMAddJobPendingParam_p)((Object)object)).i_MsgId.set(jMFailureReasonMsg_t.id.get());
            JMAddJobPendingParam_t jMAddJobPendingParam_t = ((JMAddJobPendingParam_p)((Object)object)).executeQuery();
            if (jMAddJobPendingParam_t.r_MsgId.get() < 0) {
                logger.error(this.workflow.getJobId(), "Stored Procedure to insert the failure reason returned error. Event Id [" + evMessageContainer.getMessageId() + "]. Number of Parameters [" + evMessageContainer.getArgumentInfo().getArguments().size() + "]. Error = [" + jMAddJobPendingParam_t.r_ErrorStr.get() + "]");
            }
        }
        catch (CTEDBException cTEDBException) {
            this.cleanupParamTable(jMFailureReasonMsg_t.id.get());
            throw new Exception("failed to execute procedure JMAddJobPendingParam", cTEDBException);
        }
        this.cleanupParamTable(jMFailureReasonMsg_t.id.get());
        return jMFailureReasonMsg_t.id.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupParamTable(int n) {
        String string = String.format("delete from JMFailureReasonMsgParamTmp where msgId = %s", n);
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            cTEDBReservation.executeUpdate(string);
        }
    }

    private void initJobManagerStatsRow() throws CTEDBException {
        this.jobStatsRow = new JMJobStats_t();
        String string = String.format("jobId = %s AND commCellId = %s", this.workflow.getJobId(), this.workflow.getCommCellId());
        if (!this.jobStatsRow.fill(string)) {
            logger.debug(this.workflow.getJobId(), "creating new commserve JMJobStats row");
            this.jobStatsRow.jobId.set(Integer.valueOf((int)this.workflow.getJobId()));
            this.jobStatsRow.commCellId.set(Integer.valueOf(this.workflow.getCommCellId()));
            this.jobStatsRow.status.set(Integer.valueOf(1));
            this.jobStatsRow.opType.set(Integer.valueOf(WorkflowRegistry.getInstance().getJMOpType()));
            this.jobStatsRow.jobCategory.set(Integer.valueOf(3));
            this.jobStatsRow.jobDescription.set("");
            this.jobStatsRow.xmlJobInfo.set(this.workflow.getXmlJobInfo());
            this.jobStatsRow.subOpType.set(Integer.valueOf(0));
            this.jobStatsRow.foreignToken.set("");
            if (!this.jobStatsRow.save()) {
                throw new Error("failed to create job stats row");
            }
        } else {
            logger.debug(this.workflow.getJobId(), "retrieved existing commserve JMJobStats row");
        }
    }

    private void verifyJobManagerStatsRow() throws CTEDBException {
        JMJobStats_t jMJobStats_t = new JMJobStats_t();
        String string = String.format("jobId = %s AND commCellId = %s", this.workflow.getJobId(), this.workflow.getCommCellId());
        if (!jMJobStats_t.fill(string)) {
            logger.debug(this.workflow.getJobId(), "creating new commserve JMJobStats row");
            jMJobStats_t.jobId.set(Integer.valueOf((int)this.workflow.getJobId()));
            jMJobStats_t.commCellId.set(Integer.valueOf(this.workflow.getCommCellId()));
            jMJobStats_t.status.set(Integer.valueOf(1));
            jMJobStats_t.opType.set(Integer.valueOf(WorkflowRegistry.getInstance().getJMOpType()));
            jMJobStats_t.jobCategory.set(Integer.valueOf(3));
            jMJobStats_t.jobDescription.set("");
            jMJobStats_t.xmlJobInfo.set(this.workflow.getXmlJobInfo());
            jMJobStats_t.subOpType.set(Integer.valueOf(0));
            jMJobStats_t.foreignToken.set("");
            if (!jMJobStats_t.save()) {
                throw new Error("failed to create job stats row");
            }
            this.jobStatsRow = jMJobStats_t;
        }
    }

    private void initJobInfoRow() throws CTEDBException {
        this.jobInfoRow = new JMJobInfo_t();
        String string = String.format("jobId = %s AND commCellId = %s", this.workflow.getJobId(), this.workflow.getCommCellId());
        if (!this.jobInfoRow.fill(string) && !this.workflow.getStatus().isJobComplete()) {
            long l = CommServUtils.getCommCellTime();
            int n = (int)(l / 1000L);
            this.jobInfoRow.zero();
            logger.debug(this.workflow.getJobId(), "creating new commserve JMJobInfo row");
            this.jobInfoRow.jobId.set(Integer.valueOf((int)this.workflow.getJobId()));
            this.jobInfoRow.commCellId.set(Integer.valueOf(this.workflow.getCommCellId()));
            this.jobInfoRow.initFrom.set(Integer.valueOf(this.workflow.getInitFrom().getEnumValue()));
            this.jobInfoRow.opType.set(Integer.valueOf(WorkflowRegistry.getInstance().getJMOpType()));
            this.jobInfoRow.currentPhase.set(Integer.valueOf(0));
            this.jobInfoRow.currentPhaseName.set("");
            this.jobInfoRow.attemptStartTime.set(Integer.valueOf(0));
            this.jobInfoRow.jobStartTime.set(Integer.valueOf(n));
            this.jobInfoRow.serverEndTime.set(Integer.valueOf(-1));
            this.jobInfoRow.jobElapsedTime.set(Integer.valueOf(0));
            this.jobInfoRow.elapsedTime.set(Integer.valueOf(0));
            this.jobInfoRow.lastStartOrRun.set(Integer.valueOf(n));
            this.jobInfoRow.startAttempts.set(Integer.valueOf(1));
            this.jobInfoRow.runAttempts.set(Integer.valueOf(1));
            if (this.workflow.isDisabled()) {
                this.jobInfoRow.state.set(Integer.valueOf(ProcessStatus.FAILED.toInt()));
                this.jobInfoRow.displayState.set(Integer.valueOf(ProcessStatus.FAILED.toInt()));
            } else {
                this.jobInfoRow.state.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
                this.jobInfoRow.displayState.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
            }
            this.jobInfoRow.userId.set(Integer.valueOf(this.workflow.getExecutorId()));
            this.jobInfoRow.opUsername.set(this.workflow.getExecutor());
            this.jobInfoRow.lastStateChangeTime.set(Long.valueOf(JobManager.getLastStateChangeTime(l)));
            this.jobInfoRow.pendingCause.set(Integer.valueOf(0));
            this.jobInfoRow.errorType.set(Integer.valueOf(0));
            this.jobInfoRow.failureReason.set("");
            this.jobInfoRow.percentcomplete.set(Integer.valueOf(0));
            this.jobInfoRow.jobDescription.set("");
            this.jobInfoRow.xmlJobInfo.set(this.workflow.getXmlJobInfo());
            this.jobInfoRow.clientPriority.set(Integer.valueOf(9));
            this.jobInfoRow.opPriority.set(Integer.valueOf(9));
            this.jobInfoRow.appPriority.set(Integer.valueOf(9));
            this.jobInfoRow.restartable.set(Integer.valueOf(1));
            this.jobInfoRow.preemptable.set(Integer.valueOf(1));
            this.jobInfoRow.taskLinkID.set(Integer.valueOf(1));
            this.jobInfoRow.jobCategory.set(Integer.valueOf(3));
            this.jobInfoRow.timeToComplete.set(Integer.valueOf(-1));
            if (!this.jobInfoRow.save()) {
                throw new Error("failed to create job info row");
            }
        } else {
            logger.debug(this.workflow.getJobId(), "retrieved existing commserve JMJobInfo row");
        }
    }

    private void initAdminJobInfoRow() throws CTEDBException {
        this.adminJobInfoRow = new JMAdminJobInfoTable_t();
        String string = String.format("jobId = %s AND commCellId = %s", this.workflow.getJobId(), this.workflow.getCommCellId());
        if (!this.adminJobInfoRow.fill(string) && !this.workflow.getStatus().isJobComplete()) {
            long l = CommServUtils.getCommCellTime();
            int n = (int)(l / 1000L);
            this.adminJobInfoRow.zero();
            logger.debug(this.workflow.getJobId(), "creating new commserve JMAdminJobInfoTable row");
            this.adminJobInfoRow.jobId.set(Integer.valueOf((int)this.workflow.getJobId()));
            this.adminJobInfoRow.commCellId.set(Integer.valueOf(this.workflow.getCommCellId()));
            this.adminJobInfoRow.opType.set(Integer.valueOf(WorkflowRegistry.getInstance().getJMOpType()));
            if (this.workflow.isDisabled()) {
                this.adminJobInfoRow.status.set(Integer.valueOf(ProcessStatus.FAILED.toInt()));
            } else {
                this.adminJobInfoRow.status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
            }
            this.adminJobInfoRow.servStart.set(Integer.valueOf(n));
            this.adminJobInfoRow.servEnd.set(Integer.valueOf(-1));
            this.adminJobInfoRow.cloudId.set(Integer.valueOf(WorkflowProperties.getInstance().getClient().getClientId()));
            this.adminJobInfoRow.workFlowId.set(Integer.valueOf(this.workflow.getWorkflowId()));
            this.adminJobInfoRow.subTaskId.set(Integer.valueOf(this.workflow.getSubTaskId()));
            this.adminJobInfoRow.archGrpID.set(Integer.valueOf(1));
            this.adminJobInfoRow.maxRestarts.set(Integer.valueOf(this.workflow.getJobSettings().getMaxRestarts()));
            this.adminJobInfoRow.restartInterval.set(Integer.valueOf(this.workflow.getJobSettings().getRestartInterval()));
            if (WorkflowRegistry.getInstance().isAppendWorkflowOperation()) {
                this.adminJobInfoRow.otherOpName.set("Workflow - " + this.workflow.getName());
            } else {
                this.adminJobInfoRow.otherOpName.set(this.workflow.getName());
            }
            if (!this.adminJobInfoRow.save()) {
                throw new Error("failed to create admin job info row");
            }
        } else {
            logger.debug(this.workflow.getJobId(), "retrieved existing commserve JMAdminJobInfoTable row");
        }
    }

    private void initMiscRows() throws CTEDBException {
        Object object;
        this.jobVersionRow = null;
        String string = String.format("jobId = %s AND commCellId = %s", this.workflow.getJobId(), this.workflow.getCommCellId());
        List<JMMisc_t> list = JMMisc_t.select(string);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((JMMisc_t)((Object)object)).itemType.get() != 90) continue;
            this.jobVersionRow = object;
        }
        if (this.jobVersionRow == null) {
            this.jobVersionRow = new JMMisc_t();
            this.jobVersionRow.jobId.set(Integer.valueOf(Long.valueOf(this.workflow.getJobId()).intValue()));
            this.jobVersionRow.commcellId.set(Integer.valueOf(this.workflow.getCommCellId()));
            this.jobVersionRow.selfRefId.set(Integer.valueOf(0));
            this.jobVersionRow.itemType.set(Integer.valueOf(90));
            this.jobVersionRow.attribute.set(Integer.valueOf(0));
            this.jobVersionRow.intData.set(Integer.valueOf(this.workflow.getVersion()));
            this.jobVersionRow.data.set("");
            this.jobVersionRow.save();
        }
        if ((object = JMJobOptions_t.select((String)(object2 = String.format("jobId = %s AND commCellId = %s AND attributeId = 0 AND attributeName = 'workflowId'", this.workflow.getJobId(), this.workflow.getCommCellId())))).size() == 0) {
            JMJobOptions_t jMJobOptions_t = new JMJobOptions_t();
            jMJobOptions_t.jobId.set(Integer.valueOf(Long.valueOf(this.workflow.getJobId()).intValue()));
            jMJobOptions_t.commCellId.set(Integer.valueOf(this.workflow.getCommCellId()));
            jMJobOptions_t.attributeId.set(Integer.valueOf(0));
            jMJobOptions_t.attributeName.set("workflowId");
            jMJobOptions_t.attributeValue.set("");
            jMJobOptions_t.attributeValueInt.set(Long.valueOf(this.workflow.getWorkflowId()));
            try {
                jMJobOptions_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.workflow.getJobId(), "failed to write workflow id [" + this.workflow.getWorkflowId() + "] to job options table", cTEDBException);
            }
        }
    }

    private static void copyAdminJobAttemptStats(JMJobStats_t jMJobStats_t) throws CTEDBException {
        logger.trace((long)jMJobStats_t.jobId.get(), "copying entries from JMAdminJobAttemptInfoTable to JMAdminJobAttemptStatsTable");
        String string = String.format("jobId = %s AND commCellId = %s", jMJobStats_t.jobId.get(), jMJobStats_t.commCellId.get());
        List<JMAdminJobAttemptInfoTable_t> list = JMAdminJobAttemptInfoTable_t.select(string);
        for (JMAdminJobAttemptInfoTable_t jMAdminJobAttemptInfoTable_t : list) {
            JMAdminJobAttemptStatsTable_t jMAdminJobAttemptStatsTable_t = new JMAdminJobAttemptStatsTable_t();
            String string2 = String.format("jobId = %s AND commCellId = %s AND phaseNum = %s AND attemptNum = %s", jMAdminJobAttemptInfoTable_t.jobId.get(), jMAdminJobAttemptInfoTable_t.commCellId.get(), jMAdminJobAttemptInfoTable_t.phaseNum.get(), jMAdminJobAttemptInfoTable_t.attemptNum.get());
            if (!jMAdminJobAttemptStatsTable_t.fill(string2)) {
                jMAdminJobAttemptStatsTable_t.zero();
                jMAdminJobAttemptStatsTable_t.jobId.set(jMAdminJobAttemptInfoTable_t.jobId.get());
                jMAdminJobAttemptStatsTable_t.commCellId.set(jMAdminJobAttemptInfoTable_t.commCellId.get());
                jMAdminJobAttemptStatsTable_t.phaseNum.set(jMAdminJobAttemptInfoTable_t.phaseNum.get());
                jMAdminJobAttemptStatsTable_t.attemptNum.set(jMAdminJobAttemptInfoTable_t.attemptNum.get());
            }
            jMAdminJobAttemptStatsTable_t.status.set(jMAdminJobAttemptInfoTable_t.status.get());
            jMAdminJobAttemptStatsTable_t.startTime.set(jMAdminJobAttemptInfoTable_t.startTime.get());
            jMAdminJobAttemptStatsTable_t.endTime.set(jMAdminJobAttemptInfoTable_t.endTime.get());
            jMAdminJobAttemptStatsTable_t.elapsedTime.set(jMAdminJobAttemptInfoTable_t.elapsedTime.get());
            jMAdminJobAttemptStatsTable_t.failureReason.set(jMAdminJobAttemptInfoTable_t.failureReason.get());
            jMAdminJobAttemptStatsTable_t.writeTime.set(jMAdminJobAttemptInfoTable_t.writeTime.get());
            jMAdminJobAttemptStatsTable_t.embeddedObjects.set(jMAdminJobAttemptInfoTable_t.embeddedObjects.get());
            jMAdminJobAttemptStatsTable_t.uncompBytes.set(jMAdminJobAttemptInfoTable_t.uncompBytes.get());
            jMAdminJobAttemptStatsTable_t.numFiles.set(jMAdminJobAttemptInfoTable_t.numFiles.get());
            jMAdminJobAttemptStatsTable_t.skippedItems.set(jMAdminJobAttemptInfoTable_t.skippedItems.get());
            jMAdminJobAttemptStatsTable_t.TotalSize.set(jMAdminJobAttemptInfoTable_t.TotalSize.get());
            jMAdminJobAttemptStatsTable_t.nwTransBytes.set(jMAdminJobAttemptInfoTable_t.nwTransBytes.get());
            jMAdminJobAttemptStatsTable_t.totalAllocationTime.set(jMAdminJobAttemptInfoTable_t.totalAllocationTime.get());
            jMAdminJobAttemptStatsTable_t.totalWaitTimeBeforeAllocation.set(jMAdminJobAttemptInfoTable_t.totalWaitTimeBeforeAllocation.get());
            jMAdminJobAttemptStatsTable_t.save();
        }
    }

    private static void copyAdminJobInfoStats(JMJobStats_t jMJobStats_t, JMJobInfo_t jMJobInfo_t, JMAdminJobInfoTable_t jMAdminJobInfoTable_t, int n, String string) throws CTEDBException {
        logger.trace((long)jMJobStats_t.jobId.get(), "copying entry from JMAdminJobInfoTable to JMAdminJobStatsTable");
        JMAdminJobStatsTable_t jMAdminJobStatsTable_t = new JMAdminJobStatsTable_t();
        String string2 = String.format("jobId = %s AND commCellId = %s", jMAdminJobInfoTable_t.jobId.get(), jMAdminJobInfoTable_t.commCellId.get());
        if (!jMAdminJobStatsTable_t.fill(string2)) {
            jMAdminJobStatsTable_t.zero();
            jMAdminJobStatsTable_t.jobId.set(jMAdminJobInfoTable_t.jobId.get());
            jMAdminJobStatsTable_t.commCellId.set(jMAdminJobInfoTable_t.commCellId.get());
        }
        ProcessStatus processStatus = ProcessStatus.fromInt((int)jMAdminJobInfoTable_t.status.get());
        jMAdminJobStatsTable_t.status.set(Integer.valueOf(processStatus.getCompletionStatus().toInt()));
        jMAdminJobStatsTable_t.version.set(Integer.valueOf(n));
        jMAdminJobStatsTable_t.username.set(string);
        jMAdminJobStatsTable_t.failureErrorCode.set(Integer.valueOf(0));
        jMAdminJobStatsTable_t.opType.set(jMAdminJobInfoTable_t.opType.get());
        jMAdminJobStatsTable_t.servStart.set(jMAdminJobInfoTable_t.servStart.get());
        jMAdminJobStatsTable_t.servEnd.set(jMAdminJobInfoTable_t.servEnd.get());
        jMAdminJobStatsTable_t.workFlowId.set(jMAdminJobInfoTable_t.workFlowId.get());
        jMAdminJobStatsTable_t.archGrpID.set(jMAdminJobInfoTable_t.archGrpID.get());
        jMAdminJobStatsTable_t.archGrpName.set(jMAdminJobInfoTable_t.archGrpName.get());
        jMAdminJobStatsTable_t.AP_NumDays.set(jMAdminJobInfoTable_t.AP_NumDays.get());
        jMAdminJobStatsTable_t.AP_IsForecast.set(jMAdminJobInfoTable_t.AP_IsForecast.get());
        jMAdminJobStatsTable_t.AP_SeqNum.set(jMAdminJobInfoTable_t.AP_SeqNum.get());
        jMAdminJobStatsTable_t.AC_NewMediaFlag.set(jMAdminJobInfoTable_t.AC_NewMediaFlag.get());
        jMAdminJobStatsTable_t.ER_BkpLevel.set(jMAdminJobInfoTable_t.ER_BkpLevel.get());
        jMAdminJobStatsTable_t.ER_DbName.set(jMAdminJobInfoTable_t.ER_DbName.get());
        jMAdminJobStatsTable_t.ER_Destination.set(jMAdminJobInfoTable_t.ER_Destination.get());
        jMAdminJobStatsTable_t.ER_SendCount.set(jMAdminJobInfoTable_t.ER_SendCount.get());
        jMAdminJobStatsTable_t.ER_MediasUsed.set(jMAdminJobInfoTable_t.ER_MediasUsed.get());
        jMAdminJobStatsTable_t.initFrom.set(jMJobInfo_t.initFrom.get());
        jMAdminJobStatsTable_t.failureReason.set(jMJobInfo_t.failureReason.get());
        jMAdminJobStatsTable_t.archGrpCopyID.set(jMAdminJobInfoTable_t.archGrpCopyID.get());
        jMAdminJobStatsTable_t.LibraryID.set(jMAdminJobInfoTable_t.LibraryID.get());
        jMAdminJobStatsTable_t.MI_InventoryType.set(jMAdminJobInfoTable_t.MI_InventoryType.get());
        jMAdminJobStatsTable_t.noOfStreams.set(jMAdminJobInfoTable_t.noOfStreams.get());
        jMAdminJobStatsTable_t.appID.set(jMAdminJobInfoTable_t.appID.get());
        jMAdminJobStatsTable_t.TotalSize.set(jMAdminJobInfoTable_t.TotalSize.get());
        jMAdminJobStatsTable_t.embeddedObjects.set(jMAdminJobInfoTable_t.embeddedObjects.get());
        jMAdminJobStatsTable_t.uncompBytes.set(jMAdminJobInfoTable_t.uncompBytes.get());
        jMAdminJobStatsTable_t.numFiles.set(jMAdminJobInfoTable_t.numFiles.get());
        jMAdminJobStatsTable_t.skippedItems.set(jMAdminJobInfoTable_t.skippedItems.get());
        jMAdminJobStatsTable_t.cloudId.set(jMAdminJobInfoTable_t.cloudId.get());
        jMAdminJobStatsTable_t.fromTime.set(jMAdminJobInfoTable_t.fromTime.get());
        jMAdminJobStatsTable_t.toTime.set(jMAdminJobInfoTable_t.toTime.get());
        jMAdminJobStatsTable_t.subTaskId.set(jMAdminJobInfoTable_t.subTaskId.get());
        jMAdminJobStatsTable_t.otherOpName.set(jMAdminJobInfoTable_t.otherOpName.get());
        jMAdminJobStatsTable_t.nwTransBytes.set(jMAdminJobInfoTable_t.nwTransBytes.get());
        jMAdminJobStatsTable_t.save();
    }

    static {
        int n = WorkflowRegistry.getInstance().getJobManagerThreads();
        DB_EXEC = n > 0 ? new ThreadPoolExecutor(0, n, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("JMThread-" + String.valueOf(this.count.incrementAndGet()));
                return thread;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy()) : null;
    }
}

