/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.PackageImporter;
import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.SchemaLocationType;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;

public class InternalClassPath
implements Repeatable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InternalClassPath.class);
    private static InternalClassPath instance = new InternalClassPath();
    private final File packageFolder;
    private Map<String, File> localPackages = new ConcurrentHashMap<String, File>();

    public static InternalClassPath getInstance() {
        return instance;
    }

    private InternalClassPath() {
        logger.trace("initializing local class path");
        String string = WorkflowRegistry.getInstance().getClassPathFolder();
        if (string == null || string.trim().length() == 0) {
            logger.warn("invalid class path folder in registry, defaulting to [classpath]");
            string = "classpath";
        }
        this.packageFolder = new File(WorkflowRegistry.getInstance().getInstallFolder(), string);
        if (!this.packageFolder.exists()) {
            logger.debug("creating local class path folder [%s]", this.packageFolder.getAbsolutePath());
            this.packageFolder.mkdir();
        }
        this.validate();
    }

    @Override
    public void run() {
    }

    @Override
    public int getInterval() {
        return WorkflowRegistry.getInstance().getClassPathRefreshInterval();
    }

    private void checkInternal() {
        List<WF_SchemaLocation_t> list;
        logger.trace("checking internal classpath");
        String string = String.format("LocationType = %s", SchemaLocationType.INTERNAL.getEnumValue());
        try {
            list = WF_SchemaLocation_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error selecting from WF_SchemaLocation using where clause [" + string + "]", cTEDBException);
            return;
        }
        for (WF_SchemaLocation_t wF_SchemaLocation_t : list) {
            File file = new File(WorkflowRegistry.getInstance().getInstallFolder(), wF_SchemaLocation_t.LocationUrl.get());
            if (!file.exists()) {
                logger.error("could not find internal jar file [" + file.getAbsolutePath() + "]");
                continue;
            }
            boolean bl = false;
            if (wF_SchemaLocation_t.MD5CheckSum.isNull() || wF_SchemaLocation_t.MD5CheckSum.get().length() == 0) {
                logger.info("updating internal jar [%s] since md5 checksum in database is null", wF_SchemaLocation_t.LocationUrl.get());
                bl = true;
            } else {
                JarFile jarFile;
                String string2;
                try {
                    string2 = WorkflowUtils.getMD5Checksum(file);
                }
                catch (Exception exception) {
                    logger.error("failed to create md5 checksum from internal file [" + file.getAbsolutePath() + "]", exception);
                    continue;
                }
                if (string2.equals(wF_SchemaLocation_t.MD5CheckSum.get())) continue;
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException iOException) {
                    logger.error("failed to load JarFile from local file [" + file.getAbsolutePath() + "]", iOException);
                    continue;
                }
                double d = WorkflowUtils.getManifestVersion(jarFile);
                if (d > wF_SchemaLocation_t.Version.get()) {
                    logger.info("updating internal jar [%s] since local jar version [%s] is greater then database version [%s]", wF_SchemaLocation_t.LocationUrl.get(), d, wF_SchemaLocation_t.Version.get());
                    bl = true;
                }
            }
            if (!bl) continue;
            try {
                PackageImporter.importPackage(file);
            }
            catch (EvFailureException evFailureException) {
                logger.error("failed to update WF_SchemaLocation entry for id [" + wF_SchemaLocation_t.LocationId.get() + "]", evFailureException);
            }
        }
    }

    private void validate() {
        List<WF_SchemaLocation_t> list;
        logger.trace("validating local classpath");
        String string = String.format("LocationType = %s", SchemaLocationType.JAR.getEnumValue());
        try {
            list = WF_SchemaLocation_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error selecting from WF_SchemaLocation using where clause [" + string + "]", cTEDBException);
            return;
        }
        boolean bl = true;
        for (WF_SchemaLocation_t wF_SchemaLocation_t : list) {
            File file = this.localPackages.get(wF_SchemaLocation_t.LocationUrl.get().toLowerCase());
            if (file == null) {
                logger.warn("local engine is missing activity package [%s]", wF_SchemaLocation_t.LocationUrl.get());
                bl = false;
                continue;
            }
            try {
                String string2 = WorkflowUtils.getMD5Checksum(file);
                if (wF_SchemaLocation_t.MD5CheckSum.isNull()) {
                    logger.warn("imported package [%s] does not contain an md5 checksum", file.getName());
                    bl = false;
                    continue;
                }
                if (wF_SchemaLocation_t.MD5CheckSum.get().equals(string2)) continue;
                logger.warn("local package [%s] failed md5 checksum", file.getName());
                bl = false;
            }
            catch (Exception exception) {
                logger.error("failed to generate checksum for file [" + file.getAbsolutePath() + "]", exception);
            }
        }
        if (bl) {
            logger.debug("all activity packages are imported and up to date");
        }
    }

    public synchronized File getSystemPackage(String string) {
        return new File(WorkflowRegistry.getInstance().getInstallFolder(), string);
    }

    public synchronized File getPackage(String string) {
        return this.localPackages.get(string.toLowerCase());
    }
}

