/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.InputPageRequest;
import commvault.msgs.Workflow.PageControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputFormManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InputFormManager.class);
    private static final double PAGE_SIZE = 100.0;
    private Map<String, OptionGroup> cache = new HashMap<String, OptionGroup>();

    public InputFormManager(InputForm inputForm, boolean bl) {
        for (XMLSchema xMLSchema : inputForm.getEntries()) {
            if (bl || !xMLSchema.getSearchable()) continue;
            this.cache.put(xMLSchema.getInputName().toLowerCase(), new OptionGroup(xMLSchema.getOptions(), xMLSchema.getLabelsForOptions()));
            this.process(xMLSchema, PageControl.FIRST, "");
            if (xMLSchema.getTotalPages() <= 1 || xMLSchema.getDefaultValue().length() <= 0 || this.containsDefaultValue(xMLSchema)) continue;
            boolean bl2 = false;
            while (xMLSchema.getCurrentPage() < xMLSchema.getTotalPages()) {
                this.process(xMLSchema, PageControl.NEXT, "");
                if (!this.containsDefaultValue(xMLSchema)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            logger.warn("could not find default value [" + xMLSchema.getDefaultValue() + "] in options for entry [" + xMLSchema.getName() + "]");
            this.process(xMLSchema, PageControl.FIRST, "");
        }
    }

    private boolean containsDefaultValue(XMLSchema xMLSchema) {
        for (String string : xMLSchema.getOptions()) {
            if (!string.equalsIgnoreCase(xMLSchema.getDefaultValue())) continue;
            return true;
        }
        return false;
    }

    public XMLSchema process(InputPageRequest inputPageRequest) {
        return this.process(inputPageRequest.getInput(), inputPageRequest.getPageControl(), inputPageRequest.getSearch());
    }

    public XMLSchema process(XMLSchema xMLSchema, PageControl pageControl, String string) {
        int n;
        OptionGroup optionGroup = this.cache.get(xMLSchema.getInputName().toLowerCase());
        if (optionGroup == null) {
            logger.warn("cannot page input name [" + xMLSchema.getInputName() + "] since it does not have any searchable options");
            return xMLSchema;
        }
        ArrayList<OptionLabel> arrayList = optionGroup.options;
        xMLSchema.getOptions().clear();
        xMLSchema.getLabelsForOptions().clear();
        if (string.length() > 0) {
            ArrayList<OptionLabel> arrayList2 = new ArrayList<OptionLabel>();
            if (optionGroup.optionOnly) {
                for (OptionLabel optionLabel : optionGroup.options) {
                    if (optionLabel.option.toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
                    arrayList2.add(optionLabel);
                }
            } else {
                for (OptionLabel optionLabel : optionGroup.options) {
                    if (optionLabel.label.toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
                    arrayList2.add(optionLabel);
                }
            }
            logger.debug("search term [%s] on input [%s] returned [%s] results", string, xMLSchema.getInputName(), arrayList2.size());
            arrayList = arrayList2;
        }
        xMLSchema.setTotalPages((int)Math.ceil((double)arrayList.size() / 100.0));
        xMLSchema.setTotalResults(arrayList.size());
        if (arrayList.size() == 0) {
            xMLSchema.setCurrentPage(1);
            return xMLSchema;
        }
        int n2 = xMLSchema.getCurrentPage() - 1;
        n2 = pageControl == PageControl.NEXT ? ++n2 : (pageControl == PageControl.PREVIOUS ? --n2 : (pageControl == PageControl.LAST ? xMLSchema.getTotalPages() - 1 : (pageControl == PageControl.SELECTION ? xMLSchema.getCurrentPage() - 1 : 0)));
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > xMLSchema.getTotalPages() - 1) {
            n2 = xMLSchema.getTotalPages() - 1;
        }
        xMLSchema.setCurrentPage(n2 + 1);
        int n3 = (int)((double)n2 * 100.0);
        int n4 = (int)((double)n3 + 100.0);
        for (n = n3; n < n4 && n < arrayList.size(); ++n) {
            xMLSchema.getOptions().add(((OptionLabel)arrayList.get(n)).option);
            if (optionGroup.optionOnly) continue;
            xMLSchema.getLabelsForOptions().add(((OptionLabel)arrayList.get(n)).label);
        }
        logger.info("returning selectable options from page [%s], start index [%s], end index [%s], completed index [%s], total size [%s]", n2 + 1, n3, n4, n - 1, arrayList.size());
        return xMLSchema;
    }

    private static class OptionGroup {
        private List<OptionLabel> options = new ArrayList<OptionLabel>();
        private boolean optionOnly;

        private OptionGroup(List list, List list2) {
            this.optionOnly = list2.size() == 0;
            for (int i = 0; i < list.size(); ++i) {
                OptionLabel optionLabel = new OptionLabel();
                optionLabel.option = String.valueOf(list.get(i));
                if (list2.size() > i) {
                    optionLabel.label = String.valueOf(list2.get(i));
                }
                this.options.add(optionLabel);
            }
        }
    }

    private static class OptionLabel {
        private String option = "";
        private String label = "";

        private OptionLabel() {
        }
    }
}

