/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.EvEvent;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.logger.CTELogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class EventMessage {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EventMessage.class);
    public static final String JM_WORKFLOW_ACTIVITY_TIMEOUT = "JM_WORKFLOW_ACTIVITY_TIMEOUT";
    public static final String JM_WORKFLOW_FAILED_SHUTDOWN = "JM_WORKFLOW_FAILED_SHUTDOWN";
    public static final String GUIMSG_QUICKRUN_TOOL_NOT_IN_CLIENT = "GUIMSG_QUICKRUN_TOOL_NOT_IN_CLIENT";
    public static final String JM_WORKFLOW_INVALID_XPATH_TRAN = "JM_WORKFLOW_INVALID_XPATH_TRAN";
    public static final int JOBMGR_ID = 19;
    public static final int GUIMSG_ID = 35;
    public static final int JOBMGR_SSID = 0x13000000;
    public static final int GUIMSG_SSID = 0x23000000;
    private static final String[] TAB_FILES = new String[]{"guimsglocale.tab", "jmlocale.tab"};
    private static final Map<String, Integer> TAB_SSID = new HashMap<String, Integer>();
    private static EventMessage instance;
    private Map<String, Integer> eventMap = new HashMap<String, Integer>();

    public static EvMessageContainer getContainer(String string, Object ... objectArray) {
        return new EvMessageContainer(EventMessage.getInstance().getMessageId(string), objectArray);
    }

    public static EventMessage getInstance() {
        if (instance == null) {
            instance = new EventMessage();
        }
        return instance;
    }

    private EventMessage() {
        try {
            System.loadLibrary("WorkflowEvent");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadEventHeaders() {
        JarFile jarFile;
        File file = new File(WorkflowRegistry.getInstance().getInstallFolder(), "workflowEngine.jar");
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        for (String string : TAB_FILES) {
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry == null) continue;
            try {
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                int n = TAB_SSID.get(string);
                Scanner scanner = new Scanner(inputStream);
                int n2 = 0;
                while (scanner.hasNextLine()) {
                    String string2 = scanner.nextLine().trim();
                    if (string2.length() == 0 || string2.startsWith("#")) continue;
                    String string3 = string2.split("\\s")[0].split(",")[0];
                    this.eventMap.put(string3, ++n2 | n);
                }
                scanner.close();
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getMessageId(String string) {
        Integer n = this.eventMap.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public String formatMessage(EvMessageContainer evMessageContainer, int n) {
        try {
            String string = XMLEncoder.encode((Object)evMessageContainer.getArgumentInfo());
            logger.debug("formatting message for id [%s], locale id [%s], arguments [%s]", evMessageContainer.getMessageId(), n, string);
            return this.formatMessage(n, evMessageContainer.getMessageId(), string);
        }
        catch (Throwable throwable) {
            return String.valueOf(evMessageContainer.getMessageId());
        }
    }

    public void generateEvent(EvEvent evEvent) {
        if (evEvent.getContainer() != null) {
            try {
                EvMessageContainer evMessageContainer = evEvent.getContainer();
                String string = XMLEncoder.encode((Object)evMessageContainer.getArgumentInfo());
                this.generateEvent(evMessageContainer.getMessageId(), evEvent.getJobId(), evEvent.getSeverity().getEnumValue(), string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected native boolean initialize(String var1);

    private native String formatMessage(long var1, int var3, String var4);

    private native boolean generateEvent(int var1, long var2, int var4, String var5);

    public native boolean sendAlert(String var1);

    public native boolean setPort(long var1);

    public native boolean debugLog(String var1, long var2, int var4, long var5, String var7);

    public native String getRegistryNumber(String var1, String var2, long var3);

    public native boolean setRegistryNumber(String var1, String var2, long var3);

    public native String getRegistryString(String var1, String var2, String var3);

    public native String[] getRegistryChildKeys(String var1);

    static {
        TAB_SSID.put("guimsglocale.tab", 0x23000000);
        TAB_SSID.put("jmlocale.tab", 0x13000000);
    }
}

