/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.logger.CTELogger;

public class EvFailureReason {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EvFailureReason.class);
    private final EvMessageContainer container;
    private final WorkflowContext workflow;
    private Integer failureId = 0;
    private Object userObject;
    private int hash = new Integer(0).hashCode();

    public EvFailureReason(WorkflowContext workflowContext, EvMessageContainer evMessageContainer) {
        this.container = evMessageContainer;
        this.workflow = workflowContext;
        if (this.workflow.getJobId() > 0L) {
            try {
                this.failureId = workflowContext.getJobManager().writeFailure(this.getProcessStepId(), evMessageContainer);
                if (this.failureId != null) {
                    this.hash = this.failureId.hashCode();
                }
            }
            catch (Exception exception) {
                logger.error(workflowContext.getJobId(), "failed to add failure reason to CommServ", exception);
            }
        }
    }

    public String getFailureId() {
        if (this.failureId == null || this.failureId <= 0) {
            return "";
        }
        return this.failureId.toString() + ",";
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Integer getProcessStepId() {
        if (this.workflow.getProcessStepId() == null) {
            return 0;
        }
        return this.workflow.getProcessStepId();
    }

    public EvMessageContainer getMessageContainer() {
        return this.container;
    }

    public String getMessage() {
        return EventMessage.getInstance().formatMessage(this.container, 0);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EvFailureReason) {
            if (this.failureId != null) {
                return this.failureId.equals(((EvFailureReason)object).failureId);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

