/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvEvent;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventManager;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.JobManagerContext;
import commvault.cte.workflow.WorkflowManager;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.EventSeverity;
import commvault.msgs.Workflow.AlertCriteria;

public class DecoupledWorkflowManager
extends WorkflowManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DecoupledWorkflowManager.class);
    private int jobStartTime = DateUtilities.getNow();

    protected DecoupledWorkflowManager(WorkflowProcess workflowProcess) {
        super(workflowProcess);
    }

    @Override
    protected void worker() {
        super.worker();
    }

    @Override
    protected JobManagerContext createJobManager(WorkflowProcess workflowProcess) throws CTEDBException {
        return new JobManagerContext(){

            @Override
            public void updatePendingReason() {
            }

            @Override
            public void setCurrentAttempt(ActivityContext activityContext) {
            }

            @Override
            public void saveAttempt(ActivityContext activityContext) {
            }

            @Override
            public Integer writeFailure(int n, EvMessageContainer evMessageContainer) throws Exception {
                return null;
            }

            @Override
            public void setReportType(int n) {
            }

            @Override
            public void setArchGroupId(int n) {
            }

            @Override
            public void save() {
                if (DecoupledWorkflowManager.this.getWorkflow().getStatus().isJobComplete()) {
                    EventManager.getInstance().fireWorkflowEndEvent(DecoupledWorkflowManager.this.getWorkflow());
                }
            }

            @Override
            public int getReportType() {
                return 0;
            }

            @Override
            public int getJobStartTime() {
                return DecoupledWorkflowManager.this.jobStartTime;
            }

            @Override
            public int getArchGroupId() {
                return 0;
            }

            @Override
            public boolean cleanup() {
                return true;
            }

            @Override
            public void writeEvent(EventSeverity eventSeverity, EvMessageContainer evMessageContainer) {
                EvEvent evEvent = new EvEvent(eventSeverity, 0L, 0, 0, evMessageContainer);
                EventMessage.getInstance().generateEvent(evEvent);
            }

            @Override
            public void writeAlert(AlertCriteria alertCriteria) {
                String string;
                try {
                    string = XMLEncoder.encode((Object)alertCriteria);
                }
                catch (Exception exception) {
                    logger.error("failed to encode Workflow::AlertCriteria", exception);
                    return;
                }
                logger.xml("sending alert type [%s], criteria xml [%s]", alertCriteria.getAlertType().toString(), string);
                try {
                    if (!EventMessage.getInstance().sendAlert(string)) {
                        logger.error(alertCriteria.getJobId(), "failed to send alert type [" + alertCriteria.getAlertType().toString() + "], check Workflow.log for additional details, xml [" + string + "]");
                    }
                }
                catch (Throwable throwable) {
                    logger.error(alertCriteria.getJobId(), "failed to send alert type [" + alertCriteria.getAlertType().toString() + "], xml [" + string + "]", throwable);
                }
            }

            @Override
            public void checkStaleRecords() {
            }
        };
    }

    @Override
    protected void complete() {
        if (this.getSize() > 0) {
            logger.error(this.workflow.getJobId(), "execution of workflow did complete successfully");
            this.workflow.setStatus(ProcessStatus.FAILED);
        }
        super.complete();
    }
}

