/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.engine.WF_Chunk_t;
import commvault.cte.workflow.logger.CTELogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextStorage {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ContextStorage.class);
    private long jobId;
    private int stepId;
    private int commCellId;
    private ActivityContext context;
    private List<WF_Chunk_t> chunks;
    private Map<String, Object> storage;

    public ContextStorage(ActivityContext activityContext) throws Exception {
        this.stepId = activityContext.getStepId();
        this.jobId = activityContext.getJobId();
        this.commCellId = activityContext.getCommCellId();
        this.context = activityContext;
        String string = String.format("StepId = %s AND jobId = %s AND commCellId = %s", this.stepId, this.jobId, this.commCellId);
        this.chunks = WF_Chunk_t.select(string);
        if (this.chunks.size() > 0) {
            Object object2;
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            for (Object object2 : this.chunks) {
                arrayList.add(object2.Chunk.get());
            }
            Object object3 = this.glueChopsBackTogether(arrayList);
            object2 = new ByteArrayInputStream((byte[])object3);
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object2);
            this.storage = (Map)objectInputStream.readObject();
        } else {
            this.storage = new HashMap<String, Object>();
        }
    }

    public Map<String, Object> getStorage() {
        return this.storage;
    }

    public void save() throws Exception {
        block10: {
            block9: {
                int n;
                if (this.context.isOnDemand()) {
                    logger.debug(this.context.getJobId(), "skip saving storage for on-demand jobs");
                    return;
                }
                if (this.storage.size() == 0) {
                    if (this.chunks.size() > 0) {
                        for (WF_Chunk_t wF_Chunk_t : this.chunks) {
                            wF_Chunk_t.delete();
                        }
                    }
                    return;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.storage);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                List<byte[]> list = this.chopItUp(byArray);
                if (list.size() <= 0) break block9;
                for (n = 0; n < list.size(); ++n) {
                    WF_Chunk_t wF_Chunk_t;
                    if (n < this.chunks.size()) {
                        wF_Chunk_t = this.chunks.get(n);
                    } else {
                        wF_Chunk_t = new WF_Chunk_t();
                        wF_Chunk_t.StepId.set(Integer.valueOf(this.stepId));
                        wF_Chunk_t.jobId.set(Long.valueOf(this.jobId));
                        wF_Chunk_t.commCellId.set(Integer.valueOf(this.commCellId));
                        wF_Chunk_t.Created.set(Integer.valueOf(DateUtilities.getNow()));
                    }
                    wF_Chunk_t.Chunk.set(list.get(n));
                    wF_Chunk_t.Size.set(Integer.valueOf(list.get(n).length));
                    wF_Chunk_t.Modified.set(Integer.valueOf(DateUtilities.getNow()));
                    wF_Chunk_t.save();
                }
                while (n < this.chunks.size()) {
                    this.chunks.get(n).delete();
                    ++n;
                }
                break block10;
            }
            if (this.chunks.size() <= 0) break block10;
            for (WF_Chunk_t wF_Chunk_t : this.chunks) {
                wF_Chunk_t.delete();
            }
        }
    }

    private List<byte[]> chopItUp(byte[] byArray) {
        int n = WorkflowRegistry.getInstance().getChunkSize();
        ArrayList<byte[]> arrayList = null;
        if (byArray != null && byArray.length > 0) {
            byte[] byArray2;
            arrayList = new ArrayList<byte[]>();
            int n2 = 0;
            while (byArray.length - n2 > n) {
                byArray2 = new byte[n];
                System.arraycopy(byArray, n2, byArray2, 0, n);
                arrayList.add(byArray2);
                n2 += n;
            }
            byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] glueChopsBackTogether(List<byte[]> list) {
        byte[] byArray = null;
        if (list != null) {
            for (byte[] byArray2 : list) {
                if (byArray == null) {
                    byArray = byArray2;
                    continue;
                }
                byte[] byArray3 = byArray;
                byArray = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                System.arraycopy(byArray2, 0, byArray, byArray3.length, byArray2.length);
            }
        }
        return byArray;
    }
}

