/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.JobSettings;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.APP_CommCell_t;
import commvault.cte.workflow.db.cs.GXGlobalParam_t;
import commvault.cte.workflow.db.cs.JMPhase_t;
import commvault.cte.workflow.logger.CTELogger;

public class CommCellSettings
implements JobSettings {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommCellSettings.class);
    private static JMPhase_t PHASE_ROW;
    private static final String EVSMTPport = "EVSMTPport";
    private static final String EVSMTPUsername = "EVSMTPUsername";
    private static final String EVSMTPPassword = "EVSMTPPassword";
    private static final String EVSMTPSender = "EVSMTPSender";
    private static final String EVSMTPSenderDisplay = "EVSMTPDisplayName";
    private static final String EVSMTPIsCredentialRequired = "EVSMTPIsCredentialRequired";
    private static final String EVSMTPSSL = "EVSMTPSSL";
    private static final String UseHTTPProxy = "SendLogsUseHTTPProxy";
    private static final String HTTPProxySite = "SendLogsHTTPProxySite";
    private static final String HTTPProxyPort = "SendLogsHTTPProxyPort";
    private static final String UseHTTPProxyAuthentication = "CommservUseHTTPProxyAuthentication";
    private static final String HTTPProxyUser = "SendLogsHTTPProxyUser";
    private static final String HTTPProxyPassword = "SendLogsHTTPProxyPassword";

    private static JMPhase_t getDefaultPhaseRow() {
        JMPhase_t jMPhase_t = new JMPhase_t();
        jMPhase_t.zero();
        jMPhase_t.cleanupTimeout.set(Integer.valueOf(1800000));
        jMPhase_t.maxRestarts.set(Integer.valueOf(1));
        jMPhase_t.restartInterval.set(Integer.valueOf(1200));
        jMPhase_t.totalRunningTime.set(Integer.valueOf(21600));
        jMPhase_t.enableTotalRunningTime.set(Integer.valueOf(0));
        jMPhase_t.killJobIfRunningTimeExpires.set(Integer.valueOf(0));
        return jMPhase_t;
    }

    private APP_CommCell_t getAppCommCell() {
        APP_CommCell_t aPP_CommCell_t = new APP_CommCell_t();
        try {
            if (aPP_CommCell_t.fill(String.format("id = %s", WorkflowRegistry.getInstance().getCommCellId()))) {
                return aPP_CommCell_t;
            }
        }
        catch (CTEDBException cTEDBException) {
            throw new Error(cTEDBException);
        }
        throw new Error("did not find APP_CommCell_t row for commCellId [" + WorkflowRegistry.getInstance().getCommCellId() + "]");
    }

    private JMPhase_t getPhaseRow() {
        return PHASE_ROW;
    }

    private String getGlobalParameterValue(String string) {
        GXGlobalParam_t gXGlobalParam_t = new GXGlobalParam_t();
        String string2 = String.format("name = '%s'", string);
        try {
            if (gXGlobalParam_t.fill(string2)) {
                return gXGlobalParam_t.value.get();
            }
        }
        catch (CTEDBException cTEDBException) {
            throw new Error(cTEDBException);
        }
        logger.debug("did not find GXGlobalParam entry for [%s]", string);
        return null;
    }

    @Override
    public String getSmtpServer() {
        return this.getAppCommCell().smtpServer.get();
    }

    @Override
    public int getSmtpPort() {
        String string = this.getGlobalParameterValue(EVSMTPport);
        if (string == null) {
            return 25;
        }
        return Integer.parseInt(string);
    }

    @Override
    public String getSmtpSender() {
        return this.getGlobalParameterValue(EVSMTPSender);
    }

    public String getSmtpSenderDisplay() {
        return this.getGlobalParameterValue(EVSMTPSenderDisplay);
    }

    @Override
    public String getSmtpUsername() {
        return this.getGlobalParameterValue(EVSMTPUsername);
    }

    @Override
    public String getSmtpPassword() {
        return this.getGlobalParameterValue(EVSMTPPassword);
    }

    @Override
    public boolean isSmtpCredentialsReq() {
        String string = this.getGlobalParameterValue(EVSMTPIsCredentialRequired);
        if (string == null) {
            return false;
        }
        return string.equals(String.valueOf(1));
    }

    @Override
    public boolean isSmtpSSL() {
        String string = this.getGlobalParameterValue(EVSMTPSSL);
        if (string == null) {
            return false;
        }
        return string.equals(String.valueOf(1));
    }

    @Override
    public int getMaxRestarts() {
        return this.getPhaseRow().maxRestarts.get();
    }

    @Override
    public int getRestartInterval() {
        return this.getPhaseRow().restartInterval.get();
    }

    @Override
    public boolean isEnableTotalRunningTime() {
        return this.getPhaseRow().enableTotalRunningTime.get() != 0;
    }

    @Override
    public int getTotalRunningTime() {
        return this.getPhaseRow().totalRunningTime.get();
    }

    @Override
    public boolean isKillJobIfRunningTimeExpires() {
        return this.getPhaseRow().killJobIfRunningTimeExpires.get() != 0;
    }

    @Override
    public int getCleanupTimeout() {
        return this.getPhaseRow().cleanupTimeout.get();
    }

    @Override
    public boolean isHttpUseProxy() {
        String string = this.getGlobalParameterValue(UseHTTPProxy);
        if (string == null) {
            return false;
        }
        return string.equals(String.valueOf(1));
    }

    @Override
    public String getHttpProxySite() {
        return this.getGlobalParameterValue(HTTPProxySite);
    }

    @Override
    public int getHttpProxyPort() {
        String string = this.getGlobalParameterValue(HTTPProxyPort);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    @Override
    public boolean isHttpUseProxyAuthentication() {
        String string = this.getGlobalParameterValue(UseHTTPProxyAuthentication);
        if (string == null) {
            return false;
        }
        return string.equals(String.valueOf(1));
    }

    @Override
    public String getHttpProxyUser() {
        return this.getGlobalParameterValue(HTTPProxyUser);
    }

    @Override
    public String getHttpProxyPassword() {
        return this.getGlobalParameterValue(HTTPProxyPassword);
    }

    static {
        JMPhase_t jMPhase_t = new JMPhase_t();
        try {
            if (jMPhase_t.fill(String.format("opTableId IN (select id from JMOpTable where operation=%s)", WorkflowRegistry.getInstance().getJMOpType()))) {
                PHASE_ROW = jMPhase_t;
            } else {
                logger.info("no JMPhase row on CommCell");
                PHASE_ROW = CommCellSettings.getDefaultPhaseRow();
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to get JMPhase row from CommCell", cTEDBException);
            PHASE_ROW = CommCellSettings.getDefaultPhaseRow();
        }
    }
}

