/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.workflow.CommCellContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.SimpleConnection;
import commvault.cte.workflow.db.cs.APP_ClientProp_t;
import commvault.cte.workflow.db.cs.APP_Client_t;
import commvault.cte.workflow.db.cs.APP_CommCellInfo_t;
import commvault.cte.workflow.db.cs.APP_CommCell_t;
import commvault.cte.workflow.db.cs.simInstalledPackages_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.CvEntities.CommCellEntity;
import java.util.List;

public class CommCellProperties
implements CommCellContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommCellProperties.class);
    private CTEDBConnInfo connInfo;
    private CTEDBConnection conn;
    private String commServHost;
    private ClientEntity commServClient;
    private CommCellEntity commCell;
    private WorkflowProperties.WebServiceParameters webServiceParameters = null;

    public static CommCellContext load(int n) throws Exception {
        if (n == WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
            return WorkflowProperties.getInstance();
        }
        APP_CommCell_t aPP_CommCell_t = new APP_CommCell_t();
        if (!aPP_CommCell_t.fill(String.format("id = %s", n))) {
            throw new Exception("commcell id [" + n + "] is not registered on local commcell [" + WorkflowProperties.getInstance().getCommCell().getCommCellName() + "]");
        }
        APP_CommCellInfo_t aPP_CommCellInfo_t = new APP_CommCellInfo_t();
        if (!aPP_CommCellInfo_t.fill(String.format("commcellId = %s", aPP_CommCell_t.id.get()))) {
            throw new Exception("failed to find APP_CommCellInfo row for commCell id [" + aPP_CommCell_t.id.get() + "]");
        }
        APP_Client_t aPP_Client_t = new APP_Client_t();
        if (!aPP_Client_t.fill(String.format("id = %s", aPP_CommCell_t.clientId.get()))) {
            throw new Exception("failed to find client for registered commcell [" + aPP_CommCell_t.aliasName.get() + "], client id [" + aPP_CommCell_t.clientId.get() + "]");
        }
        CommCellProperties commCellProperties = new CommCellProperties(aPP_CommCell_t, aPP_CommCellInfo_t, aPP_Client_t);
        return commCellProperties;
    }

    public static CommCellContext load(String string) throws Exception {
        if (string == null || string.length() == 0 || string.equalsIgnoreCase(WorkflowProperties.getInstance().getCommCell().getCommCellName())) {
            return WorkflowProperties.getInstance();
        }
        APP_CommCell_t aPP_CommCell_t = new APP_CommCell_t();
        if (!aPP_CommCell_t.fill(String.format("aliasName = '%s'", string))) {
            throw new Exception("commcell [" + string + "] is not registered on local commcell [" + WorkflowProperties.getInstance().getCommCell().getCommCellName() + "]");
        }
        if (aPP_CommCell_t.id.get().intValue() == WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
            return WorkflowProperties.getInstance();
        }
        APP_CommCellInfo_t aPP_CommCellInfo_t = new APP_CommCellInfo_t();
        if (!aPP_CommCellInfo_t.fill(String.format("commcellId = %s", aPP_CommCell_t.id.get()))) {
            throw new Exception("failed to find APP_CommCellInfo row for commCell id [" + aPP_CommCell_t.id.get() + "]");
        }
        APP_Client_t aPP_Client_t = new APP_Client_t();
        if (!aPP_Client_t.fill(String.format("id = %s", aPP_CommCell_t.clientId.get()))) {
            throw new Exception("failed to find client for registered commcell [" + string + "], client id [" + aPP_CommCell_t.clientId.get() + "]");
        }
        CommCellProperties commCellProperties = new CommCellProperties(aPP_CommCell_t, aPP_CommCellInfo_t, aPP_Client_t);
        return commCellProperties;
    }

    private CommCellProperties(APP_CommCell_t aPP_CommCell_t, APP_CommCellInfo_t aPP_CommCellInfo_t, APP_Client_t aPP_Client_t) {
        this.connInfo = WorkflowUtils.getDatabaseConnection(aPP_CommCellInfo_t);
        this.conn = new SimpleConnection(this.connInfo, "CommServ");
        this.commServHost = aPP_CommCellInfo_t.CCHostName.get();
        this.commServClient = new ClientEntity();
        this.commServClient.setClientId(aPP_Client_t.id.get().intValue());
        this.commServClient.setClientName(aPP_Client_t.name.get());
        this.commCell = new CommCellEntity();
        this.commCell.setCommCellId(aPP_CommCell_t.id.get().intValue());
        this.commCell.setCommCellName(aPP_CommCell_t.aliasName.get());
    }

    @Override
    public String getCommServHost() {
        return this.commServHost;
    }

    @Override
    public String getCommServClient() {
        return this.commServClient.getClientName();
    }

    @Override
    public CommCellEntity getCommCell() {
        return this.commCell;
    }

    @Override
    public CTEDBConnection getCommCellConnection() {
        return this.conn;
    }

    @Override
    public CTEDBConnInfo getConnInfo() {
        return this.connInfo;
    }

    private ClientEntity getDefaultWebServer() throws Exception {
        String string;
        simInstalledPackages_t simInstalledPackages_t2 = new simInstalledPackages_t(this.getCommCellConnection());
        List list = simInstalledPackages_t2.executeSelect(string = "simPackageID = 252 And clientId in (Select componentNameId From APP_ClientProp Where attrname = 'DM2WebService Web Site Port')");
        if (list.size() == 0) {
            return null;
        }
        Integer n = null;
        for (simInstalledPackages_t simInstalledPackages_t3 : list) {
            if (simInstalledPackages_t3.ClientId.get() == 2) {
                if (n != null) continue;
                n = simInstalledPackages_t3.ClientId.get();
                continue;
            }
            n = simInstalledPackages_t3.ClientId.get();
        }
        return CommServUtils.getClientEntity(n, this.getCommCellConnection());
    }

    private String getConfiguredWebServiceUrl() {
        String string = WorkflowRegistry.getInstance().getDefaultWebServer();
        if (string != null && string.length() > 0) {
            if (string.endsWith("/")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    private WorkflowProperties.WebServiceParameters getWebServiceParameters() throws Exception {
        if (this.webServiceParameters == null) {
            String string;
            if (this.commCell.getCommCellId() == 2 && (string = this.getConfiguredWebServiceUrl()) != null) {
                this.webServiceParameters = new WorkflowProperties.WebServiceParameters(string, "");
                return this.webServiceParameters;
            }
            string = this.getDefaultWebServer();
            if (string != null) {
                APP_ClientProp_t aPP_ClientProp_t = new APP_ClientProp_t(this.getCommCellConnection());
                String string2 = String.format("attrname in ('DM2WebService Web Site Port', 'DM2WebService Search Web Alias') AND componentNameId=%s", string.getClientId());
                List list = aPP_ClientProp_t.executeSelect(string2);
                String string3 = null;
                String string4 = "SearchSvc";
                for (APP_ClientProp_t aPP_ClientProp_t2 : list) {
                    if (aPP_ClientProp_t2.attrName.get().equalsIgnoreCase("DM2WebService Search Web Alias")) {
                        string4 = aPP_ClientProp_t2.attrVal.get();
                    }
                    if (!aPP_ClientProp_t2.attrName.get().equalsIgnoreCase("DM2WebService Web Site Port")) continue;
                    string3 = aPP_ClientProp_t2.attrVal.get();
                }
                if (string3 == null) {
                    throw new Exception("failed to get [DM2WebService Web Site Port] setting from APP_ClientProp table for client id [" + string.getClientId() + "]");
                }
                this.webServiceParameters = new WorkflowProperties.WebServiceParameters("http://" + string.getHostName() + ":" + string3, "/" + string4 + "/" + "CVWebService.svc");
            } else {
                logger.debug("no web server found on CommCell");
            }
        }
        return this.webServiceParameters;
    }

    @Override
    public WorkflowProperties.WebServiceParameters getDefaultWebService() {
        try {
            return this.getWebServiceParameters();
        }
        catch (Exception exception) {
            logger.error("failed to retrieve web service parameters from commcell [" + this.getCommCell().getCommCellName() + "]", exception);
            return null;
        }
    }
}

