/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.ResourceLimits;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.polyglot.management.ExecutionEvent;

public abstract class AbstractPolyglotImpl {
    APIAccess api;
    ManagementAccess management;
    IOAccess io;

    protected AbstractPolyglotImpl() {
        if (!this.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotImpl") && !this.getClass().getName().equals("org.graalvm.polyglot.Engine$PolyglotInvalid")) {
            throw new AssertionError((Object)"Only one implementation Engine.Impl allowed.");
        }
    }

    public final void setMonitoring(ManagementAccess monitoring) {
        this.management = monitoring;
    }

    public final void setConstructors(APIAccess constructors) {
        this.api = constructors;
        this.initialize();
    }

    public final void setIO(IOAccess ioAccess) {
        Objects.requireNonNull(ioAccess, "IOAccess must be non null.");
        this.io = ioAccess;
    }

    public APIAccess getAPIAccess() {
        return this.api;
    }

    public ManagementAccess getManagement() {
        return this.management;
    }

    public final IOAccess getIO() {
        if (this.io == null) {
            try {
                Class.forName(ProcessHandler.ProcessCommand.class.getName(), true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.io;
    }

    protected void initialize() {
    }

    public abstract Engine buildEngine(OutputStream var1, OutputStream var2, InputStream var3, Map<String, String> var4, long var5, TimeUnit var7, boolean var8, long var9, boolean var11, boolean var12, boolean var13, MessageTransport var14, Object var15, HostAccess var16);

    public abstract void preInitializeEngine();

    public abstract void resetPreInitializedEngine();

    public abstract AbstractSourceImpl getSourceImpl();

    public abstract AbstractSourceSectionImpl getSourceSectionImpl();

    public abstract AbstractManagementImpl getManagementImpl();

    public abstract Class<?> loadLanguageClass(String var1);

    public Context getCurrentContext() {
        throw new IllegalStateException("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
    }

    public abstract Collection<Engine> findActiveEngines();

    public abstract Value asValue(Object var1);

    public abstract <S, T> Object newTargetTypeMapping(Class<S> var1, Class<T> var2, Predicate<S> var3, Function<S, T> var4);

    public abstract Object buildLimits(long var1, Predicate<Source> var3, Duration var4, Duration var5, Consumer<ResourceLimitEvent> var6);

    public abstract Context getLimitEventContext(Object var1);

    public static abstract class AbstractValueImpl {
        protected AbstractValueImpl(AbstractPolyglotImpl impl) {
            Objects.requireNonNull(impl);
        }

        public boolean hasArrayElements(Object receiver) {
            return false;
        }

        public abstract Value getArrayElement(Object var1, long var2);

        public abstract void setArrayElement(Object var1, long var2, Object var4);

        public abstract boolean removeArrayElement(Object var1, long var2);

        public abstract long getArraySize(Object var1);

        public boolean hasMembers(Object receiver) {
            return false;
        }

        public abstract Value getMember(Object var1, String var2);

        public boolean hasMember(Object receiver, String key) {
            return false;
        }

        public Context getContext() {
            return null;
        }

        public Set<String> getMemberKeys(Object receiver) {
            return Collections.emptySet();
        }

        public abstract void putMember(Object var1, String var2, Object var3);

        public abstract boolean removeMember(Object var1, String var2);

        public boolean canExecute(Object receiver) {
            return false;
        }

        public abstract Value execute(Object var1, Object[] var2);

        public abstract Value execute(Object var1);

        public boolean canInstantiate(Object receiver) {
            return false;
        }

        public abstract Value newInstance(Object var1, Object[] var2);

        public abstract void executeVoid(Object var1, Object[] var2);

        public abstract void executeVoid(Object var1);

        public boolean canInvoke(String identifier, Object receiver) {
            return false;
        }

        public abstract Value invoke(Object var1, String var2, Object[] var3);

        public abstract Value invoke(Object var1, String var2);

        public boolean isString(Object receiver) {
            return false;
        }

        public abstract String asString(Object var1);

        public boolean isBoolean(Object receiver) {
            return false;
        }

        public abstract boolean asBoolean(Object var1);

        public boolean fitsInInt(Object receiver) {
            return false;
        }

        public abstract int asInt(Object var1);

        public boolean fitsInLong(Object receiver) {
            return false;
        }

        public abstract long asLong(Object var1);

        public boolean fitsInDouble(Object receiver) {
            return false;
        }

        public abstract double asDouble(Object var1);

        public boolean fitsInFloat(Object receiver) {
            return false;
        }

        public abstract float asFloat(Object var1);

        public boolean isNull(Object receiver) {
            return false;
        }

        public boolean isNativePointer(Object receiver) {
            return false;
        }

        public boolean fitsInByte(Object receiver) {
            return false;
        }

        public abstract byte asByte(Object var1);

        public boolean fitsInShort(Object receiver) {
            return false;
        }

        public abstract short asShort(Object var1);

        public abstract long asNativePointer(Object var1);

        public boolean isHostObject(Object receiver) {
            return false;
        }

        public boolean isProxyObject(Object receiver) {
            return false;
        }

        public abstract Object asHostObject(Object var1);

        public abstract Object asProxyObject(Object var1);

        public abstract String toString(Object var1);

        public abstract Value getMetaObject(Object var1);

        public boolean isNumber(Object receiver) {
            return false;
        }

        public abstract <T> T as(Object var1, Class<T> var2);

        public abstract <T> T as(Object var1, TypeLiteral<T> var2);

        public abstract SourceSection getSourceLocation(Object var1);

        public boolean isDate(Object receiver) {
            return false;
        }

        public abstract LocalDate asDate(Object var1);

        public boolean isTime(Object receiver) {
            return false;
        }

        public abstract LocalTime asTime(Object var1);

        public abstract Instant asInstant(Object var1);

        public boolean isTimeZone(Object receiver) {
            return false;
        }

        public abstract ZoneId asTimeZone(Object var1);

        public boolean isDuration(Object receiver) {
            return false;
        }

        public abstract Duration asDuration(Object var1);

        public boolean isException(Object receiver) {
            return false;
        }

        public abstract RuntimeException throwException(Object var1);
    }

    public static abstract class AbstractLanguageImpl {
        protected AbstractLanguageImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getName();

        public abstract String getImplementationName();

        public abstract boolean isInteractive();

        public abstract String getVersion();

        public abstract String getId();

        public abstract OptionDescriptors getOptions();

        public abstract Set<String> getMimeTypes();

        public abstract String getDefaultMimeType();
    }

    public static abstract class AbstractInstrumentImpl {
        protected AbstractInstrumentImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getId();

        public abstract String getName();

        public abstract OptionDescriptors getOptions();

        public abstract String getVersion();

        public abstract <T> T lookup(Class<T> var1);
    }

    public static abstract class AbstractStackFrameImpl {
        protected AbstractStackFrameImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract StackTraceElement toHostFrame();

        public abstract SourceSection getSourceLocation();

        public abstract String getRootName();

        public abstract Language getLanguage();

        public abstract boolean isHostFrame();

        public abstract String toStringImpl(int var1);
    }

    public static abstract class AbstractExceptionImpl {
        protected AbstractExceptionImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract boolean isInternalError();

        public abstract boolean isCancelled();

        public abstract boolean isExit();

        public abstract int getExitStatus();

        public abstract Iterable<PolyglotException.StackFrame> getPolyglotStackTrace();

        public abstract boolean isSyntaxError();

        public abstract Value getGuestObject();

        public abstract boolean isIncompleteSource();

        public abstract void onCreate(PolyglotException var1);

        public abstract void printStackTrace(PrintStream var1);

        public abstract void printStackTrace(PrintWriter var1);

        public abstract StackTraceElement[] getStackTrace();

        public abstract String getMessage();

        public abstract boolean isHostException();

        public abstract Throwable asHostException();

        public abstract SourceSection getSourceLocation();
    }

    public static abstract class AbstractEngineImpl {
        protected AbstractEngineImpl(AbstractPolyglotImpl impl) {
            Objects.requireNonNull(impl);
        }

        public abstract Language requirePublicLanguage(String var1);

        public abstract Instrument requirePublicInstrument(String var1);

        public abstract void close(Engine var1, boolean var2);

        public abstract Map<String, Instrument> getInstruments();

        public abstract Map<String, Language> getLanguages();

        public abstract OptionDescriptors getOptions();

        public abstract Context createContext(OutputStream var1, OutputStream var2, InputStream var3, boolean var4, HostAccess var5, PolyglotAccess var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, Predicate<String> var12, Map<String, String> var13, Map<String, String[]> var14, String[] var15, FileSystem var16, Object var17, boolean var18, ProcessHandler var19, EnvironmentAccess var20, Map<String, String> var21, ZoneId var22, Object var23, String var24);

        public abstract String getImplementationName();
    }

    public static abstract class AbstractContextImpl {
        protected AbstractContextImpl(AbstractPolyglotImpl impl) {
            if (!this.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotContextImpl")) {
                throw new AssertionError((Object)"Only one implementation of AbstractContextImpl allowed.");
            }
        }

        public abstract boolean initializeLanguage(String var1);

        public abstract Value eval(String var1, Object var2);

        public abstract Engine getEngineImpl(Context var1);

        public abstract void close(Context var1, boolean var2);

        public abstract Value asValue(Object var1);

        public abstract void explicitEnter(Context var1);

        public abstract void explicitLeave(Context var1);

        public abstract Value getBindings(String var1);

        public abstract Value getPolyglotBindings();

        public abstract void resetLimits();
    }

    public static abstract class AbstractSourceSectionImpl {
        protected AbstractSourceSectionImpl(AbstractPolyglotImpl polyglotImpl) {
            Objects.requireNonNull(polyglotImpl);
        }

        public abstract boolean isAvailable(Object var1);

        public abstract boolean hasLines(Object var1);

        public abstract boolean hasColumns(Object var1);

        public abstract boolean hasCharIndex(Object var1);

        public abstract int getStartLine(Object var1);

        public abstract int getStartColumn(Object var1);

        public abstract int getEndLine(Object var1);

        public abstract int getEndColumn(Object var1);

        public abstract int getCharIndex(Object var1);

        public abstract int getCharLength(Object var1);

        public abstract int getCharEndIndex(Object var1);

        public abstract CharSequence getCode(Object var1);

        public abstract String toString(Object var1);

        public abstract int hashCode(Object var1);

        public abstract boolean equals(Object var1, Object var2);
    }

    public static abstract class AbstractSourceImpl {
        protected final AbstractPolyglotImpl engineImpl;

        protected AbstractSourceImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
            this.engineImpl = engineImpl;
        }

        public abstract Source build(String var1, Object var2, URI var3, String var4, String var5, Object var6, boolean var7, boolean var8, boolean var9, Charset var10) throws IOException;

        public abstract String getName(Object var1);

        public abstract String getPath(Object var1);

        public abstract boolean isInteractive(Object var1);

        public abstract URL getURL(Object var1);

        public abstract URI getURI(Object var1);

        public abstract Reader getReader(Object var1);

        public abstract InputStream getInputStream(Object var1);

        public abstract int getLength(Object var1);

        public abstract CharSequence getCode(Object var1);

        public abstract CharSequence getCode(Object var1, int var2);

        public abstract int getLineCount(Object var1);

        public abstract int getLineNumber(Object var1, int var2);

        public abstract int getColumnNumber(Object var1, int var2);

        public abstract int getLineStartOffset(Object var1, int var2);

        public abstract int getLineLength(Object var1, int var2);

        public abstract String toString(Object var1);

        public abstract int hashCode(Object var1);

        public abstract boolean equals(Object var1, Object var2);

        public abstract boolean isInternal(Object var1);

        public abstract String findLanguage(File var1) throws IOException;

        public abstract String findLanguage(URL var1) throws IOException;

        public abstract String findLanguage(String var1);

        public abstract String findMimeType(File var1) throws IOException;

        public abstract String findMimeType(URL var1) throws IOException;

        public abstract ByteSequence getBytes(Object var1);

        public abstract boolean hasCharacters(Object var1);

        public abstract boolean hasBytes(Object var1);

        public abstract String getMimeType(Object var1);
    }

    public static abstract class AbstractManagementImpl {
        protected AbstractManagementImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract List<Value> getExecutionEventInputValues(Object var1);

        public abstract SourceSection getExecutionEventLocation(Object var1);

        public abstract String getExecutionEventRootName(Object var1);

        public abstract Value getExecutionEventReturnValue(Object var1);

        public abstract boolean isExecutionEventExpression(Object var1);

        public abstract boolean isExecutionEventStatement(Object var1);

        public abstract boolean isExecutionEventRoot(Object var1);

        public abstract void closeExecutionListener(Object var1);

        public abstract Object attachExecutionListener(Engine var1, Consumer<ExecutionEvent> var2, Consumer<ExecutionEvent> var3, boolean var4, boolean var5, boolean var6, Predicate<Source> var7, Predicate<String> var8, boolean var9, boolean var10, boolean var11);

        public abstract PolyglotException getExecutionEventException(Object var1);
    }

    public static abstract class APIAccess {
        protected APIAccess() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.Engine.APIAccessImpl")) {
                throw new AssertionError((Object)("Only one implementation of APIAccess allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract Engine newEngine(AbstractEngineImpl var1);

        public abstract Context newContext(AbstractContextImpl var1);

        public abstract PolyglotException newLanguageException(String var1, AbstractExceptionImpl var2);

        public abstract Language newLanguage(AbstractLanguageImpl var1);

        public abstract Instrument newInstrument(AbstractInstrumentImpl var1);

        public abstract Value newValue(Object var1, AbstractValueImpl var2);

        public abstract Source newSource(String var1, Object var2);

        public abstract SourceSection newSourceSection(Source var1, Object var2);

        public abstract Object getReceiver(Value var1);

        public abstract AbstractValueImpl getImpl(Value var1);

        public abstract AbstractContextImpl getImpl(Context var1);

        public abstract AbstractEngineImpl getImpl(Engine var1);

        public abstract AbstractExceptionImpl getImpl(PolyglotException var1);

        public abstract AbstractStackFrameImpl getImpl(PolyglotException.StackFrame var1);

        public abstract AbstractLanguageImpl getImpl(Language var1);

        public abstract AbstractInstrumentImpl getImpl(Instrument var1);

        public abstract ResourceLimitEvent newResourceLimitsEvent(Object var1);

        public abstract PolyglotException.StackFrame newPolyglotStackTraceElement(PolyglotException var1, AbstractStackFrameImpl var2);

        public abstract List<Object> getTargetMappings(HostAccess var1);

        public abstract boolean allowsAccess(HostAccess var1, AnnotatedElement var2);

        public abstract boolean allowsImplementation(HostAccess var1, Class<?> var2);

        public abstract boolean isArrayAccessible(HostAccess var1);

        public abstract boolean isListAccessible(HostAccess var1);

        public abstract Object getHostAccessImpl(HostAccess var1);

        public abstract void setHostAccessImpl(HostAccess var1, Object var2);

        public abstract UnmodifiableEconomicSet<String> getEvalAccess(PolyglotAccess var1, String var2);

        public abstract UnmodifiableEconomicSet<String> getBindingsAccess(PolyglotAccess var1);

        public abstract void validatePolyglotAccess(PolyglotAccess var1, UnmodifiableEconomicSet<String> var2);

        public abstract Object getImpl(ResourceLimits var1);
    }

    public static abstract class IOAccess {
        protected IOAccess() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.io.ProcessHandler.ProcessCommand.IOAccessImpl")) {
                throw new AssertionError((Object)("Only one implementation of IOAccess allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract ProcessHandler.ProcessCommand newProcessCommand(List<String> var1, String var2, Map<String, String> var3, boolean var4, ProcessHandler.Redirect var5, ProcessHandler.Redirect var6, ProcessHandler.Redirect var7);

        public abstract ProcessHandler.Redirect createRedirectToStream(OutputStream var1);

        public abstract OutputStream getOutputStream(ProcessHandler.Redirect var1);
    }

    public static abstract class ManagementAccess {
        protected ManagementAccess() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.management.Management.ManagementAccessImpl")) {
                throw new AssertionError((Object)("Only one implementation of ManagementAccessImpl allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract ExecutionEvent newExecutionEvent(Object var1);
    }
}

