<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<jsp:include page="../common/header.jsp">
	<jsp:param value="css/fujitsustyles.css" name="css" />
	<jsp:param value="Register Commvault Appliance" name="title" />
</jsp:include>

<form>
	<div id="appInfoDiv" class="commcellRegForm" data-state="3">
		<p class="logintitle">Appliance Information</p>
		<p class="subtitle">Please provide CommCell ID and IP address to which the appliance belongs to</p>
		<br>
		<p class="infoQ">If you dont know how to get below information, then please click on ? icon adjacent to each information header below.</p>
		<div class="loginMsg">&nbsp;</div>
		<table><thead><tr><th>Appliance Serial No.</th>
		<th>CommCell ID <a target="_blank" href="http://documentation.commvault.com/commvault/v10/article?p=features/license/license_how_to.htm#Viewing_CommCell_Group_Information_" class="infoQ"><img alt="CV Logo" src="../../common/img/info.png" ></a></th>
		<th>CommServe IP address <a target="_blank" href="http://documentation.commvault.com/commvault/v10/article?p=features/license/license_how_to.htm#Viewing_CommCell_Group_Information_" class="infoQ"><img alt="CV Logo" src="../../common/img/info.png" ></a></th>
		<th>Serial No <a target="_blank" href="http://documentation.commvault.com/commvault/v11/article?p=features/license/license_how_to.htm#Viewing_CommCell_Group_Information_" class="infoQ"><img alt="CV Logo" src="../../common/img/info.png" ></a></th>
		<th>Registration Code <a target="_blank" href="http://documentation.commvault.com/commvault/v11/article?p=features/license/license_how_to.htm#Viewing_CommCell_Group_Information_" class="infoQ"><img alt="CV Logo" src="../../common/img/info.png" ></a></th></tr></thead>
		<tbody id="appinfotbl">
			<c:if test="${fn:length(sessionScope.APPLIANCE_DETAILS) > 0}">

				<c:forEach var="appl" items="${sessionScope.APPLIANCE_DETAILS}" varStatus="itemLoop">
					<c:set var="iscomm" value="" scope="page"/>
					<c:set var="isip" value="" scope="page"/>
					<c:if test="${not empty appl.commcellid}"><c:set var="iscomm" value="disabled" scope="page"/></c:if>
					<c:if test="${not empty appl.commcellip}"><c:set var="isip" value="disabled" scope="page"/></c:if>
					<tr class="serialtr">
						<td> <p class="serial inp" data-inpname="serials"><c:out value="${appl.serailnumber}"/></p></td>
						<td>
							<input type="text" data-msg="Please enter valid Commcell ID in UPPER case." data-validation="(^[0-9A-F]{1,12}$)" data-inpname="commcells" class="inp commcell" ${iscomm} id="commcell${itemLoop.index+1}" name="commcell${itemLoop.index+1}" value="${appl.commcellid}"/>
							<br>
							<label for="commcell${itemLoop.index+1}" class="error">&nbsp;</label>
							<br>
						</td>
						<td>
							<input type="text" data-msg="Please enter valid IP address" id="ip${itemLoop.index+1}" data-inpname="ips" name="ip${itemLoop.index+1}" data-validation="^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$" class="inp" ${isip} value="${appl.commcellip}"/>
							<br>
							<label for="ip${itemLoop.index+1}" class="error">&nbsp;</label>
							<br>
						</td>
						<td>
							<input type="text" data-msg="Please enter valid Commvault Software Serial Number"  data-inpname="softserials" id="swserial${itemLoop.index+1}" name="swserial${itemLoop.index+1}" data-validation="^[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{6}$" class="inp appinfo" ${isip} value="${appl.commcellserial}"/>
							<br>
							<label for="swserial${itemLoop.index+1}" class="error">&nbsp;</label>
							<br>
						</td>
						<td>
							<input type="text" data-msg="Please enter valid Commvault Software Registration Code" data-inpname="regcodes" id="regcode${itemLoop.index+1}" name="regcode${itemLoop.index+1}" data-validation="^[0-9A-F]{3}-[0-9A-F]{3}-[0-9A-F]{4}$" class="inp" ${isip} value="${appl.commcellregcode}"/>
							<br>
							<label for="regcode${itemLoop.index+1}" class="error">&nbsp;</label>
							<br>
						</td>
					</tr>

				</c:forEach>
			</c:if>
		</tbody></table>
	</div>
	<div><span id="bckBtn" class="hideit mainBtn backBtn" data-state="2">Back</span></div>
	<div><span id="nextBtn" class="mainBtn" data-state="2">Next</span></div>
</form>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/fujitsuappliance.js" name="js"/>
</jsp:include>