	CHAT_AVAILABLE = false; //will be set to true when chat engineers are available to chat on the desired channel
    CHAT_APP = 'cloud'
    CHAT_CHANNEL = 5;
    CHAT_BASE_URL = 'https://chatbeta.commvault.com'; //"https://chatbeta.commvault.com";

    function detectAvailability() {

        var partnerAccount = 'A618C621-7C10-E211-950A-D067E5F12FD2'; //Commvault
        var userId = $('#userId').val(); //typically the email address of the user

        var url = CHAT_BASE_URL + '/client/channelstatus?pid=' + partnerAccount + '&appId=' + CHAT_APP + '&userId=' + userId;
        $.ajax({
            type: "GET",
            url: url,
            dataType: 'jsonp'
        }).done(function (channelList) {

            determineAvailability(channelList);

        }).error(function (error) {
            console.log("error!");
            console.log(error);
        });
    }

    function determineAvailability(channelList) {

        CHAT_AVAILABLE = false;

        for (var i = 0; i < channelList.length; i++) {
            var channel = channelList[i];
            if (channel.IsNocActive && channel.ChannelId == CHAT_CHANNEL) {
                CHAT_AVAILABLE = true;
            }
        }

        if (CHAT_AVAILABLE) {
            $('#chatNotAvailable').hide();
			loadTopicList(channelList);
			 $('#chatInfo').find('#userId, #firstMessage').val('');
			 $('#validationErrors').hide();
            $('#chatAvailable').show();
        } else {
            $('#chatNotAvailable').show();
            $('#chatAvailable').hide();
			$('#chatTestDiv').hide();
        }
    }
	
	function loadTopicList(data) {
 
        var topicList = ["Registration Issues > Cannot register", "Registration Issues > How to register", "Registration issues > Associating an additional CommServe" ,"Report Issues > Download issues", "Report issues > Finding a report", "Other"];
        $("#topic").empty();
 
        $.each(topicList, function (index, topic) {
 
          $('#topic').append($('<option/>', { 
			text : topic
			}));
        });
        
      
        return topicList;
    }

    function validEmail(email) {

        var isValid = false;
        var emailRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+$/;
        isValid = emailRegex.test(email);

        return isValid;
    }

	function closeChatWindow(e){
			
			e.preventDefault();
			if($('#chatAvailable').not(':hidden'))
				$('#chatAvailable').hide();
			
			if($('#chatNotAvailable').not(':hidden'))
				$('#chatNotAvailable').hide();
			
			$('#chatTestDiv').show();
			
	}
	
    function startChatting() {
		
        $('#validationErrors').html('');

        var userId = $('#userId').val();

        if (!userId) {
            $('#validationErrors').html('Email Address is required.');
			$('#validationErrors').show();
            return false;
        }

        if (!validEmail(userId)) {
            $('#validationErrors').html('Email Address is invalid.');
			$('#validationErrors').show();
            return false;
        }

        var message = $('#firstMessage').val();

        if (!message) {
            $('#validationErrors').html('Chat message is required.');
			$('#validationErrors').show();
            return false;
        }

        if (message.trim().length === 0) {
            $('#validationErrors').html('Chat message is required.');
			$('#validationErrors').show();
            return false;
        }

        if (message.length > 1000) {
            $('#validationErrors').html('Chat message is too long. Please limit to 1000 characters or less.');
			$('#validationErrors').show();
            return false;
        }

        var topic = $("#topic").val(); //This is normally a drop-down list maintained by each AppId

        if (topic.length > 100) {
            $('#validationErrors').html('Topic is too long. Please limit to 100 characters or less.');
			$('#validationErrors').show();
            return false;
        }

        var url = CHAT_BASE_URL + '/client/anon?cid=' + CHAT_CHANNEL
            + '&appId=' + encodeURIComponent(CHAT_APP)
            + '&user=' + encodeURIComponent(userId)
            + '&topic=' + encodeURIComponent(topic)
            + '&message=' + encodeURIComponent(message);
		$('#validationErrors').hide();
        window.open(url)

    }

	$(document)
		.ready(function() {
			var host = window.location.hostname.toLowerCase();
			
			if(host.indexOf("cloud.commvault.com") > -1 )
			//if(host.indexOf("testupdates") > -1 )
			{
				CHAT_BASE_URL = 'https://chat.commvault.com'
			}
			else
			{
				CHAT_BASE_URL = 'https://chatbeta.commvault.com'
			}
			
			$('#checkChat').click(function() {
				console.log("hello");
				detectAvailability();
			});
			
			$('.close_Chat').click(function(e) {
				closeChatWindow(e);
			});
		});