var workflowHandler = workflowHandler || {};
workflowHandler.EXECUTE_URL = "/runworkflow.do";
workflowHandler.getInputs = function(){
	var inputs = {};
	var noinputs = true;
	$(".workflow-input").each(function(i, el){
		var val = $(el).val();
		if($(el).is(':checkbox')){
			if($(el).is(":checked")){
				val = "true";
			}else{
				val = "false";
			}
		}
		if(!(!val.trim())){
			noinputs = false;
		}
		if($(el).data("xmlencode") == true){
			val = val.replace(/</g, "&lt;")
	         .replace(/>/g, "&gt;");
		}
		inputs[$(el).attr("name")] = encodeURIComponent(val);
	});
	if(noinputs){
		inputs = {};
	}
	return inputs;
};

workflowHandler.executeWorkflow = function(workflowName){
	var data = {};
	data.name = workflowName;
	var inputs = workflowHandler.getInputs();
	if($.isEmptyObject(inputs)){
		workflowHandler.showErrMsg("No inputs provided");
	}else{
		$(".workflowSbmtBtn").off('click');
		if (window.cvCustomMask) {
			$("#content").mask("");
		}
		data.inputs = JSON.stringify(inputs);
		data.urlencoded = true;
		cvUtil.loadPage(commonUtil.CONTEXT_PATH+workflowHandler.EXECUTE_URL,
				data, workflowHandler.workflowSuccess,
				workflowHandler.workflowError);
	}
};
workflowHandler.submitWorkflow = function(el){
	$(".workflowmsg").html("");
	var workflowName = $(this).data("workname");
	workflowHandler.executeWorkflow(workflowName);
};
workflowHandler.workflowSuccess = function(data){
	console.log(data);
	if(typeof data === 'string' ){
		data = JSON.parse(data);
	}
	var err= "Unable to submit request, please check inputs and try again, or contact site administrator.";
	var succ = "Successfully submitted your request.";
	if(data.code == -1){
		workflowHandler.showErrMsg(data.msg);
	}else if(data.data){

		if(data.data.workflowresponse && data.data.workflowresponse.success == false){
			if(data.data.workflowresponse.errorMsg){
				err = "";
				for(var i=0;i<data.data.workflowresponse.errorMsg.length;i++){
					err += data.data.workflowresponse.errorMsg[i]+"<br>";
				}
			}
			workflowHandler.showErrMsg(err);
		}else if(data.data.workflowresponse && data.data.workflowresponse.respType <= 0){
			var wresp = data.data.workflowresponse;
			if(wresp.response && (wresp.response.errorCode == -1 || wresp.response.errorCode == -9999 || wresp.response.errorCode > 0)){
				if(wresp.response.errorMessage){
					err = wresp.response.errorMessage;
				}
				workflowHandler.showErrMsg(err);
			}else if(wresp.response && (wresp.response.errorCode == 0)){
				workflowHandler.showSuccessMsg(succ);
			}
		}else if(data.data.workflowresponse && data.data.workflowresponse.respType > 0){
			var wresp = data.data.workflowresponse;
			if(wresp.response && wresp.response.jobId > 0){
				workflowHandler.showSuccessMsg(succ);
			}
		}
	}else{
		$(".workflowmsg").html(succ);
		$(".workflowmsg").addClass("success").removeClass("error hidden");
	}
	$(".workflowSbmtBtn").on("click", workflowHandler.submitWorkflow);
};
workflowHandler.workflowError = function(xhr){
	$(".workflowmsg").addClass("error").removeClass("success hidden").html("Unable to submit request, please check with admin.");
	$(".workflowSbmtBtn").on("click", workflowHandler.submitWorkflow);
};
workflowHandler.showSuccessMsg = function(succ){
	$(".workflowmsg").html(succ).addClass("success").removeClass("error hidden");
	$(".workflowSbmtBtn").addClass("hidden");
};
workflowHandler.showErrMsg = function(err){
	$(".workflowmsg").html(err).addClass("error").removeClass("success hidden");
};
$(document).ready(function() {
	$(document).ajaxStart(function() {
		$(".workflowSbmtBtn").addClass("loading");
	}).ajaxStop(function() {
		$(".workflowSbmtBtn").removeClass("loading");
	});

	$(".workflowSbmtBtn").on("click", workflowHandler.submitWorkflow);
});