/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn.util;

import commvault.web.creconn.dto.ReportDataResponse;
import commvault.web.creconn.entity.Field;
import commvault.web.creconn.model.ColumnTransformer;
import commvault.web.creconn.model.DataFormatDefinition;
import commvault.web.creconn.model.DataTableModel;
import commvault.web.creconn.model.MDataProp;
import commvault.web.creconn.model.RowMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataTableConverter
implements MDataProp {
    private static final String RENDERER_CAPACITY_MB = "capacityMB";
    private static final String RENDERER_SIZEMB = "SIZEMB";
    private static final String RENDERER_DONOTSHOW = "DONOTSHOW";
    private static final String RENDERER_HIDDEN = "HIDDEN";
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    private ReportDataResponse result;
    private DataFormatDefinition definition;
    private Pattern pattern = Pattern.compile("<(.+?)>");

    public DataTableConverter(ReportDataResponse reportDataResponse, DataFormatDefinition dataFormatDefinition) {
        this.result = reportDataResponse;
        this.definition = dataFormatDefinition;
    }

    public DataTableModel convert() {
        logger.debug((Object)"Beginning to convert data");
        DataTableModel dataTableModel = new DataTableModel();
        List<ColumnTransformer> list = this.getAllTransformers(this.result.getColumns(), this.definition.getTransformers());
        dataTableModel.setCacheID(this.result.getCacheId());
        dataTableModel.setOffset(this.result.getOffset());
        List<Map<String, Object>> list2 = this.getMapList();
        for (ColumnTransformer columnTransformer : list) {
            Iterator<Map<String, Object>> iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string;
                Map<String, Object> map;
                Object object = columnTransformer.transform(map = iterator.next(), string = this.getMDataProp(columnTransformer.getColName()), map.get(string));
                map.put(string, object != null ? object : "");
            }
        }
        dataTableModel.setAoColumns(this.getColumns(list));
        dataTableModel.setAaData(list2);
        dataTableModel.setiTotalRecords(list2.size());
        dataTableModel.setiTotalDisplayRecords(list2.size());
        dataTableModel.setiDisplayLength(list2.size());
        logger.debug((Object)"Leaving convert");
        return dataTableModel;
    }

    private List<DataTableModel.DataTableColumn> getColumns(List<ColumnTransformer> list) {
        ArrayList<DataTableModel.DataTableColumn> arrayList = new ArrayList<DataTableModel.DataTableColumn>();
        for (ColumnTransformer columnTransformer : list) {
            arrayList.add(this.getDataTableColumn(columnTransformer));
        }
        return arrayList;
    }

    public List<ColumnTransformer> getAllTransformers(List<Field> list, List<ColumnTransformer> list2) {
        ArrayList<ColumnTransformer> arrayList = new ArrayList<ColumnTransformer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Field object : list) {
            ColumnTransformer bl = null;
            for (ColumnTransformer columnTransformer : list2) {
                if (!columnTransformer.getOldColName().equals(object.getName())) continue;
                bl = columnTransformer;
                break;
            }
            if (bl != null) {
                bl.setType(object.getType());
                arrayList2.add(bl);
                continue;
            }
            ColumnTransformer columnTransformer = new ColumnTransformer(object.getName());
            columnTransformer.setType(object.getType());
            arrayList2.add(columnTransformer);
        }
        arrayList.addAll(arrayList2);
        for (ColumnTransformer columnTransformer : list2) {
            boolean bl = false;
            for (ColumnTransformer columnTransformer2 : arrayList2) {
                if (!columnTransformer2.getOldColName().equals(columnTransformer.getOldColName())) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(columnTransformer);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<Map<String, Object>> getMapList() {
        List<Object> list = this.result.getRecords();
        List<Field> list2 = this.result.getColumns();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Object object : list) {
            Map<String, Object> map = this.makeRowMap(object, list2);
            arrayList.add(map);
        }
        return arrayList;
    }

    public List<RowMap> getRowMapList() {
        List<Object> list = this.result.getRecords();
        List<Field> list2 = this.result.getColumns();
        ArrayList<RowMap> arrayList = new ArrayList<RowMap>();
        for (Object object : list) {
            Map<String, Object> map = this.makeRowMap(object, list2);
            RowMap rowMap = new RowMap(map);
            arrayList.add(rowMap);
        }
        return arrayList;
    }

    private Map<String, Object> makeRowMap(Object object, List<Field> list) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (object != null && object instanceof List) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i).getName();
                treeMap.put(this.getMDataProp(string), ((List)object).get(i));
            }
        }
        return treeMap;
    }

    @Override
    public String getMDataProp(String string) {
        return this.definition.getMdataProp().getMDataProp(string).replace(".", "");
    }

    private DataTableModel.DataTableColumn getDataTableColumn(ColumnTransformer columnTransformer) {
        DataTableModel.DataTableColumn dataTableColumn = new DataTableModel.DataTableColumn();
        List<String> list = this.definition.getDoNotShowColumnNames();
        String string = columnTransformer.getColName();
        Matcher matcher = this.pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        for (String string2 : arrayList) {
            if (string2.equals(RENDERER_HIDDEN)) {
                dataTableColumn.setbVisible(false);
                continue;
            }
            if (string2.equals(RENDERER_DONOTSHOW)) {
                dataTableColumn.setbVisible(false);
                dataTableColumn.setDoNotShow(true);
                continue;
            }
            if (string2.equals(RENDERER_SIZEMB)) {
                dataTableColumn.setRendererType(RENDERER_CAPACITY_MB);
                continue;
            }
            if (string2.equals("ALTSORT")) continue;
            dataTableColumn.setRendererType(string2);
        }
        if (columnTransformer.getType() != null) {
            dataTableColumn.setSqlType(columnTransformer.getType().name());
        }
        if (list.contains(string)) {
            dataTableColumn.setbVisible(false);
            dataTableColumn.setDoNotShow(true);
        }
        if (columnTransformer != null) {
            string = columnTransformer.getColName();
        }
        dataTableColumn.setOriginalColName(columnTransformer.getOldColName());
        String string3 = string.replaceAll(this.pattern.pattern(), "");
        dataTableColumn.setsTitle(string3);
        dataTableColumn.setmDataProp(this.getMDataProp(string));
        dataTableColumn.setsName(string3);
        return dataTableColumn;
    }

    public static DataTableModel.DataTableColumn getColumn(DataTableModel dataTableModel, String string) {
        return DataTableConverter.getColumn(dataTableModel, string, false);
    }

    public static DataTableModel.DataTableColumn getColumn(DataTableModel dataTableModel, String string, boolean bl) {
        List<DataTableModel.DataTableColumn> list = dataTableModel.getAoColumns();
        for (DataTableModel.DataTableColumn dataTableColumn : list) {
            if (!dataTableColumn.getsTitle().equals(string)) continue;
            return dataTableColumn;
        }
        DataTableModel.DataTableColumn dataTableColumn = new DataTableModel.DataTableColumn();
        dataTableColumn.setsTitle(string);
        dataTableColumn.setmDataProp(string);
        if (bl) {
            list.add(dataTableColumn);
        }
        return dataTableColumn;
    }

    public static DataTableModel transpose(DataTableModel dataTableModel) {
        return DataTableConverter.transpose(dataTableModel, null);
    }

    public static DataTableModel transpose(DataTableModel dataTableModel, DataTableModel.DataTableColumn dataTableColumn) {
        return DataTableConverter.transpose(dataTableModel, null, new DataFormatDefinition());
    }

    public static DataTableModel transpose(DataTableModel dataTableModel, DataTableModel.DataTableColumn dataTableColumn, DataFormatDefinition dataFormatDefinition) {
        Iterator<Map.Entry<String, String>> iterator;
        DataTableModel dataTableModel2 = new DataTableModel();
        ArrayList<Iterator<Map.Entry<String, String>>> arrayList = new ArrayList<Iterator<Map.Entry<String, String>>>();
        ArrayList<DataTableModel.DataTableColumn> arrayList2 = new ArrayList<DataTableModel.DataTableColumn>();
        List<?> list = dataTableModel.getAaData();
        List<DataTableModel.DataTableColumn> list2 = dataTableModel.getAoColumns();
        if (dataTableColumn == null) {
            dataTableColumn = list2.get(0);
        }
        DataTableModel.DataTableColumn dataTableColumn2 = dataTableColumn;
        arrayList2.add(dataTableColumn2);
        List<Object> list3 = DataTableConverter.getColumnValues(dataTableModel, dataTableColumn, dataFormatDefinition);
        for (Object object : list3) {
            iterator = dataFormatDefinition.getMdataProp().getMDataProp(String.valueOf(object));
            dataTableColumn2 = new DataTableModel.DataTableColumn((String)((Object)iterator), (String)((Object)iterator), (String)((Object)iterator), false, true);
            dataTableColumn2.setsTitle(String.valueOf(object));
            dataTableColumn2.setsName(String.valueOf(object));
            arrayList2.add(dataTableColumn2);
        }
        for (DataTableModel.DataTableColumn dataTableColumn3 : list2) {
            if (dataTableColumn3.getmDataProp().equals(dataTableColumn.getmDataProp())) continue;
            iterator = new HashMap();
            iterator.put(dataTableColumn.getmDataProp(), dataTableColumn3.getsTitle());
            arrayList.add(iterator);
        }
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                for (int i = 1; i < arrayList2.size(); ++i) {
                    DataTableModel.DataTableColumn dataTableColumn4 = (DataTableModel.DataTableColumn)arrayList2.get(i);
                    for (int j = 0; j < arrayList.size(); ++j) {
                        Map map2 = (Map)arrayList.get(j);
                        if (!string.equals(((Map)arrayList.get(j)).get(dataTableColumn.getmDataProp())) || !dataTableColumn4.getmDataProp().equals(map.get(dataTableColumn.getmDataProp()))) continue;
                        map2.put(dataTableColumn4.getmDataProp(), v);
                    }
                }
            }
        }
        dataTableModel2.setAoColumns(arrayList2);
        dataTableModel2.setAaData(arrayList);
        dataTableModel2.setiTotalRecords(arrayList.size());
        return dataTableModel2;
    }

    public static List<Object> getColumnValues(DataTableModel dataTableModel, DataTableModel.DataTableColumn dataTableColumn) {
        return DataTableConverter.getColumnValues(dataTableModel, dataTableColumn, new DataFormatDefinition());
    }

    public static List<Object> getColumnValues(DataTableModel dataTableModel, int n) {
        return DataTableConverter.getColumnValues(dataTableModel, dataTableModel.getAoColumns().get(n), new DataFormatDefinition());
    }

    public static List<Object> getColumnValues(DataTableModel dataTableModel, DataTableModel.DataTableColumn dataTableColumn, DataFormatDefinition dataFormatDefinition) {
        List<?> list = dataTableModel.getAaData();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map map : list) {
            Object v = map.get(dataTableColumn.getmDataProp());
            ColumnTransformer columnTransformer = DataTableConverter.getTransformer(dataFormatDefinition, dataTableColumn.getmDataProp());
            if (columnTransformer != null) {
                arrayList.add(columnTransformer.transform(map, dataTableColumn.getmDataProp(), v));
                continue;
            }
            arrayList.add(v);
        }
        return arrayList;
    }

    public static ColumnTransformer getTransformer(DataFormatDefinition dataFormatDefinition, String string) {
        for (ColumnTransformer columnTransformer : dataFormatDefinition.getTransformers()) {
            if (!string.equals(dataFormatDefinition.getMdataProp().getMDataProp(columnTransformer.getColName()))) continue;
            return columnTransformer;
        }
        return null;
    }

    public static Map<Object, DataTableModel> split(DataTableModel dataTableModel, String string, String string2) {
        return DataTableConverter.split(dataTableModel, string, string2, new DataFormatDefinition());
    }

    public static Map<Object, DataTableModel> split(DataTableModel dataTableModel, String string, final String string2, final DataFormatDefinition dataFormatDefinition) {
        Object object;
        TreeMap treeMap;
        Object object2;
        Object object32;
        List<?> list = dataTableModel.getAaData();
        TreeMap<TreeMap<Object, DataTableModel>, Object> treeMap2 = new TreeMap<TreeMap<Object, DataTableModel>, Object>();
        for (Object object32 : list) {
            if (!(object32 instanceof Map)) continue;
            object2 = (Map)object32;
            treeMap = object2.get(dataFormatDefinition.getMdataProp().getMDataProp(string));
            if (treeMap2.containsKey(treeMap)) {
                object = (List)treeMap2.get(treeMap);
            } else {
                object = new ArrayList();
                treeMap2.put(treeMap, object);
            }
            object.add(object2);
        }
        Comparator<Map<String, Object>> comparator = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> map, Map<String, Object> map2) {
                Object object = map.get(dataFormatDefinition.getMdataProp().getMDataProp(string2));
                Object object2 = map2.get(dataFormatDefinition.getMdataProp().getMDataProp(string2));
                if (object instanceof Comparable) {
                    return ((Comparable)object).compareTo(object2);
                }
                return object.toString().compareTo(object2.toString());
            }
        };
        object32 = treeMap2.entrySet().iterator();
        treeMap = new TreeMap();
        while (object32.hasNext()) {
            object = (Map.Entry)object32.next();
            Object k = object.getKey();
            List list2 = (List)object.getValue();
            Collections.sort(list2, comparator);
            object2 = new DataTableModel();
            ((DataTableModel)object2).setAoColumns(dataTableModel.getAoColumns());
            ((DataTableModel)object2).setAaData(list2);
            ((DataTableModel)object2).setiTotalRecords(list2.size());
            treeMap.put(k, (DataTableModel)object2);
        }
        return treeMap;
    }
}

