/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn.service;

import commvault.web.core.filter.RequestContext;
import commvault.web.core.util.CVCoreUtil;
import commvault.web.creconn.CreRequestObject;
import commvault.web.creconn.CustomReportsClient;
import commvault.web.creconn.OpReq;
import commvault.web.creconn.dto.ReportDataResponse;
import commvault.web.creconn.exception.MetricsException;
import commvault.web.creconn.service.DBService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import org.apache.log4j.Logger;

@RequestScoped
public class DBServiceImpl
implements DBService {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    private static final String DATA_END_POINT = "data";
    private CustomReportsClient service = CVCoreUtil.lookup(CustomReportsClient.class);

    @Override
    public ReportDataResponse performOperation(OpReq opReq) throws MetricsException {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        logger.debug((Object)("Request: " + opReq));
        if (this.service == null) {
            throw new MetricsException("Custom Reports Service is not available");
        }
        try {
            if (RequestContext.getRequest().getSession() == null) {
                throw new MetricsException("Not Logged In");
            }
            Map<String, Object> map = opReq.getRequestParams();
            CreRequestObject creRequestObject = CreRequestObject.get("datasets/" + opReq.getDataSetName() + "/" + DATA_END_POINT);
            creRequestObject.setParamMap(map);
            ReportDataResponse reportDataResponse = this.service.getResponse(creRequestObject, ReportDataResponse.class);
            if (reportDataResponse != null) {
                if (reportDataResponse.getFailures().isEmpty()) {
                    return reportDataResponse;
                }
                logger.error((Object)("Execution resulted in some failures for operation : " + (Object)((Object)opReq.getOperation())));
                logger.debug((Object)("" + opReq));
                Iterator<List<String>> iterator = reportDataResponse.getFailures().values().iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    List<String> list = iterator.next();
                    arrayList.addAll(list);
                }
                for (String string : arrayList) {
                    logger.error((Object)("Failure: " + string));
                }
                throw new MetricsException(arrayList);
            }
            return null;
        }
        catch (Exception exception) {
            logger.debug((Object)"", (Throwable)exception);
            throw new MetricsException(exception);
        }
    }
}

